/*
 * Decompiled with CFR 0.152.
 */
package com.oneidentity.safeguard.safeguardjava.restclient;

import com.oneidentity.safeguard.safeguardjava.IProgressCallback;
import com.oneidentity.safeguard.safeguardjava.data.TransferProgress;
import java.io.IOException;
import java.io.OutputStream;

public class OutputStreamProgress
extends OutputStream {
    private final OutputStream outstream;
    private final IProgressCallback progressCallback;
    private final TransferProgress transferProgress = new TransferProgress();
    private int lastSentPercent = 5;
    private volatile long bytesWritten = 0L;

    public OutputStreamProgress(OutputStream outstream, IProgressCallback progressCallback, long totalBytes) {
        this.outstream = outstream;
        this.progressCallback = progressCallback;
        this.transferProgress.setBytesTotal(totalBytes);
        this.transferProgress.setBytesTransferred(this.bytesWritten);
    }

    private void sendProgress() {
        this.transferProgress.setBytesTransferred(this.bytesWritten);
        if (this.transferProgress.getPercentComplete() >= this.lastSentPercent) {
            this.lastSentPercent += 5;
            this.progressCallback.checkProgress(this.transferProgress);
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.outstream.write(b);
        ++this.bytesWritten;
        if (this.progressCallback != null) {
            this.sendProgress();
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.outstream.write(b);
        this.bytesWritten += (long)b.length;
        if (this.progressCallback != null) {
            this.sendProgress();
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.outstream.write(b, off, len);
        this.bytesWritten += (long)len;
        if (this.progressCallback != null) {
            this.sendProgress();
        }
    }

    @Override
    public void flush() throws IOException {
        this.outstream.flush();
    }

    @Override
    public void close() throws IOException {
        this.outstream.close();
    }

    public long getWrittenLength() {
        return this.bytesWritten;
    }
}

