/*
 * Decompiled with CFR 0.152.
 */
package com.oneidentity.safeguard.safeguardjava.restclient;

import com.oneidentity.safeguard.safeguardjava.CertificateUtilities;
import com.oneidentity.safeguard.safeguardjava.IProgressCallback;
import com.oneidentity.safeguard.safeguardjava.data.CertificateContext;
import com.oneidentity.safeguard.safeguardjava.data.JsonObject;
import com.oneidentity.safeguard.safeguardjava.exceptions.SafeguardForJavaException;
import com.oneidentity.safeguard.safeguardjava.restclient.ByteArrayEntity;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.HttpEntity;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.apache.http.impl.cookie.BasicClientCookie;

public class RestClient {
    private CloseableHttpClient client = null;
    private BasicCookieStore cookieStore = new BasicCookieStore();
    private String serverUrl = null;
    private String hostDomain = null;
    private boolean ignoreSsl = false;
    private HostnameVerifier validationCallback = null;
    Logger logger = Logger.getLogger(this.getClass().getName());

    public RestClient(String connectionAddr, boolean ignoreSsl, HostnameVerifier validationCallback) {
        this.client = this.createClientBuilder(connectionAddr, ignoreSsl, validationCallback).build();
    }

    public RestClient(String connectionAddr, String userName, char[] password, boolean ignoreSsl, HostnameVerifier validationCallback) {
        HttpClientBuilder builder = this.createClientBuilder(connectionAddr, ignoreSsl, validationCallback);
        BasicCredentialsProvider provider = new BasicCredentialsProvider();
        provider.setCredentials(AuthScope.ANY, new UsernamePasswordCredentials(userName, new String(password)));
        RequestConfig customizedRequestConfig = RequestConfig.custom().setCookieSpec("standard").build();
        this.client = builder.setDefaultCredentialsProvider(provider).setDefaultRequestConfig(customizedRequestConfig).setDefaultCookieStore(this.cookieStore).build();
    }

    private HttpClientBuilder createClientBuilder(String connectionAddr, boolean ignoreSsl, HostnameVerifier validationCallback) {
        this.ignoreSsl = ignoreSsl;
        this.serverUrl = connectionAddr;
        try {
            URL aUrl = new URL(connectionAddr);
            this.hostDomain = aUrl.getHost();
        }
        catch (MalformedURLException ex) {
            Logger.getLogger(RestClient.class.getName()).log(Level.SEVERE, "Invalid URL", ex);
        }
        SSLConnectionSocketFactory sslsf = null;
        if (ignoreSsl) {
            this.validationCallback = null;
            sslsf = new SSLConnectionSocketFactory(this.getSSLContext(null, null, null, null), (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        } else if (validationCallback != null) {
            this.validationCallback = validationCallback;
            sslsf = new SSLConnectionSocketFactory(this.getSSLContext(null, null, null, null), validationCallback);
        } else {
            sslsf = new SSLConnectionSocketFactory(this.getSSLContext(null, null, null, null));
        }
        Registry<ConnectionSocketFactory> socketFactoryRegistry = RegistryBuilder.create().register("https", sslsf).build();
        BasicHttpClientConnectionManager connectionManager = new BasicHttpClientConnectionManager(socketFactoryRegistry);
        return HttpClients.custom().setSSLSocketFactory(sslsf).setConnectionManager(connectionManager);
    }

    private URI getBaseURI(String segments) {
        try {
            return new URI(this.serverUrl + "/" + segments);
        }
        catch (URISyntaxException ex) {
            Logger.getLogger(RestClient.class.getName()).log(Level.SEVERE, "Invalid URI", ex);
            return null;
        }
    }

    public String getBaseURL() {
        return this.serverUrl;
    }

    private Map<String, String> parseKeyValue(String value) {
        String[] parts;
        HashMap<String, String> keyValues = new HashMap<String, String>();
        for (String p : parts = value.split(";")) {
            String[] kv = p.split("=");
            if (kv.length == 1) {
                keyValues.put(kv[0].trim(), "");
            }
            if (kv.length != 2) continue;
            keyValues.put(kv[0].trim(), kv[1].trim());
        }
        return keyValues;
    }

    public void addSessionId(String cookieValue) {
        if (cookieValue == null) {
            Logger.getLogger(RestClient.class.getName()).log(Level.SEVERE, "Session cookie cannot be null");
            return;
        }
        try {
            Map<String, String> keyValues = this.parseKeyValue(cookieValue);
            String sessionId = keyValues.get("session_id");
            if (sessionId != null) {
                String secure;
                String path;
                BasicClientCookie cookie = new BasicClientCookie("session_id", sessionId);
                String expiryDate = keyValues.get("expires");
                if (expiryDate != null) {
                    SimpleDateFormat formatter = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss z");
                    Date date = formatter.parse(expiryDate);
                    cookie.setExpiryDate(date);
                }
                if ((path = keyValues.get("Path")) != null) {
                    cookie.setPath(path);
                }
                if (this.hostDomain != null) {
                    cookie.setDomain(this.hostDomain);
                }
                if ((secure = keyValues.get("Secure")) != null) {
                    cookie.setSecure(true);
                }
                this.cookieStore.addCookie(cookie);
            }
        }
        catch (Exception ex) {
            Logger.getLogger(RestClient.class.getName()).log(Level.SEVERE, "Failed to set session cookie.", ex);
        }
    }

    public CloseableHttpResponse execGET(String path, Map<String, String> queryParams, Map<String, String> headers, Integer timeout2) {
        RequestBuilder rb = this.prepareRequest(RequestBuilder.get(this.getBaseURI(path)), queryParams, headers, timeout2);
        try {
            CloseableHttpResponse r = this.client.execute(rb.build());
            return r;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public CloseableHttpResponse execGET(String path, Map<String, String> queryParams, Map<String, String> headers, Integer timeout2, CertificateContext certificateContext) {
        CloseableHttpClient certClient = this.getClientWithCertificate(certificateContext);
        if (certClient != null) {
            RequestBuilder rb = this.prepareRequest(RequestBuilder.get(this.getBaseURI(path)), queryParams, headers, timeout2);
            try {
                CloseableHttpResponse r = certClient.execute(rb.build());
                return r;
            }
            catch (Exception ex) {
                return null;
            }
        }
        return null;
    }

    public CloseableHttpResponse execGETBytes(String path, Map<String, String> queryParams, Map<String, String> headers, Integer timeout2, IProgressCallback progressCallback) {
        if (headers == null || !headers.containsKey("Accept")) {
            headers = headers == null ? new HashMap<String, String>() : headers;
            headers.put("Accept", "application/octet-stream");
        }
        RequestBuilder rb = this.prepareRequest(RequestBuilder.get(this.getBaseURI(path)), queryParams, headers, timeout2);
        try {
            CloseableHttpResponse r = this.client.execute(rb.build());
            return r;
        }
        catch (IOException ex) {
            return null;
        }
    }

    public CloseableHttpResponse execGETBytes(String path, Map<String, String> queryParams, Map<String, String> headers, Integer timeout2, CertificateContext certificateContext, IProgressCallback progressCallback) {
        CloseableHttpClient certClient = this.getClientWithCertificate(certificateContext);
        if (certClient != null) {
            if (headers == null || !headers.containsKey("Accept")) {
                headers = headers == null ? new HashMap<String, String>() : headers;
                headers.put("Accept", "application/octet-stream");
            }
            RequestBuilder rb = this.prepareRequest(RequestBuilder.get(this.getBaseURI(path)), queryParams, headers, timeout2);
            try {
                CloseableHttpResponse r = this.client.execute(rb.build());
                return r;
            }
            catch (IOException ex) {
                return null;
            }
        }
        return null;
    }

    public CloseableHttpResponse execPUT(String path, Map<String, String> queryParams, Map<String, String> headers, Integer timeout2, JsonObject requestEntity) {
        RequestBuilder rb = this.prepareRequest(RequestBuilder.put(this.getBaseURI(path)), queryParams, headers, timeout2);
        try {
            String body = requestEntity.toJson();
            rb.setEntity(new StringEntity(body == null ? "{}" : body));
            CloseableHttpResponse r = this.client.execute(rb.build());
            return r;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public CloseableHttpResponse execPOST(String path, Map<String, String> queryParams, Map<String, String> headers, Integer timeout2, JsonObject requestEntity) {
        RequestBuilder rb = this.prepareRequest(RequestBuilder.post(this.getBaseURI(path)), queryParams, headers, timeout2);
        try {
            String body = requestEntity.toJson();
            rb.setEntity(new StringEntity(body == null ? "{}" : body));
            CloseableHttpResponse r = this.client.execute(rb.build());
            return r;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public CloseableHttpResponse execPOST(String path, Map<String, String> queryParams, Map<String, String> headers, Integer timeout2, JsonObject requestEntity, CertificateContext certificateContext) throws SafeguardForJavaException {
        CloseableHttpClient certClient = this.getClientWithCertificate(certificateContext);
        if (certClient != null) {
            RequestBuilder rb = this.prepareRequest(RequestBuilder.post(this.getBaseURI(path)), queryParams, headers, timeout2);
            try {
                String body = requestEntity.toJson();
                rb.setEntity(new StringEntity(body == null ? "{}" : body));
                CloseableHttpResponse r = certClient.execute(rb.build());
                return r;
            }
            catch (IOException ex) {
                return null;
            }
        }
        return null;
    }

    public CloseableHttpResponse execPOSTBytes(String path, Map<String, String> queryParams, Map<String, String> headers, Integer timeout2, byte[] requestEntity, IProgressCallback progressCallback) {
        if (headers == null || !headers.containsKey("Content-Type")) {
            headers = headers == null ? new HashMap<String, String>() : headers;
            headers.put("Content-Type", "application/octet-stream");
        }
        RequestBuilder rb = this.prepareRequest(RequestBuilder.post(this.getBaseURI(path)), queryParams, headers, timeout2);
        try {
            rb.setEntity(new ByteArrayEntity(requestEntity, progressCallback));
            CloseableHttpResponse r = this.client.execute(rb.build());
            return r;
        }
        catch (IOException ex) {
            return null;
        }
    }

    public CloseableHttpResponse execPOSTBytes(String path, Map<String, String> queryParams, Map<String, String> headers, Integer timeout2, byte[] requestEntity, CertificateContext certificateContext, IProgressCallback progressCallback) {
        CloseableHttpClient certClient = this.getClientWithCertificate(certificateContext);
        if (certClient != null) {
            if (headers == null || !headers.containsKey("Content-Type")) {
                headers = headers == null ? new HashMap<String, String>() : headers;
                headers.put("Content-Type", "application/octet-stream");
            }
            RequestBuilder rb = this.prepareRequest(RequestBuilder.post(this.getBaseURI(path)), queryParams, headers, timeout2);
            try {
                rb.setEntity(new ByteArrayEntity(requestEntity, progressCallback));
                CloseableHttpResponse r = this.client.execute(rb.build());
                return r;
            }
            catch (IOException ex) {
                return null;
            }
        }
        return null;
    }

    public CloseableHttpResponse execPOSTFile(String path, Map<String, String> queryParams, Map<String, String> headers, Integer timeout2, String fileName) {
        File file = new File(fileName);
        HttpEntity data = MultipartEntityBuilder.create().setMode(HttpMultipartMode.BROWSER_COMPATIBLE).addBinaryBody("firmware", file, ContentType.MULTIPART_FORM_DATA, file.getName()).build();
        if (headers == null || !headers.containsKey("Content-Type")) {
            headers = headers == null ? new HashMap<String, String>() : headers;
        }
        RequestBuilder rb = this.prepareRequest(RequestBuilder.post(this.getBaseURI(path)), queryParams, headers, timeout2);
        try {
            rb.setEntity(data);
            CloseableHttpResponse r = this.client.execute(rb.build());
            return r;
        }
        catch (IOException ex) {
            return null;
        }
    }

    public CloseableHttpResponse execPOSTFile(String path, Map<String, String> queryParams, Map<String, String> headers, Integer timeout2, String fileName, CertificateContext certificateContext) {
        CloseableHttpClient certClient = this.getClientWithCertificate(certificateContext);
        if (certClient != null) {
            File file = new File(fileName);
            HttpEntity data = MultipartEntityBuilder.create().setMode(HttpMultipartMode.BROWSER_COMPATIBLE).addBinaryBody("firmware", file, ContentType.MULTIPART_FORM_DATA, file.getName()).build();
            if (headers == null || !headers.containsKey("Content-Type")) {
                headers = headers == null ? new HashMap<String, String>() : headers;
            }
            RequestBuilder rb = this.prepareRequest(RequestBuilder.post(this.getBaseURI(path)), queryParams, headers, timeout2);
            try {
                rb.setEntity(data);
                CloseableHttpResponse r = this.client.execute(rb.build());
                return r;
            }
            catch (IOException ex) {
                return null;
            }
        }
        return null;
    }

    public CloseableHttpResponse execDELETE(String path, Map<String, String> queryParams, Map<String, String> headers, Integer timeout2) {
        RequestBuilder rb = this.prepareRequest(RequestBuilder.delete(this.getBaseURI(path)), queryParams, headers, timeout2);
        try {
            CloseableHttpResponse r = this.client.execute(rb.build());
            return r;
        }
        catch (Exception ex) {
            return null;
        }
    }

    private CloseableHttpClient getClientWithCertificate(CertificateContext certificateContext) {
        CloseableHttpClient certClient = null;
        if (certificateContext.getCertificatePath() != null || certificateContext.getCertificateData() != null || certificateContext.getCertificateThumbprint() != null) {
            String certificateAlias;
            char[] keyPass;
            ArrayList<Object> aliases;
            KeyStore clientKs;
            block7: {
                clientKs = null;
                aliases = null;
                keyPass = certificateContext.getCertificatePassword();
                certificateAlias = certificateContext.getCertificateAlias();
                try {
                    if (certificateContext.isWindowsKeyStore()) {
                        clientKs = KeyStore.getInstance(CertificateUtilities.WINDOWSKEYSTORE);
                        clientKs.load(null, null);
                        aliases = new ArrayList();
                        aliases = Collections.list(clientKs.aliases());
                        break block7;
                    }
                    InputStream in = certificateContext.getCertificatePath() != null ? new FileInputStream(certificateContext.getCertificatePath()) : new ByteArrayInputStream(certificateContext.getCertificateData());
                    try {
                        clientKs = KeyStore.getInstance("JKS");
                    }
                    catch (KeyStoreException ex) {
                        Logger.getLogger(RestClient.class.getName()).log(Level.SEVERE, "Could not get instance of JDK, trying PKCS12", ex);
                        clientKs = KeyStore.getInstance("PKCS12");
                    }
                    clientKs.load(in, keyPass);
                    aliases = Collections.list(clientKs.aliases());
                    in.close();
                }
                catch (FileNotFoundException ex) {
                    Logger.getLogger(RestClient.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException ex) {
                    Logger.getLogger(RestClient.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            SSLConnectionSocketFactory sslsf = null;
            sslsf = this.ignoreSsl ? new SSLConnectionSocketFactory(this.getSSLContext(clientKs, keyPass, certificateAlias == null ? (String)aliases.get(0) : certificateAlias, certificateContext), (HostnameVerifier)NoopHostnameVerifier.INSTANCE) : (this.validationCallback != null ? new SSLConnectionSocketFactory(this.getSSLContext(clientKs, keyPass, certificateAlias == null ? (String)aliases.get(0) : certificateAlias, certificateContext), this.validationCallback) : new SSLConnectionSocketFactory(this.getSSLContext(clientKs, keyPass, certificateAlias == null ? (String)aliases.get(0) : certificateAlias, certificateContext)));
            Registry<ConnectionSocketFactory> socketFactoryRegistry = RegistryBuilder.create().register("https", sslsf).build();
            BasicHttpClientConnectionManager connectionManager = new BasicHttpClientConnectionManager(socketFactoryRegistry);
            certClient = HttpClients.custom().setSSLSocketFactory(sslsf).setConnectionManager(connectionManager).build();
        }
        return certClient;
    }

    private RequestBuilder prepareRequest(RequestBuilder rb, Map<String, String> queryParams, Map<String, String> headers, Integer timeout2) {
        if (headers == null || !headers.containsKey("Accept")) {
            rb.addHeader("Accept", "application/json");
        }
        if (headers == null || !headers.containsKey("Content-Type")) {
            rb.addHeader("Content-Type", "application/json");
        }
        if (headers != null) {
            headers.entrySet().forEach(entry -> rb.addHeader((String)entry.getKey(), (String)entry.getValue()));
        }
        if (queryParams != null) {
            queryParams.entrySet().forEach(entry -> rb.addParameter((String)entry.getKey(), (String)entry.getValue()));
        }
        if (timeout2 != null) {
            RequestConfig rconfig = RequestConfig.custom().setConnectTimeout(timeout2).setConnectionRequestTimeout(timeout2).setSocketTimeout(timeout2).build();
            rb.setConfig(rconfig);
        }
        return rb;
    }

    private SSLContext getSSLContext(KeyStore keyStorePath, char[] keyStorePassword, String alias, CertificateContext certificateContext) {
        TrustManager[] customTrustManager = null;
        KeyManager[] customKeyManager = null;
        if (this.ignoreSsl || this.validationCallback != null) {
            customTrustManager = new TrustManager[]{new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }
            }};
        }
        if (keyStorePath != null && keyStorePassword != null && alias != null || keyStorePath != null && certificateContext.isWindowsKeyStore()) {
            try {
                KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
                keyManagerFactory.init(keyStorePath, keyStorePassword);
                customKeyManager = new KeyManager[]{new SafeguardExtendedX509KeyManager((X509KeyManager)keyManagerFactory.getKeyManagers()[0], alias)};
            }
            catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException ex) {
                ex.printStackTrace();
            }
        }
        SSLContext ctx = null;
        try {
            ctx = SSLContext.getInstance("TLS");
            ctx.init(customKeyManager, customTrustManager, new SecureRandom());
        }
        catch (GeneralSecurityException generalSecurityException) {
            // empty catch block
        }
        return ctx;
    }

    class SafeguardExtendedX509KeyManager
    extends X509ExtendedKeyManager {
        X509KeyManager defaultKeyManager;
        String alias;

        public SafeguardExtendedX509KeyManager(X509KeyManager inKeyManager, String alias) {
            this.defaultKeyManager = inKeyManager;
            this.alias = alias;
        }

        @Override
        public String chooseEngineClientAlias(String[] keyType, Principal[] issuers, SSLEngine engine) {
            return this.alias;
        }

        @Override
        public String chooseClientAlias(String[] strings, Principal[] prncpls, Socket socket) {
            return this.alias;
        }

        @Override
        public String[] getClientAliases(String string, Principal[] prncpls) {
            return this.defaultKeyManager.getClientAliases(string, prncpls);
        }

        @Override
        public String[] getServerAliases(String string, Principal[] prncpls) {
            return this.defaultKeyManager.getServerAliases(string, prncpls);
        }

        @Override
        public String chooseServerAlias(String string, Principal[] prncpls, Socket socket) {
            return this.defaultKeyManager.chooseServerAlias(string, prncpls, socket);
        }

        @Override
        public X509Certificate[] getCertificateChain(String string) {
            return this.defaultKeyManager.getCertificateChain(string);
        }

        @Override
        public PrivateKey getPrivateKey(String string) {
            return this.defaultKeyManager.getPrivateKey(string);
        }
    }
}

