/*
 * Copyright (c) 2010-2018 Osman Shoukry
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.openpojo.reflection.impl;

import com.openpojo.reflection.PojoPackage;

/**
 * @author oshoukry
 */
public class PojoPackageFactory {

  public static PojoPackage getPojoPackage(final String packageName) {
    return new PojoPackageImpl(packageName);
  }

  private PojoPackageFactory() {
    throw new UnsupportedOperationException(PojoPackageFactory.class.getName() + " should not be constructed!");
  }
}
