/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.client;

import com.openshift.client.ApplicationScale;
import com.openshift.client.IApplication;
import com.openshift.client.IDomain;
import com.openshift.client.IGearProfile;
import com.openshift.client.IUser;
import com.openshift.client.Messages;
import com.openshift.client.OpenShiftException;
import com.openshift.client.OpenShiftRequestException;
import com.openshift.client.cartridge.IEmbeddableCartridge;
import com.openshift.client.cartridge.IStandaloneCartridge;
import com.openshift.internal.client.APIResource;
import com.openshift.internal.client.AbstractOpenShiftResource;
import com.openshift.internal.client.ApplicationResource;
import com.openshift.internal.client.GearProfile;
import com.openshift.internal.client.httpclient.request.Parameter;
import com.openshift.internal.client.httpclient.request.StringParameter;
import com.openshift.internal.client.response.ApplicationResourceDTO;
import com.openshift.internal.client.response.DomainResourceDTO;
import com.openshift.internal.client.response.Link;
import com.openshift.internal.client.response.LinkParameter;
import com.openshift.internal.client.utils.Assert;
import com.openshift.internal.client.utils.CollectionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class DomainResource
extends AbstractOpenShiftResource
implements IDomain {
    private static final String LINK_GET = "GET";
    private static final String LINK_LIST_APPLICATIONS = "LIST_APPLICATIONS";
    private static final String LINK_ADD_APPLICATION = "ADD_APPLICATION";
    private static final String LINK_UPDATE = "UPDATE";
    private static final String LINK_DELETE = "DELETE";
    private String id;
    private String suffix;
    private final APIResource connectionResource;
    private List<IApplication> applications = null;

    protected DomainResource(String namespace, String suffix, Map<String, Link> links, Messages messages, APIResource api) {
        super(api.getService(), links, messages);
        this.id = namespace;
        this.suffix = suffix;
        this.connectionResource = api;
    }

    protected DomainResource(DomainResourceDTO domainDTO, APIResource api) {
        this(domainDTO.getId(), domainDTO.getSuffix(), domainDTO.getLinks(), domainDTO.getMessages(), api);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getSuffix() {
        return this.suffix;
    }

    @Override
    public void rename(String id) throws OpenShiftException {
        Assert.notNull(id);
        DomainResourceDTO domainDTO = new UpdateDomainRequest().execute(id);
        this.id = domainDTO.getId();
        this.suffix = domainDTO.getSuffix();
        this.getLinks().clear();
        this.getLinks().putAll(domainDTO.getLinks());
    }

    @Override
    public IUser getUser() throws OpenShiftException {
        return this.connectionResource.getUser();
    }

    @Override
    public IApplication createApplication(String name, IStandaloneCartridge cartridge) throws OpenShiftException {
        return this.createApplication(name, cartridge, (String)null);
    }

    @Override
    public IApplication createApplication(String name, IStandaloneCartridge cartridge, ApplicationScale scale) throws OpenShiftException {
        return this.createApplication(name, cartridge, scale, null, null);
    }

    @Override
    public IApplication createApplication(String name, IStandaloneCartridge cartridge, String initialGitUrl) throws OpenShiftException {
        return this.createApplication(name, cartridge, null, null, initialGitUrl);
    }

    public IApplication createApplication(String name, IStandaloneCartridge cartridge, ApplicationScale scale, String initialGitUrl) throws OpenShiftException {
        return this.createApplication(name, cartridge, scale, null, initialGitUrl);
    }

    @Override
    public IApplication createApplication(String name, IStandaloneCartridge cartridge, IGearProfile gearProfile) throws OpenShiftException {
        return this.createApplication(name, cartridge, null, gearProfile);
    }

    public IApplication createApplication(String name, IStandaloneCartridge cartridge, IGearProfile gearProfile, String initialGitUrl) throws OpenShiftException {
        return this.createApplication(name, cartridge, null, gearProfile, initialGitUrl);
    }

    @Override
    public IApplication createApplication(String name, IStandaloneCartridge cartridge, ApplicationScale scale, IGearProfile gearProfile) throws OpenShiftException {
        return this.createApplication(name, cartridge, scale, gearProfile, null);
    }

    @Override
    public IApplication createApplication(String name, IStandaloneCartridge cartridge, ApplicationScale scale, IGearProfile gearProfile, String initialGitUrl) throws OpenShiftException {
        return this.createApplication(name, cartridge, scale, gearProfile, initialGitUrl, 0, new IEmbeddableCartridge[0]);
    }

    @Override
    public IApplication createApplication(String name, IStandaloneCartridge cartridge, ApplicationScale scale, IGearProfile gearProfile, String initialGitUrl, int timeout, IEmbeddableCartridge ... cartridges) throws OpenShiftException {
        if (name == null) {
            throw new OpenShiftException("Application name is mandatory but none was given.", new Object[0]);
        }
        if (this.hasApplicationByName(name)) {
            throw new OpenShiftException("Application with name \"{0}\" already exists.", name);
        }
        ApplicationResourceDTO applicationDTO = new CreateApplicationRequest().execute(name, cartridge, scale, gearProfile, initialGitUrl, timeout, null, cartridges);
        ApplicationResource application = new ApplicationResource(applicationDTO, this);
        this.getOrLoadApplications().add(application);
        return application;
    }

    @Override
    public IApplication createApplication(String name, IStandaloneCartridge cartridge, ApplicationScale scale, IGearProfile gearProfile, String initialGitUrl, int timeout, Map<String, String> environmentVariables, IEmbeddableCartridge ... cartridges) throws OpenShiftException {
        if (name == null) {
            throw new OpenShiftException("Application name is mandatory but none was given.", new Object[0]);
        }
        if (this.hasApplicationByName(name)) {
            throw new OpenShiftException("Application with name \"{0}\" already exists.", name);
        }
        ApplicationResourceDTO applicationDTO = new CreateApplicationRequest().execute(name, cartridge, scale, gearProfile, initialGitUrl, timeout, environmentVariables, cartridges);
        ApplicationResource application = new ApplicationResource(applicationDTO, this);
        this.getOrLoadApplications().add(application);
        return application;
    }

    @Override
    public boolean hasApplicationByName(String name) throws OpenShiftException {
        return this.getApplicationByName(name) != null;
    }

    @Override
    public IApplication getApplicationByName(String name) throws OpenShiftException {
        Assert.notNull(name);
        return this.getApplicationByName(name, this.getApplications());
    }

    private IApplication getApplicationByName(String name, Collection<IApplication> applications) throws OpenShiftException {
        Assert.notNull(name);
        if (applications == null) {
            return null;
        }
        IApplication matchingApplication = null;
        for (IApplication application : applications) {
            if (!application.getName().equalsIgnoreCase(name)) continue;
            matchingApplication = application;
            break;
        }
        return matchingApplication;
    }

    @Override
    public List<IApplication> getApplicationsByCartridge(IStandaloneCartridge cartridge) throws OpenShiftException {
        ArrayList<IApplication> matchingApplications = new ArrayList<IApplication>();
        for (IApplication application : this.getApplications()) {
            if (!cartridge.equals(application.getCartridge())) continue;
            matchingApplications.add(application);
        }
        return matchingApplications;
    }

    @Override
    public boolean hasApplicationByCartridge(IStandaloneCartridge cartridge) throws OpenShiftException {
        return this.getApplicationsByCartridge(cartridge).size() > 0;
    }

    @Override
    public boolean canCreateApplicationWithEnvironmentVariables() {
        try {
            Link link = this.getLink(LINK_ADD_APPLICATION);
            return link.hasParameter("environment_variables");
        }
        catch (OpenShiftRequestException e) {
            return false;
        }
    }

    @Override
    public void destroy() throws OpenShiftException {
        this.destroy(false);
    }

    @Override
    public void destroy(boolean force) throws OpenShiftException {
        new DeleteDomainRequest().execute(force);
        this.connectionResource.removeDomain(this);
    }

    @Override
    public List<IApplication> getApplications() throws OpenShiftException {
        return CollectionUtils.toUnmodifiableCopy(this.getOrLoadApplications());
    }

    protected List<IApplication> getOrLoadApplications() throws OpenShiftException {
        if (this.applications == null) {
            this.applications = this.loadApplications();
        }
        return this.applications;
    }

    private List<IApplication> loadApplications() throws OpenShiftException {
        ArrayList<IApplication> applications = new ArrayList<IApplication>();
        List applicationDTOs = (List)new ListApplicationsRequest().execute();
        for (ApplicationResourceDTO dto : applicationDTOs) {
            applications.add(new ApplicationResource(dto, this));
        }
        return applications;
    }

    private List<IApplication> updateApplications() throws OpenShiftException {
        List applicationDTOs = (List)new ListApplicationsRequest().execute();
        this.addOrUpdateApplications(applicationDTOs, this.applications);
        this.removeApplications(applicationDTOs, this.applications);
        return this.applications;
    }

    private List<IApplication> addOrUpdateApplications(List<ApplicationResourceDTO> dtos, List<IApplication> applications) throws OpenShiftException {
        for (ApplicationResourceDTO dto : dtos) {
            this.addOrUpdateApplication(dto, applications);
        }
        return applications;
    }

    private void addOrUpdateApplication(ApplicationResourceDTO applicationDTO, List<IApplication> applications) {
        ApplicationResource application = (ApplicationResource)this.getApplicationByName(applicationDTO.getName(), applications);
        if (application == null) {
            ApplicationResource newApplication = new ApplicationResource(applicationDTO, this);
            applications.add(newApplication);
        } else {
            application.update(applicationDTO);
        }
    }

    private List<IApplication> removeApplications(List<ApplicationResourceDTO> dtos, List<IApplication> applications) {
        ListIterator<IApplication> it = applications.listIterator();
        while (it.hasNext()) {
            IApplication application = it.next();
            if (this.hasApplicationDTOByName(application.getName(), dtos)) continue;
            it.remove();
        }
        return applications;
    }

    private boolean hasApplicationDTOByName(String name, List<ApplicationResourceDTO> dtos) {
        for (ApplicationResourceDTO dto : dtos) {
            if (!name.equals(dto.getName())) continue;
            return true;
        }
        return false;
    }

    protected void removeApplication(IApplication application) {
        this.applications.remove(application);
    }

    @Override
    public List<String> getAvailableCartridgeNames() throws OpenShiftException {
        ArrayList<String> cartridges = new ArrayList<String>();
        for (LinkParameter param : this.getLink(LINK_ADD_APPLICATION).getRequiredParams()) {
            if (!param.getName().equals("cartridge")) continue;
            for (String option : param.getValidOptions()) {
                cartridges.add(option);
            }
        }
        return cartridges;
    }

    @Override
    public List<IGearProfile> getAvailableGearProfiles() throws OpenShiftException {
        ArrayList<IGearProfile> gearSizes = new ArrayList<IGearProfile>();
        for (LinkParameter param : this.getLink(LINK_ADD_APPLICATION).getOptionalParams()) {
            if (!param.getName().equals("gear_profile")) continue;
            for (String option : param.getValidOptions()) {
                gearSizes.add(new GearProfile(option));
            }
        }
        return gearSizes;
    }

    @Override
    public void refresh() throws OpenShiftException {
        DomainResourceDTO domainResourceDTO = new GetDomainRequest().execute();
        this.id = domainResourceDTO.getId();
        this.suffix = domainResourceDTO.getSuffix();
        if (this.applications == null) {
            this.loadApplications();
        } else {
            this.updateApplications();
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.suffix == null ? 0 : this.suffix.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DomainResource other = (DomainResource)obj;
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        return !(this.suffix == null ? other.suffix != null : !this.suffix.equals(other.suffix));
    }

    public String toString() {
        return "Domain [id=" + this.id + ", " + "suffix=" + this.suffix + "]";
    }

    private class DeleteDomainRequest
    extends AbstractOpenShiftResource.ServiceRequest {
        private DeleteDomainRequest() throws OpenShiftException {
            super(DomainResource.this, DomainResource.LINK_DELETE);
        }

        protected void execute(boolean force) throws OpenShiftException {
            super.execute(new StringParameter("force", String.valueOf(force)));
        }
    }

    private class UpdateDomainRequest
    extends AbstractOpenShiftResource.ServiceRequest {
        private UpdateDomainRequest() throws OpenShiftException {
            super(DomainResource.this, DomainResource.LINK_UPDATE);
        }

        protected DomainResourceDTO execute(String namespace) throws OpenShiftException {
            return (DomainResourceDTO)super.execute(new StringParameter("id", namespace));
        }
    }

    private class CreateApplicationRequest
    extends AbstractOpenShiftResource.ServiceRequest {
        private CreateApplicationRequest() throws OpenShiftException {
            super(DomainResource.this, DomainResource.LINK_ADD_APPLICATION);
        }

        protected ApplicationResourceDTO execute(String name, IStandaloneCartridge cartridge, ApplicationScale scale, IGearProfile gearProfile, String initialGitUrl, int timeout, Map<String, String> environmentVariables, IEmbeddableCartridge ... embeddableCartridges) throws OpenShiftException {
            if (cartridge == null) {
                throw new OpenShiftException("Application cartridge is mandatory but was not given.", new Object[0]);
            }
            AbstractOpenShiftResource.Parameters parameters = new AbstractOpenShiftResource.Parameters().add("name", name).addCartridges(cartridge, embeddableCartridges).scale(scale).gearProfile(gearProfile).add("initial_git_url", initialGitUrl).addEnvironmentVariables(environmentVariables);
            AbstractOpenShiftResource.Parameters urlParameters = new AbstractOpenShiftResource.Parameters().include("cartridges");
            return (ApplicationResourceDTO)this.execute(timeout, urlParameters.toList(), parameters.toArray());
        }
    }

    private class ListApplicationsRequest
    extends AbstractOpenShiftResource.ServiceRequest {
        private ListApplicationsRequest() throws OpenShiftException {
            super(DomainResource.this, DomainResource.LINK_LIST_APPLICATIONS);
        }

        protected <DTO> DTO execute() throws OpenShiftException {
            AbstractOpenShiftResource.Parameters urlParameters = new AbstractOpenShiftResource.Parameters().include("cartridges");
            return super.execute(urlParameters.toList(), new Parameter[0]);
        }
    }

    private class GetDomainRequest
    extends AbstractOpenShiftResource.ServiceRequest {
        private GetDomainRequest() throws OpenShiftException {
            super(DomainResource.this, DomainResource.LINK_GET);
        }

        protected DomainResourceDTO execute() throws OpenShiftException {
            return (DomainResourceDTO)super.execute(new Parameter[0]);
        }
    }
}

