/******************************************************************************* 
 * Copyright (c) 2012 Red Hat, Inc. 
 * Distributed under license by Red Hat, Inc. All rights reserved. 
 * This program is made available under the terms of the 
 * Eclipse Public License v1.0 which accompanies this distribution, 
 * and is available at http://www.eclipse.org/legal/epl-v10.html 
 * 
 * Contributors: 
 * Red Hat, Inc. - initial API and implementation 
 ******************************************************************************/
package com.openshift.internal.client.response;



/**
 * @author Andre Dietisheim
 */
public class LinkParameterType {
	
	
	public static final LinkParameterType STRING = new LinkParameterType("string");
	public static final LinkParameterType BOOLEAN = new LinkParameterType("boolean");
	public static final LinkParameterType INTEGER = new LinkParameterType("integer");
	public static final LinkParameterType ARRAY = new LinkParameterType("array");
		
	private String type;

	public LinkParameterType(String type) {
		this.type = type;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((type == null) ? 0 : type.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		LinkParameterType other = (LinkParameterType) obj;
		if (type == null) {
			if (other.type != null)
				return false;
		} else if (!type.equals(other.type))
			return false;
		return true;
	}
}
