/*
 * Decompiled with CFR 0.152.
 */
package com.opentable.db.postgres.junit;

import com.google.common.base.Preconditions;
import com.opentable.db.postgres.embedded.EmbeddedPostgres;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import org.junit.rules.ExternalResource;

public class SingleInstancePostgresRule
extends ExternalResource {
    private volatile EmbeddedPostgres epg;
    private volatile Connection postgresConnection;

    SingleInstancePostgresRule() {
    }

    protected void before() throws Throwable {
        super.before();
        this.epg = EmbeddedPostgres.start();
        this.postgresConnection = this.epg.getPostgresDatabase().getConnection();
    }

    public EmbeddedPostgres getEmbeddedPostgres() {
        EmbeddedPostgres epg = this.epg;
        Preconditions.checkState((epg != null ? 1 : 0) != 0, (Object)"JUnit test not started yet!");
        return epg;
    }

    protected void after() {
        try {
            this.postgresConnection.close();
        }
        catch (SQLException e) {
            throw new AssertionError((Object)e);
        }
        try {
            this.epg.close();
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }
}

