/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.base;

import com.oracle.coherence.common.base.SingleWaiterMultiNotifier;
import com.oracle.coherence.common.collections.ConcurrentLinkedQueue;
import java.util.Queue;
import java.util.concurrent.locks.LockSupport;

public class SingleWaiterCooperativeNotifier
extends SingleWaiterMultiNotifier {
    protected Thread m_threadAwait;
    protected static byte s_cSignal;
    private static final Queue<SingleWaiterCooperativeNotifier> s_queueDeferred;
    private static final int FLUSH_AWAKE_COUNT;

    public static void flush() {
        SingleWaiterCooperativeNotifier.flush(FLUSH_AWAKE_COUNT, null);
    }

    @Override
    public void await(long cMillis) throws InterruptedException {
        SingleWaiterCooperativeNotifier.flush(cMillis <= 0L || cMillis > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)cMillis, this);
        try {
            this.m_threadAwait = Thread.currentThread();
            super.await(cMillis);
        }
        finally {
            SingleWaiterCooperativeNotifier.flush(2, null);
        }
    }

    @Override
    public void signal() {
        if (this.signalInternal() != null) {
            s_queueDeferred.add(this);
        }
        if ((s_cSignal = (byte)(s_cSignal + 1)) == 0) {
            SingleWaiterCooperativeNotifier.flush(1, null);
        }
    }

    @Override
    public String toString() {
        String s = super.toString();
        Thread thread = this.m_threadAwait;
        if (thread != null && !s.endsWith(")")) {
            s = s + "(" + thread + ")";
        }
        return s + "/" + s_queueDeferred.size();
    }

    protected static void flush(int cWake, SingleWaiterCooperativeNotifier self) {
        SingleWaiterCooperativeNotifier notifier;
        int i = 0;
        while (i < cWake && (self == null || self.m_oState == null) && (notifier = s_queueDeferred.poll()) != null) {
            Object oState = notifier.m_oState;
            Thread thread = notifier.m_threadAwait;
            if (oState != notifier || thread == null) continue;
            LockSupport.unpark(thread);
            ++i;
        }
    }

    @Override
    protected void consumeSignal() {
        this.m_threadAwait = null;
        super.consumeSignal();
    }

    static {
        s_queueDeferred = new ConcurrentLinkedQueue<SingleWaiterCooperativeNotifier>();
        FLUSH_AWAKE_COUNT = Integer.parseInt(System.getProperty(SingleWaiterCooperativeNotifier.class.getName() + ".wakeOnFlush", "1"));
    }
}

