/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.internal.io;

import com.oracle.coherence.common.base.InverseComparator;
import com.oracle.coherence.common.internal.io.WrapperBufferManager;
import com.oracle.coherence.common.internal.util.HeapDump;
import com.oracle.coherence.common.io.BufferManager;
import com.oracle.coherence.common.io.BufferManagers;
import com.oracle.coherence.common.util.MemorySize;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CheckedBufferManager
extends WrapperBufferManager {
    protected static final Logger LOGGER = Logger.getLogger(CheckedBufferManager.class.getName());
    protected static final long BYTE_WARNING_INTERVAL = new MemorySize(System.getProperty(CheckedBufferManager.class.getName() + ".limit", String.valueOf(Runtime.getRuntime().maxMemory() / 10L))).getByteCount();
    protected static final boolean DUMP_ON_WARNING = Boolean.getBoolean(CheckedBufferManager.class.getName() + ".dump");
    protected static final int SAMPLING_RATIO = Integer.parseInt(System.getProperty(CheckedBufferManager.class.getName() + ".samplingRatio", "1"));
    protected final Map<ByteBuffer, AcquisitionSite> m_mapAllocated = Collections.synchronizedMap(new IdentityHashMap());
    protected final AtomicLong m_cbBufferAllocated = new AtomicLong();
    protected final AtomicLong m_cbWarnNext = new AtomicLong(BYTE_WARNING_INTERVAL);
    protected final AtomicLong m_cbLow = new AtomicLong();
    protected final AtomicLong m_cbHigh = new AtomicLong();

    public CheckedBufferManager(BufferManager mgr) {
        super(mgr);
    }

    @Override
    public ByteBuffer acquire(int cbMin) {
        AcquisitionSite errorSite;
        ByteBuffer buff;
        int cAttempts = 0;
        AcquisitionSite site = null;
        do {
            errorSite = site;
            buff = this.f_delegate.acquire(cbMin);
            ++cAttempts;
        } while (!CheckedBufferManager.zeroed(buff) || (site = this.m_mapAllocated.put(buff, new AcquisitionSite())) != null);
        this.checkLeaks(this.m_cbBufferAllocated.addAndGet(buff.capacity()));
        if (cAttempts > 1) {
            LOGGER.log(Level.WARNING, "Compensating for unaccounted for ByteBuffer re-use of " + (cAttempts - 1) + " buffers for request size of " + cbMin + " from " + this.f_delegate + (errorSite == null ? "" : " last " + errorSite));
        }
        return buff;
    }

    @Override
    public ByteBuffer acquirePref(int cbPref) {
        AcquisitionSite errorSite;
        ByteBuffer buff;
        int cAttempts = 0;
        AcquisitionSite site = null;
        do {
            errorSite = site;
            buff = this.f_delegate.acquirePref(cbPref);
            ++cAttempts;
        } while (!CheckedBufferManager.zeroed(buff) || (site = this.m_mapAllocated.put(buff, new AcquisitionSite())) != null);
        this.checkLeaks(this.m_cbBufferAllocated.addAndGet(buff.capacity()));
        if (cAttempts > 1) {
            LOGGER.log(Level.WARNING, "Compensating for unaccounted for ByteBuffer re-use of " + (cAttempts - 1) + " buffers for prefered size of " + cbPref + " from " + this.f_delegate + (errorSite == null ? "" : " last " + errorSite));
        }
        return buff;
    }

    @Override
    public ByteBuffer acquireSum(int cbSum) {
        AcquisitionSite errorSite;
        ByteBuffer buff;
        int cAttempts = 0;
        AcquisitionSite site = null;
        do {
            errorSite = site;
            buff = this.f_delegate.acquireSum(cbSum);
            ++cAttempts;
        } while (!CheckedBufferManager.zeroed(buff) || (site = this.m_mapAllocated.put(buff, new AcquisitionSite())) != null);
        this.checkLeaks(this.m_cbBufferAllocated.addAndGet(buff.capacity()));
        if (cAttempts > 1) {
            LOGGER.log(Level.WARNING, "Compensating for unaccounted for ByteBuffer re-use of " + (cAttempts - 1) + " buffers for accumulated size of " + cbSum + this.f_delegate + (errorSite == null ? "" : " last " + errorSite));
        }
        return buff;
    }

    @Override
    public ByteBuffer truncate(ByteBuffer buff) {
        RuntimeException e;
        Map<ByteBuffer, AcquisitionSite> mapAllocated = this.m_mapAllocated;
        AcquisitionSite site = mapAllocated.remove(buff);
        if (site == null) {
            e = new IllegalArgumentException("Rejecting attempt to truncate unknown buffer of size " + buff.capacity() + " from " + this.f_delegate);
        } else {
            ByteBuffer buffNew = this.f_delegate.truncate(buff);
            this.checkLeaks(this.m_cbBufferAllocated.addAndGet(buffNew.capacity() - buff.capacity()));
            AcquisitionSite errorSite = mapAllocated.put(buffNew, buff == buffNew ? site : new AcquisitionSite());
            if (errorSite == null) {
                return buffNew;
            }
            e = new IllegalStateException("Unable to safely compensate for unaccounted  ByteBuffer re-use of truncated buffer size of " + buff.limit() + " to " + this.f_delegate + " prior " + errorSite);
        }
        LOGGER.log(Level.SEVERE, e.getMessage(), e);
        throw e;
    }

    @Override
    public void release(ByteBuffer buff) {
        if (this.m_mapAllocated.remove(buff) == null) {
            IllegalArgumentException e = new IllegalArgumentException("Rejecting attempt to release unknown buffer of size " + buff.capacity() + " to " + this.f_delegate);
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
            throw e;
        }
        this.m_cbBufferAllocated.addAndGet(-buff.capacity());
        this.f_delegate.release(buff);
    }

    @Override
    public String toString() {
        int cBuff = this.m_mapAllocated.size();
        long cbNow = this.m_cbBufferAllocated.get();
        long cbHigh = this.m_cbHigh.get();
        long cbLow = this.m_cbLow.get();
        SortedSet<LeakSuspect> setSuspect = this.getSuspects(BYTE_WARNING_INTERVAL / 4L);
        StringBuilder sb = new StringBuilder().append("CheckedBufferManager(oustanding buffers=").append(cBuff).append(", bytes(low=").append(new MemorySize(cbLow)).append(", allocated=").append(new MemorySize(cbNow)).append(", high=").append(new MemorySize(cbHigh)).append("), suspects=").append(setSuspect.size()).append(", delegate=").append(this.f_delegate).append(")");
        if (setSuspect.size() > 0) {
            sb.append("\nSuspects:");
        }
        for (LeakSuspect record : setSuspect) {
            sb.append("\n").append(record);
        }
        return sb.toString();
    }

    @Override
    public void dispose() {
        this.f_delegate.dispose();
    }

    protected static boolean zeroed(ByteBuffer buffer) {
        if (BufferManagers.ZERO_ON_RELEASE) {
            int cb = buffer.capacity();
            int ofLim = buffer.limit();
            buffer.limit(cb);
            for (int i = 0; i < cb; ++i) {
                if (buffer.get(i) == 0) continue;
                return false;
            }
            buffer.limit(ofLim);
        }
        return true;
    }

    protected void checkLeaks(long cbAllocated) {
        long cbWarnNext = this.m_cbWarnNext.get();
        if (cbAllocated > cbWarnNext && this.m_cbWarnNext.compareAndSet(cbWarnNext, Math.max(cbAllocated, cbWarnNext) + BYTE_WARNING_INTERVAL)) {
            String sDump = DUMP_ON_WARNING ? HeapDump.dumpHeap() : null;
            String sSuffix = sDump == null ? "" : "; " + sDump + " has been collected for analysis";
            LOGGER.warning("Passing new allocation limit: " + this + sSuffix);
            this.m_cbLow.set(cbAllocated);
            this.m_cbHigh.set(cbAllocated);
        } else {
            long cbLow = this.m_cbLow.get();
            while (cbAllocated < cbLow && !this.m_cbLow.compareAndSet(cbLow, cbAllocated)) {
                cbLow = this.m_cbLow.get();
            }
            long cbHigh = this.m_cbHigh.get();
            while (cbAllocated > cbHigh && !this.m_cbHigh.compareAndSet(cbHigh, cbAllocated)) {
                cbHigh = this.m_cbHigh.get();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedSet<LeakSuspect> getSuspects(long cbSuspect) {
        Map.Entry[] aEntry = new Map.Entry[]{};
        Map<ByteBuffer, AcquisitionSite> map = this.m_mapAllocated;
        synchronized (map) {
            aEntry = this.m_mapAllocated.entrySet().toArray(aEntry);
        }
        TreeSet<LeakSuspect> setSuspect = new TreeSet<LeakSuspect>(InverseComparator.INSTANCE);
        HashMap<AcquisitionSite, LeakSuspect> mapRecords = new HashMap<AcquisitionSite, LeakSuspect>();
        for (Map.Entry entry : aEntry) {
            ByteBuffer buff = (ByteBuffer)entry.getKey();
            AcquisitionSite site = (AcquisitionSite)entry.getValue();
            LeakSuspect record = (LeakSuspect)mapRecords.get(site);
            if (record == null) {
                record = new LeakSuspect();
                record.site = (AcquisitionSite)entry.getValue();
                mapRecords.put(site, record);
            }
            ++record.cOccurances;
            record.cb += (long)buff.capacity();
            if (record.cb <= cbSuspect) continue;
            setSuspect.add(record);
        }
        return setSuspect;
    }

    public static class LeakSuspect
    implements Comparable<LeakSuspect> {
        AcquisitionSite site;
        long cOccurances;
        long cb;

        public AcquisitionSite getAcquisitionSite() {
            return this.site;
        }

        public long getByteCount() {
            return this.cb;
        }

        public long getBufferCount() {
            return this.cOccurances;
        }

        @Override
        public int compareTo(LeakSuspect that) {
            long cbDiff = this.cb - that.cb;
            long cDiff = this.cOccurances - that.cOccurances;
            return (int)(cbDiff == 0L ? (cDiff == 0L ? (long)(this.hashCode() - that.hashCode()) : cDiff) : cbDiff);
        }

        public String toString() {
            return this.cOccurances + " acquisitions consuming a total of " + new MemorySize(this.cb) + " from " + this.site;
        }
    }

    public static class AcquisitionSite {
        final StackTraceElement[] f_aStackTraceElement;

        public AcquisitionSite() {
            if (SAMPLING_RATIO == 1 || ThreadLocalRandom.current().nextInt(SAMPLING_RATIO) == 0) {
                StackTraceElement[] stack = new Throwable().getStackTrace();
                if (stack.length > 1) {
                    StackTraceElement[] stackTrim = new StackTraceElement[stack.length - 1];
                    for (int i = 0; i < stackTrim.length; ++i) {
                        stackTrim[i] = stack[i + 1];
                    }
                    stack = stackTrim;
                }
                this.f_aStackTraceElement = stack;
            } else {
                this.f_aStackTraceElement = null;
            }
        }

        public StackTraceElement[] getStackTrace() {
            return this.f_aStackTraceElement;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("AcquisitionSite");
            StackTraceElement[] stack = this.getStackTrace();
            if (stack == null) {
                return sb.append(" - unsampled").toString();
            }
            sb.append('\n');
            for (StackTraceElement e : stack) {
                sb.append("\tat ").append(e).append('\n');
            }
            return sb.toString();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            return Arrays.equals(this.getStackTrace(), ((AcquisitionSite)obj).getStackTrace());
        }

        public int hashCode() {
            return Arrays.hashCode(this.getStackTrace());
        }
    }
}

