/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.internal.net;

import com.oracle.coherence.common.internal.net.WrapperSelector;
import com.oracle.coherence.common.internal.net.WrapperSocket;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import java.util.Set;

public class WrapperSocketChannel
extends SocketChannel
implements WrapperSelector.WrapperSelectableChannel {
    protected final SocketChannel f_delegate;
    protected final Socket f_socket;

    public WrapperSocketChannel(SocketChannel channel, SelectorProvider provider) {
        super(provider);
        this.f_delegate = channel;
        this.f_socket = this.wrapSocket(channel.socket());
    }

    protected Socket wrapSocket(Socket socket) {
        return new WrapperSocket(socket){

            @Override
            public SocketChannel getChannel() {
                return WrapperSocketChannel.this;
            }
        };
    }

    public static SocketChannel open() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Socket socket() {
        return this.f_socket;
    }

    @Override
    public boolean isConnected() {
        return this.f_delegate.isConnected();
    }

    @Override
    public boolean isConnectionPending() {
        return this.f_delegate.isConnectionPending();
    }

    @Override
    public boolean connect(SocketAddress remote) throws IOException {
        return this.f_delegate.connect(remote);
    }

    @Override
    public boolean finishConnect() throws IOException {
        return this.f_delegate.finishConnect();
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        return this.f_delegate.read(dst);
    }

    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        return this.f_delegate.read(dsts, offset, length);
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        return this.f_delegate.write(src);
    }

    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        return this.f_delegate.write(srcs, offset, length);
    }

    @Override
    protected void implCloseSelectableChannel() throws IOException {
        this.f_delegate.close();
    }

    @Override
    protected void implConfigureBlocking(boolean block) throws IOException {
        this.f_delegate.configureBlocking(block);
    }

    @Override
    public SocketChannel bind(SocketAddress local) throws IOException {
        return this.f_delegate.bind(local);
    }

    @Override
    public <T> SocketChannel setOption(SocketOption<T> name, T value) throws IOException {
        return this.f_delegate.setOption((SocketOption)name, (Object)value);
    }

    @Override
    public SocketChannel shutdownInput() throws IOException {
        return this.f_delegate.shutdownInput();
    }

    @Override
    public SocketChannel shutdownOutput() throws IOException {
        return this.f_delegate.shutdownOutput();
    }

    @Override
    public SocketAddress getRemoteAddress() throws IOException {
        return this.f_delegate.getRemoteAddress();
    }

    @Override
    public SocketAddress getLocalAddress() throws IOException {
        return this.f_delegate.getLocalAddress();
    }

    @Override
    public <T> T getOption(SocketOption<T> name) throws IOException {
        return this.f_delegate.getOption(name);
    }

    @Override
    public Set<SocketOption<?>> supportedOptions() {
        return this.f_delegate.supportedOptions();
    }

    @Override
    public WrapperSelector.WrapperSelectionKey registerInternal(WrapperSelector selector, int ops, Object att) throws IOException {
        return new WrapperSelector.WrapperSelectionKey(selector, this.f_delegate.register(selector.getDelegate(), ops), att){

            @Override
            public SelectableChannel channel() {
                return WrapperSocketChannel.this;
            }
        };
    }
}

