/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.internal.net.ssl;

import java.io.ByteArrayInputStream;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;

public class SSLCertUtility {
    private static final String WILDCARD_PREFIX = "*.";

    public static X509Certificate toX509(Certificate cert) throws CertificateException {
        if (cert == null) {
            return null;
        }
        if (cert instanceof X509Certificate) {
            return (X509Certificate)cert;
        }
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        return (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(cert.getEncoded()));
    }

    public static X509Certificate getPeerLeafCert(SSLSession session) {
        try {
            Certificate[] certs = session.getPeerCertificates();
            return certs == null || certs.length == 0 ? null : SSLCertUtility.toX509(certs[0]);
        }
        catch (CertificateException | SSLPeerUnverifiedException ignored) {
            return null;
        }
    }

    public static String getCommonName(X509Certificate cert) {
        String dn;
        int index;
        String cn = null;
        if (cert != null && (index = (dn = cert.getSubjectX500Principal().getName()).indexOf("CN=")) >= 0) {
            boolean containsEscapeCharacters = false;
            int start = index + 3;
            int end = dn.indexOf(44, start);
            while (end > 0 && dn.charAt(end - 1) == '\\') {
                containsEscapeCharacters = true;
                end = dn.indexOf(",", end + 1);
            }
            if (end < 0) {
                end = dn.length();
            }
            cn = dn.substring(start, end);
            if (containsEscapeCharacters) {
                int cnLength = cn.length();
                StringBuffer buf = new StringBuffer(cnLength);
                for (int i = 0; i < cnLength; ++i) {
                    char c = cn.charAt(i);
                    if (c == '\\') {
                        if (++i == cnLength) break;
                        c = cn.charAt(i);
                    }
                    buf.append(c);
                }
                cn = buf.toString();
            }
        }
        return cn;
    }

    public static String getCommonName(SSLSession session) {
        return SSLCertUtility.getCommonName(SSLCertUtility.getPeerLeafCert(session));
    }

    public static Collection<String> getDNSSubjAltNames(SSLSession session, boolean fWildcardSANDNSNames, boolean fNonWildcardSANDNSNames) {
        Collection<List<?>> sansCollection;
        X509Certificate cert = SSLCertUtility.getPeerLeafCert(session);
        if (cert == null) {
            return null;
        }
        try {
            sansCollection = cert.getSubjectAlternativeNames();
        }
        catch (CertificateParsingException cpe) {
            return null;
        }
        if (sansCollection == null) {
            return null;
        }
        ArrayList<String> dnsNames = new ArrayList<String>();
        for (List<?> generalName : sansCollection) {
            ListIterator<?> li = generalName.listIterator();
            while (li.hasNext()) {
                int index;
                Object ob = li.next();
                if (!(ob instanceof Integer) || (index = ((Integer)ob).intValue()) != 2 || !li.hasNext()) continue;
                String dnsName = (String)li.next();
                if (!fWildcardSANDNSNames && dnsName != null && dnsName.startsWith(WILDCARD_PREFIX) || !fNonWildcardSANDNSNames && dnsName != null && !dnsName.startsWith(WILDCARD_PREFIX)) continue;
                dnsNames.add(dnsName);
            }
        }
        return dnsNames;
    }
}

