/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.internal.security;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Principal;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.X509TrustManager;

public class PeerX509TrustManager
implements X509TrustManager {
    protected final KeyStore m_keyStore;
    public static final String ALGORITHM = "PeerX509";
    private static final String CN_PREFIX = "CN=";
    private static final int CN_PREFIX_LENGTH = "CN=".length();
    private static final X509Certificate[] EMPTY_CERTS = new X509Certificate[0];

    public PeerX509TrustManager(KeyStore keyStore) {
        if (keyStore == null) {
            throw new IllegalArgumentException();
        }
        this.m_keyStore = keyStore;
    }

    public void checkPeerTrusted(X509Certificate[] aCert, String sAuthType) throws CertificateException {
        if (aCert == null || aCert.length == 0) {
            throw new IllegalArgumentException("Missing required certificate chain");
        }
        if (aCert == null || aCert.length == 0 || sAuthType == null || sAuthType.length() == 0) {
            throw new IllegalArgumentException("Missing required authentication type");
        }
        try {
            if (this.m_keyStore.getCertificateAlias(aCert[0]) == null) {
                throw new CertificateException("Untrusted peer: " + this.getCommonName(aCert[0].getSubjectDN()));
            }
        }
        catch (KeyStoreException e) {
            throw new CertificateException(e);
        }
    }

    @Override
    public void checkClientTrusted(X509Certificate[] aCert, String sAuthType) throws CertificateException {
        this.checkPeerTrusted(aCert, sAuthType);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] aCert, String sAuthType) throws CertificateException {
        this.checkPeerTrusted(aCert, sAuthType);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return EMPTY_CERTS;
    }

    protected String getCommonName(Principal principal) {
        String sCN = null;
        String sDN = principal.getName();
        int i = sDN.toUpperCase().indexOf(CN_PREFIX);
        if (i != -1) {
            int j = sDN.indexOf(",", i += CN_PREFIX_LENGTH);
            if (j == -1) {
                j = sDN.length();
            }
            sCN = sDN.substring(i, j);
        }
        return sCN;
    }
}

