/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.internal.util;

public class CanonicalNames {
    public static final String VALUE_EXTRACTOR_METHOD_SUFFIX = "()";
    public static final String[] VALUE_EXTRACTOR_BEAN_ACCESSOR_PREFIXES = new String[]{"get", "is"};

    public static String computeValueExtractorCanonicalName(String sName, Object[] aoParam) {
        int nMethodSuffixLength = VALUE_EXTRACTOR_METHOD_SUFFIX.length();
        if (aoParam != null && aoParam.length > 0) {
            return null;
        }
        if (sName.endsWith(VALUE_EXTRACTOR_METHOD_SUFFIX)) {
            String sNameCanonical = sName;
            int nNameLength = sName.length();
            for (String sPrefix : VALUE_EXTRACTOR_BEAN_ACCESSOR_PREFIXES) {
                int nPrefixLength = sPrefix.length();
                if (nNameLength <= nPrefixLength || !sName.startsWith(sPrefix)) continue;
                sNameCanonical = Character.toLowerCase(sName.charAt(nPrefixLength)) + sName.substring(nPrefixLength + 1, nNameLength - nMethodSuffixLength);
                break;
            }
            return sNameCanonical;
        }
        return sName;
    }

    public static String computeValueExtractorCanonicalName(String sName) {
        return CanonicalNames.computeValueExtractorCanonicalName(sName, null);
    }
}

