/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.internal.util;

import com.oracle.coherence.common.base.Converter;
import com.tangosol.util.Base;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.PrintStream;
import java.time.LocalTime;

public class Histogram
implements Cloneable,
Externalizable {
    private static final String[] f_asPercentage = new String[]{"33%", "66%", "99%", "99.9%", "99.99%", "99.999%"};
    private static final double[] f_adPercentage = new double[]{0.33, 0.66, 0.99, 0.999, 0.9999, 0.99999, 1.0};
    protected long[] m_alResults;
    protected Converter<Double, String> m_formatter = new Converter<Double, String>(){

        @Override
        public String convert(Double value) {
            return value.toString();
        }
    };

    public Histogram(int cLabels) {
        this.m_alResults = new long[cLabels];
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public Histogram setFormatter(Converter<Double, String> formatter) {
        this.m_formatter = formatter;
        return this;
    }

    public int getIndex(int nSample) {
        return nSample;
    }

    public int getLabelMin(int i) {
        return i;
    }

    public int getLabelMax(int i) {
        return this.getLabelMin(i + 1) - 1;
    }

    public int getLabelMedian(int i) {
        int nMin = this.getLabelMin(i);
        int nMax = this.getLabelMax(i);
        return nMin + (nMax - nMin) / 2;
    }

    public String getLabelText(int i) {
        Converter<Double, String> formatter = this.m_formatter;
        if (i < 0) {
            return "n/a";
        }
        if (i == 0) {
            return "<" + formatter.convert(Double.valueOf(this.getLabelMin(1)));
        }
        if (i == this.m_alResults.length - 1) {
            return ">" + formatter.convert(Double.valueOf(this.getLabelMin(i)));
        }
        int nMin = this.getLabelMin(i);
        int nMax = this.getLabelMax(i);
        int nMedian = this.getLabelMedian(i);
        int nRange = nMax - nMin;
        if (nRange > 1) {
            return formatter.convert(Double.valueOf(nMedian)) + " +/-" + formatter.convert((double)nRange / 2.0);
        }
        return formatter.convert(Double.valueOf(nMedian));
    }

    public void addSample(int nSampleValue) {
        long[] alResults = this.m_alResults;
        int i = this.getIndex(nSampleValue);
        int n = i = Math.max(0, Math.min(i, alResults.length - 1));
        alResults[n] = alResults[n] + 1L;
    }

    public void addSamples(Histogram histThat) {
        long[] alResultThat = histThat.getResults();
        long[] alResult = this.m_alResults;
        int c = alResultThat.length;
        for (int i = 0; i < c; ++i) {
            int n = i;
            alResult[n] = alResult[n] + alResultThat[i];
        }
    }

    public Histogram compare(Histogram histThat) {
        Histogram histDiff;
        try {
            histDiff = (Histogram)this.clone();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (histThat == null) {
            histDiff.m_alResults = (long[])this.getResults().clone();
        } else {
            long[] alResultThat = histThat.getResults();
            long[] alResult = this.m_alResults;
            histDiff.m_alResults = new long[alResultThat.length];
            long[] alResultDiff = histDiff.m_alResults;
            int c = alResultThat.length;
            for (int i = 0; i < c; ++i) {
                alResultDiff[i] = alResult[i] - alResultThat[i];
            }
        }
        return histDiff;
    }

    public long[] getResults() {
        return this.m_alResults;
    }

    public Snapshot snapshot() {
        return new Snapshot(this);
    }

    public long getSampleCount() {
        long[] alResults = this.m_alResults;
        long cSamples = 0L;
        for (long cSample : alResults) {
            if (cSample <= 0L) continue;
            cSamples += cSample;
        }
        return cSamples;
    }

    public String toString() {
        Snapshot snapshot = new Snapshot(this);
        Converter<Double, String> formatter = this.m_formatter;
        StringBuilder sb = new StringBuilder();
        sb.append("samples ").append(snapshot.getSampleCount());
        sb.append("; avg ").append(formatter.convert(snapshot.getAverage()));
        sb.append("; stddev ").append(formatter.convert(snapshot.getStdDev()));
        sb.append("; min ").append(this.getLabelText(snapshot.getMin()));
        int[] anPercentile = snapshot.getPercentiles();
        String[] asPercentage = snapshot.getPercentileNames();
        int c = anPercentile.length;
        for (int i = 0; i < c; ++i) {
            if (i != anPercentile.length - 1 && anPercentile[i] == anPercentile[i + 1]) continue;
            sb.append("; " + asPercentage[i] + " <" + formatter.convert(Double.valueOf(this.getLabelMax(anPercentile[i]))));
        }
        sb.append("; max ").append(this.getLabelText(snapshot.getMax()));
        return sb.toString();
    }

    public void writeReport(PrintStream out) {
        long[] alResults = this.m_alResults;
        int c = alResults.length;
        for (int i = 0; i < c; ++i) {
            long cSample = alResults[i];
            if (cSample <= 0L) continue;
            out.println(this.getLabelText(i) + '\t' + cSample);
        }
    }

    public void writeReportHeaderHz(PrintStream out) {
        long[] alResults = this.m_alResults;
        int c = alResults.length;
        for (int i = 0; i < c; ++i) {
            out.print(this.getLabelText(i) + '\t');
        }
        out.println();
    }

    public void writeReportHz(PrintStream out) {
        long[] alResults = this.m_alResults;
        int cSkip = 0;
        int c = alResults.length;
        for (int i = 0; i < c; ++i) {
            long cSample = alResults[i];
            if (cSample == 0L) {
                ++cSkip;
                continue;
            }
            while (cSkip > 0) {
                out.print("0\t");
                --cSkip;
            }
            out.print(alResults[i] + "\t");
        }
        out.println();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.readExternal((DataInput)in);
    }

    public void readExternal(DataInput dataInput) throws IOException {
        int c = dataInput.readInt();
        this.m_alResults = c <= 0 ? new long[]{} : (c < 0xFFFFFF ? this.readHistgram(dataInput, c) : this.readLargeHistgram(dataInput, c));
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.writeExternal((DataOutput)out);
    }

    public void writeExternal(DataOutput dataOutput) throws IOException {
        long[] alResults = this.m_alResults;
        int c = alResults.length;
        dataOutput.writeInt(c);
        int iSkipStart = -1;
        for (int i = 0; i < c; ++i) {
            long n = alResults[i];
            if (n == 0L) {
                if (iSkipStart >= 0) continue;
                iSkipStart = i;
                continue;
            }
            if (iSkipStart >= 0) {
                dataOutput.writeLong(iSkipStart - i);
                iSkipStart = -1;
            }
            dataOutput.writeLong(n);
        }
        if (iSkipStart >= 0) {
            dataOutput.writeLong(iSkipStart - c);
        }
    }

    private long[] readHistgram(DataInput in, int c) throws IOException {
        long[] alResults = new long[c];
        int i = 0;
        while (i < c) {
            long n = in.readLong();
            if (n < 0L) {
                i = (int)((long)i + -n);
                continue;
            }
            alResults[i++] = n;
        }
        return alResults;
    }

    private long[] readLargeHistgram(DataInput in, int cLength) throws IOException {
        int cBatchMax = 0x7FFFFF;
        int cBatch = cLength / cBatchMax + 1;
        long[] aMerged = null;
        int cRead = 0;
        int cAllocate = cBatchMax;
        for (int i = 0; i < cBatch && cRead < cLength; ++i) {
            long[] al = this.readHistgram(in, cAllocate);
            aMerged = Base.mergeLongArray(aMerged, al);
            cAllocate = Math.min(cLength - (cRead += al.length), cBatchMax);
        }
        return aMerged;
    }

    public static class Snapshot {
        protected long m_cSamples = 0L;
        protected int m_iMin = -1;
        protected int m_iMax = 0;
        protected LocalTime m_timestamp = LocalTime.now();
        protected int[] m_anPercentile;
        protected double m_dAvg;
        protected double m_dStddev;

        Snapshot(Histogram histogram) {
            long[] alResults = histogram.getResults();
            long cTotal = 0L;
            double cTotalSq = 0.0;
            int c = alResults.length;
            for (int i = 0; i < c; ++i) {
                long cSample = alResults[i];
                if (cSample <= 0L) continue;
                if (this.m_iMin == -1) {
                    this.m_iMin = i;
                }
                this.m_iMax = i;
                this.m_cSamples += cSample;
                int nMedian = histogram.getLabelMedian(i);
                cTotal += cSample * (long)nMedian;
                cTotalSq += (double)(cSample * (long)nMedian * (long)nMedian);
            }
            this.m_anPercentile = new int[f_adPercentage.length - 1];
            long cRunningTotal = 0L;
            long lLimit = (long)(f_adPercentage[0] * (double)this.m_cSamples);
            int c2 = alResults.length;
            int p = 0;
            for (int i = 0; i < c2 && p < this.m_anPercentile.length; ++i) {
                cRunningTotal += alResults[i];
                while (cRunningTotal > lLimit && p < this.m_anPercentile.length) {
                    this.m_anPercentile[p] = i;
                    lLimit = (long)(f_adPercentage[++p] * (double)this.m_cSamples);
                }
            }
            this.m_dAvg = (double)cTotal / (double)this.m_cSamples;
            this.m_dStddev = Math.sqrt(((double)this.m_cSamples * cTotalSq - (double)cTotal * (double)cTotal) / ((double)this.m_cSamples * (double)(this.m_cSamples - 1L)));
            this.m_dAvg = (double)((int)(this.m_dAvg * 1000.0)) / 1000.0;
            this.m_dStddev = (double)((int)(this.m_dStddev * 1000.0)) / 1000.0;
        }

        public LocalTime getTimestamp() {
            return this.m_timestamp;
        }

        public double getAverage() {
            return this.m_dAvg;
        }

        public double getStdDev() {
            return this.m_dStddev;
        }

        public int get33Percentile() {
            return this.m_anPercentile[0];
        }

        public int get66Percentile() {
            return this.m_anPercentile[1];
        }

        public int get99Percentile() {
            return this.m_anPercentile[2];
        }

        public int get999Percentile() {
            return this.m_anPercentile[3];
        }

        public int get9999Percentile() {
            return this.m_anPercentile[4];
        }

        public int get99999Percentile() {
            return this.m_anPercentile[5];
        }

        int[] getPercentiles() {
            return this.m_anPercentile;
        }

        String[] getPercentileNames() {
            return f_asPercentage;
        }

        int getMin() {
            return this.m_iMin;
        }

        int getMax() {
            return this.m_iMax;
        }

        long getSampleCount() {
            return this.m_cSamples;
        }
    }
}

