/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.net;

import com.oracle.coherence.common.internal.net.InterruptibleChannels;
import com.oracle.coherence.common.net.InetAddresses;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.MulticastSocket;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketOptions;
import java.nio.channels.SelectableChannel;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Sockets {
    private static boolean s_fWarnReuseAddr = true;
    private static Logger LOGGER = Logger.getLogger(Sockets.class.getName());

    public static void configure(ServerSocket socket, SocketOptions options) throws SocketException {
        if (options == null || socket.isClosed()) {
            return;
        }
        try {
            Object oOption;
            if (!socket.isBound() && (oOption = options.getOption(4)) != null) {
                socket.setReuseAddress((Boolean)oOption);
            }
            if ((oOption = options.getOption(4098)) != null) {
                int cb = (Integer)oOption;
                socket.setReceiveBufferSize(cb);
                int cbReal = socket.getReceiveBufferSize();
                if (cbReal < cb) {
                    Sockets.warnBufferSize(socket, "receive", cb, cbReal);
                }
            }
            if ((oOption = options.getOption(4102)) != null) {
                socket.setSoTimeout((Integer)oOption);
            }
        }
        catch (SocketException e) {
            if (socket.isClosed()) {
                return;
            }
            throw e;
        }
    }

    public static void configure(Socket socket, SocketOptions options) throws SocketException {
        if (options == null || socket.isClosed()) {
            return;
        }
        try {
            int cbReal;
            int cb;
            Object oOption;
            if (!socket.isBound() && (oOption = options.getOption(4)) != null) {
                boolean fReuse = (Boolean)oOption;
                if (fReuse != socket.getReuseAddress()) {
                    Sockets.warnReuseAddr(fReuse);
                }
                socket.setReuseAddress((Boolean)oOption);
            }
            if ((oOption = options.getOption(4098)) != null) {
                cb = (Integer)oOption;
                socket.setReceiveBufferSize(cb);
                cbReal = socket.getReceiveBufferSize();
                if (cbReal < cb) {
                    Sockets.warnBufferSize(socket, "receive", cb, cbReal);
                }
            }
            if ((oOption = options.getOption(4097)) != null) {
                cb = (Integer)oOption;
                socket.setSendBufferSize(cb);
                cbReal = socket.getSendBufferSize();
                if (cbReal < cb) {
                    Sockets.warnBufferSize(socket, "send", cb, cbReal);
                }
            }
            if ((oOption = options.getOption(4102)) != null) {
                socket.setSoTimeout((Integer)oOption);
            }
            if ((oOption = options.getOption(128)) != null) {
                socket.setSoLinger(true, (Integer)oOption);
            }
            if ((oOption = options.getOption(8)) != null) {
                socket.setKeepAlive((Boolean)oOption);
            }
            if ((oOption = options.getOption(1)) != null) {
                socket.setTcpNoDelay((Boolean)oOption);
            }
            if ((oOption = options.getOption(3)) != null) {
                socket.setTrafficClass((Integer)oOption);
            }
        }
        catch (SocketException e) {
            if (socket.isClosed()) {
                return;
            }
            try {
                socket.setKeepAlive(socket.getKeepAlive());
            }
            catch (SocketException e2) {
                return;
            }
            throw e;
        }
    }

    public static void configure(DatagramSocket socket, SocketOptions options) throws SocketException {
        if (options == null || socket.isClosed()) {
            return;
        }
        try {
            int cbReal;
            int cb;
            Object oOption;
            if (!socket.isBound() && (oOption = options.getOption(4)) != null) {
                boolean fReuse = (Boolean)oOption;
                if (fReuse != socket.getReuseAddress()) {
                    Sockets.warnReuseAddr(fReuse);
                }
                socket.setReuseAddress((Boolean)oOption);
            }
            if ((oOption = options.getOption(4098)) != null) {
                cb = (Integer)oOption;
                socket.setReceiveBufferSize(cb);
                cbReal = socket.getReceiveBufferSize();
                if (cbReal < cb) {
                    Sockets.warnBufferSize(socket, "receive", cb, cbReal);
                }
            }
            if ((oOption = options.getOption(4097)) != null) {
                cb = (Integer)oOption;
                socket.setSendBufferSize(cb);
                cbReal = socket.getSendBufferSize();
                if (cbReal < cb) {
                    Sockets.warnBufferSize(socket, "send", cb, cbReal);
                }
            }
            if ((oOption = options.getOption(4102)) != null) {
                socket.setSoTimeout((Integer)oOption);
            }
        }
        catch (SocketException e) {
            if (socket.isClosed()) {
                return;
            }
            throw e;
        }
    }

    public void configure(MulticastSocket socket, SocketOptions options) throws SocketException {
        Sockets.configure(socket, options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean configureBlocking(SelectableChannel chan, boolean fBlocking) throws IOException {
        Object object = chan.blockingLock();
        synchronized (object) {
            chan.configureBlocking(fBlocking);
            return InterruptibleChannels.setInterruptible(chan, fBlocking);
        }
    }

    public static int getMTU(Socket socket) {
        int nMtu = 0;
        try {
            nMtu = InetAddresses.getLocalMTU(socket.getLocalAddress());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return nMtu == 0 ? InetAddresses.getLocalMTU() : nMtu;
    }

    protected static void warnBufferSize(Object socket, String sBuffer, int cb, int cbReal) {
        LOGGER.log(Level.INFO, "Failed to set the " + sBuffer + " buffer size on " + socket + " to " + cb + " bytes; actual size is " + cbReal + " bytes. Consult your OS documentation regarding  increasing the maximum socket buffer size. Proceeding with the actual value may cause sub-optimal performance.");
    }

    protected static void warnReuseAddr(boolean fReuse) {
        if (s_fWarnReuseAddr) {
            s_fWarnReuseAddr = false;
            LOGGER.log(Level.WARNING, "The value of SO_REUSEADDR is being overriden to " + fReuse + " from the system default; this setting is not portable and may result in differeing behavior across environments.");
        }
    }
}

