/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MemorySize {
    private static final Pattern REGEX_PATTERN = Pattern.compile("([0-9]+(?:\\.[0-9]+)?)([kKMmGgTtPpEe]?[Bb]?)");
    private long m_cBytes;

    public MemorySize(long cBytes) {
        assert (cBytes >= 0L);
        this.m_cBytes = cBytes;
    }

    public MemorySize(MemorySize m) {
        assert (m != null);
        this.m_cBytes = m.m_cBytes;
    }

    public MemorySize(String s) {
        this(s, null);
    }

    public MemorySize(double nAmount, Magnitude magnitude) {
        assert (nAmount >= 0.0);
        this.m_cBytes = Math.round(nAmount * (double)magnitude.getByteCount());
    }

    public MemorySize(int nAmount, Magnitude magnitude) {
        assert (nAmount >= 0);
        this.m_cBytes = (long)nAmount * magnitude.getByteCount();
    }

    public MemorySize(String s, Magnitude m) {
        String string = s = s == null ? null : s.trim();
        if (s == null || s.isEmpty()) {
            throw new IllegalArgumentException("An empty or null string was provided.  Expected a memory size");
        }
        if (!s.equals("0")) {
            Magnitude magnitude;
            Matcher matcher = REGEX_PATTERN.matcher(s);
            if (!matcher.matches()) {
                throw new IllegalArgumentException(String.format("The specified %s [%s] is invalid.", this.getClass().getName(), s));
            }
            String sSuffix = matcher.group(2);
            Magnitude magnitude2 = magnitude = sSuffix == null || sSuffix.trim().isEmpty() ? m : Magnitude.fromSuffix(sSuffix);
            if (magnitude == null) {
                magnitude = Magnitude.BYTES;
            }
            double nAmount = Double.valueOf(matcher.group(1));
            this.m_cBytes = Math.round(nAmount * (double)magnitude.getByteCount());
        }
    }

    public double as(Magnitude magnitude) {
        return (double)this.m_cBytes / (double)magnitude.getByteCount();
    }

    public long getByteCount() {
        return this.m_cBytes;
    }

    public String toString(boolean fExact) {
        int nSignificanceFactor;
        long nDecimals;
        Magnitude magnitude = Magnitude.BYTES;
        long nBytes = this.m_cBytes;
        while (magnitude.next() != null && nBytes >= magnitude.next().getByteCount() && (fExact && nBytes % magnitude.next().getByteCount() % (magnitude.next().getByteCount() / 4L) == 0L || !fExact)) {
            magnitude = magnitude.next();
        }
        long cMagnitudeUnits = nBytes / magnitude.getByteCount();
        long nRemainder = nBytes % magnitude.getByteCount();
        int cSignificantDigits = 3;
        StringBuilder bldrString = new StringBuilder();
        bldrString.append(cMagnitudeUnits);
        int cDigits = bldrString.length();
        int cRemainingDigits = cSignificantDigits - cDigits;
        if (cRemainingDigits > 0 && nRemainder > 0L && (nDecimals = (long)Math.floor((double)nRemainder * (double)(nSignificanceFactor = (int)Math.pow(10.0, cRemainingDigits)) / (double)magnitude.getByteCount())) > 0L) {
            bldrString.append(".");
            int cLeadingZeros = cRemainingDigits - (int)Math.log10(nDecimals) - 1;
            for (int i = 0; i < cLeadingZeros; ++i) {
                bldrString.append('0');
            }
            bldrString.append(nDecimals);
        }
        bldrString.append(magnitude.getSuffix());
        return bldrString.toString();
    }

    public int hashCode() {
        return 31 + (int)(this.m_cBytes ^ this.m_cBytes >>> 32);
    }

    public boolean equals(Object obj) {
        return this == obj || obj != null && obj instanceof MemorySize && ((MemorySize)obj).m_cBytes == this.m_cBytes;
    }

    public String toString() {
        return this.toString(false);
    }

    public static enum Magnitude {
        BYTES(0, "B", "bytes"),
        KB(10, "KB", "kilobytes"),
        MB(20, "MB", "megabytes"),
        GB(30, "GB", "gigabytes"),
        TB(40, "TB", "terabytes"),
        PB(50, "PB", "petabytes"),
        EB(60, "EB", "exabytes");

        private static final Magnitude[] VALUES;
        public static final Magnitude LOWEST;
        public static final Magnitude HIGHEST;
        private final long BIT_MASK;
        private final long BYTE_COUNT;
        private final String DESCRIPTION;
        private final int SHIFT_COUNT;
        private final String SUFFIX;
        private final char SUFFIX_CHAR;

        private Magnitude(int cShift, String sSuffix, String sDescription) {
            this.SHIFT_COUNT = cShift;
            this.SUFFIX = sSuffix.trim();
            this.SUFFIX_CHAR = sSuffix.length() > 0 ? Character.toUpperCase(sSuffix.charAt(0)) : (char)'\u0000';
            this.DESCRIPTION = sDescription;
            this.BYTE_COUNT = 1L << this.SHIFT_COUNT;
            this.BIT_MASK = this.BYTE_COUNT - 1L;
        }

        public long getByteCount() {
            return this.BYTE_COUNT;
        }

        public String getDescription() {
            return this.DESCRIPTION;
        }

        public long getResidualBitMask() {
            return this.BIT_MASK;
        }

        public String getSuffix() {
            return this.SUFFIX;
        }

        public boolean isSuffix(String s) {
            return s.equalsIgnoreCase(this.SUFFIX) || Character.toUpperCase(s.charAt(0)) == this.SUFFIX_CHAR;
        }

        public Magnitude next() {
            if (this.equals((Object)HIGHEST)) {
                return null;
            }
            return VALUES[this.ordinal() + 1];
        }

        public Magnitude previous() {
            if (this.equals((Object)LOWEST)) {
                return null;
            }
            return VALUES[this.ordinal() - 1];
        }

        public static Magnitude fromSuffix(String sSuffix) {
            if ((sSuffix = sSuffix.trim()).length() == 0) {
                return BYTES;
            }
            if (sSuffix.length() > 0) {
                for (Magnitude magnitude : VALUES) {
                    if (!magnitude.isSuffix(sSuffix)) continue;
                    return magnitude;
                }
            }
            throw new IllegalArgumentException(String.format("Unknown %s suffix [%s]", Magnitude.class.getName(), sSuffix));
        }

        static {
            VALUES = Magnitude.values();
            LOWEST = VALUES[0];
            HIGHEST = VALUES[VALUES.length - 1];
        }
    }
}

