/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.util;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.atomic.AtomicBoolean;

public class SafeClock
extends AtomicBoolean {
    protected long m_ldtLastSafe;
    protected long m_ldtLastUnsafe;
    protected final long m_lJitter;
    public static final SafeClock INSTANCE = new SafeClock();
    public static final long DEFAULT_JITTER_THRESHOLD = Long.valueOf(AccessController.doPrivileged(new PrivilegedAction<String>(){

        @Override
        public String run() {
            return System.getProperty(SafeClock.class.getName() + ".jitter", "16");
        }
    }));

    public SafeClock() {
        this(System.currentTimeMillis());
    }

    public SafeClock(long ldtUnsafe) {
        this(ldtUnsafe, DEFAULT_JITTER_THRESHOLD);
    }

    public SafeClock(long ldtUnsafe, long lJitter) {
        this.m_ldtLastSafe = this.m_ldtLastUnsafe = ldtUnsafe;
        this.m_lJitter = lJitter;
    }

    public final long getSafeTimeMillis() {
        return this.getSafeTimeMillis(System.currentTimeMillis());
    }

    public final long getSafeTimeMillis(long ldtUnsafe) {
        long lDelta = ldtUnsafe - this.m_ldtLastUnsafe;
        return lDelta == 0L || lDelta < 0L && lDelta >= -this.m_lJitter ? this.m_ldtLastSafe : this.updateSafeTimeMillis(ldtUnsafe);
    }

    public final long getLastSafeTimeMillis() {
        return this.m_ldtLastSafe;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long updateSafeTimeMillis(long ldtUnsafe) {
        if (this.compareAndSet(false, true)) {
            try {
                long lJitter = this.m_lJitter;
                long ldtLastSafe = this.m_ldtLastSafe;
                long lDelta = ldtUnsafe - this.m_ldtLastUnsafe;
                long ldtNewSafe = ldtLastSafe;
                if (lDelta > 0L) {
                    if (ldtUnsafe >= ldtLastSafe) {
                        ldtNewSafe = ldtUnsafe;
                    } else {
                        if (lDelta > lJitter && ldtLastSafe - ldtUnsafe <= lJitter) {
                            long l = ldtLastSafe;
                            return l;
                        }
                        ldtNewSafe += lDelta == 1L ? ldtUnsafe % 2L : lDelta / 2L;
                    }
                } else if (lDelta >= -lJitter) {
                    long l = ldtLastSafe;
                    return l;
                }
                this.m_ldtLastUnsafe = ldtUnsafe;
                long l = this.m_ldtLastSafe = ldtNewSafe;
                return l;
            }
            finally {
                this.set(false);
            }
        }
        return this.m_ldtLastSafe;
    }
}

