/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net;

import com.oracle.coherence.common.base.SingleWaiterMultiNotifier;
import com.oracle.coherence.common.net.InetAddresses;
import com.oracle.coherence.common.net.exabus.EndPoint;
import com.oracle.coherence.common.util.Threads;
import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.application.console.Coherence;
import com.tangosol.coherence.component.application.console.Coherence$Logger;
import com.tangosol.coherence.component.net.Cluster;
import com.tangosol.coherence.component.net.Cluster$ClusterService$Acknowledgement;
import com.tangosol.coherence.component.net.Cluster$ClusterService$BusEventMessage;
import com.tangosol.coherence.component.net.Cluster$ClusterService$ConfigRequest;
import com.tangosol.coherence.component.net.Cluster$ClusterService$ConfigResponse;
import com.tangosol.coherence.component.net.Cluster$ClusterService$ConfigSync;
import com.tangosol.coherence.component.net.Cluster$ClusterService$ConfigUpdate;
import com.tangosol.coherence.component.net.Cluster$ClusterService$DaemonPool;
import com.tangosol.coherence.component.net.Cluster$ClusterService$DispatchEvent;
import com.tangosol.coherence.component.net.Cluster$ClusterService$DispatchNotification;
import com.tangosol.coherence.component.net.Cluster$ClusterService$EventDispatcher;
import com.tangosol.coherence.component.net.Cluster$ClusterService$Guard;
import com.tangosol.coherence.component.net.Cluster$ClusterService$MemberConfigUpdate;
import com.tangosol.coherence.component.net.Cluster$ClusterService$MemberHeartbeat;
import com.tangosol.coherence.component.net.Cluster$ClusterService$MemberJoined;
import com.tangosol.coherence.component.net.Cluster$ClusterService$MemberLeaving;
import com.tangosol.coherence.component.net.Cluster$ClusterService$MemberLeft;
import com.tangosol.coherence.component.net.Cluster$ClusterService$MemberWelcome;
import com.tangosol.coherence.component.net.Cluster$ClusterService$MemberWelcomeRequest;
import com.tangosol.coherence.component.net.Cluster$ClusterService$MemberWelcomeRequestTask;
import com.tangosol.coherence.component.net.Cluster$ClusterService$NewMemberAnnounce;
import com.tangosol.coherence.component.net.Cluster$ClusterService$NewMemberAnnounceReply;
import com.tangosol.coherence.component.net.Cluster$ClusterService$NewMemberAnnounceWait;
import com.tangosol.coherence.component.net.Cluster$ClusterService$NewMemberInduct;
import com.tangosol.coherence.component.net.Cluster$ClusterService$NewMemberRequestId;
import com.tangosol.coherence.component.net.Cluster$ClusterService$NewMemberRequestIdReject;
import com.tangosol.coherence.component.net.Cluster$ClusterService$NewMemberRequestIdReply;
import com.tangosol.coherence.component.net.Cluster$ClusterService$NewMemberRequestIdWait;
import com.tangosol.coherence.component.net.Cluster$ClusterService$NewMemberTimestampRequest;
import com.tangosol.coherence.component.net.Cluster$ClusterService$NewMemberTimestampResponse;
import com.tangosol.coherence.component.net.Cluster$ClusterService$NewMemberWelcome;
import com.tangosol.coherence.component.net.Cluster$ClusterService$NewMemberWelcomeAnnounce;
import com.tangosol.coherence.component.net.Cluster$ClusterService$NewMemberWelcomeRequest;
import com.tangosol.coherence.component.net.Cluster$ClusterService$NotifyConnectionClose;
import com.tangosol.coherence.component.net.Cluster$ClusterService$NotifyConnectionOpen;
import com.tangosol.coherence.component.net.Cluster$ClusterService$NotifyIpTimeout;
import com.tangosol.coherence.component.net.Cluster$ClusterService$NotifyMemberJoined;
import com.tangosol.coherence.component.net.Cluster$ClusterService$NotifyMemberLeaving;
import com.tangosol.coherence.component.net.Cluster$ClusterService$NotifyMemberLeft;
import com.tangosol.coherence.component.net.Cluster$ClusterService$NotifyMessageReceipt;
import com.tangosol.coherence.component.net.Cluster$ClusterService$NotifyPollClosed;
import com.tangosol.coherence.component.net.Cluster$ClusterService$NotifyResponse;
import com.tangosol.coherence.component.net.Cluster$ClusterService$NotifyServiceAnnounced;
import com.tangosol.coherence.component.net.Cluster$ClusterService$NotifyServiceJoining;
import com.tangosol.coherence.component.net.Cluster$ClusterService$NotifyServiceLeaving;
import com.tangosol.coherence.component.net.Cluster$ClusterService$NotifyServiceLeft;
import com.tangosol.coherence.component.net.Cluster$ClusterService$NotifyServiceQuiescence;
import com.tangosol.coherence.component.net.Cluster$ClusterService$NotifyShutdown;
import com.tangosol.coherence.component.net.Cluster$ClusterService$NotifyStartup;
import com.tangosol.coherence.component.net.Cluster$ClusterService$NotifyTcmpTimeout;
import com.tangosol.coherence.component.net.Cluster$ClusterService$PingRequest;
import com.tangosol.coherence.component.net.Cluster$ClusterService$PollArray;
import com.tangosol.coherence.component.net.Cluster$ClusterService$ProtocolContext;
import com.tangosol.coherence.component.net.Cluster$ClusterService$QuorumControl;
import com.tangosol.coherence.component.net.Cluster$ClusterService$QuorumRollCall;
import com.tangosol.coherence.component.net.Cluster$ClusterService$Response;
import com.tangosol.coherence.component.net.Cluster$ClusterService$SeniorMemberHeartbeat;
import com.tangosol.coherence.component.net.Cluster$ClusterService$SeniorMemberKill;
import com.tangosol.coherence.component.net.Cluster$ClusterService$SeniorMemberPanic;
import com.tangosol.coherence.component.net.Cluster$ClusterService$ServiceConfig;
import com.tangosol.coherence.component.net.Cluster$ClusterService$ServiceJoinRequest;
import com.tangosol.coherence.component.net.Cluster$ClusterService$ServiceJoined;
import com.tangosol.coherence.component.net.Cluster$ClusterService$ServiceJoining;
import com.tangosol.coherence.component.net.Cluster$ClusterService$ServiceLeaving;
import com.tangosol.coherence.component.net.Cluster$ClusterService$ServiceLeft;
import com.tangosol.coherence.component.net.Cluster$ClusterService$ServiceQuiescenceRequest;
import com.tangosol.coherence.component.net.Cluster$ClusterService$ServiceRegister;
import com.tangosol.coherence.component.net.Cluster$ClusterService$ServiceRegisterRequest;
import com.tangosol.coherence.component.net.Cluster$ClusterService$ServiceUpdateResponse;
import com.tangosol.coherence.component.net.Cluster$ClusterService$TcpRing;
import com.tangosol.coherence.component.net.Cluster$ClusterService$WitnessRequest;
import com.tangosol.coherence.component.net.Cluster$ClusterService$WrapperGuardable;
import com.tangosol.coherence.component.net.Cluster$NameService;
import com.tangosol.coherence.component.net.Cluster$NameServiceBridge;
import com.tangosol.coherence.component.net.Cluster$PacketListenerBT;
import com.tangosol.coherence.component.net.Cluster$PacketListenerBU;
import com.tangosol.coherence.component.net.Cluster$TransportService;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.MessageHandler$Connection;
import com.tangosol.coherence.component.net.memberSet.actualMemberSet.ServiceMemberSet;
import com.tangosol.coherence.component.net.message.DiscoveryMessage;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$MemberConfigListener;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$ReceiveQueue;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService;
import com.tangosol.license.LicensedObject;
import com.tangosol.util.Base;
import com.tangosol.util.ListMap;
import com.tangosol.util.SimpleResourceRegistry;
import com.tangosol.util.WrapperException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicLong;

public class Cluster$ClusterService
extends ClusterService {
    private static ListMap __mapChildren;

    static {
        Cluster$ClusterService.__initStatic();
    }

    public Cluster$ClusterService() {
        this(null, null, true);
    }

    public Cluster$ClusterService(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setAcceptingClients(false);
            this.setAcceptingOthers(true);
            this.setBroadcastRepeatMillis(256);
            this.setBroadcastTimeoutMillis(32768);
            this.setDaemonState(0);
            this.setDefaultGuardRecovery(0.9f);
            this.setDefaultGuardTimeout(60000L);
            this.setMessageClassMap(new HashMap());
            this.setNotifier(new SingleWaiterMultiNotifier());
            this.setOldestPendingRequestSUIDCounter(new AtomicLong());
            this.setResourceRegistry(new SimpleResourceRegistry());
            this.setSerializerMap(new WeakHashMap());
            this.setServiceId(0);
            this.setServiceName("Cluster");
            this.setSuspendPollLimit(new AtomicLong());
            this.setTimestampMaxVariance(10);
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this._addChild(new Cluster$ClusterService$DaemonPool("DaemonPool", this, true), "DaemonPool");
        this._addChild(new Cluster$ClusterService$EventDispatcher("EventDispatcher", this, true), "EventDispatcher");
        this._addChild(new Cluster$ClusterService$Guard("Guard", this, true), "Guard");
        this._addChild(new Grid$MemberConfigListener("MemberConfigListener", this, true), "MemberConfigListener");
        this._addChild(new Cluster$ClusterService$PollArray("PollArray", this, true), "PollArray");
        this._addChild(new Cluster$ClusterService$QuorumControl("QuorumControl", this, true), "QuorumControl");
        this._addChild(new Grid$ReceiveQueue("ReceiveQueue", this, true), "ReceiveQueue");
        this._addChild(new Cluster$ClusterService$ServiceConfig("ServiceConfig", this, true), "ServiceConfig");
        this._addChild(new Cluster$ClusterService$TcpRing("TcpRing", this, true), "TcpRing");
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    private static void __initStatic() {
        __mapChildren = new ListMap();
        Class clazz = __mapChildren.put("Acknowledgement", Cluster$ClusterService$Acknowledgement.get_CLASS());
        Class clazz2 = __mapChildren.put("BusEventMessage", Cluster$ClusterService$BusEventMessage.get_CLASS());
        Class clazz3 = __mapChildren.put("ConfigRequest", Cluster$ClusterService$ConfigRequest.get_CLASS());
        Class clazz4 = __mapChildren.put("ConfigResponse", Cluster$ClusterService$ConfigResponse.get_CLASS());
        Class clazz5 = __mapChildren.put("ConfigSync", Cluster$ClusterService$ConfigSync.get_CLASS());
        Class clazz6 = __mapChildren.put("ConfigUpdate", Cluster$ClusterService$ConfigUpdate.get_CLASS());
        Class clazz7 = __mapChildren.put("DispatchEvent", Cluster$ClusterService$DispatchEvent.get_CLASS());
        Class clazz8 = __mapChildren.put("DispatchNotification", Cluster$ClusterService$DispatchNotification.get_CLASS());
        Class clazz9 = __mapChildren.put("MemberConfigUpdate", Cluster$ClusterService$MemberConfigUpdate.get_CLASS());
        Class clazz10 = __mapChildren.put("MemberHeartbeat", Cluster$ClusterService$MemberHeartbeat.get_CLASS());
        Class clazz11 = __mapChildren.put("MemberJoined", Cluster$ClusterService$MemberJoined.get_CLASS());
        Class clazz12 = __mapChildren.put("MemberLeaving", Cluster$ClusterService$MemberLeaving.get_CLASS());
        Class clazz13 = __mapChildren.put("MemberLeft", Cluster$ClusterService$MemberLeft.get_CLASS());
        Class clazz14 = __mapChildren.put("MemberWelcome", Cluster$ClusterService$MemberWelcome.get_CLASS());
        Class clazz15 = __mapChildren.put("MemberWelcomeRequest", Cluster$ClusterService$MemberWelcomeRequest.get_CLASS());
        Class clazz16 = __mapChildren.put("MemberWelcomeRequestTask", Cluster$ClusterService$MemberWelcomeRequestTask.get_CLASS());
        Class clazz17 = __mapChildren.put("NewMemberAnnounce", Cluster$ClusterService$NewMemberAnnounce.get_CLASS());
        Class clazz18 = __mapChildren.put("NewMemberAnnounceReply", Cluster$ClusterService$NewMemberAnnounceReply.get_CLASS());
        Class clazz19 = __mapChildren.put("NewMemberAnnounceWait", Cluster$ClusterService$NewMemberAnnounceWait.get_CLASS());
        Class clazz20 = __mapChildren.put("NewMemberInduct", Cluster$ClusterService$NewMemberInduct.get_CLASS());
        Class clazz21 = __mapChildren.put("NewMemberRequestId", Cluster$ClusterService$NewMemberRequestId.get_CLASS());
        Class clazz22 = __mapChildren.put("NewMemberRequestIdReject", Cluster$ClusterService$NewMemberRequestIdReject.get_CLASS());
        Class clazz23 = __mapChildren.put("NewMemberRequestIdReply", Cluster$ClusterService$NewMemberRequestIdReply.get_CLASS());
        Class clazz24 = __mapChildren.put("NewMemberRequestIdWait", Cluster$ClusterService$NewMemberRequestIdWait.get_CLASS());
        Class clazz25 = __mapChildren.put("NewMemberTimestampRequest", Cluster$ClusterService$NewMemberTimestampRequest.get_CLASS());
        Class clazz26 = __mapChildren.put("NewMemberTimestampResponse", Cluster$ClusterService$NewMemberTimestampResponse.get_CLASS());
        Class clazz27 = __mapChildren.put("NewMemberWelcome", Cluster$ClusterService$NewMemberWelcome.get_CLASS());
        Class clazz28 = __mapChildren.put("NewMemberWelcomeAnnounce", Cluster$ClusterService$NewMemberWelcomeAnnounce.get_CLASS());
        Class clazz29 = __mapChildren.put("NewMemberWelcomeRequest", Cluster$ClusterService$NewMemberWelcomeRequest.get_CLASS());
        Class clazz30 = __mapChildren.put("NotifyConnectionClose", Cluster$ClusterService$NotifyConnectionClose.get_CLASS());
        Class clazz31 = __mapChildren.put("NotifyConnectionOpen", Cluster$ClusterService$NotifyConnectionOpen.get_CLASS());
        Class clazz32 = __mapChildren.put("NotifyIpTimeout", Cluster$ClusterService$NotifyIpTimeout.get_CLASS());
        Class clazz33 = __mapChildren.put("NotifyMemberJoined", Cluster$ClusterService$NotifyMemberJoined.get_CLASS());
        Class clazz34 = __mapChildren.put("NotifyMemberLeaving", Cluster$ClusterService$NotifyMemberLeaving.get_CLASS());
        Class clazz35 = __mapChildren.put("NotifyMemberLeft", Cluster$ClusterService$NotifyMemberLeft.get_CLASS());
        Class clazz36 = __mapChildren.put("NotifyMessageReceipt", Cluster$ClusterService$NotifyMessageReceipt.get_CLASS());
        Class clazz37 = __mapChildren.put("NotifyPollClosed", Cluster$ClusterService$NotifyPollClosed.get_CLASS());
        Class clazz38 = __mapChildren.put("NotifyResponse", Cluster$ClusterService$NotifyResponse.get_CLASS());
        Class clazz39 = __mapChildren.put("NotifyServiceAnnounced", Cluster$ClusterService$NotifyServiceAnnounced.get_CLASS());
        Class clazz40 = __mapChildren.put("NotifyServiceJoining", Cluster$ClusterService$NotifyServiceJoining.get_CLASS());
        Class clazz41 = __mapChildren.put("NotifyServiceLeaving", Cluster$ClusterService$NotifyServiceLeaving.get_CLASS());
        Class clazz42 = __mapChildren.put("NotifyServiceLeft", Cluster$ClusterService$NotifyServiceLeft.get_CLASS());
        Class clazz43 = __mapChildren.put("NotifyServiceQuiescence", Cluster$ClusterService$NotifyServiceQuiescence.get_CLASS());
        Class clazz44 = __mapChildren.put("NotifyShutdown", Cluster$ClusterService$NotifyShutdown.get_CLASS());
        Class clazz45 = __mapChildren.put("NotifyStartup", Cluster$ClusterService$NotifyStartup.get_CLASS());
        Class clazz46 = __mapChildren.put("NotifyTcmpTimeout", Cluster$ClusterService$NotifyTcmpTimeout.get_CLASS());
        Class clazz47 = __mapChildren.put("PingRequest", Cluster$ClusterService$PingRequest.get_CLASS());
        Class clazz48 = __mapChildren.put("ProtocolContext", Cluster$ClusterService$ProtocolContext.get_CLASS());
        Class clazz49 = __mapChildren.put("QuorumRollCall", Cluster$ClusterService$QuorumRollCall.get_CLASS());
        Class clazz50 = __mapChildren.put("Response", Cluster$ClusterService$Response.get_CLASS());
        Class clazz51 = __mapChildren.put("SeniorMemberHeartbeat", Cluster$ClusterService$SeniorMemberHeartbeat.get_CLASS());
        Class clazz52 = __mapChildren.put("SeniorMemberKill", Cluster$ClusterService$SeniorMemberKill.get_CLASS());
        Class clazz53 = __mapChildren.put("SeniorMemberPanic", Cluster$ClusterService$SeniorMemberPanic.get_CLASS());
        Class clazz54 = __mapChildren.put("ServiceJoined", Cluster$ClusterService$ServiceJoined.get_CLASS());
        Class clazz55 = __mapChildren.put("ServiceJoining", Cluster$ClusterService$ServiceJoining.get_CLASS());
        Class clazz56 = __mapChildren.put("ServiceJoinRequest", Cluster$ClusterService$ServiceJoinRequest.get_CLASS());
        Class clazz57 = __mapChildren.put("ServiceLeaving", Cluster$ClusterService$ServiceLeaving.get_CLASS());
        Class clazz58 = __mapChildren.put("ServiceLeft", Cluster$ClusterService$ServiceLeft.get_CLASS());
        Class clazz59 = __mapChildren.put("ServiceQuiescenceRequest", Cluster$ClusterService$ServiceQuiescenceRequest.get_CLASS());
        Class clazz60 = __mapChildren.put("ServiceRegister", Cluster$ClusterService$ServiceRegister.get_CLASS());
        Class clazz61 = __mapChildren.put("ServiceRegisterRequest", Cluster$ClusterService$ServiceRegisterRequest.get_CLASS());
        Class clazz62 = __mapChildren.put("ServiceUpdateResponse", Cluster$ClusterService$ServiceUpdateResponse.get_CLASS());
        Class clazz63 = __mapChildren.put("WitnessRequest", Cluster$ClusterService$WitnessRequest.get_CLASS());
        Class clazz64 = __mapChildren.put("WrapperGuardable", Cluster$ClusterService$WrapperGuardable.get_CLASS());
    }

    protected void ensureBroadcastDiscovery() {
        Cluster cluster = (Cluster)this.get_Module();
        Cluster$NameServiceBridge nsClient = cluster.getNameServiceBridge();
        Cluster$PacketListenerBT listenerBT = cluster.getTcpBroadcastListener();
        Cluster$PacketListenerBU listenerBU = cluster.getUdpBroadcastListener();
        if (nsClient.isForeignBroadcastBound()) {
            if (this.getWellKnownAddresses() == null) {
                listenerBU.joinGroup();
                listenerBU.tryStart();
            }
        } else if (listenerBT.isStarted() ? true : listenerBT.tryStart()) {
            if (nsClient.isRunning()) {
                nsClient.shutdown();
            }
            if (this.getWellKnownAddresses() == null) {
                listenerBU.joinGroup();
            }
            listenerBU.tryStart();
        } else if (nsClient.tryForeignBind() && this.getWellKnownAddresses() == null) {
            listenerBU.joinGroup();
            listenerBU.tryStart();
        }
    }

    public boolean ensureDiscovery() {
        Cluster cluster = (Cluster)this.get_Module();
        Cluster$NameService ns = cluster.getNameService();
        Cluster$NameServiceBridge nsClient = cluster.getNameServiceBridge();
        Cluster$PacketListenerBT listenerBT = cluster.getTcpBroadcastListener();
        if ((!listenerBT.isStarted() ? false : ns.isStarted()) ? true : nsClient.isFullyBound()) {
            return true;
        }
        if (nsClient.isForeignBroadcastBound()) {
            if (ns.isStarted() ^ true) {
                ns.start();
            }
            if (nsClient.tryForeignBind()) {
                return true;
            }
        } else {
            Cluster$PacketListenerBU listenerBU = cluster.getUdpBroadcastListener();
            if (!(!(this.getServiceMemberSet().getOldestLocalMember() == this.getThisMember()) ? false : listenerBT.isStarted() ^ true) ? false : listenerBT.tryStart() ^ true) {
                if (ns.isStarted() ^ true) {
                    ns.start();
                }
                return nsClient.tryForeignBind();
            }
            if (!listenerBT.isStarted() ? false : ((listenerBU.getUdpSocket().getDatagramSocketProvider().isSecure() ? true : listenerBU.isStarted()) ? true : listenerBU.tryStart())) {
                if (ns.isStarted() ^ true) {
                    ns.start();
                }
                if (ns.tryClusterBind()) {
                    nsClient.shutdown();
                    return true;
                }
            }
        }
        return false;
    }

    public void ensureMulticastDiscovery() {
        ServiceMemberSet setMembers = this.getServiceMemberSet();
        Member memberSenior = setMembers.getOldestMember();
        Member memberThis = this.getThisMember();
        Cluster$PacketListenerBU listenerBU = ((Cluster)this.get_Module()).getUdpBroadcastListener();
        if (listenerBU.isInGroup() ^ true) {
            if (memberThis != memberSenior) {
                boolean fThisCollocated = memberThis.getMachineId() == memberSenior.getMachineId();
                Iterator iter = setMembers.iterator();
                while (iter.hasNext()) {
                    boolean fNextOlder;
                    Member memberNext = (Member)iter.next();
                    if (!(!(memberNext != memberSenior) ? false : memberNext != memberThis)) continue;
                    boolean fNextCollocated = memberNext.getMachineId() == memberSenior.getMachineId();
                    boolean bl = fNextOlder = setMembers.compareSeniority(memberNext, memberThis) < (long)0;
                    if (!((!fThisCollocated ? false : (fNextCollocated ^ true ? true : fNextOlder)) ? true : (!(fNextCollocated ^ true) ? false : fNextOlder))) continue;
                    return;
                }
            }
            listenerBU.joinGroup();
            if (listenerBU.isStarted() ^ true) {
                listenerBU.start();
            }
        }
    }

    public String getMemberStatsDescription(Member member) {
        MessageHandler$Connection connection;
        EndPoint peer;
        ServiceMemberSet setMember;
        String s = super.getMemberStatsDescription(member);
        Cluster$TransportService svc = ((Cluster)this.get_Module()).getTransportService();
        if (svc.isStarted() && (setMember = svc.getServiceMemberSet()) != null && (peer = setMember.getServiceEndPoint(member.getId())) != null && (connection = (MessageHandler$Connection)svc.getMessageHandler().getConnectionMap().get(peer)) != null) {
            s = new StringBuilder(String.valueOf(s)).append(new StringBuilder(String.valueOf(", ")).append(connection).toString()).toString();
        }
        return s;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/net/Cluster$ClusterService".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    public static Component get_Instance() {
        return new Cluster$ClusterService();
    }

    private final Component get_Module() {
        return this.get_Parent();
    }

    public boolean isHeuristicallyDead(Member member) {
        long ldtTimeout;
        MessageHandler$Connection connection;
        EndPoint peer;
        Cluster$TransportService svc;
        boolean fDead = super.isHeuristicallyDead(member);
        if (fDead ^ true && (svc = ((Cluster)this.get_Module()).getTransportService()).isStarted() && (peer = svc.getServiceMemberSet().getServiceEndPoint(member.getId())) != null && (connection = (MessageHandler$Connection)svc.getMessageHandler().getConnectionMap().get(peer)) != null && (!((ldtTimeout = connection.getSuspectTimeoutTimestamp()) != (long)0) ? false : Base.getSafeTimeMillis() > ldtTimeout - (long)(this.getDeliveryTimeoutMillis() - this.getHeuristicTimeoutMillis()))) {
            return true;
        }
        return fDead;
    }

    public boolean isRecentlyHeuristicallyDead(Member member) {
        MessageHandler$Connection connection;
        EndPoint peer;
        Cluster$TransportService svc;
        boolean fDead = super.isRecentlyHeuristicallyDead(member);
        if (fDead ^ true && (svc = ((Cluster)this.get_Module()).getTransportService()).isStarted() && (peer = svc.getServiceMemberSet().getServiceEndPoint(member.getId())) != null && (connection = (MessageHandler$Connection)svc.getMessageHandler().getConnectionMap().get(peer)) != null) {
            return connection.getLastHeuristicDeathTimestamp() >= Base.getSafeTimeMillis() - (long)this.getDeliveryTimeoutMillis();
        }
        return fDead;
    }

    public void onException(Throwable e) {
        Cluster cluster = (Cluster)this.get_Module();
        try {
            if (cluster.getState() < Cluster.STATE_RUNNING) {
                cluster.setStartException(e);
            }
            super.onException(e);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (cluster.getState() < Cluster.STATE_STOPPING) {
                Component._trace(new StringBuilder(String.valueOf(this.get_Name())).append(": stopping cluster.").toString(), 1);
                cluster.stop();
            }
            throw throwable;
        }
        Object var4_3 = null;
        if (cluster.getState() < Cluster.STATE_STOPPING) {
            Component._trace(new StringBuilder(String.valueOf(this.get_Name())).append(": stopping cluster.").toString(), 1);
            cluster.stop();
        }
    }

    protected void onExit() {
        Cluster cluster = (Cluster)this.getCluster();
        cluster.getTcpBroadcastListener().stop();
        cluster.getUdpBroadcastListener().stop();
        cluster.getNameService().stop();
        cluster.getNameServiceBridge().stop();
        super.onExit();
    }

    protected void onMemberLeft(Member member) {
        super.onMemberLeft(member);
        if (member != this.getThisMember()) {
            if (InetAddresses.isLocalAddress(member.getAddress())) {
                this.ensureDiscovery();
            }
            if (this.getWellKnownAddresses() == null) {
                this.ensureMulticastDiscovery();
            }
        }
    }

    public void onStopRunning() {
        Component._trace(new StringBuilder(String.valueOf("Exiting cluster\n")).append(((Cluster)this.get_Module()).getTransportService().getMessageHandler()).append("\n").append(Threads.getThreadDump()).toString(), 2);
        super.onStopRunning();
    }

    public void onTimerAnnouncing() {
        if (this.getBroadcastCounter() >= this.getBroadcastLimit() / ClusterService.ANNOUNCE_BIND_THRESHOLD) {
            this.ensureBroadcastDiscovery();
        }
        super.onTimerAnnouncing();
    }

    public void onTimerRunning() {
        this.ensureDiscovery();
        super.onTimerRunning();
    }

    public void resetBroadcastCounter(String sReason, DiscoveryMessage msg) {
        Cluster$PacketListenerBU listenerBU;
        super.resetBroadcastCounter(sReason, msg);
        Cluster cluster = (Cluster)this.get_Module();
        if (cluster.getDependencies().getPublisherGroupThreshold() >= 100 && (listenerBU = cluster.getUdpBroadcastListener()).isInGroup()) {
            listenerBU.leaveGroup();
        }
    }

    public synchronized void setState(int nState) {
        Coherence singleton;
        Coherence$Logger logger;
        super.setState(nState);
        if (nState == ClusterService.STATE_JOINED && (!((logger = (singleton = (Coherence)Coherence.get_Instance()).getLogger()) != null) ? false : logger.getHashCode() == System.identityHashCode(singleton))) {
            int nType = 0;
            int cCpus = 0;
            Object[] aoLic = (Object[])this.get_Feed();
            int i = 0;
            int c = aoLic.length;
            while (i < c) {
                nType = ((LicensedObject.LicenseData)aoLic[i]).nLicenseType;
                cCpus += ((LicensedObject.LicenseData)aoLic[i]).cCpus;
                ++i;
            }
            logger.setHashCode((new Random().nextInt(77) + Math.max(0, Math.min(cCpus, 76)) * 77 + Math.max(0, nType) * 5929) * 777);
        }
    }

    public void setStatsCpu(long cMillis) {
        super.setStatsCpu(cMillis);
    }

    public synchronized void shutdown() {
        super.shutdown();
    }
}

