/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.Net;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofPrincipal;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.security.Principal;
import java.util.Iterator;
import java.util.Set;
import javax.security.auth.Subject;

public class RequestContext
extends Net
implements ExternalizableLite {
    private long __m_OldestPendingSUID;
    private long __m_RequestSUID;
    private Subject __m_Subject;

    public RequestContext() {
        this(null, null, true);
    }

    public RequestContext(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    public long getOldestPendingSUID() {
        return this.__m_OldestPendingSUID;
    }

    public long getRequestSUID() {
        return this.__m_RequestSUID;
    }

    public Subject getSubject() {
        return this.__m_Subject;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/net/RequestContext".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public static Component get_Instance() {
        return new RequestContext();
    }

    private final Component get_Module() {
        return this;
    }

    public void readExternal(DataInput in) throws IOException {
        long lSUIDPending = in.readLong();
        int cDelta = in.readInt();
        long lSUIDCurrent = cDelta == -1 ? in.readLong() : lSUIDPending + (long)cDelta;
        this.setRequestSUID(lSUIDCurrent);
        this.setOldestPendingSUID(lSUIDPending);
        int cPals = in.readByte();
        if (cPals > 0) {
            Subject subject = new Subject();
            Set<Principal> setPals = subject.getPrincipals();
            int i = 0;
            while (i < cPals) {
                String sName = in.readUTF();
                setPals.add(new PofPrincipal(sName));
                ++i;
            }
            subject.setReadOnly();
            this.setSubject(subject);
        }
    }

    public void setOldestPendingSUID(long lSUID) {
        this.__m_OldestPendingSUID = lSUID;
    }

    public void setRequestSUID(long lSUID) {
        this.__m_RequestSUID = lSUID;
    }

    public void setSubject(Subject subject) {
        this.__m_Subject = subject;
    }

    public void writeExternal(DataOutput out) throws IOException {
        long lSUIDCurrent = this.getRequestSUID();
        long lSUIDPending = this.getOldestPendingSUID();
        long lDelta = lSUIDCurrent - lSUIDPending;
        out.writeLong(lSUIDPending);
        Component._assert(lDelta >= (long)0);
        if (lDelta < (long)Integer.MAX_VALUE) {
            out.writeInt((int)lDelta);
        } else {
            out.writeInt(-1);
            out.writeLong(lSUIDCurrent);
        }
        Subject subject = this.getSubject();
        if (subject == null) {
            out.writeByte(0);
        } else {
            Set<Principal> setPals = subject.getPrincipals();
            out.writeByte(setPals.size());
            Iterator<Principal> iter = setPals.iterator();
            while (iter.hasNext()) {
                Principal p = iter.next();
                out.writeUTF(p.getName());
            }
        }
    }
}

