/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net;

import com.oracle.coherence.common.base.Blocking;
import com.oracle.coherence.common.net.SocketProvider;
import com.oracle.coherence.common.net.Sockets;
import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.Net;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.TcpRing$MemberMonitor;
import com.tangosol.net.SocketOptions;
import com.tangosol.util.Base;
import com.tangosol.util.LiteSet;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.net.SocketException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class TcpRing
extends Net {
    private Map __m_Buddies;
    private transient ByteBuffer __m_Buffer;
    private int __m_InboundConnectionCount;
    private int __m_RedundancyLevel;
    private transient Selector __m_Selector;
    private transient ServerSocketChannel __m_ServerSocketChannel;
    private transient SocketOptions __m_SocketOptions;
    private SocketProvider __m_SocketProvider;
    private transient long __m_StatsFailures;
    private transient long __m_StatsPings;

    public TcpRing(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        block13: {
            Selector selector = this.getSelector();
            selector.wakeup();
            Selector selector2 = selector;
            synchronized (selector2) {
                if (selector.isOpen()) {
                    try {
                        Iterator<SelectionKey> iter = selector.keys().iterator();
                        while (iter.hasNext()) {
                            SelectionKey key = iter.next();
                            try {
                                if (!(!key.isValid() ? false : key.channel().isOpen())) continue;
                                key.channel().close();
                            }
                            catch (IOException e) {
                                // empty catch block
                            }
                        }
                    }
                    catch (ClosedSelectorException cse) {
                        // empty catch block
                    }
                    try {
                        selector.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
            }
            ServerSocketChannel server = this.getServerSocketChannel();
            if (!(server != null)) break block13;
            try {
                server.close();
            }
            catch (IOException iOException) {}
        }
    }

    protected TcpRing$MemberMonitor close(SelectionKey key) {
        if (key != null) {
            LiteSet setKeys;
            TcpRing$MemberMonitor monitor = (TcpRing$MemberMonitor)key.attachment();
            if (monitor != null && (setKeys = monitor.getKeys()).remove(key) ^ true) {
                monitor.setPendingConnections(monitor.getPendingConnections() - 1);
            }
            try {
                if (key.channel().isOpen()) {
                    key.channel().close();
                }
            }
            catch (IOException e) {
                this.onDisconnectException(e, key);
            }
            return monitor;
        }
        return null;
    }

    protected void connect(Member member) {
        Map mapBuddies = this.getBuddies();
        TcpRing$MemberMonitor monitor = (TcpRing$MemberMonitor)mapBuddies.get(member);
        if (monitor == null) {
            monitor = new TcpRing$MemberMonitor();
            monitor.setMember(member);
            mapBuddies.put(member, monitor);
        }
        int cNew = 1 + this.getRedundancyLevel() - (monitor.getKeys().size() + monitor.getPendingConnections());
        int i = 0;
        while (i < cNew) {
            SelectionKey key = null;
            try {
                SocketChannel channel = this.getSocketProvider().openSocketChannel();
                Sockets.configureBlocking(channel, false);
                this.getSocketOptions().apply(channel.socket());
                key = channel.register(this.ensureSelector(channel), SelectionKey.OP_CONNECT, monitor);
                monitor.setPendingConnections(monitor.getPendingConnections() + 1);
                if (channel.connect(new InetSocketAddress(member.getAddress(), member.getTcpRingPort()))) {
                    this.onConnect(key);
                } else {
                    Component._trace(new StringBuilder(String.valueOf("TcpRing connecting to ")).append(member).toString(), 6);
                }
            }
            catch (IOException e) {
                this.onDisconnect(key, e);
            }
            ++i;
        }
    }

    protected void disconnectAll() {
        Iterator<SelectionKey> iter = this.getSelector().keys().iterator();
        while (iter.hasNext()) {
            SelectionKey key = iter.next();
            if (!key.isValid()) continue;
            this.close(key);
        }
    }

    protected Selector ensureSelector(SelectableChannel channel) throws IOException {
        Selector selector = this.getSelector();
        if (selector == null) {
            selector = channel.provider().openSelector();
            this.setSelector(selector);
        }
        return selector;
    }

    public void ensureTopology(Set setConnect) {
        Map mapBuddies = this.getBuddies();
        Iterator iter = mapBuddies.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            Member member = (Member)entry.getKey();
            if (!(setConnect.remove(member) ^ true)) continue;
            iter.remove();
            TcpRing$MemberMonitor monitor = (TcpRing$MemberMonitor)entry.getValue();
            LiteSet setKeys = monitor.getKeys();
            if (!(setKeys.isEmpty() ^ true)) continue;
            Component._trace(new StringBuilder(String.valueOf("TcpRing disconnected from ")).append(member).append(" to maintain ring").toString(), 3);
            Iterator iterKey = setKeys.iterator();
            while (iterKey.hasNext()) {
                SelectionKey key = (SelectionKey)iterKey.next();
                if (!key.isValid()) continue;
                this.close(key);
            }
        }
        iter = setConnect.iterator();
        while (iter.hasNext()) {
            this.connect((Member)((Object)iter.next()));
        }
    }

    public String formatStats() {
        return new StringBuilder(String.valueOf("Pings=")).append(this.getStatsPings()).append(", Failures=").append(this.getStatsFailures()).toString();
    }

    public Map getBuddies() {
        return this.__m_Buddies;
    }

    public ByteBuffer getBuffer() {
        return this.__m_Buffer;
    }

    public int getInboundConnectionCount() {
        return this.__m_InboundConnectionCount;
    }

    public int getRedundancyLevel() {
        return this.__m_RedundancyLevel;
    }

    public Selector getSelector() {
        return this.__m_Selector;
    }

    public ServerSocketChannel getServerSocketChannel() {
        return this.__m_ServerSocketChannel;
    }

    public SocketOptions getSocketOptions() {
        return this.__m_SocketOptions;
    }

    public SocketProvider getSocketProvider() {
        return this.__m_SocketProvider;
    }

    public long getStatsFailures() {
        return this.__m_StatsFailures;
    }

    public long getStatsPings() {
        return this.__m_StatsPings;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/net/TcpRing".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    private final Component get_Module() {
        return this;
    }

    protected void heartbeat(SelectionKey key) {
        block2: {
            SocketChannel channel;
            if (!(key != null) || !((channel = (SocketChannel)key.channel()).isConnectionPending() ^ true)) break block2;
            ByteBuffer buffer = this.getBuffer();
            ((Buffer)buffer).clear();
            try {
                channel.write(buffer);
                this.setStatsPings(this.getStatsPings() + 1L);
            }
            catch (IOException e) {
                this.onDisconnect(key, e);
            }
        }
    }

    public void heartbeatBuddies() {
        try {
            Iterator iter = this.getBuddies().values().iterator();
            while (iter.hasNext()) {
                TcpRing$MemberMonitor monitor = (TcpRing$MemberMonitor)iter.next();
                this.connect(monitor.getMember());
                Iterator iterKey = ((Set)monitor.getKeys()).iterator();
                while (iterKey.hasNext()) {
                    this.heartbeat((SelectionKey)iterKey.next());
                }
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
        if (this.getInboundConnectionCount() == 0) {
            this.onIsolation();
        }
    }

    protected void onAccept(SelectionKey key) {
        block11: {
            SocketChannel channel = null;
            try {
                channel = ((ServerSocketChannel)key.channel()).accept();
                if (channel == null) {
                    return;
                }
            }
            catch (IOException e) {
                this.onAcceptException(e);
                return;
            }
            SelectionKey keyClient = null;
            try {
                channel.configureBlocking(false);
                try {
                    channel.socket().setSoLinger(false, 0);
                }
                catch (IOException e) {
                    // empty catch block
                }
                keyClient = channel.register(this.ensureSelector(channel), SelectionKey.OP_READ);
                this.setInboundConnectionCount(this.getInboundConnectionCount() + 1);
            }
            catch (IOException e) {
                if (channel.socket().isClosed() ^ true) {
                    Component._trace(new StringBuilder(String.valueOf("error on TcpRing accept: ")).append(channel.socket()).append("\n").append(Component.getStackTrace(e)).toString(), 1);
                }
                if (keyClient == null) {
                    try {
                        channel.socket().close();
                    }
                    catch (IOException e2) {}
                    break block11;
                }
                this.close(keyClient);
            }
        }
    }

    protected void onAcceptException(Exception e) {
        this.onException(e);
    }

    protected void onConnect(SelectionKey key) {
        block3: {
            SocketChannel channel = (SocketChannel)key.channel();
            TcpRing$MemberMonitor monitor = (TcpRing$MemberMonitor)key.attachment();
            try {
                if (!channel.finishConnect()) break block3;
                key.interestOps(SelectionKey.OP_READ);
                monitor.setPendingConnections(monitor.getPendingConnections() - 1);
                monitor.getKeys().add(key);
                Member member = monitor.getMember();
                if (this.getBuddies().get(member) == monitor) {
                    Component._trace(new StringBuilder(String.valueOf("TcpRing connected to ")).append(member).toString(), 6);
                    break block3;
                }
                this.close(key);
            }
            catch (IOException e) {
                this.onDisconnect(key, e);
            }
        }
    }

    protected void onDeadBuddy(Member member, IOException e) {
        this.setStatsFailures(this.getStatsFailures() + (long)1);
        this.getBuddies().remove(member);
    }

    protected void onDisconnect(SelectionKey key, IOException e) {
        TcpRing$MemberMonitor monitor = this.close(key);
        if (monitor == null) {
            int cInbound = this.getInboundConnectionCount() - 1;
            this.setInboundConnectionCount(cInbound);
            if (cInbound == 0) {
                this.onIsolation();
            }
        } else {
            Member member = monitor.getMember();
            if (this.getBuddies().containsKey(member)) {
                String sReason = e.getMessage();
                sReason = new StringBuilder(String.valueOf(e.getClass().getSimpleName())).append(sReason == null ? "" : new StringBuilder(String.valueOf(": ")).append(sReason).toString()).toString();
                if ((e instanceof NoRouteToHostException ? true : "No route to host".equals(e.getMessage())) ? true : "Connection timed out".equals(e.getMessage())) {
                    Component._trace(new StringBuilder(String.valueOf("TcpRing connection to ")).append(member).append(" timed out (").append(sReason).append("); retrying.").toString(), 2);
                } else if (monitor.getKeys().isEmpty()) {
                    Component._trace(new StringBuilder(String.valueOf("TcpRing disconnected from ")).append(member).append(" due to a peer departure (").append(sReason).append("); removing the member.").toString(), 3);
                    this.onDeadBuddy(member, e);
                } else {
                    Component._trace(new StringBuilder(String.valueOf("TcpRing connection to ")).append(member).append(" failed (").append(sReason).append("); retrying.").toString(), 6);
                }
            }
        }
    }

    protected void onDisconnectException(Exception e, SelectionKey key) {
        Component._trace(new StringBuilder(String.valueOf("TcpRing disconnect from ")).append(key.attachment()).append(" failed: ").append(e.getMessage()).toString(), 3);
    }

    protected void onException(Exception e) {
    }

    public void onInit() {
        this.setBuffer(ByteBuffer.allocate(1));
        super.onInit();
        try {
            SocketOptions options = this.getSocketOptions();
            options.setOption(java.net.SocketOptions.TCP_NODELAY, Boolean.TRUE);
            options.setOption(java.net.SocketOptions.SO_LINGER, 0);
        }
        catch (SocketException e) {
            throw Base.ensureRuntimeException(e);
        }
    }

    protected void onIsolation() {
    }

    protected void onRead(SelectionKey key) {
        SocketChannel channel = (SocketChannel)key.channel();
        ByteBuffer buffer = this.getBuffer();
        ((Buffer)buffer).clear();
        try {
            if (channel.read(buffer) == -1) {
                this.onDisconnect(key, new IOException("end of stream"));
            }
        }
        catch (IOException e) {
            this.onDisconnect(key, e);
        }
    }

    protected void onSelect() {
        Iterator<SelectionKey> iter = this.getSelector().selectedKeys().iterator();
        while (iter.hasNext()) {
            SelectionKey key = iter.next();
            iter.remove();
            if (key.isValid() ^ true) continue;
            int nMaskOps = key.readyOps();
            if ((nMaskOps & SelectionKey.OP_ACCEPT) != 0) {
                this.onAccept(key);
            }
            if ((nMaskOps & SelectionKey.OP_CONNECT) != 0) {
                this.onConnect(key);
            }
            if (!((nMaskOps & SelectionKey.OP_READ) != 0)) continue;
            this.onRead(key);
        }
    }

    public void resetStats() {
        this.setStatsFailures(0L);
        this.setStatsPings(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void select(long cMillis) {
        Selector selector;
        Selector selector2 = selector = this.getSelector();
        synchronized (selector2) {
            try {
                if (selector.isOpen() ^ true) {
                    throw new IllegalStateException("TcpRing has been closed");
                }
                if (cMillis < 0L) {
                    selector.selectNow();
                } else {
                    Blocking.select(selector, cMillis);
                }
                this.onSelect();
            }
            catch (ClosedSelectorException e) {
                Component._trace(e, "socket is closed");
            }
            catch (IOException e) {
                Component._trace(e, new StringBuilder(String.valueOf("Caught an I/O exception while processing a TcpRing Socket; ")).append("the exception has been logged and will be ignored").toString());
            }
        }
    }

    protected void setBuddies(Map mapBuddies) {
        this.__m_Buddies = mapBuddies;
    }

    protected void setBuffer(ByteBuffer buffer) {
        this.__m_Buffer = buffer;
    }

    public void setInboundConnectionCount(int nCount) {
        this.__m_InboundConnectionCount = nCount;
    }

    public void setRedundancyLevel(int nLevel) {
        this.__m_RedundancyLevel = nLevel;
    }

    public void setSelector(Selector selector) {
        this.__m_Selector = selector;
    }

    public void setServerSocketChannel(ServerSocketChannel channel) {
        ServerSocketChannel channelOld = this.getServerSocketChannel();
        if (channelOld != null) {
            try {
                channel.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        try {
            channel.register(this.ensureSelector(channel), SelectionKey.OP_ACCEPT);
            this.getSocketOptions().apply(channel.socket());
        }
        catch (IOException e) {
            throw Base.ensureRuntimeException(e);
        }
        this.__m_ServerSocketChannel = channel;
    }

    protected void setSocketOptions(SocketOptions options) {
        Component._assert(options != null);
        Component._assert(this.getSocketOptions() == null);
        this.__m_SocketOptions = options;
    }

    public void setSocketProvider(SocketProvider providerSocket) {
        this.__m_SocketProvider = providerSocket;
    }

    protected void setStatsFailures(long cFailures) {
        this.__m_StatsFailures = cFailures;
    }

    protected void setStatsPings(long cPings) {
        this.__m_StatsPings = cPings;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TcpRing{Connections=[");
        Set setBuddies = this.getBuddies().keySet();
        try {
            Iterator iter = setBuddies.iterator();
            while (iter.hasNext()) {
                sb.append(((Member)iter.next()).getId());
                if (!iter.hasNext()) continue;
                sb.append(", ");
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
        sb.append("]}");
        return sb.toString();
    }

    public boolean verifyReachable(Member member, long cTimeoutMillis) {
        try {
            Socket socket = this.getSocketProvider().openSocket();
            Blocking.connect(socket, new InetSocketAddress(member.getAddress(), member.getTcpRingPort()), (int)cTimeoutMillis);
            socket.getOutputStream().write(0);
            socket.close();
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public void wakeup() {
        this.getSelector().wakeup();
    }
}

