/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net.extend.proxy;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.extend.Message;
import com.tangosol.coherence.component.net.extend.Proxy;
import com.tangosol.coherence.component.net.extend.messageFactory.NamedCacheFactory$MapEvent;
import com.tangosol.coherence.component.net.extend.proxy.NamedCacheProxy;
import com.tangosol.coherence.component.net.message.MapEventMessage;
import com.tangosol.net.NamedCache;
import com.tangosol.net.cache.CacheEvent;
import com.tangosol.net.messaging.Channel;
import com.tangosol.net.messaging.ConnectionException;
import com.tangosol.net.messaging.Protocol;
import com.tangosol.util.Binary;
import com.tangosol.util.ConcurrentMap;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.Filter;
import com.tangosol.util.MapEvent;
import com.tangosol.util.MapListener;
import com.tangosol.util.MapListenerSupport;
import com.tangosol.util.SegmentedConcurrentMap;
import com.tangosol.util.SegmentedHashSet;
import com.tangosol.util.WrapperException;
import com.tangosol.util.filter.InKeySetFilter;
import java.util.Iterator;
import java.util.Set;

public class MapListenerProxy
extends Proxy
implements MapListenerSupport.SynchronousListener {
    protected static final int LITE = 1;
    protected static final int PRIMING = 2;
    private Channel __m_Channel;
    private ConcurrentMap __m_FilterMap;
    private ConcurrentMap __m_KeyMap;
    private Set __m_KeySet;
    private MapListener __m_PrimingListener;

    public MapListenerProxy() {
        this(null, null, true);
    }

    public MapListenerProxy(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setEnabled(true);
            this.setFilterMap(new SegmentedConcurrentMap());
            this.setKeyMap(new SegmentedConcurrentMap());
            this.setKeySet(new SegmentedHashSet());
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    public void addListener(NamedCache cache, Filter filter, long lFilterId, boolean fLite, boolean fPriming) {
        Component._assert(lFilterId > (long)0);
        if (filter instanceof InKeySetFilter) {
            InKeySetFilter filterKeys = (InKeySetFilter)filter;
            Iterator<?> iter = filterKeys.getKeys().iterator();
            while (iter.hasNext()) {
                Binary binKey = (Binary)iter.next();
                this.addListener(cache, binKey, fLite, fPriming, false);
            }
            filterKeys.markConverted();
            cache.addMapListener(fPriming ? this.getPrimingListener() : this, filterKeys, fLite);
        } else {
            if (fPriming) {
                throw new UnsupportedOperationException("Priming listeners are only supported with InKeySetFilter");
            }
            ConcurrentMap map = this.getFilterMap();
            map.lock(filter, -1L);
            try {
                map.put(filter, new Object[]{lFilterId, fLite});
                cache.addMapListener(this, filter, fLite);
            }
            finally {
                Object var9_11 = null;
                map.unlock(filter);
            }
        }
    }

    public void addListener(NamedCache cache, Object oKey, boolean fLite, boolean fPriming) {
        this.addListener(cache, oKey, fLite, fPriming, true);
    }

    protected void addListener(NamedCache cache, Object oKey, boolean fLite, boolean fPriming, boolean fRegister) {
        ConcurrentMap map;
        block7: {
            Object oKeyDown = oKey;
            if (cache instanceof NamedCacheProxy) {
                oKey = this.normalizeKey(oKey);
            }
            map = this.getKeyMap();
            map.lock(oKey, -1L);
            try {
                int nFlags = fLite ? LITE : 0;
                nFlags |= fPriming ? PRIMING : nFlags;
                if (map.containsKey(oKey)) {
                    nFlags = (Integer)map.get(oKey);
                    if ((nFlags & PRIMING) == PRIMING) {
                        fRegister = false;
                    }
                    if (fPriming) {
                        fRegister = false;
                        Channel channel = this.getChannel();
                        Protocol.MessageFactory factory = channel.getMessageFactory();
                        NamedCacheFactory$MapEvent message = (NamedCacheFactory$MapEvent)factory.createMessage(NamedCacheFactory$MapEvent.TYPE_ID);
                        message.setId(MapEventMessage.ENTRY_UPDATED | MapEventMessage.EVT_SYNTHETIC | MapEventMessage.EVT_PRIMING);
                        message.setKey(oKey);
                        message.setSynthetic(true);
                        message.setTransformationState(CacheEvent.TransformationState.TRANSFORMABLE.ordinal());
                        message.setPriming(true);
                        message.setValueNew(cache.get(oKey));
                        channel.send(message);
                        nFlags |= PRIMING;
                        fRegister = false;
                    }
                    if (fLite ^ true) {
                        nFlags &= ~LITE;
                        fRegister = true;
                    }
                }
                map.put(oKey, nFlags);
                this.getKeySet().add(oKeyDown);
                if (!fRegister) break block7;
                cache.addMapListener(fPriming ? this.getPrimingListener() : this, oKeyDown, fLite);
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                map.unlock(oKey);
                throw throwable;
            }
        }
        Object var9_10 = null;
        map.unlock(oKey);
    }

    public void entryDeleted(MapEvent evt) {
        this.onMapEvent(evt);
    }

    public void entryInserted(MapEvent evt) {
        this.onMapEvent(evt);
    }

    public void entryUpdated(MapEvent evt) {
        this.onMapEvent(evt);
    }

    public Channel getChannel() {
        return this.__m_Channel;
    }

    public ConcurrentMap getFilterMap() {
        return this.__m_FilterMap;
    }

    public ConcurrentMap getKeyMap() {
        return this.__m_KeyMap;
    }

    public Set getKeySet() {
        return this.__m_KeySet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MapListener getPrimingListener() {
        MapListenerSupport.WrapperPrimingListener listener = (MapListenerSupport.WrapperPrimingListener)this.__m_PrimingListener;
        if (listener == null) {
            MapListenerProxy mapListenerProxy = this;
            synchronized (mapListenerProxy) {
                listener = (MapListenerSupport.WrapperPrimingListener)this.__m_PrimingListener;
                if (listener == null) {
                    listener = new MapListenerSupport.WrapperPrimingListener((MapListener)this);
                    this.setPrimingListener(listener);
                }
            }
        }
        return listener;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/net/extend/proxy/MapListenerProxy".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public static Component get_Instance() {
        return new MapListenerProxy();
    }

    private final Component get_Module() {
        return this;
    }

    protected Message[] instantiateMapEventMessages(MapEvent evt) {
        Message[] aMessages;
        int nId = evt.getId();
        Object oKey = evt.getKey();
        Integer NFlags = (Integer)this.getKeyMap().get(oKey);
        boolean fKeyLite = NFlags == null ? true : (NFlags & LITE) != 0;
        boolean fPriming = !(NFlags != null) ? false : (NFlags & PRIMING) != 0;
        int cFilters = 0;
        long[] alFilterIds = null;
        boolean[] afFilterLite = null;
        boolean fFilterLite = true;
        CacheEvent evtCache = evt instanceof CacheEvent ? (CacheEvent)evt : null;
        boolean fSynthetic = !(evtCache != null) ? false : evtCache.isSynthetic();
        boolean fExpired = !(evtCache != null) ? false : evtCache.isExpired();
        ConcurrentMap mapFilters = this.getFilterMap();
        MapEvent evtUnwrapped = MapListenerSupport.unwrapEvent(evt);
        if (evtUnwrapped instanceof MapListenerSupport.FilterEvent) {
            Filter[] aFilters = ((MapListenerSupport.FilterEvent)evtUnwrapped).getFilter();
            cFilters = aFilters.length;
            alFilterIds = new long[cFilters];
            afFilterLite = new boolean[cFilters];
            int i = 0;
            while (i < cFilters) {
                Object[] ao = (Object[])mapFilters.get(aFilters[i]);
                if (ao != null) {
                    long lId = (Long)ao[0];
                    boolean fLite = (Boolean)ao[1];
                    alFilterIds[i] = lId;
                    afFilterLite[i] = fLite;
                    if (fLite ^ true) {
                        fFilterLite = false;
                    }
                }
                ++i;
            }
        } else {
            Object[] ao = (Object[])mapFilters.get(null);
            if (ao != null) {
                long lId = (Long)ao[0];
                boolean fLite = (Boolean)ao[1];
                cFilters = 1;
                alFilterIds = new long[]{lId};
                afFilterLite = new boolean[]{fLite};
                fFilterLite = fLite;
            }
        }
        Channel channel = this.getChannel();
        Protocol.MessageFactory factory = channel.getMessageFactory();
        if (factory.getVersion() > 3 ? true : cFilters == 0) {
            NamedCacheFactory$MapEvent message = (NamedCacheFactory$MapEvent)factory.createMessage(NamedCacheFactory$MapEvent.TYPE_ID);
            message.setId(nId);
            message.setFilterIds(alFilterIds);
            message.setKey(oKey);
            message.setSynthetic(fSynthetic);
            message.setExpired(fExpired);
            if ((fKeyLite ^ true ? true : fFilterLite ^ true) ? true : fPriming) {
                message.setValueNew(evt.getNewValue());
                if (fPriming ^ true) {
                    message.setValueOld(evt.getOldValue());
                }
            }
            message.setTransformationState((evtCache == null ? CacheEvent.TransformationState.TRANSFORMABLE : evtCache.getTransformationState()).ordinal());
            message.setPriming(!(evtCache != null) ? false : evtCache.isPriming());
            aMessages = new NamedCacheFactory$MapEvent[]{message};
        } else {
            aMessages = new NamedCacheFactory$MapEvent[cFilters];
            int i = 0;
            while (i < cFilters) {
                NamedCacheFactory$MapEvent message = (NamedCacheFactory$MapEvent)factory.createMessage(NamedCacheFactory$MapEvent.TYPE_ID);
                message.setId(nId);
                message.setKey(oKey);
                message.setFilterId(alFilterIds[i]);
                message.setSynthetic(fSynthetic);
                message.setExpired(fExpired);
                if (afFilterLite[i] ^ true) {
                    message.setValueNew(evt.getNewValue());
                    message.setValueOld(evt.getOldValue());
                }
                aMessages[i] = message;
                ++i;
            }
        }
        return aMessages;
    }

    protected Object normalizeKey(Object oKey) {
        Binary binKey;
        if (oKey instanceof Binary && ExternalizableHelper.isIntDecorated(binKey = (Binary)oKey)) {
            oKey = ExternalizableHelper.removeIntDecoration(binKey);
        }
        return oKey;
    }

    public void onMapEvent(MapEvent evt) {
        Channel channel = this.getChannel();
        Component._assert(channel != null);
        Message[] aMessages = this.instantiateMapEventMessages(evt);
        try {
            int i = 0;
            int c = aMessages.length;
            while (i < c) {
                channel.send(aMessages[i]);
                ++i;
            }
        }
        catch (ConnectionException e) {
        }
        catch (Throwable t) {
            Component._trace(t, new StringBuilder(String.valueOf("Error sending MapEvent to ")).append(channel).toString());
        }
    }

    public void removeListener(NamedCache cache) {
        Filter filter;
        ConcurrentMap map = this.getFilterMap();
        map.lock(ConcurrentMap.LOCK_ALL, -1L);
        try {
            Iterator iter = map.keySet().iterator();
            while (iter.hasNext()) {
                filter = (Filter)iter.next();
                cache.removeMapListener(this, filter);
            }
            map.clear();
        }
        finally {
            filter = null;
            map.unlock(ConcurrentMap.LOCK_ALL);
        }
        map = this.getKeyMap();
        map.lock(ConcurrentMap.LOCK_ALL, -1L);
        try {
            Set set = this.getKeySet();
            Iterator iter = set.iterator();
            while (iter.hasNext()) {
                Integer NFlags;
                Object oKey;
                Object oKeyDown = oKey = iter.next();
                if (cache instanceof NamedCacheProxy) {
                    oKey = this.normalizeKey(oKey);
                }
                boolean fPriming = !((NFlags = (Integer)map.remove(oKey)) != null) ? false : (NFlags & PRIMING) != 0;
                cache.removeMapListener(fPriming ? this.getPrimingListener() : this, oKeyDown);
            }
            set.clear();
        }
        finally {
            Object var4_6 = null;
            map.unlock(ConcurrentMap.LOCK_ALL);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void removeListener(NamedCache cache, Filter filter, boolean fPriming) {
        ConcurrentMap map;
        block5: {
            if (filter instanceof InKeySetFilter) {
                InKeySetFilter filterKeys = (InKeySetFilter)filter;
                Iterator<?> iter = filterKeys.getKeys().iterator();
                while (iter.hasNext()) {
                    Binary binKey = (Binary)iter.next();
                    this.removeListener(cache, binKey, fPriming, false);
                }
                filterKeys.markConverted();
                cache.removeMapListener(fPriming ? this.getPrimingListener() : this, filterKeys);
                return;
            }
            if (fPriming) {
                throw new UnsupportedOperationException("Priming listeners are only supported with InKeySetFilter");
            }
            map = this.getFilterMap();
            map.lock(filter, -1L);
            try {
                if (!(map.remove(filter) != null)) break block5;
                cache.removeMapListener(this, filter);
            }
            catch (Throwable throwable) {
                Object var6_10 = null;
                map.unlock(filter);
                throw throwable;
            }
        }
        Object var6_9 = null;
        map.unlock(filter);
    }

    public void removeListener(NamedCache cache, Object oKey, boolean fPriming) {
        this.removeListener(cache, oKey, fPriming, true);
    }

    protected void removeListener(NamedCache cache, Object oKey, boolean fPriming, boolean fUnregister) {
        ConcurrentMap map;
        block5: {
            Object oKeyDown = oKey;
            if (cache instanceof NamedCacheProxy) {
                oKey = this.normalizeKey(oKey);
            }
            map = this.getKeyMap();
            map.lock(oKey, -1L);
            try {
                Integer NFlags = (Integer)map.remove(oKey);
                if (!(NFlags != null)) break block5;
                int nFlags = NFlags;
                fPriming &= (nFlags & PRIMING) == PRIMING;
                if (this.getKeySet().remove(oKeyDown)) {
                    if (fUnregister) {
                        cache.removeMapListener(fPriming ? this.getPrimingListener() : this, oKeyDown);
                    }
                    break block5;
                }
                Component._assert(false);
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                map.unlock(oKey);
                throw throwable;
            }
        }
        Object var8_10 = null;
        map.unlock(oKey);
    }

    public void setChannel(Channel channel) {
        Component._assert(this.getChannel() == null);
        this.__m_Channel = channel;
    }

    protected void setFilterMap(ConcurrentMap map) {
        this.__m_FilterMap = map;
    }

    protected void setKeyMap(ConcurrentMap map) {
        this.__m_KeyMap = map;
    }

    protected void setKeySet(Set set) {
        this.__m_KeySet = set;
    }

    public void setPrimingListener(MapListener sProperty) {
        this.__m_PrimingListener = sProperty;
    }
}

