/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net.extend.remoteService;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Extend;
import com.tangosol.coherence.component.net.extend.RemoteNamedCache;
import com.tangosol.coherence.component.net.extend.RemoteService;
import com.tangosol.coherence.component.net.extend.messageFactory.CacheServiceFactory$DestroyCacheRequest;
import com.tangosol.coherence.component.net.extend.messageFactory.CacheServiceFactory$EnsureCacheRequest;
import com.tangosol.coherence.component.net.extend.protocol.CacheServiceProtocol;
import com.tangosol.coherence.component.net.extend.protocol.NamedCacheProtocol;
import com.tangosol.internal.net.service.extend.remote.DefaultRemoteCacheServiceDependencies;
import com.tangosol.internal.net.service.extend.remote.DefaultRemoteServiceDependencies;
import com.tangosol.internal.net.service.extend.remote.LegacyXmlRemoteCacheServiceHelper;
import com.tangosol.internal.net.service.extend.remote.RemoteCacheServiceDependencies;
import com.tangosol.internal.net.service.extend.remote.RemoteServiceDependencies;
import com.tangosol.net.BackingMapManager;
import com.tangosol.net.CacheService;
import com.tangosol.net.NamedCache;
import com.tangosol.net.RequestTimeoutException;
import com.tangosol.net.internal.ScopedCacheReferenceStore;
import com.tangosol.net.messaging.Channel;
import com.tangosol.net.messaging.Connection;
import com.tangosol.net.messaging.ConnectionEvent;
import com.tangosol.net.messaging.ConnectionInitiator;
import com.tangosol.net.messaging.Protocol;
import com.tangosol.net.security.SecurityHelper;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.util.IteratorEnumerator;
import com.tangosol.util.Listeners;
import com.tangosol.util.NullImplementation;
import com.tangosol.util.SimpleResourceRegistry;
import com.tangosol.util.WrapperException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import javax.security.auth.Subject;

public class RemoteCacheService
extends RemoteService
implements CacheService {
    private boolean __m_DeferKeyAssociationCheck;
    private ScopedCacheReferenceStore __m_ScopedCacheStore;

    public RemoteCacheService() {
        this(null, null, true);
    }

    public RemoteCacheService(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setMemberListeners(new Listeners());
            this.setResourceRegistry(new SimpleResourceRegistry());
            this.setScopedCacheStore(new ScopedCacheReferenceStore());
            this.setServiceListeners(new Listeners());
            this.setServiceVersion("14");
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    protected DefaultRemoteServiceDependencies cloneDependencies(RemoteServiceDependencies deps) {
        return new DefaultRemoteCacheServiceDependencies((RemoteCacheServiceDependencies)deps);
    }

    public void connectionClosed(ConnectionEvent evt) {
        this.releaseCaches();
        super.connectionClosed(evt);
    }

    public void connectionError(ConnectionEvent evt) {
        this.releaseCaches();
        super.connectionError(evt);
    }

    protected RemoteNamedCache createRemoteNamedCache(String sName, ClassLoader loader) {
        URI uri;
        Channel channel = this.ensureChannel();
        Connection connection = channel.getConnection();
        Protocol.MessageFactory factory = channel.getMessageFactory();
        RemoteNamedCache cache = new RemoteNamedCache();
        Subject subject = SecurityHelper.getCurrentSubject();
        CacheServiceFactory$EnsureCacheRequest request = (CacheServiceFactory$EnsureCacheRequest)factory.createMessage(CacheServiceFactory$EnsureCacheRequest.TYPE_ID);
        request.setCacheName(sName);
        try {
            uri = new URI((String)channel.request(request));
        }
        catch (URISyntaxException e) {
            throw Extend.ensureRuntimeException(e, "error instantiating URI");
        }
        if (loader == NullImplementation.getClassLoader()) {
            loader = this.getContextClassLoader();
            Component._assert(loader != null, "ContextClassLoader is missing");
            cache.setPassThrough(true);
        }
        cache.setCacheName(sName);
        cache.setCacheService(this);
        cache.setDeferKeyAssociationCheck(this.isDeferKeyAssociationCheck());
        cache.setEventDispatcher(this.ensureEventDispatcher());
        connection.acceptChannel(uri, loader, cache, subject);
        return cache;
    }

    public void destroyCache(NamedCache map) {
        if (map instanceof RemoteNamedCache ^ true) {
            throw new IllegalArgumentException(new StringBuilder(String.valueOf("illegal map: ")).append(map).toString());
        }
        RemoteNamedCache cache = (RemoteNamedCache)map;
        String sName = cache.getCacheName();
        this.getScopedCacheStore().releaseCache(cache);
        this.destroyRemoteNamedCache(cache);
    }

    protected void destroyRemoteNamedCache(RemoteNamedCache cache) {
        this.releaseRemoteNamedCache(cache);
        Channel channel = this.ensureChannel();
        Protocol.MessageFactory factory = channel.getMessageFactory();
        CacheServiceFactory$DestroyCacheRequest request = (CacheServiceFactory$DestroyCacheRequest)factory.createMessage(CacheServiceFactory$DestroyCacheRequest.TYPE_ID);
        request.setCacheName(cache.getCacheName());
        channel.request(request);
    }

    protected void doConfigure(XmlElement xml) {
        this.setDependencies(LegacyXmlRemoteCacheServiceHelper.fromXml(xml, new DefaultRemoteCacheServiceDependencies(), this.getOperationalContext(), this.getContextClassLoader()));
    }

    protected void doShutdown() {
        super.doShutdown();
        this.getScopedCacheStore().clear();
    }

    public NamedCache ensureCache(String sName, ClassLoader loader) {
        ScopedCacheReferenceStore store;
        RemoteNamedCache cache;
        if (sName == null ? true : sName.length() == 0) {
            sName = "Default";
        }
        if (loader == null) {
            loader = this.getContextClassLoader();
            Component._assert(loader != null, "ContextClassLoader is missing");
        }
        if ((cache = (RemoteNamedCache)(store = this.getScopedCacheStore()).getCache(sName, loader)) == null ? true : cache.isActive() ^ true) {
            block7: {
                long cWait = this.getDependencies().getRequestTimeoutMillis();
                if (cWait <= (long)0) {
                    cWait = -1;
                }
                if (store.lock(sName, cWait) ^ true) {
                    throw new RequestTimeoutException(new StringBuilder(String.valueOf("Failed to get a reference to cache '")).append(sName).append("' after ").append(cWait).append("ms").toString());
                }
                try {
                    cache = (RemoteNamedCache)store.getCache(sName, loader);
                    if (!(cache == null ? true : cache.isActive() ^ true)) break block7;
                    cache = this.createRemoteNamedCache(sName, loader);
                    store.putCache(cache, loader);
                }
                catch (Throwable throwable) {
                    Object var8_7 = null;
                    store.unlock(sName);
                    throw throwable;
                }
            }
            Object var8_6 = null;
            store.unlock(sName);
        }
        return cache;
    }

    public BackingMapManager getBackingMapManager() {
        return null;
    }

    public Enumeration getCacheNames() {
        return new IteratorEnumerator(Arrays.asList(this.getScopedCacheStore().getNames().toArray()).iterator());
    }

    public ScopedCacheReferenceStore getScopedCacheStore() {
        return this.__m_ScopedCacheStore;
    }

    public String getServiceType() {
        return CacheService.TYPE_REMOTE;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/net/extend/remoteService/RemoteCacheService".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public static Component get_Instance() {
        return new RemoteCacheService();
    }

    private final Component get_Module() {
        return this;
    }

    public boolean isDeferKeyAssociationCheck() {
        return this.__m_DeferKeyAssociationCheck;
    }

    protected void onDependencies(RemoteServiceDependencies deps) {
        super.onDependencies(deps);
        RemoteCacheServiceDependencies remoteDeps = (RemoteCacheServiceDependencies)deps;
        this.setDeferKeyAssociationCheck(remoteDeps.isDeferKeyAssociationCheck());
        ConnectionInitiator initiator = this.getInitiator();
        initiator.registerProtocol(CacheServiceProtocol.getInstance());
        initiator.registerProtocol(NamedCacheProtocol.getInstance());
    }

    protected Channel openChannel() {
        this.lookupProxyServiceAddress();
        Connection connection = this.getInitiator().ensureConnection();
        return connection.openChannel(CacheServiceProtocol.getInstance(), "CacheServiceProxy", null, null, SecurityHelper.getCurrentSubject());
    }

    public void releaseCache(NamedCache map) {
        if (map instanceof RemoteNamedCache ^ true) {
            throw new IllegalArgumentException(new StringBuilder(String.valueOf("illegal map: ")).append(map).toString());
        }
        RemoteNamedCache cache = (RemoteNamedCache)map;
        String sName = cache.getCacheName();
        this.getScopedCacheStore().releaseCache(cache);
        this.releaseRemoteNamedCache(cache);
    }

    protected void releaseCaches() {
        ScopedCacheReferenceStore store = this.getScopedCacheStore();
        Iterator iter = store.getAllCaches().iterator();
        while (iter.hasNext()) {
            RemoteNamedCache cache = (RemoteNamedCache)iter.next();
            this.releaseRemoteNamedCache(cache);
        }
        store.clear();
    }

    protected void releaseRemoteNamedCache(RemoteNamedCache cache) {
        try {
            Channel channel = cache.getChannel();
            if (channel != null) {
                channel.close();
            }
        }
        catch (RuntimeException runtimeException) {}
    }

    public void setBackingMapManager(BackingMapManager manager) {
    }

    protected void setDeferKeyAssociationCheck(boolean fDefer) {
        this.__m_DeferKeyAssociationCheck = fDefer;
    }

    protected void setScopedCacheStore(ScopedCacheReferenceStore store) {
        this.__m_ScopedCacheStore = store;
    }
}

