/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net.management.model;

import com.oracle.coherence.common.base.Blocking;
import com.oracle.coherence.common.base.Continuation;
import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.management.Connector;
import com.tangosol.coherence.component.net.management.Gateway;
import com.tangosol.coherence.component.net.management.Model;
import com.tangosol.coherence.component.net.management.listenerHolder.LocalHolder;
import com.tangosol.coherence.component.net.management.model.LocalModel;
import com.tangosol.coherence.component.net.management.model.RemoteModel$InvocationObserver;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.net.Invocable;
import com.tangosol.net.InvocationObserver;
import com.tangosol.net.InvocationService;
import com.tangosol.net.Member;
import com.tangosol.net.PriorityTask;
import com.tangosol.net.RequestTimeoutException;
import com.tangosol.util.Base;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.ListMap;
import com.tangosol.util.WrapperException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;

public class RemoteModel
extends Model
implements ExternalizableLite,
Invocable,
InvocationObserver,
PriorityTask {
    public static final int MUTEX_ACQUIRED_NOWAIT = 1;
    public static final int MUTEX_ACQUIRED_WAIT = 2;
    public static final int MUTEX_TIMEOUT = -1;
    public static final int OP_GET = 1;
    public static final int OP_INVOKE = 2;
    public static final int OP_SET = 3;
    private transient long __m_AccessTime;
    private transient boolean __m_Accessed;
    private Connector __m_Connector;
    private Continuation __m_Continuation;
    private volatile transient boolean __m_ExecutingFlag;
    private transient long __m_ExecutionLastTimeMillis;
    private long __m_ExecutionTimeoutMillis;
    private RemoteModel$InvocationObserver __m_InvocationObserver;
    private String __m_InvokeName;
    private transient int __m_InvokeOp;
    private Object[] __m_InvokeParam;
    private String[] __m_InvokeSignature;
    private transient Member __m_ModelOwner;
    private transient long __m_PauseDuration;
    private transient LocalModel __m_Snapshot;
    private transient LocalModel __m_SnapshotNext;
    private static ListMap __mapChildren;

    static {
        RemoteModel.__initStatic();
    }

    public RemoteModel() {
        this(null, null, true);
    }

    public RemoteModel(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setAccessed(false);
            this.setExecutingFlag(false);
            this.setExecutionTimeoutMillis(0L);
            this.setPauseDuration(128L);
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    private static void __initStatic() {
        __mapChildren = new ListMap();
        Class clazz = __mapChildren.put("InvocationObserver", RemoteModel$InvocationObserver.get_CLASS());
    }

    public LocalHolder _addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) {
        LocalHolder holder = super._addNotificationListener(listener, filter, handback);
        if (holder != null) {
            this.getConnector().subscribe(this.get_ModelName(), this.getModelOwner(), holder.ensureRemoteHolder());
        }
        return holder;
    }

    public Set _removeNotificationListener(NotificationListener listener) {
        Set setHolders = super._removeNotificationListener(listener);
        if (setHolders != null) {
            this.getConnector().unsubscribe(this.get_ModelName(), this.getModelOwner(), setHolders);
        }
        return setHolders;
    }

    public LocalHolder _removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) {
        LocalHolder holder = super._removeNotificationListener(listener, filter, handback);
        if (holder != null) {
            this.getConnector().unsubscribe(this.get_ModelName(), this.getModelOwner(), Collections.singleton(holder));
        }
        return holder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int acquireExecuteMutex(long cTimeout) {
        int nWaited = MUTEX_ACQUIRED_NOWAIT;
        boolean fWaited = false;
        RemoteModel remoteModel = this;
        synchronized (remoteModel) {
            while (this.isExecutingFlag()) {
                try {
                    long cElapsed = Base.getSafeTimeMillis() - this.getExecutionLastTimeMillis();
                    if (cElapsed < cTimeout) {
                        nWaited = MUTEX_ACQUIRED_WAIT;
                        fWaited = true;
                        Blocking.wait(this, cTimeout - cElapsed);
                        continue;
                    }
                    nWaited = MUTEX_TIMEOUT;
                    if (!fWaited) break;
                    Connector conn = this.getConnector();
                    conn.setStatsRefreshTimeoutCount(conn.getStatsRefreshTimeoutCount() + (long)1);
                    break;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw Base.ensureRuntimeException(e);
                }
            }
            if (nWaited != MUTEX_TIMEOUT) {
                this.setExecutingFlag(true);
                if (nWaited == MUTEX_ACQUIRED_NOWAIT) {
                    this.setExecutionLastTimeMillis(Base.getSafeTimeMillis());
                }
            }
        }
        return nWaited;
    }

    public RemoteModel cloneModel() {
        RemoteModel model = new RemoteModel();
        model.set_ModelName(this.get_ModelName());
        model.setConnector(this.getConnector());
        model.setAccessed(model.isAccessed());
        model.setModelOwner(model.getModelOwner());
        return model;
    }

    public Object doGet(String sName) {
        Component._assert(sName != null);
        Connector connector = this.getConnector();
        if (connector.getInvokeContinuation() != null) {
            return this.invokeRemote(OP_GET, sName, null);
        }
        LocalModel model = connector.ensureFreshSnapshot(this);
        Map mapAttr = model.get_SnapshotMap();
        this.setAccessed(true);
        if (sName.startsWith("is")) {
            sName = sName.substring(2);
        } else if (sName.startsWith("get")) {
            sName = sName.substring(3);
        }
        this.setAccessTime(Base.getSafeTimeMillis());
        return mapAttr.get(sName);
    }

    public void doSet(String sName, Object[] aoParam) {
        this.invokeRemote(OP_SET, sName, aoParam);
    }

    protected long getAccessTime() {
        return this.__m_AccessTime;
    }

    public long getAttributeTimeoutMillis() {
        return this.getConnector().getRefreshAttributeTimeoutMillis();
    }

    public Connector getConnector() {
        return this.__m_Connector;
    }

    protected Continuation getContinuation() {
        return this.__m_Continuation;
    }

    public long getExecutionLastTimeMillis() {
        long cMillis = this.__m_ExecutionLastTimeMillis;
        return cMillis == 0L ? Base.getSafeTimeMillis() : cMillis;
    }

    public long getExecutionTimeoutMillis() {
        return this.__m_ExecutionTimeoutMillis;
    }

    public RemoteModel$InvocationObserver getInvocationObserver() {
        return this.__m_InvocationObserver;
    }

    public String getInvokeName() {
        return this.__m_InvokeName;
    }

    public int getInvokeOp() {
        return this.__m_InvokeOp;
    }

    public Object[] getInvokeParam() {
        return this.__m_InvokeParam;
    }

    public String[] getInvokeSignature() {
        return this.__m_InvokeSignature;
    }

    public Member getModelOwner() {
        return this.__m_ModelOwner;
    }

    public long getPauseDuration() {
        return this.__m_PauseDuration;
    }

    public long getRequestTimeout() {
        return this.getConnector().getRequestTimeout();
    }

    public long getRequestTimeoutMillis() {
        return this.getInvokeOp() == OP_INVOKE ? this.getConnector().getRequestTimeout() : this.getConnector().getRefreshRequestTimeoutMillis();
    }

    public Object getResult() {
        return this.getSnapshot();
    }

    public int getSchedulingPriority() {
        return 0;
    }

    public LocalModel getSnapshot() {
        LocalModel modelNext = this.getSnapshotNext();
        if (!(modelNext != null) ? false : this.isActive() ^ true) {
            int nMutex;
            block5: {
                nMutex = this.acquireExecuteMutex(this.getAttributeTimeoutMillis());
                try {
                    modelNext = this.getSnapshotNext();
                    if (!(modelNext != null)) break block5;
                    this.setSnapshot(modelNext);
                    this.setSnapshotNext(null);
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    if (nMutex != MUTEX_TIMEOUT) {
                        this.releaseExecuteMutex();
                    }
                    throw throwable;
                }
            }
            Object var4_3 = null;
            if (nMutex != MUTEX_TIMEOUT) {
                this.releaseExecuteMutex();
            }
        }
        return this.__m_Snapshot;
    }

    public LocalModel getSnapshotNext() {
        return this.__m_SnapshotNext;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/net/management/model/RemoteModel".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    public static Component get_Instance() {
        return new RemoteModel();
    }

    private final Component get_Module() {
        return this;
    }

    public void init(InvocationService service) {
        this.setConnector((Connector)service.getUserContext());
    }

    public void invocationCompleted() {
        Continuation cont = this.getContinuation();
        if (cont == null) {
            this.releaseExecuteMutex();
        } else {
            LocalModel model = this.getSnapshotNext();
            if (model == null) {
                model = this.getSnapshot();
            }
            cont.proceed(model.get_InvocationResult());
            this.setContinuation(null);
        }
    }

    public Object invoke(int nOp, String sName, Object[] aoParam) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException, MBeanException {
        return this.invoke(nOp, sName, aoParam, null);
    }

    public Object invoke(int nOp, String sName, Object[] aoParam, String[] asSignature) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException, MBeanException {
        switch (nOp) {
            case 1: {
                return this.doGet(sName);
            }
            case 3: {
                this.doSet(sName, aoParam);
                return null;
            }
            case 2: {
                return this.invokeRemote(nOp, sName, aoParam, asSignature);
            }
        }
        throw new IllegalStateException();
    }

    public Object invokeRemote(int nOp, String sName, Object[] aoParam) {
        return this.invokeRemote(nOp, sName, aoParam, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object invokeRemote(int nOp, String sName, Object[] aoParam, String[] asSignature) {
        Object object;
        int nWaited;
        block14: {
            RemoteModel$InvocationObserver observer;
            block13: {
                boolean bl;
                LocalModel localModel;
                block12: {
                    nWaited = MUTEX_TIMEOUT;
                    try {
                        try {
                            Map.Entry entry;
                            LocalModel model;
                            if (sName == null) {
                                this.invokeRemoteAsync();
                                nWaited = this.acquireExecuteMutex(this.getAttributeTimeoutMillis());
                                localModel = this.getSnapshot();
                                Object var14_10 = null;
                                bl = nWaited != MUTEX_TIMEOUT;
                                break block12;
                            }
                            nWaited = this.acquireExecuteMutex(0L);
                            RemoteModel task = nWaited == MUTEX_TIMEOUT ? this.cloneModel() : this;
                            task.setInvokeOp(nOp);
                            task.setInvokeName(sName);
                            task.setInvokeParam(aoParam);
                            task.setInvokeSignature(asSignature);
                            Connector connector = this.getConnector();
                            InvocationService service = connector.getService();
                            Set<Member> setTarget = Collections.singleton(this.getModelOwner());
                            Continuation cont = connector.getInvokeContinuation();
                            if (cont != null) {
                                if (service == null) {
                                    cont.proceed(new RuntimeException("Service has been stopped"));
                                } else {
                                    observer = (RemoteModel$InvocationObserver)this._newChild("InvocationObserver");
                                    observer.setContinuation(cont);
                                    service.execute(task, setTarget, observer);
                                }
                                observer = null;
                                break block13;
                            }
                            if (service == null) {
                                throw new RuntimeException("Service has been stopped");
                            }
                            Map mapResult = service.query(task, setTarget);
                            Object oResult = null;
                            if (mapResult.isEmpty() ^ true && !((model = (LocalModel)(entry = mapResult.entrySet().iterator().next()).getValue()) == null)) {
                                oResult = model.get_InvocationResult();
                                if (oResult instanceof Throwable) {
                                    throw Base.ensureRuntimeException((Throwable)oResult);
                                }
                                if (nOp == OP_INVOKE) {
                                    this.setAccessTime(0L);
                                }
                                this.setSnapshot(model);
                            }
                            object = oResult;
                            break block14;
                        }
                        catch (RequestTimeoutException e) {
                            throw Base.ensureRuntimeException(e, "Timeout occurred when executing remote method");
                        }
                    }
                    catch (Throwable throwable) {
                        Object var14_13 = null;
                        if (!(nWaited != MUTEX_TIMEOUT)) throw throwable;
                        this.releaseExecuteMutex();
                        throw throwable;
                    }
                }
                if (!bl) return localModel;
                this.releaseExecuteMutex();
                return localModel;
            }
            Object var14_11 = null;
            if (!(nWaited != MUTEX_TIMEOUT)) return observer;
            this.releaseExecuteMutex();
            return observer;
        }
        Object var14_12 = null;
        if (!(nWaited != MUTEX_TIMEOUT)) return object;
        this.releaseExecuteMutex();
        return object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean invokeRemoteAsync() {
        int nMutex;
        block3: {
            boolean bl;
            nMutex = MUTEX_TIMEOUT;
            try {
                nMutex = this.acquireExecuteMutex(0L);
                if (!(nMutex == MUTEX_ACQUIRED_NOWAIT)) break block3;
                RemoteModel task = this;
                task.setInvokeOp(OP_GET);
                task.setInvokeName(null);
                task.setInvokeParam(null);
                InvocationService service = this.getConnector().getService();
                if (!(service != null)) break block3;
                service.execute(task, Collections.singleton(this.getModelOwner()), this.getInvocationObserver());
                bl = true;
                Object var5_6 = null;
                if (!(nMutex == MUTEX_ACQUIRED_WAIT)) return bl;
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                if (!(nMutex == MUTEX_ACQUIRED_WAIT)) throw throwable;
                this.releaseExecuteMutex();
                throw throwable;
            }
            this.releaseExecuteMutex();
            return bl;
        }
        Object var5_7 = null;
        if (nMutex != MUTEX_ACQUIRED_WAIT) {
            return false;
        }
        boolean bl = true;
        if (!bl) return false;
        this.releaseExecuteMutex();
        return false;
    }

    public boolean isAccessed() {
        return this.__m_Accessed;
    }

    public boolean isActive() {
        return Base.getSafeTimeMillis() < this.getAccessTime() + this.getPauseDuration();
    }

    public boolean isExecutingFlag() {
        return this.__m_ExecutingFlag;
    }

    public boolean isRefreshRequired() {
        LocalModel modelNext = this.getSnapshotNext();
        LocalModel model = modelNext == null ? this.getSnapshot() : modelNext;
        Connector connector = this.getConnector();
        if (connector == null ? true : model == null) {
            return false;
        }
        return !(this.isExecutingFlag() ^ true) ? false : model._checkExpired(connector.getRefreshTimeoutMillis());
    }

    public boolean isResponsibilityMBean() {
        return Gateway.isResponsibilityMBean(this.get_ModelName());
    }

    public void memberCompleted(Member member, Object oResult) {
        LocalModel model = (LocalModel)oResult;
        if (model == null) {
            Component._trace(new StringBuilder(String.valueOf("Missing result for ")).append(this.get_ModelName()).append(" from ").append(member).toString(), 4);
        } else {
            this.setSnapshot(model);
        }
    }

    public void memberFailed(Member member, Throwable exception) {
    }

    public void memberLeft(Member member) {
    }

    public void onInit() {
        this.setInvocationObserver((RemoteModel$InvocationObserver)this._newChild("InvocationObserver"));
    }

    public void readExternal(DataInput in) throws IOException {
        this.set_ModelName(ExternalizableHelper.readSafeUTF(in));
        this.setInvokeName(ExternalizableHelper.readSafeUTF(in));
        this.setInvokeParam((Object[])ExternalizableHelper.readObject(in));
        this.setInvokeOp(ExternalizableHelper.readInt(in));
        boolean fSig = in.readBoolean();
        if (fSig) {
            this.setInvokeSignature((String[])ExternalizableHelper.readObject(in));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseExecuteMutex() {
        RemoteModel remoteModel = this;
        synchronized (remoteModel) {
            this.setExecutingFlag(false);
            this.notify();
        }
    }

    public void run() {
        block6: {
            LocalModel model;
            String[] asSign;
            int nOp;
            Object[] aoParam;
            String sMethod;
            block5: {
                String sModel = this.get_ModelName();
                sMethod = this.getInvokeName();
                aoParam = this.getInvokeParam();
                nOp = this.getInvokeOp();
                asSign = this.getInvokeSignature();
                model = (LocalModel)this.getConnector().getLocalRegistry().get(sModel);
                if (!(model == null)) break block5;
                if (!(this.isResponsibilityMBean() ^ true)) break block6;
                Component._trace(new StringBuilder(String.valueOf("Missing model ")).append(sModel).toString(), 4);
                break block6;
            }
            this.setSnapshot(model);
            if (sMethod == null) {
                model.set_InvocationResult(null);
            } else {
                try {
                    if (aoParam == null) {
                        aoParam = ClassHelper.VOID;
                    }
                    model.set_InvocationResult(model.invoke(nOp, sMethod, aoParam, asSign));
                }
                catch (Throwable e) {
                    model.set_InvocationResult(e);
                }
            }
        }
    }

    public void runCanceled(boolean fAbandoned) {
    }

    protected void setAccessTime(long ldt) {
        this.__m_AccessTime = ldt;
    }

    public void setAccessed(boolean fUsed) {
        this.__m_Accessed = fUsed;
    }

    public void setConnector(Connector connector) {
        this.__m_Connector = connector;
    }

    protected void setContinuation(Continuation continuation) {
        this.__m_Continuation = continuation;
    }

    protected void setExecutingFlag(boolean fExecuting) {
        this.__m_ExecutingFlag = fExecuting;
    }

    protected void setExecutionLastTimeMillis(long cMillis) {
        this.__m_ExecutionLastTimeMillis = cMillis;
    }

    protected void setExecutionTimeoutMillis(long cMillis) {
        this.__m_ExecutionTimeoutMillis = cMillis;
    }

    public void setInvocationObserver(RemoteModel$InvocationObserver observerInvocation) {
        this.__m_InvocationObserver = observerInvocation;
    }

    protected void setInvokeName(String sName) {
        this.__m_InvokeName = sName;
    }

    protected void setInvokeOp(int nOp) {
        this.__m_InvokeOp = nOp;
    }

    protected void setInvokeParam(Object[] aoParams) {
        this.__m_InvokeParam = aoParams;
    }

    protected void setInvokeSignature(String[] asSig) {
        this.__m_InvokeSignature = asSig;
    }

    public void setModelOwner(Member member) {
        this.__m_ModelOwner = member;
    }

    public void setPauseDuration(long cMillis) {
        this.__m_PauseDuration = cMillis;
    }

    public void setSnapshot(LocalModel model) {
        Map mapSnapshot = model.get_SnapshotMap();
        mapSnapshot.put("RefreshTime", new Date(System.currentTimeMillis()));
        if (this.isActive()) {
            this.setSnapshotNext(model);
        } else {
            this.__m_Snapshot = model;
            this.setSnapshotNext(null);
        }
    }

    protected void setSnapshotNext(LocalModel model) {
        this.__m_SnapshotNext = model;
    }

    public String toString() {
        return new StringBuilder(String.valueOf(super.toString())).append(", owner=").append(this.getModelOwner()).toString();
    }

    public void writeExternal(DataOutput out) throws IOException {
        String[] asSig = this.getInvokeSignature();
        boolean fSig = asSig != null;
        ExternalizableHelper.writeSafeUTF(out, this.get_ModelName());
        ExternalizableHelper.writeSafeUTF(out, this.getInvokeName());
        ExternalizableHelper.writeObject(out, this.getInvokeParam());
        ExternalizableHelper.writeInt(out, this.getInvokeOp());
        out.writeBoolean(fSig);
        if (fSig) {
            ExternalizableHelper.writeObject(out, this.getInvokeSignature());
        }
    }
}

