/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net.management.model.localModel;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Cluster;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.management.Gateway;
import com.tangosol.coherence.component.net.management.Model;
import com.tangosol.coherence.component.net.management.model.LocalModel;
import com.tangosol.coherence.component.util.SafeCluster;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.management.MBeanHelper;
import com.tangosol.net.management.Registry;
import com.tangosol.util.Base;
import com.tangosol.util.WrapperException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class ClusterModel
extends LocalModel {
    private transient SafeCluster __m__Cluster;
    private transient WeakReference __m__ClusterRef;
    private static /* synthetic */ Class __sf0;

    public ClusterModel() {
        this(null, null, true);
    }

    public ClusterModel(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.set_SnapshotMap(new HashMap());
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    private static /* synthetic */ Class __sm0() {
        Class<?> clazz = __sf0;
        if (clazz == null) {
            try {
                clazz = __sf0 = Class.forName("[Ljava.lang.String;");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public void configureTracing(String sRole, Float fRatio) {
        this.checkReadOnly("configureTracing");
        if (fRatio == null) {
            throw new IllegalArgumentException("fRatio cannot be null");
        }
        float fRatioPrim = fRatio.floatValue();
        fRatio = Float.valueOf(fRatioPrim < 0.0f ? (float)-1 : Math.min(fRatioPrim, 1.0f));
        SafeCluster cluster = this.get_Cluster();
        if (cluster == null) {
            return;
        }
        MBeanServer server = MBeanHelper.findMBeanServer();
        Gateway gateway = (Gateway)cluster.getManagement();
        boolean fAllMembers = sRole == null ? true : sRole.isEmpty();
        String sNodePrefix = new StringBuilder(String.valueOf(gateway.getDomainName())).append(':').append(Registry.NODE_TYPE).toString();
        Iterator iter = cluster.getMemberSet().iterator();
        while (iter.hasNext()) {
            com.tangosol.net.Member member = (com.tangosol.net.Member)iter.next();
            if (!(fAllMembers ? true : Objects.equals(member.getRoleName(), sRole))) continue;
            try {
                String sNode = gateway.ensureGlobalName(sNodePrefix, member);
                server.setAttribute(new ObjectName(sNode), new Attribute("TracingSamplingRatio", fRatio));
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
    }

    public void dumpClusterHeap(String sRole) {
        this.checkReadOnly("dumpClusterHeap");
        SafeCluster cluster = this.get_Cluster();
        if (cluster == null) {
            return;
        }
        MBeanServer server = MBeanHelper.findMBeanServer();
        Gateway gateway = (Gateway)cluster.getManagement();
        boolean fAllMembers = sRole == null ? true : sRole.isEmpty();
        String sNodePrefix = new StringBuilder(String.valueOf(gateway.getDomainName())).append(':').append(Registry.NODE_TYPE).toString();
        Iterator iter = cluster.getMemberSet().iterator();
        while (iter.hasNext()) {
            com.tangosol.net.Member member = (com.tangosol.net.Member)iter.next();
            if (!(fAllMembers ? true : Objects.equals(member.getRoleName(), sRole))) continue;
            try {
                String sNode = gateway.ensureGlobalName(sNodePrefix, member);
                String sFileName = (String)server.invoke(new ObjectName(sNode), "dumpHeap", new Object[]{null}, null);
                Component._trace(new StringBuilder(String.valueOf("Heapdump is created for Node")).append(member.getId()).append(" in ").append(sFileName).toString(), 2);
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
    }

    public String ensureGlobalFileName(String sOptions, int nMemberId) {
        String FILE_OPTION = "filename";
        String NAME_OPTION = "name";
        int iFilename = sOptions.indexOf(FILE_OPTION);
        while (iFilename >= 0) {
            char chFilePre = sOptions.charAt(Math.max(iFilename - 1, 0));
            char chFilePost = sOptions.charAt(iFilename + FILE_OPTION.length());
            if (!(!(!(chFilePre != ' ') ? false : chFilePre != ',') ? false : (!(chFilePost != ' ') ? false : chFilePost != '='))) {
                int iValueStart = iFilename + FILE_OPTION.length();
                while (sOptions.charAt(iValueStart) == ' ' ? true : sOptions.charAt(iValueStart) == '=') {
                    ++iValueStart;
                }
                int iValueEnd = iValueStart + 1;
                while (!(iValueEnd < sOptions.length()) ? false : sOptions.charAt(iValueEnd) != ',') {
                    ++iValueEnd;
                }
                String sFileName = sOptions.substring(iValueStart, iValueEnd);
                int iFileName = sFileName.lastIndexOf(File.separator);
                if (iFileName > 0) {
                    sFileName = sFileName.substring(iFileName + 1);
                }
                int iFileExt = sFileName.length() > 0 ? sFileName.lastIndexOf(".") : -1;
                String sName = "";
                if (iFileExt < 0 ? true : sFileName.length() - iFileExt > 4) {
                    int iBegin = sOptions.indexOf(NAME_OPTION);
                    while (iBegin >= 0) {
                        char chNamePre = sOptions.charAt(Math.max(iBegin - 1, 0));
                        char chNamePost = sOptions.charAt(iBegin + NAME_OPTION.length());
                        if (!(((iBegin == 0 ? true : chNamePre == ' ') ? true : chNamePre == ',') ^ true ? true : (chNamePost == ' ' ? true : chNamePost == '=') ^ true)) {
                            int iEnd = (iBegin += NAME_OPTION.length()) + 1;
                            while (!(iEnd < sOptions.length()) ? false : sOptions.charAt(iEnd) != ',') {
                                ++iEnd;
                            }
                            sName = sOptions.substring(iBegin + 1, iEnd);
                            break;
                        }
                        iBegin = sOptions.indexOf(NAME_OPTION, iBegin + NAME_OPTION.length());
                    }
                    return sFileName.length() == 0 ? new StringBuilder(String.valueOf(sOptions.substring(0, iValueEnd))).append(nMemberId).append("-").append(sName).append(".jfr").append(sOptions.substring(iValueEnd)).toString() : new StringBuilder(String.valueOf(sOptions.substring(0, iValueEnd))).append(File.separator).append(nMemberId).append("-").append(sName).append(".jfr").append(sOptions.substring(iValueEnd)).toString();
                }
                iFileName = sOptions.lastIndexOf(File.separator) + 1;
                if (iFileName > 0) {
                    iValueStart = iFileName;
                }
                return new StringBuilder(String.valueOf(sOptions.substring(0, iValueStart))).append(nMemberId).append('-').append(sOptions.substring(iValueStart)).toString();
            }
            iFilename = sOptions.indexOf(FILE_OPTION, iFilename + FILE_OPTION.length());
        }
        return sOptions;
    }

    public void ensureRunning() {
        this.checkReadOnly("ensureRunning");
        SafeCluster cluster = this.get_Cluster();
        if (!(cluster != null) ? false : cluster.isRunning() ^ true) {
            cluster.start();
        }
    }

    public String[] flightRecording(String sRole, String sCmd, String sOptions) {
        this.checkReadOnly("clusterJfr");
        SafeCluster cluster = this.get_Cluster();
        if (cluster == null) {
            return null;
        }
        MBeanServer server = MBeanHelper.findMBeanServer();
        Gateway gateway = (Gateway)cluster.getManagement();
        boolean fAllMembers = sRole == null ? true : sRole.isEmpty();
        String[] sResults = new String[cluster.getMemberSet().size()];
        String sDiagPrefix = new StringBuilder(String.valueOf(gateway.getDomainName())).append(":type=DiagnosticCommand,Domain=com.sun.management,subType=DiagnosticCommand").toString();
        int i = 0;
        ArrayList<ObjectName> listMBeanNames = new ArrayList<ObjectName>(cluster.getMemberSet().size());
        Iterator iter = cluster.getMemberSet().iterator();
        while (iter.hasNext()) {
            com.tangosol.net.Member member = (com.tangosol.net.Member)iter.next();
            if (!(fAllMembers ? true : Objects.equals(member.getRoleName(), sRole))) continue;
            try {
                ObjectName oName = new ObjectName(gateway.ensureGlobalName(sDiagPrefix, member));
                listMBeanNames.add(oName);
                if (!(System.getProperty("java.runtime.version").contains("-perf-") ^ true)) continue;
                server.invoke(oName, "vmUnlockCommercialFeatures", null, null);
            }
            catch (Exception e) {
                throw Base.ensureRuntimeException(e, new StringBuilder(String.valueOf("Unable to unlock commercial features for member ")).append(member.getId()).append(" due to: ").append(e.getMessage()).toString());
            }
        }
        iter = listMBeanNames.iterator();
        while (iter.hasNext()) {
            ObjectName oName = (ObjectName)iter.next();
            int nMemberId = Integer.parseInt(oName.getKeyProperty("nodeId"));
            String sMember = oName.getKeyProperty("member");
            if (sMember == null) {
                sMember = new StringBuilder(String.valueOf("Member ")).append(nMemberId).toString();
            }
            try {
                String sNodeOptions = sOptions;
                if (sOptions.indexOf("filename=") >= 0) {
                    sNodeOptions = this.ensureGlobalFileName(sOptions, nMemberId);
                }
                String[] aoArguments = sNodeOptions.split(",");
                String sMessage = (String)server.invoke(oName, sCmd, new Object[]{aoArguments}, new String[]{ClusterModel.__sm0().getName()});
                sResults[i++] = new StringBuilder(String.valueOf(sMember)).append("->").append(sMessage).toString();
            }
            catch (Exception ignore) {
                String sMessage = new StringBuilder(String.valueOf("Flight Recorder operation for node ")).append(nMemberId).append(", got exception: ").append(ignore.getMessage()).toString();
                sResults[i++] = new StringBuilder(String.valueOf(sMember)).append("->").append(sMessage).append("\n").toString();
                Component._trace(sMessage, 2);
            }
        }
        return sResults;
    }

    public String getClusterName() {
        SafeCluster cluster = this.get_Cluster();
        return cluster == null ? Model.canonicalString(null) : Model.canonicalString(cluster.getClusterName());
    }

    public int getClusterSize() {
        SafeCluster cluster = this.get_Cluster();
        return (!(cluster != null) ? false : cluster.isRunning()) ? cluster.getMemberSet().size() : 0;
    }

    public String getDescription() {
        SafeCluster cluster = this.get_Cluster();
        return (!(cluster != null) ? false : cluster.isRunning()) ? new StringBuilder(String.valueOf("MemberId=")).append(cluster.getLocalMember().getId()).toString() : "Not running";
    }

    public String getLicenseMode() {
        SafeCluster cluster = this.get_Cluster();
        if (!(cluster != null) ? false : cluster.isRunning()) {
            Member member = (Member)cluster.getLocalMember();
            return Member.MODE_NAME[member.getMode()];
        }
        return Model.canonicalString(null);
    }

    public int getLocalMemberId() {
        SafeCluster cluster = this.get_Cluster();
        if (!(cluster != null) ? false : cluster.isRunning()) {
            return cluster.getLocalMember().getId();
        }
        return -1;
    }

    public int[] getMemberIds() {
        SafeCluster cluster = this.get_Cluster();
        if (!(cluster != null) ? false : cluster.isRunning()) {
            Set setMember = cluster.getMemberSet();
            int[] anMember = new int[setMember.size()];
            Iterator iter = setMember.iterator();
            int i = 0;
            while (!iter.hasNext() ? false : i < anMember.length) {
                anMember[i] = ((com.tangosol.net.Member)iter.next()).getId();
                ++i;
            }
            return anMember;
        }
        return new int[0];
    }

    public String[] getMembers() {
        SafeCluster cluster = this.get_Cluster();
        if (!(cluster != null) ? false : cluster.isRunning()) {
            Set setMember = cluster.getMemberSet();
            String[] asMember = new String[setMember.size()];
            Iterator iter = setMember.iterator();
            int i = 0;
            while (!iter.hasNext() ? false : i < asMember.length) {
                asMember[i] = iter.next().toString();
                ++i;
            }
            return asMember;
        }
        return new String[0];
    }

    public String[] getMembersDeparted() {
        try {
            Cluster clusterReal = this.get_Cluster().getCluster();
            HashSet setMembers = new HashSet(clusterReal.getClusterService().getClusterMemberSet().getRecycleSet());
            String[] asMembers = new String[setMembers.size()];
            Iterator iter = setMembers.iterator();
            int i = 0;
            while (iter.hasNext()) {
                asMembers[i] = String.valueOf(iter.next());
                ++i;
            }
            return asMembers;
        }
        catch (Exception e) {
            return new String[0];
        }
    }

    public long getMembersDepartureCount() {
        try {
            Cluster clusterReal = this.get_Cluster().getCluster();
            return clusterReal.getClusterService().getStatsMembersDepartureCount();
        }
        catch (Exception e) {
            return 0L;
        }
    }

    public int getOldestMemberId() {
        SafeCluster cluster = this.get_Cluster();
        if (!(cluster != null) ? false : cluster.isRunning()) {
            return cluster.getOldestMember().getId();
        }
        return -1;
    }

    public String getVersion() {
        return CacheFactory.VERSION;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/net/management/model/localModel/ClusterModel".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public SafeCluster get_Cluster() {
        WeakReference wr = this.get_ClusterRef();
        return wr == null ? null : (SafeCluster)wr.get();
    }

    protected WeakReference get_ClusterRef() {
        return this.__m__ClusterRef;
    }

    public static Component get_Instance() {
        return new ClusterModel();
    }

    private final Component get_Module() {
        return this;
    }

    public boolean isRunning() {
        SafeCluster cluster = this.get_Cluster();
        return !(cluster != null) ? false : cluster.isRunning();
    }

    public void logClusterState(String sRole) {
        this.checkReadOnly("logClusterState");
        SafeCluster cluster = this.get_Cluster();
        if (cluster == null) {
            return;
        }
        MBeanServer server = MBeanHelper.findMBeanServer();
        Gateway gateway = (Gateway)cluster.getManagement();
        boolean fAllMembers = sRole == null ? true : sRole.isEmpty();
        String sNodePrefix = new StringBuilder(String.valueOf(gateway.getDomainName())).append(':').append(Registry.NODE_TYPE).toString();
        Iterator iter = cluster.getMemberSet().iterator();
        while (iter.hasNext()) {
            com.tangosol.net.Member member = (com.tangosol.net.Member)iter.next();
            if (!(fAllMembers ? true : member.getRoleName().equals(sRole))) continue;
            try {
                String sNode = gateway.ensureGlobalName(sNodePrefix, member);
                server.invoke(new ObjectName(sNode), "logNodeState", null, null);
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
    }

    public void readExternal(DataInput in) throws IOException {
        throw new IllegalStateException("ClusterModel is not global");
    }

    public void resumeService(String sService) {
        this.checkReadOnly("resumeService");
        SafeCluster cluster = this.get_Cluster();
        if (cluster != null) {
            cluster.resumeService(sService);
        }
    }

    public void set_Cluster(SafeCluster cluster) {
        this.set_ClusterRef(new WeakReference<SafeCluster>(cluster));
    }

    protected void set_ClusterRef(WeakReference refCluster) {
        this.__m__ClusterRef = refCluster;
    }

    public void shutdown() {
        this.checkReadOnly("shutdown");
        SafeCluster cluster = this.get_Cluster();
        if (cluster != null) {
            cluster.shutdown();
        }
    }

    public void suspendService(String sService) {
        this.checkReadOnly("suspendService");
        SafeCluster cluster = this.get_Cluster();
        if (cluster != null) {
            cluster.suspendService(sService);
        }
    }

    public void writeExternal(DataOutput out) throws IOException {
        throw new IllegalStateException("ClusterModel is not global");
    }
}

