/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net.management.model.localModel;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.management.model.LocalModel;
import com.tangosol.coherence.component.util.Queue;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Peer;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.peer.Acceptor;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.peer.acceptor.HttpAcceptor;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.peer.acceptor.MemcachedAcceptor;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.peer.acceptor.TcpAcceptor;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.peer.acceptor.TcpAcceptor$BufferPool;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.peer.acceptor.TcpAcceptor$TcpConnection;
import com.tangosol.io.MultiBufferWriteBuffer;
import com.tangosol.net.internal.SocketAddressHelper;
import com.tangosol.util.Base;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.WrapperException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.SocketAddress;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ConnectionManagerModel
extends LocalModel {
    private transient String __m_HostIP;
    private transient boolean __m_MessagingDebug;
    private Acceptor __m__Acceptor;
    private transient Date __m__CreateTime;

    public ConnectionManagerModel() {
        this(null, null, true);
    }

    public ConnectionManagerModel(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.set_SnapshotMap(new HashMap());
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    public float getAverageRequestTime() {
        Acceptor acceptor = this.get_Acceptor();
        if (acceptor instanceof HttpAcceptor) {
            return this.getHttpStatsFloat((HttpAcceptor)acceptor, "getAverageRequestTime");
        }
        return -1.0f;
    }

    public int getConnectionCount() {
        Acceptor acceptor = this.get_Acceptor();
        if (acceptor instanceof TcpAcceptor) {
            Set setConn = ((TcpAcceptor)acceptor).getConnectionSet();
            return setConn == null ? 0 : setConn.size();
        }
        return -1;
    }

    public String getHostIP() {
        String sAddr = this.__m_HostIP;
        if (sAddr == null) {
            Acceptor acceptor = this.get_Acceptor();
            if (acceptor instanceof TcpAcceptor) {
                SocketAddress address = ((TcpAcceptor)acceptor).getLocalAddress();
                if (address != null) {
                    sAddr = SocketAddressHelper.toString(address);
                    this.setHostIP(sAddr);
                }
            } else if (acceptor instanceof HttpAcceptor) {
                HttpAcceptor httpAcceptor = (HttpAcceptor)acceptor;
                return new StringBuilder(String.valueOf(httpAcceptor.getLocalAddress())).append(':').append(httpAcceptor.getLocalPort()).toString();
            }
        }
        return sAddr;
    }

    public String getHttpServerType() {
        Object oServer = null;
        Acceptor acceptor = this.get_Acceptor();
        if (acceptor instanceof HttpAcceptor) {
            oServer = ((HttpAcceptor)acceptor).getHttpServer();
        }
        return oServer == null ? "n/a" : oServer.getClass().getName();
    }

    protected Object getHttpStats(HttpAcceptor httpAcceptor, String sMethod) {
        return this.getHttpStats(httpAcceptor, sMethod, new Object[0]);
    }

    protected Object getHttpStats(HttpAcceptor httpAcceptor, String sMethod, Object[] oaArgs) {
        Object oServer = httpAcceptor.getHttpServer();
        Component._assert(oServer != null);
        try {
            return ClassHelper.invoke(oServer, sMethod, oaArgs);
        }
        catch (Exception e) {
            Component._trace(new StringBuilder(String.valueOf("Unable to call method ")).append(sMethod).append(" on ").append(oServer).toString(), 1);
            throw Base.ensureRuntimeException(e);
        }
    }

    protected float getHttpStatsFloat(HttpAcceptor httpAcceptor, String sMethod) {
        Float fValue = (Float)this.getHttpStats(httpAcceptor, sMethod);
        return fValue instanceof Float ? fValue.floatValue() : (float)0L;
    }

    protected long getHttpStatsLong(HttpAcceptor httpAcceptor, String sMethod) {
        Long lValue = (Long)this.getHttpStats(httpAcceptor, sMethod);
        return lValue instanceof Long ? lValue : 0L;
    }

    protected long getHttpStatusCount(HttpAcceptor httpAcceptor, int nPrefix) {
        Long lValue = (Long)this.getHttpStats(httpAcceptor, "getHttpStatusCount", new Object[]{nPrefix});
        return lValue instanceof Long ? lValue : 0L;
    }

    public long getIncomingBufferPoolCapacity() {
        Acceptor acceptor = this.get_Acceptor();
        if (acceptor instanceof TcpAcceptor) {
            TcpAcceptor$BufferPool pool = ((TcpAcceptor)acceptor).getBufferPoolIn();
            return pool == null ? 0L : (long)pool.getMaximumCapacity();
        }
        return -1L;
    }

    public long getIncomingBufferPoolSize() {
        Acceptor acceptor = this.get_Acceptor();
        if (acceptor instanceof TcpAcceptor) {
            TcpAcceptor$BufferPool pool = ((TcpAcceptor)acceptor).getBufferPoolIn();
            return pool == null ? 0L : (long)(pool.getSize() * pool.getBufferSize());
        }
        return -1L;
    }

    public long getOutgoingBufferPoolCapacity() {
        Acceptor acceptor = this.get_Acceptor();
        if (acceptor instanceof TcpAcceptor) {
            TcpAcceptor$BufferPool pool = ((TcpAcceptor)acceptor).getBufferPoolOut();
            return pool == null ? 0 : pool.getMaximumCapacity();
        }
        return -1L;
    }

    public long getOutgoingBufferPoolSize() {
        Acceptor acceptor = this.get_Acceptor();
        if (acceptor instanceof TcpAcceptor) {
            TcpAcceptor$BufferPool pool = ((TcpAcceptor)acceptor).getBufferPoolOut();
            return pool == null ? 0L : (long)(pool.getSize() * pool.getBufferSize());
        }
        return -1L;
    }

    public long getOutgoingByteBacklog() {
        Set setConn;
        long cBacklog = 0L;
        Acceptor acceptor = this.get_Acceptor();
        if (acceptor instanceof TcpAcceptor && (setConn = ((TcpAcceptor)acceptor).getConnectionSet()) != null) {
            Iterator iterConn = setConn.iterator();
            while (iterConn.hasNext()) {
                TcpAcceptor$TcpConnection conn = (TcpAcceptor$TcpConnection)iterConn.next();
                if (!(conn != null)) continue;
                Queue q = conn.getOutgoingQueue();
                Iterator iterBuff = q.iterator();
                while (iterBuff.hasNext()) {
                    MultiBufferWriteBuffer buff = (MultiBufferWriteBuffer)iterBuff.next();
                    cBacklog += (long)buff.length();
                }
            }
        }
        return cBacklog;
    }

    public long getOutgoingMessageBacklog() {
        Set setConn;
        Acceptor acceptor = this.get_Acceptor();
        if (acceptor instanceof TcpAcceptor && (setConn = ((TcpAcceptor)acceptor).getConnectionSet()) != null) {
            long cBacklog = 0L;
            Iterator iter = setConn.iterator();
            while (iter.hasNext()) {
                TcpAcceptor$TcpConnection conn = (TcpAcceptor$TcpConnection)iter.next();
                if (!(conn != null)) continue;
                cBacklog += (long)conn.getOutgoingQueue().size();
            }
            return cBacklog;
        }
        return 0L;
    }

    public String getProtocol() {
        Acceptor acceptor = this.get_Acceptor();
        return acceptor instanceof TcpAcceptor ? "tcp" : (acceptor instanceof HttpAcceptor ? "http" : (acceptor instanceof MemcachedAcceptor ? "memcached" : "n/a"));
    }

    public float getRequestsPerSecond() {
        Acceptor acceptor = this.get_Acceptor();
        if (acceptor instanceof HttpAcceptor) {
            return this.getHttpStatsFloat((HttpAcceptor)acceptor, "getRequestsPerSecond");
        }
        return -1.0f;
    }

    public long getResponseCount1xx() {
        Acceptor acceptor = this.get_Acceptor();
        if (acceptor instanceof HttpAcceptor) {
            return this.getHttpStatusCount((HttpAcceptor)acceptor, 1);
        }
        return -1L;
    }

    public long getResponseCount2xx() {
        Acceptor acceptor = this.get_Acceptor();
        if (acceptor instanceof HttpAcceptor) {
            return this.getHttpStatusCount((HttpAcceptor)acceptor, 2);
        }
        return -1L;
    }

    public long getResponseCount3xx() {
        Acceptor acceptor = this.get_Acceptor();
        if (acceptor instanceof HttpAcceptor) {
            return this.getHttpStatusCount((HttpAcceptor)acceptor, 3);
        }
        return -1L;
    }

    public long getResponseCount4xx() {
        Acceptor acceptor = this.get_Acceptor();
        if (acceptor instanceof HttpAcceptor) {
            return this.getHttpStatusCount((HttpAcceptor)acceptor, 4);
        }
        return -1L;
    }

    public long getResponseCount5xx() {
        Acceptor acceptor = this.get_Acceptor();
        if (acceptor instanceof HttpAcceptor) {
            return this.getHttpStatusCount((HttpAcceptor)acceptor, 5);
        }
        return -1L;
    }

    public long getTotalBytesReceived() {
        Acceptor acceptor = this.get_Acceptor();
        if (acceptor instanceof TcpAcceptor) {
            return ((TcpAcceptor)acceptor).getStatsBytesReceived();
        }
        return -1;
    }

    public long getTotalBytesSent() {
        Acceptor acceptor = this.get_Acceptor();
        if (acceptor instanceof TcpAcceptor) {
            return ((TcpAcceptor)acceptor).getStatsBytesSent();
        }
        return -1;
    }

    public long getTotalErrorCount() {
        Acceptor acceptor = this.get_Acceptor();
        if (acceptor instanceof HttpAcceptor) {
            return this.getHttpStatsLong((HttpAcceptor)acceptor, "getErrorCount");
        }
        return -1L;
    }

    public long getTotalMessagesReceived() {
        Acceptor acceptor = this.get_Acceptor();
        if (acceptor instanceof TcpAcceptor) {
            return ((TcpAcceptor)acceptor).getStatsReceived();
        }
        return -1;
    }

    public long getTotalMessagesSent() {
        Acceptor acceptor = this.get_Acceptor();
        if (acceptor instanceof TcpAcceptor) {
            return ((TcpAcceptor)acceptor).getStatsSent();
        }
        return -1L;
    }

    public long getTotalRequestCount() {
        Acceptor acceptor = this.get_Acceptor();
        if (acceptor instanceof HttpAcceptor) {
            return this.getHttpStatsLong((HttpAcceptor)acceptor, "getRequestCount");
        }
        return -1L;
    }

    public long getUnauthorizedConnectionAttempts() {
        Acceptor acceptor = this.get_Acceptor();
        if (acceptor instanceof TcpAcceptor) {
            return ((TcpAcceptor)acceptor).getStatsUnauthorizedConnectionAttempts();
        }
        return -1;
    }

    public Acceptor get_Acceptor() {
        return this.__m__Acceptor;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/net/management/model/localModel/ConnectionManagerModel".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public Date get_CreateTime() {
        return this.__m__CreateTime;
    }

    public static Component get_Instance() {
        return new ConnectionManagerModel();
    }

    private final Component get_Module() {
        return this;
    }

    public boolean isMessagingDebug() {
        this.get_Acceptor();
        return Peer.isDEBUG();
    }

    public void readExternal(DataInput in) throws IOException {
        super.readExternal(in);
        Map mapSnapshot = this.get_SnapshotMap();
        mapSnapshot.put("ConnectionCount", ExternalizableHelper.readInt(in));
        mapSnapshot.put("HostIP", ExternalizableHelper.readUTF(in));
        mapSnapshot.put("IncomingBufferPoolCapacity", ExternalizableHelper.readLong(in));
        mapSnapshot.put("IncomingBufferPoolSize", ExternalizableHelper.readLong(in));
        mapSnapshot.put("OutgoingBufferPoolCapacity", ExternalizableHelper.readLong(in));
        mapSnapshot.put("OutgoingBufferPoolSize", ExternalizableHelper.readLong(in));
        mapSnapshot.put("OutgoingByteBacklog", ExternalizableHelper.readLong(in));
        mapSnapshot.put("OutgoingMessageBacklog", ExternalizableHelper.readLong(in));
        mapSnapshot.put("TotalBytesReceived", ExternalizableHelper.readLong(in));
        mapSnapshot.put("TotalBytesSent", ExternalizableHelper.readLong(in));
        mapSnapshot.put("TotalMessagesReceived", ExternalizableHelper.readLong(in));
        mapSnapshot.put("TotalMessagesSent", ExternalizableHelper.readLong(in));
        mapSnapshot.put("UnauthorizedConnectionAttempts", ExternalizableHelper.readLong(in));
        if (ExternalizableHelper.isVersionCompatible(in, 12, 2, 1, 1, 0)) {
            mapSnapshot.put("AverageRequestTime", Float.valueOf(in.readFloat()));
            mapSnapshot.put("HttpServerType", ExternalizableHelper.readUTF(in));
            mapSnapshot.put("Protocol", ExternalizableHelper.readUTF(in));
            mapSnapshot.put("ResponseCount1xx", ExternalizableHelper.readLong(in));
            mapSnapshot.put("ResponseCount2xx", ExternalizableHelper.readLong(in));
            mapSnapshot.put("ResponseCount3xx", ExternalizableHelper.readLong(in));
            mapSnapshot.put("ResponseCount4xx", ExternalizableHelper.readLong(in));
            mapSnapshot.put("ResponseCount5xx", ExternalizableHelper.readLong(in));
            mapSnapshot.put("RequestsPerSecond", Float.valueOf(in.readFloat()));
            mapSnapshot.put("TotalErrorCount", ExternalizableHelper.readLong(in));
            mapSnapshot.put("TotalRequestCount", ExternalizableHelper.readLong(in));
        } else {
            mapSnapshot.put("AverageRequestTime", Float.valueOf(-1.0f));
            mapSnapshot.put("HttpServerType", "n/a");
            mapSnapshot.put("Protocol", "n/a");
            mapSnapshot.put("ResponseCount1xx", -1L);
            mapSnapshot.put("ResponseCount2xx", -1L);
            mapSnapshot.put("ResponseCount3xx", -1L);
            mapSnapshot.put("ResponseCount4xx", -1L);
            mapSnapshot.put("ResponseCount5xx", -1L);
            mapSnapshot.put("RequestsPerSecond", Float.valueOf(-1.0f));
            mapSnapshot.put("TotalErrorCount", -1L);
            mapSnapshot.put("TotalRequestCount", -1L);
        }
    }

    public void resetStatistics() {
        this.get_Acceptor().resetStats();
    }

    protected void setHostIP(String sAddress) {
        this.__m_HostIP = sAddress;
    }

    public void setMessagingDebug(boolean fMessagingDebug) {
        this.get_Acceptor();
        Peer.setDEBUG(fMessagingDebug);
    }

    public void set_Acceptor(Acceptor acceptor) {
        this.__m__Acceptor = acceptor;
    }

    public void set_CreateTime(Date p_CreateTime) {
        this.__m__CreateTime = p_CreateTime;
    }

    public void writeExternal(DataOutput out) throws IOException {
        super.writeExternal(out);
        Map mapSnapshot = this.get_SnapshotMap();
        ExternalizableHelper.writeInt(out, this.getConnectionCount());
        ExternalizableHelper.writeUTF(out, this.getHostIP());
        ExternalizableHelper.writeLong(out, this.getIncomingBufferPoolCapacity());
        ExternalizableHelper.writeLong(out, this.getIncomingBufferPoolSize());
        ExternalizableHelper.writeLong(out, this.getOutgoingBufferPoolCapacity());
        ExternalizableHelper.writeLong(out, this.getOutgoingBufferPoolSize());
        ExternalizableHelper.writeLong(out, this.getOutgoingByteBacklog());
        ExternalizableHelper.writeLong(out, this.getOutgoingMessageBacklog());
        ExternalizableHelper.writeLong(out, this.getTotalBytesReceived());
        ExternalizableHelper.writeLong(out, this.getTotalBytesSent());
        ExternalizableHelper.writeLong(out, this.getTotalMessagesReceived());
        ExternalizableHelper.writeLong(out, this.getTotalMessagesSent());
        ExternalizableHelper.writeLong(out, this.getUnauthorizedConnectionAttempts());
        if (ExternalizableHelper.isVersionCompatible(out, 12, 2, 1, 1, 0)) {
            out.writeFloat(this.getAverageRequestTime());
            ExternalizableHelper.writeUTF(out, this.getHttpServerType());
            ExternalizableHelper.writeUTF(out, this.getProtocol());
            ExternalizableHelper.writeLong(out, this.getResponseCount1xx());
            ExternalizableHelper.writeLong(out, this.getResponseCount2xx());
            ExternalizableHelper.writeLong(out, this.getResponseCount3xx());
            ExternalizableHelper.writeLong(out, this.getResponseCount4xx());
            ExternalizableHelper.writeLong(out, this.getResponseCount5xx());
            out.writeFloat(this.getRequestsPerSecond());
            ExternalizableHelper.writeLong(out, this.getTotalErrorCount());
            ExternalizableHelper.writeLong(out, this.getTotalRequestCount());
        }
    }
}

