/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net.message.requestMessage.chainedRequest.backupRequest;

import com.oracle.coherence.common.base.Continuation;
import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.Message;
import com.tangosol.coherence.component.net.message.requestMessage.chainedRequest.BackupRequest;
import com.tangosol.coherence.component.net.message.requestMessage.chainedRequest.backupRequest.BackupSingleRequest$Poll;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.PartitionedService;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.PartitionedService$PartitionControl;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.WriteBuffer;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.ListMap;
import java.io.IOException;
import java.util.Map;

public abstract class BackupSingleRequest
extends BackupRequest
implements Continuation {
    private int __m_Partition;
    private long __m_PartitionVersion;
    private static ListMap __mapChildren;

    static {
        BackupSingleRequest.__initStatic();
    }

    public BackupSingleRequest(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    private static void __initStatic() {
        __mapChildren = new ListMap();
        Class clazz = __mapChildren.put("Poll", BackupSingleRequest$Poll.get_CLASS());
    }

    public Message cloneMessage() {
        BackupSingleRequest msg = (BackupSingleRequest)super.cloneMessage();
        msg.setPartition(this.getPartition());
        msg.setPartitionVersion(this.getPartitionVersion());
        msg.setSyncMsg(this.isSyncMsg());
        return msg;
    }

    public void doBackup() {
    }

    public String getDescription() {
        return new StringBuilder(String.valueOf(super.getDescription())).append("\nPartition=").append(this.getPartition()).append("\nPartitionVersion=").append(this.getPartitionVersion()).toString();
    }

    public int getPartition() {
        return this.__m_Partition;
    }

    public long getPartitionVersion() {
        return this.__m_PartitionVersion;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/net/message/requestMessage/chainedRequest/backupRequest/BackupSingleRequest".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    private final Component get_Module() {
        return this;
    }

    public void onReceived() {
        int nPartition;
        PartitionedService service = (PartitionedService)this.getService();
        PartitionedService$PartitionControl control = service.getPartitionControl(nPartition = this.getPartition());
        if (!(control != null) ? false : (service.isBackupOwner(nPartition) ? true : control.isTransferringOut())) {
            service.processBackup(this);
        } else {
            int nMemberOriginator = this.getOriginatingMemberId();
            Member memberOriginator = service.getServiceMemberSet().getMember(nMemberOriginator);
            if (this.isConfirmed() ? true : memberOriginator == null) {
                Component._trace(new StringBuilder(String.valueOf("Discarding ")).append(this.get_Name()).append(" for unowned partition ").append(nPartition).append(" originating from member ").append(nMemberOriginator).toString(), 5);
                this.forwardOrReply(this);
            } else {
                service.sendPingRequest(memberOriginator, this);
            }
        }
    }

    public void proceed(Object oResult) {
        this.setConfirmed(true);
        this.onReceived();
    }

    public void read(ReadBuffer.BufferInput input) throws IOException {
        super.read(input);
        this.setPartition(ExternalizableHelper.readInt(input));
        this.setPartitionVersion(ExternalizableHelper.readLong(input));
    }

    public void setPartition(int iPart) {
        this.__m_Partition = iPart;
    }

    public void setPartitionVersion(long lVersion) {
        this.__m_PartitionVersion = lVersion;
    }

    public void write(WriteBuffer.BufferOutput output) throws IOException {
        super.write(output);
        ExternalizableHelper.writeInt(output, this.getPartition());
        ExternalizableHelper.writeLong(output, this.getPartitionVersion());
    }
}

