/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util;

import com.oracle.coherence.common.base.Blocking;
import com.oracle.coherence.common.base.Notifier;
import com.oracle.coherence.common.base.SingleWaiterMultiNotifier;
import com.oracle.coherence.common.util.AssociationPile;
import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.util.Daemon;
import com.tangosol.coherence.component.util.DaemonPool;
import com.tangosol.coherence.component.util.DaemonPool$Daemon$Guard;
import com.tangosol.coherence.component.util.DaemonPool$StopTask;
import com.tangosol.coherence.component.util.DaemonPool$WorkSlot;
import com.tangosol.coherence.component.util.DaemonPool$WrapperTask;
import com.tangosol.coherence.component.util.queue.ConcurrentQueue;
import com.tangosol.net.GuardSupport;
import com.tangosol.net.PriorityTask;
import com.tangosol.run.component.EventDeathException;
import com.tangosol.util.Base;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.Gate;
import com.tangosol.util.WrapperException;

public class DaemonPool$Daemon
extends Daemon {
    private int __m_DaemonType;
    private volatile boolean __m_FlushStats;
    private volatile transient int __m_InterruptCount;
    private AssociationPile __m_Queue;
    private volatile transient DaemonPool$WrapperTask __m_WrapperTask;

    public DaemonPool$Daemon() {
        this(null, null, true);
    }

    public DaemonPool$Daemon(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setDaemonState(0);
            this.setDefaultGuardRecovery(0.9f);
            this.setDefaultGuardTimeout(60000L);
            this.setNotifier(new SingleWaiterMultiNotifier());
            this.setThreadName("Worker");
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this._addChild(new DaemonPool$Daemon$Guard("Guard", this, true), "Guard");
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void abandon() {
        Runnable task;
        boolean fAbandon = false;
        Thread thread = null;
        DaemonPool$Daemon daemonPool$Daemon = this;
        synchronized (daemonPool$Daemon) {
            thread = this.getThread();
            if (thread == null) return;
            boolean bl = false;
            if (bl) {
                return;
            }
            if (!this.isStarted() ? false : this.isExiting() ^ true) {
                fAbandon = true;
                this.setExiting(true);
            }
        }
        if (!fAbandon) return;
        DaemonPool pool = (DaemonPool)this.get_Module();
        DaemonPool$WrapperTask wrapper = this.getWrapperTask();
        String sThread = this.getThreadName();
        Object object = pool.STATS_MONITOR;
        synchronized (object) {
            pool.setStatsAbandonedCount(pool.getStatsAbandonedCount() + 1);
        }
        String sReason = wrapper == null ? ", while waiting" : new StringBuilder(String.valueOf(" executing task \"")).append(wrapper.getTaskId()).append("\"").toString();
        if (wrapper != null && (task = wrapper.getTask()) instanceof PriorityTask) {
            pool.runCanceled((PriorityTask)((Object)task), true);
        }
        StringBuffer sbMsg = new StringBuffer();
        sbMsg.append("A worker thread \"").append(sThread).append(sReason).append(", did not respond to ").append(Math.abs(pool.getAbandonThreshold())).append(" interrupt requests. The execution was canceled.").append(" The thread ");
        int cAttempts = pool.getAbandonThreshold();
        if (cAttempts < 0) {
            int i = cAttempts;
            while (!(i < 0) ? false : thread.isAlive()) {
                try {
                    ClassHelper.invoke(thread, "stop", ClassHelper.VOID);
                    Blocking.sleep(1);
                }
                catch (InterruptedException e) {
                    Thread.currentThread();
                    Thread.interrupted();
                    break;
                }
                catch (Exception e) {
                    break;
                }
                ++i;
            }
            if (thread.isAlive()) {
                sbMsg.append("could not be stopped and ");
            }
        }
        if (thread.isAlive()) {
            sThread = new StringBuilder(String.valueOf(sThread)).append("!abandoned").toString();
            try {
                thread.setName(sThread);
                thread.setPriority(Thread.MIN_PRIORITY);
            }
            catch (RuntimeException e) {
                // empty catch block
            }
            sbMsg.append("is abandoned...");
            try {
                StackTraceElement[] atrace = thread.getStackTrace();
                int i = 0;
                int c = atrace.length;
                while (true) {
                    if (!(i < c)) {
                        sbMsg.append('\n');
                    }
                    sbMsg.append("\n  at ").append(atrace[i]);
                    ++i;
                }
            }
            catch (Throwable e) {}
        } else {
            sbMsg.append("is stopped.");
        }
        Component._trace(sbMsg.toString(), 1);
    }

    public int getDaemonType() {
        return this.__m_DaemonType;
    }

    public int getInterruptCount() {
        return this.__m_InterruptCount;
    }

    public AssociationPile getQueue() {
        return this.__m_Queue;
    }

    public long getWaitMillis() {
        long cWait = super.getWaitMillis();
        if (this.isGuarded() ? true : this.isGuardian()) {
            long cMaxWait = 1000L;
            cWait = cWait == (long)0 ? cMaxWait : Math.min(cWait, cMaxWait);
        }
        return cWait;
    }

    public DaemonPool$WrapperTask getWrapperTask() {
        return this.__m_WrapperTask;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/DaemonPool$Daemon".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public static Component get_Instance() {
        return new DaemonPool$Daemon();
    }

    private final Component get_Module() {
        return this.get_Parent();
    }

    public void halt() {
        super.halt();
    }

    public void heartbeat(long cMillis) {
        super.heartbeat(cMillis);
    }

    public boolean isFlushStats() {
        return this.__m_FlushStats;
    }

    protected void onEnter() {
        super.onEnter();
        if (this.isGuarded()) {
            GuardSupport.setThreadContext(this.getGuardable().getContext());
        }
    }

    protected void onException(Throwable e) {
        if (this.isExiting()) {
            super.onException(e);
        } else {
            Component._trace(new StringBuilder(String.valueOf("An unhandled exception occurred on worker thread \"")).append(this.get_Name()).append("\":").toString(), 1);
            Component._trace(e);
        }
    }

    protected void onExit() {
        if (this.isExiting() ^ true) {
            DaemonPool$Daemon[] aDaemon = ((DaemonPool)this.get_Module()).getDaemons();
            int i = 0;
            int c = aDaemon == null ? 0 : aDaemon.length;
            while (i < c) {
                if (this == aDaemon[i]) {
                    Component._trace(new StringBuilder(String.valueOf("Worker thread \"")).append(this.getThreadName()).append("\" is exiting but still remains in its pool").toString(), 1);
                    break;
                }
                ++i;
            }
        }
        super.onExit();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void onNotify() {
        DaemonPool$WrapperTask wrapper;
        int cTasks;
        long ldtStart;
        DaemonPool pool;
        block23: {
            block22: {
                boolean bl;
                block21: {
                    pool = (DaemonPool)this.get_Parent();
                    boolean fOnce = this.getQueue() == null;
                    ldtStart = 0L;
                    cTasks = 0;
                    wrapper = this.getWrapperTask();
                    try {
                        while (this.isExiting() ^ true) {
                            Object var12_11;
                            if (fOnce ^ true) {
                                wrapper = this.removeFromQueue();
                                if (wrapper == null && (wrapper = this.removeFromAnotherQueue()) == null) {
                                    Object var8_12 = null;
                                    bl = cTasks > 0;
                                    break block21;
                                }
                                this.setWrapperTask(wrapper);
                                if (this.isFlushStats() ? true : ((long)cTasks & 0xFFL) == 0L) {
                                    ldtStart = pool.updateStats(this, cTasks, ldtStart);
                                    cTasks = 0;
                                }
                            } else if (wrapper == null) {
                                this.setExiting(true);
                                break block22;
                            }
                            long ldtStop = wrapper.getStopTime();
                            long cTimeoutMillis = wrapper.getTimeoutMillis();
                            if (ldtStop > 0L) {
                                cTimeoutMillis = Math.min(cTimeoutMillis, Math.max(1L, ldtStop - ldtStart));
                            }
                            if (cTimeoutMillis == (long)0) {
                                this.heartbeat();
                            } else {
                                this.heartbeat(cTimeoutMillis);
                            }
                            if (wrapper.isManagementTask() ^ true) {
                                ++cTasks;
                            }
                            try {
                                try {
                                    wrapper.run();
                                    if (fOnce) {
                                        this.setExiting(true);
                                    }
                                }
                                catch (EventDeathException e) {
                                    Runnable task = wrapper.getTask();
                                    if (!(task instanceof DaemonPool$StopTask)) throw e;
                                    pool.onDaemonStop(this, (DaemonPool$StopTask)task);
                                    this.setExiting(true);
                                }
                                var12_11 = null;
                                this.setWrapperTask(null);
                                this.release(wrapper);
                                wrapper = null;
                            }
                            catch (Throwable throwable) {
                                var12_11 = null;
                                this.setWrapperTask(null);
                                this.release(wrapper);
                                wrapper = null;
                                throw throwable;
                            }
                        }
                        break block23;
                    }
                    catch (Throwable throwable) {
                        Object var8_15 = null;
                        if (cTasks > 0) {
                            pool.updateStats(this, cTasks, ldtStart);
                        }
                        this.release(wrapper);
                        this.heartbeat();
                        throw throwable;
                    }
                }
                if (bl) {
                    pool.updateStats(this, cTasks, ldtStart);
                }
                this.release(wrapper);
                this.heartbeat();
                return;
            }
            Object var8_13 = null;
            if (cTasks > 0) {
                pool.updateStats(this, cTasks, ldtStart);
            }
            this.release(wrapper);
            this.heartbeat();
            return;
        }
        Object var8_14 = null;
        if (cTasks > 0) {
            pool.updateStats(this, cTasks, ldtStart);
        }
        this.release(wrapper);
        this.heartbeat();
    }

    protected void onWait() throws InterruptedException {
        if (this.getWrapperTask() == null) {
            super.onWait();
        }
    }

    protected void release(DaemonPool$WrapperTask wrapper) {
        if (wrapper != null) {
            Gate gate;
            AssociationPile queue = (AssociationPile)wrapper.get_Feed();
            if (queue != null) {
                wrapper.set_Feed(null);
                queue.release(wrapper);
            }
            if ((gate = wrapper.getGate()) != null) {
                gate.exit();
                wrapper.setGate(null);
            }
        }
    }

    protected DaemonPool$WrapperTask removeFromAnotherQueue() {
        DaemonPool pool = (DaemonPool)this.get_Parent();
        if (pool.getQueues().length <= 1) {
            return null;
        }
        AssociationPile queueThis = this.getQueue();
        int i = 0;
        int c = pool.getWorkSlotCount();
        int nHash = this.hashCode();
        while (i < c) {
            DaemonPool$WorkSlot slotThat = pool.getWorkSlot(Base.mod(nHash + i, c));
            Gate gateThat = slotThat.getGate();
            if (gateThat.enter(0L)) {
                DaemonPool$WrapperTask wrapper;
                AssociationPile queueThat = slotThat.getQueue();
                if ((!(queueThat != queueThis) ? false : slotThat.isActive()) && (wrapper = (DaemonPool$WrapperTask)queueThat.poll()) != null) {
                    if (wrapper.isManagementTask()) {
                        queueThat.release(wrapper);
                        queueThat.add(wrapper);
                    } else {
                        wrapper.set_Feed(queueThat);
                        wrapper.setGate(gateThat);
                        return wrapper;
                    }
                }
                gateThat.exit();
            }
            ++i;
        }
        return null;
    }

    protected DaemonPool$WrapperTask removeFromQueue() {
        AssociationPile queue = this.getQueue();
        DaemonPool$WrapperTask wrapper = (DaemonPool$WrapperTask)queue.poll();
        if (wrapper != null) {
            wrapper.set_Feed(queue);
        }
        return wrapper;
    }

    public void setDaemonType(int nType) {
        this.__m_DaemonType = nType;
    }

    public void setFlushStats(boolean fFlush) {
        this.__m_FlushStats = fFlush;
    }

    public void setGuardSupport(GuardSupport guardSupport) {
        super.setGuardSupport(guardSupport);
    }

    public void setInterruptCount(int cInterrupts) {
        this.__m_InterruptCount = cInterrupts;
    }

    public void setQueue(AssociationPile queue) {
        Component._assert(this.getQueue() == null, "Queue is not resettable");
        this.__m_Queue = queue;
        if (queue instanceof Notifier) {
            if (queue instanceof ConcurrentQueue) {
                this.setNotifier(((ConcurrentQueue)((Object)queue)).getNotifier());
            } else {
                this.setNotifier((Notifier)((Object)queue));
            }
        }
    }

    public void setWrapperTask(DaemonPool$WrapperTask task) {
        Thread thread = this.getThread();
        Component._assert(thread == null ? true : thread == Thread.currentThread());
        this.__m_WrapperTask = task;
        if (this.getInterruptCount() > 0) {
            Thread.interrupted();
            this.setInterruptCount(0);
            this.heartbeat();
        }
    }

    public void start() {
        ((DaemonPool)this.get_Module()).guard(this.getGuardable());
        super.start();
    }

    public String toString() {
        return new StringBuilder(String.valueOf(this.getThreadName())).append("@").append(System.identityHashCode(this)).append(" QueueId=").append(System.identityHashCode(this.getQueue())).toString();
    }
}

