/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util;

import com.oracle.coherence.common.base.Disposable;
import com.oracle.coherence.common.util.AssociationPile;
import com.oracle.coherence.common.util.ConcurrentAssociationPile;
import com.oracle.coherence.common.util.Timers;
import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.Util;
import com.tangosol.coherence.component.util.DaemonPool$Daemon;
import com.tangosol.coherence.component.util.DaemonPool$ResizeTask;
import com.tangosol.coherence.component.util.DaemonPool$ScheduleTask;
import com.tangosol.coherence.component.util.DaemonPool$StartTask;
import com.tangosol.coherence.component.util.DaemonPool$StopTask;
import com.tangosol.coherence.component.util.DaemonPool$WorkSlot;
import com.tangosol.coherence.component.util.DaemonPool$WrapperTask;
import com.tangosol.coherence.config.Config;
import com.tangosol.internal.util.DaemonPoolDependencies;
import com.tangosol.internal.util.DefaultDaemonPoolDependencies;
import com.tangosol.net.Guardable;
import com.tangosol.net.Guardian;
import com.tangosol.net.PriorityTask;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.util.Base;
import com.tangosol.util.Gate;
import com.tangosol.util.ListMap;
import com.tangosol.util.WrapperException;
import java.lang.reflect.Array;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class DaemonPool
extends Util
implements com.tangosol.internal.util.DaemonPool,
Guardian {
    public static final int DAEMON_ABANDONED = 2;
    public static final int DAEMON_NONPOOLED = 1;
    public static final int DAEMON_STANDARD = 0;
    public final Object STATS_MONITOR = new Object();
    private int __m_AbandonThreshold;
    private boolean __m_AutoStart;
    private int __m_DaemonCount;
    private int __m_DaemonCountMax;
    private int __m_DaemonCountMin;
    private AtomicInteger __m_DaemonIndex;
    private transient DaemonPool$Daemon[] __m_Daemons;
    private DaemonPoolDependencies __m_Dependencies;
    private long __m_HungThreshold;
    private volatile transient boolean __m_InTransition;
    private transient Guardian __m_InternalGuardian;
    private String __m_Name;
    private transient AssociationPile[] __m_Queues;
    private volatile DaemonPool$ResizeTask __m_ResizeTask;
    private Set __m_ScheduledTasks;
    private volatile transient boolean __m_Started;
    private transient int __m_StatsAbandonedCount;
    private transient long __m_StatsActiveMillis;
    private transient int __m_StatsHungCount;
    private transient long __m_StatsHungDuration;
    private transient String __m_StatsHungTaskId;
    private int __m_StatsLastBacklog;
    private transient long __m_StatsLastResetMillis;
    private transient long __m_StatsLastResizeMillis;
    private long __m_StatsLastTaskAddCount;
    private long __m_StatsLastTaskCount;
    private transient int __m_StatsMaxBacklog;
    private transient AtomicLong __m_StatsTaskAddCount;
    private transient long __m_StatsTaskCount;
    private transient int __m_StatsTimeoutCount;
    private long __m_TaskTimeout;
    private transient ThreadGroup __m_ThreadGroup;
    private int __m_ThreadPriority;
    private transient DaemonPool$WorkSlot[] __m_WorkSlot;
    private int __m_WorkSlotCount;
    private static ListMap __mapChildren;

    static {
        DaemonPool.__initStatic();
    }

    public DaemonPool() {
        this(null, null, true);
    }

    public DaemonPool(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setAbandonThreshold(8);
            this.setDaemonCountMax(Integer.MAX_VALUE);
            this.setDaemonCountMin(1);
            this.setScheduledTasks(new HashSet());
            this.setStatsTaskAddCount(new AtomicLong());
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
        try {
            this.__m_DaemonIndex = new AtomicInteger();
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
    }

    private static void __initStatic() {
        __mapChildren = new ListMap();
        Class clazz = __mapChildren.put("Daemon", DaemonPool$Daemon.get_CLASS());
        Class clazz2 = __mapChildren.put("ResizeTask", DaemonPool$ResizeTask.get_CLASS());
        Class clazz3 = __mapChildren.put("ScheduleTask", DaemonPool$ScheduleTask.get_CLASS());
        Class clazz4 = __mapChildren.put("StartTask", DaemonPool$StartTask.get_CLASS());
        Class clazz5 = __mapChildren.put("StopTask", DaemonPool$StopTask.get_CLASS());
        Class clazz6 = __mapChildren.put("WorkSlot", DaemonPool$WorkSlot.get_CLASS());
        Class clazz7 = __mapChildren.put("WrapperTask", DaemonPool$WrapperTask.get_CLASS());
    }

    public void add(Runnable task) {
        this.add(task, false);
    }

    public void add(Runnable task, boolean fAggressiveTimeout) {
        if (this.isStarted()) {
            DaemonPool$WrapperTask taskWrapper = this.instantiateWrapperTask(task, fAggressiveTimeout);
            int iPriority = taskWrapper.getPriority();
            if (iPriority == PriorityTask.SCHEDULE_IMMEDIATE ? true : iPriority == PriorityTask.SCHEDULE_FIRST) {
                DaemonPool$Daemon daemon = this.instantiateDaemon(DAEMON_NONPOOLED, null);
                daemon.setWrapperTask(taskWrapper);
                daemon.start();
                return;
            }
            Object oAssoc = taskWrapper.getAssociatedKey();
            long cAdded = taskWrapper.isManagementTask() ? this.getStatsTaskAddCount().get() : this.getStatsTaskAddCount().getAndIncrement();
            DaemonPool$WorkSlot slot = oAssoc == null ? this.findMinBacklogSlot((int)cAdded) : this.getWorkSlot(Base.mod(oAssoc.hashCode(), this.getWorkSlotCount()));
            slot.add(taskWrapper);
        } else {
            task.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkHungTasks() {
        int cBacklog = this.getBacklog();
        Object object = this.STATS_MONITOR;
        synchronized (object) {
            if (cBacklog > this.getStatsMaxBacklog()) {
                this.setStatsMaxBacklog(cBacklog);
            }
        }
        long cHungThreshold = this.getHungThreshold();
        if (cHungThreshold == (long)0) {
            return;
        }
        long ldtNow = Base.getSafeTimeMillis();
        DaemonPool$WrapperTask taskLongest = null;
        long cLongest = -1L;
        int cHung = 0;
        DaemonPool$Daemon[] aDaemon = this.getDaemons();
        int i = 0;
        int c = aDaemon == null ? 0 : aDaemon.length;
        while (i < c) {
            long ldtStart;
            long cDuration;
            DaemonPool$Daemon daemon = aDaemon[i];
            DaemonPool$WrapperTask wrapper = daemon.getWrapperTask();
            if (wrapper != null && (cDuration = ldtNow - (ldtStart = wrapper.getStartTime())) > cHungThreshold) {
                if (cDuration > cLongest) {
                    cLongest = cDuration;
                    taskLongest = wrapper;
                }
                ++cHung;
            }
            ++i;
        }
        Object object2 = this.STATS_MONITOR;
        synchronized (object2) {
            if (cHung == 0) {
                this.setStatsHungCount(0);
                this.setStatsHungDuration(0L);
                this.setStatsHungTaskId("");
            } else {
                this.setStatsHungCount(cHung);
                this.setStatsHungDuration(cLongest);
                this.setStatsHungTaskId(taskLongest.getTaskId());
            }
        }
    }

    protected DefaultDaemonPoolDependencies cloneDependencies(DaemonPoolDependencies deps) {
        return new DefaultDaemonPoolDependencies(deps);
    }

    public void configure(XmlElement xml) {
        throw new UnsupportedOperationException();
    }

    public static Object[] copyOnAdd(Object[] ao, Object oAdd) {
        int c = ao.length;
        Object[] aoNew = (Object[])Array.newInstance(ao.getClass().getComponentType(), c + 1);
        System.arraycopy(ao, 0, aoNew, 0, c);
        aoNew[c] = oAdd;
        return aoNew;
    }

    public static Object[] copyOnRemove(Object[] ao, Object oRemove) {
        int i = 0;
        int c = ao.length;
        while (i < c) {
            if (ao[i] == oRemove) {
                Object[] aoNew = (Object[])Array.newInstance(ao.getClass().getComponentType(), c - 1);
                if (i > 0) {
                    System.arraycopy(ao, 0, aoNew, 0, i);
                }
                if (i < c - 1) {
                    System.arraycopy(ao, i + 1, aoNew, i, c - 1 - i);
                }
                return aoNew;
            }
            ++i;
        }
        return ao;
    }

    protected DaemonPool$WorkSlot findMaxDaemonSharingSlot() {
        int[] acShare = new int[this.getQueues().length];
        DaemonPool$Daemon[] aDaemon = this.getDaemons();
        int i = 0;
        int c = aDaemon.length;
        while (i < c) {
            int iQ = this.indexOf(aDaemon[i].getQueue());
            Component._assert(iQ >= 0);
            int n = iQ;
            acShare[n] = acShare[n] + 1;
            ++i;
        }
        int cMax = 1;
        int iSlot = -1;
        int i2 = 0;
        int c2 = this.getWorkSlotCount();
        while (i2 < c2) {
            DaemonPool$WorkSlot slot = this.getWorkSlot(i2);
            int iQ = this.indexOf(slot.getQueue());
            Component._assert(iQ >= 0);
            int cShare = acShare[iQ];
            if (cShare > cMax) {
                cMax = cShare;
                iSlot = i2;
            }
            ++i2;
        }
        return iSlot == -1 ? null : this.getWorkSlot(iSlot);
    }

    protected DaemonPool$WorkSlot findMaxQueueSharingSlot() {
        int[] acShare = new int[this.getQueues().length];
        int cMax = 1;
        int iSlot = -1;
        int i = 0;
        int c = this.getWorkSlotCount();
        while (i < c) {
            DaemonPool$WorkSlot slot = this.getWorkSlot(i);
            int iQ = this.indexOf(slot.getQueue());
            Component._assert(iQ >= 0);
            int n = iQ;
            int n2 = acShare[n] + 1;
            acShare[n] = n2;
            int cShare = n2;
            if (cShare > cMax) {
                cMax = cShare;
                iSlot = i;
            }
            ++i;
        }
        return iSlot == -1 ? null : this.getWorkSlot(iSlot);
    }

    protected DaemonPool$WorkSlot findMinBacklogSlot(int iSeed) {
        DaemonPool$WorkSlot slotMin = null;
        int i = 0;
        int cSlots = this.getWorkSlotCount();
        int cMinSize = Integer.MAX_VALUE;
        while (i < cSlots) {
            DaemonPool$WorkSlot slot = this.getWorkSlot(Base.mod(iSeed + i, cSlots));
            int cSize = slot.getQueue().size();
            if (cSize == 0) {
                return slot;
            }
            if (cSize < cMinSize) {
                cMinSize = cSize;
                slotMin = slot;
            }
            ++i;
        }
        return slotMin;
    }

    protected AssociationPile findMinDaemonSharingQueue() {
        int iQ;
        AssociationPile[] aQueue = this.getQueues();
        int cQueues = aQueue.length;
        int[] acShare = new int[cQueues];
        DaemonPool$Daemon[] aDaemon = this.getDaemons();
        int i = 0;
        int c = aDaemon.length;
        while (i < c) {
            iQ = this.indexOf(aDaemon[i].getQueue());
            Component._assert(iQ >= 0);
            int n = iQ;
            acShare[n] = acShare[n] + 1;
            ++i;
        }
        int cMin = Integer.MAX_VALUE;
        int iQueue = -1;
        iQ = 0;
        while (iQ < cQueues) {
            if (acShare[iQ] < cMin) {
                cMin = acShare[iQ];
                iQueue = iQ;
            }
            ++iQ;
        }
        return aQueue[iQueue];
    }

    protected AssociationPile findMinSlotSharingQueue(AssociationPile queueExcept) {
        AssociationPile[] aQueue = this.getQueues();
        int cQueues = aQueue.length;
        int[] acShare = new int[cQueues];
        int i = 0;
        int c = this.getWorkSlotCount();
        while (i < c) {
            DaemonPool$WorkSlot slot = this.getWorkSlot(i);
            int iQ = this.indexOf(slot.getQueue());
            Component._assert(iQ >= 0);
            int n = iQ;
            acShare[n] = acShare[n] + 1;
            ++i;
        }
        int cMin = Integer.MAX_VALUE;
        int iQueue = -1;
        int iQ = 0;
        while (iQ < cQueues) {
            if (!(acShare[iQ] < cMin) ? false : aQueue[iQ] != queueExcept) {
                cMin = acShare[iQ];
                iQueue = iQ;
            }
            ++iQ;
        }
        return iQueue == -1 ? null : aQueue[iQueue];
    }

    protected DaemonPool$WorkSlot findSlot(AssociationPile queue) {
        int i = 0;
        int c = this.getWorkSlotCount();
        while (i < c) {
            DaemonPool$WorkSlot slot = this.getWorkSlot(i);
            if (slot.getQueue() == queue) {
                return slot;
            }
            ++i;
        }
        return null;
    }

    public void flushStats() {
        DaemonPool$Daemon[] aDaemon = this.getDaemons();
        int i = 0;
        int c = aDaemon == null ? 0 : aDaemon.length;
        while (i < c) {
            aDaemon[i].setFlushStats(true);
            ++i;
        }
    }

    public int getAbandonThreshold() {
        return this.__m_AbandonThreshold;
    }

    public int getActiveDaemonCount() {
        DaemonPool$Daemon[] aDaemon = this.getDaemons();
        int cActive = 0;
        int i = 0;
        int c = aDaemon == null ? 0 : aDaemon.length;
        while (i < c) {
            DaemonPool$Daemon daemon = aDaemon[i];
            if (daemon.getWrapperTask() != null) {
                ++cActive;
            }
            ++i;
        }
        return cActive;
    }

    public int getBacklog() {
        AssociationPile[] aQueue = this.getQueues();
        int cBacklog = 0;
        int i = 0;
        int c = aQueue == null ? 0 : aQueue.length;
        while (i < c) {
            cBacklog += aQueue[i].size();
            ++i;
        }
        return cBacklog;
    }

    public ClassLoader getContextClassLoader() {
        return null;
    }

    public int getDaemonCount() {
        return this.isStarted() ? this.getDaemons().length : this.__m_DaemonCount;
    }

    public int getDaemonCountMax() {
        return this.__m_DaemonCountMax;
    }

    public int getDaemonCountMin() {
        return this.__m_DaemonCountMin;
    }

    protected AtomicInteger getDaemonIndex() {
        return this.__m_DaemonIndex;
    }

    public DaemonPool$Daemon[] getDaemons() {
        return this.__m_Daemons;
    }

    public float getDefaultGuardRecovery() {
        Guardian guardian = this.getInternalGuardian();
        return guardian == null ? 0.0f : guardian.getDefaultGuardRecovery();
    }

    public long getDefaultGuardTimeout() {
        Guardian guardian = this.getInternalGuardian();
        return guardian == null ? 0L : guardian.getDefaultGuardTimeout();
    }

    public DaemonPoolDependencies getDependencies() {
        return this.__m_Dependencies;
    }

    public Guardian getGuardian() {
        return this;
    }

    public long getHungThreshold() {
        return this.__m_HungThreshold;
    }

    protected Guardian getInternalGuardian() {
        Component parent;
        Guardian guardian = this.__m_InternalGuardian;
        if (guardian == null && (parent = this.get_Parent()) instanceof Guardian) {
            guardian = (Guardian)((Object)parent);
            this.setInternalGuardian(guardian);
        }
        return guardian;
    }

    public String getName() {
        return this.__m_Name;
    }

    public AssociationPile[] getQueues() {
        return this.__m_Queues;
    }

    public long getRecoveryDelay() {
        return 50L;
    }

    public DaemonPool$ResizeTask getResizeTask() {
        return this.__m_ResizeTask;
    }

    public Set getScheduledTasks() {
        return this.__m_ScheduledTasks;
    }

    public int getStatsAbandonedCount() {
        return this.__m_StatsAbandonedCount;
    }

    public long getStatsActiveMillis() {
        return this.__m_StatsActiveMillis;
    }

    public int getStatsHungCount() {
        return this.__m_StatsHungCount;
    }

    public long getStatsHungDuration() {
        return this.__m_StatsHungDuration;
    }

    public String getStatsHungTaskId() {
        return this.__m_StatsHungTaskId;
    }

    public int getStatsLastBacklog() {
        return this.__m_StatsLastBacklog;
    }

    public long getStatsLastResetMillis() {
        return this.__m_StatsLastResetMillis;
    }

    public long getStatsLastResizeMillis() {
        return this.__m_StatsLastResizeMillis;
    }

    public long getStatsLastTaskAddCount() {
        return this.__m_StatsLastTaskAddCount;
    }

    public long getStatsLastTaskCount() {
        return this.__m_StatsLastTaskCount;
    }

    public int getStatsMaxBacklog() {
        return this.__m_StatsMaxBacklog;
    }

    public AtomicLong getStatsTaskAddCount() {
        return this.__m_StatsTaskAddCount;
    }

    public long getStatsTaskCount() {
        return this.__m_StatsTaskCount;
    }

    public int getStatsTimeoutCount() {
        return this.__m_StatsTimeoutCount;
    }

    public long getTaskTimeout() {
        return this.__m_TaskTimeout;
    }

    public ThreadGroup getThreadGroup() {
        return this.__m_ThreadGroup;
    }

    public int getThreadPriority() {
        return this.__m_ThreadPriority;
    }

    protected DaemonPool$WorkSlot[] getWorkSlot() {
        return this.__m_WorkSlot;
    }

    public DaemonPool$WorkSlot getWorkSlot(int i) {
        return this.getWorkSlot()[i];
    }

    public int getWorkSlotCount() {
        return this.__m_WorkSlotCount;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/DaemonPool".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    public static Component get_Instance() {
        return new DaemonPool();
    }

    private final Component get_Module() {
        return this;
    }

    public Guardian.GuardContext guard(Guardable guardable) {
        Guardian guardian = this.getInternalGuardian();
        return guardian == null ? null : guardian.guard(guardable);
    }

    public Guardian.GuardContext guard(Guardable guardable, long cMillis, float flPctRecover) {
        Guardian guardian = this.getInternalGuardian();
        return guardian == null ? null : guardian.guard(guardable, cMillis, flPctRecover);
    }

    protected void halt() {
        if (this.isStarted()) {
            this.setStarted(false);
            DaemonPool$Daemon[] aDaemon = this.getDaemons();
            int i = 0;
            int c = aDaemon.length;
            while (i < c) {
                aDaemon[i].halt();
                ++i;
            }
        }
    }

    protected int indexOf(AssociationPile queue) {
        AssociationPile[] aQueue = this.getQueues();
        int i = 0;
        int c = aQueue.length;
        while (i < c) {
            if (aQueue[i] == queue) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected DaemonPool$Daemon instantiateDaemon(int nType, AssociationPile queue) {
        DaemonPool$Daemon daemon = (DaemonPool$Daemon)this._newChild("Daemon");
        String sName = daemon.getThreadName();
        if (nType == DAEMON_STANDARD) {
            int iDaemon = this.getDaemonIndex().getAndIncrement();
            sName = new StringBuilder(String.valueOf(sName)).append(':').toString();
            sName = new StringBuilder(String.valueOf(sName)).append(this.isDynamic() ? new StringBuilder(String.valueOf("0x")).append(Base.toHexString(iDaemon, Math.max(4, Base.getMaxHexDigits(iDaemon)))).append(':').append(Base.getUpTimeMillis() / (long)1000).toString() : String.valueOf(iDaemon)).toString();
        } else if (nType != DAEMON_NONPOOLED) {
            throw new IllegalArgumentException(new StringBuilder(String.valueOf("Invalid type: ")).append(nType).toString());
        }
        String sPoolName = this.getName();
        daemon.setThreadName(sPoolName == null ? sName : new StringBuilder(String.valueOf(sPoolName)).append(sName).toString());
        daemon.setDaemonType(nType);
        daemon.setThreadGroup(this.getThreadGroup());
        daemon.setPriority(this.getThreadPriority());
        daemon.setQueue(queue);
        return daemon;
    }

    protected AssociationPile instantiateQueue() {
        return new ConcurrentAssociationPile();
    }

    protected DaemonPool$WrapperTask instantiateWrapperTask() {
        DaemonPool$WrapperTask task = new DaemonPool$WrapperTask();
        this._linkChild(task);
        return task;
    }

    public DaemonPool$WrapperTask instantiateWrapperTask(Runnable task, boolean fAggressiveTimeout) {
        long ldtNow = Base.getLastSafeTimeMillis();
        DaemonPool$WrapperTask wrapper = this.instantiateWrapperTask();
        wrapper.setTask(task);
        wrapper.setPostTime(ldtNow);
        if (task instanceof PriorityTask) {
            PriorityTask ptask = (PriorityTask)((Object)task);
            int iPriority = ptask.getSchedulingPriority();
            if (iPriority < PriorityTask.SCHEDULE_STANDARD ? true : iPriority > PriorityTask.SCHEDULE_IMMEDIATE) {
                Component._trace(new StringBuilder(String.valueOf("Invalid scheduling priority value: ")).append(iPriority).append(" for ").append(task.getClass().getName()).append("; changing to SCHEDULE_STANDARD").toString(), 2);
                iPriority = PriorityTask.SCHEDULE_STANDARD;
            }
            wrapper.setPriority(iPriority);
            long cTimeout = ptask.getExecutionTimeoutMillis();
            if (cTimeout == PriorityTask.TIMEOUT_DEFAULT) {
                cTimeout = this.getTaskTimeout();
            } else if (cTimeout == PriorityTask.TIMEOUT_NONE) {
                cTimeout = 0x7FFFFFFL;
            }
            if (cTimeout > 0L) {
                wrapper.setTimeoutMillis(cTimeout);
                if (fAggressiveTimeout) {
                    wrapper.setStopTime(ldtNow + cTimeout);
                    this.guard(wrapper, cTimeout, 1.0f);
                }
            }
        }
        return wrapper;
    }

    protected boolean isAutoStart() {
        return this.__m_AutoStart;
    }

    public boolean isDynamic() {
        return this.getDaemonCountMin() < this.getDaemonCountMax();
    }

    public boolean isInTransition() {
        return this.__m_InTransition;
    }

    public boolean isRunning() {
        return this.isStarted();
    }

    public boolean isStarted() {
        return this.__m_Started;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isStuck() {
        long cDeltaAdd;
        int cDeltaBacklog;
        int cBacklog;
        Object object = this.STATS_MONITOR;
        synchronized (object) {
            cBacklog = this.getBacklog();
            cDeltaBacklog = cBacklog - this.getStatsLastBacklog();
            long cAdd = this.getStatsTaskAddCount().get();
            cDeltaAdd = cAdd - this.getStatsLastTaskAddCount();
            this.setStatsLastBacklog(cBacklog);
            this.setStatsLastTaskAddCount(cAdd);
        }
        boolean fStuck = cDeltaAdd == (long)0 ? (!(cDeltaBacklog == 0) ? false : cBacklog > 0) : (cDeltaAdd > (long)0 ? (long)cDeltaBacklog == cDeltaAdd : false);
        return fStuck;
    }

    public boolean join(long cMillis) {
        DaemonPool$Daemon[] aDaemon = this.getDaemons();
        if (aDaemon != null) {
            long ldtTimeout = cMillis == (long)0 ? Long.MAX_VALUE : Base.getSafeTimeMillis() + cMillis;
            int i = 0;
            int c = aDaemon.length;
            while (i < c) {
                if (cMillis < (long)0 ? true : aDaemon[i].join(cMillis) ^ true) {
                    return false;
                }
                cMillis = Base.computeSafeWaitTime(ldtTimeout);
                ++i;
            }
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void onDaemonStop(DaemonPool$Daemon daemon, DaemonPool$StopTask taskStop) {
        block13: {
            int c2;
            int i2;
            Throwable throwable2;
            AssociationPile queueNext;
            AssociationPile queue;
            block12: {
                block10: {
                    queue = taskStop.getQueue();
                    if (!(queue != null)) break block13;
                    queueNext = queue;
                    try {
                        boolean bl;
                        block14: {
                            block11: {
                                AssociationPile queueMerge = this.findMinSlotSharingQueue(queue);
                                if (!(queueMerge != null)) break block10;
                                while (true) {
                                    Object oTask;
                                    if ((oTask = queue.poll()) == null) {
                                        queueNext = queueMerge;
                                        if (queue.size() != 0) {
                                            break;
                                        }
                                        break block11;
                                    }
                                    queueMerge.add(oTask);
                                    queue.release(oTask);
                                }
                                bl = false;
                                break block14;
                            }
                            bl = true;
                        }
                        Component._assert(bl);
                        this.setQueues((AssociationPile[])DaemonPool.copyOnRemove(this.getQueues(), queue));
                    }
                    catch (Throwable throwable2) {
                        Object var6_8 = null;
                        i2 = 0;
                        c2 = this.getWorkSlotCount();
                        break block12;
                    }
                }
                Object var6_7 = null;
                int i2 = 0;
                int c2 = this.getWorkSlotCount();
                while (i2 < c2) {
                    DaemonPool$WorkSlot slot = this.getWorkSlot(i2);
                    if (slot.getQueue() == queue) {
                        slot.setQueue(queueNext);
                        slot.getGate().open();
                    }
                    ++i2;
                }
                break block13;
            }
            while (true) {
                if (!(i2 < c2)) {
                    throw throwable2;
                }
                DaemonPool$WorkSlot slot = this.getWorkSlot(i2);
                if (slot.getQueue() == queue) {
                    slot.setQueue(queueNext);
                    slot.getGate().open();
                }
                ++i2;
            }
        }
        this.setDaemons((DaemonPool$Daemon[])DaemonPool.copyOnRemove(this.getDaemons(), daemon));
        taskStop.scheduleNext();
    }

    protected void onDependencies(DaemonPoolDependencies deps) {
        this.setInternalGuardian(deps.getGuardian());
        this.setName(deps.getName());
        this.setDaemonCount(deps.getThreadCount());
        this.setDaemonCountMax(deps.getThreadCountMax());
        this.setDaemonCountMin(deps.getThreadCountMin());
        this.setThreadGroup(deps.getThreadGroup());
        this.setThreadPriority(deps.getThreadPriority());
    }

    public void onInit() {
        String sCount = Config.getProperty("coherence.pool.interruptcount");
        if (sCount != null) {
            this.setAbandonThreshold(Integer.parseInt(sCount));
        }
        super.onInit();
        if (this.isAutoStart()) {
            this.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void replaceDaemon(DaemonPool$Daemon daemonAbandon) {
        DaemonPool$ResizeTask task;
        DaemonPool$WrapperTask wrapper = daemonAbandon.getWrapperTask();
        if ((!(wrapper != null) ? false : wrapper.getGate() != null) && (task = this.getResizeTask()) != null) {
            DaemonPool$ResizeTask daemonPool$ResizeTask = task;
            synchronized (daemonPool$ResizeTask) {
                task = this.getResizeTask();
                if (task != null) {
                    Component._trace("Stopping the dynamic pool resizing due to an abandoned thread", 2);
                    task.cancel();
                    this.setResizeTask(null);
                }
            }
        }
        DaemonPool daemonPool = this;
        synchronized (daemonPool) {
            DaemonPool$Daemon[] aDaemon = this.getDaemons();
            int i = 0;
            int cDaemons = aDaemon.length;
            while (i < cDaemons) {
                DaemonPool$Daemon daemon = aDaemon[i];
                if (daemon == daemonAbandon) {
                    DaemonPool$Daemon daemonNew = this.instantiateDaemon(DAEMON_STANDARD, daemon.getQueue());
                    daemonNew.start();
                    aDaemon[i] = daemonNew;
                    return;
                }
                ++i;
            }
        }
        Component._trace(new StringBuilder(String.valueOf("Failed to replace the abandoned daemon: ")).append(daemonAbandon).toString(), 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetStats() {
        Object object = this.STATS_MONITOR;
        synchronized (object) {
            this.setStatsActiveMillis(0L);
            this.setStatsLastBacklog(0);
            this.setStatsLastResizeMillis(0L);
            this.setStatsLastTaskAddCount(0L);
            this.setStatsLastTaskCount(0L);
            this.setStatsMaxBacklog(0);
            this.getStatsTaskAddCount().set(Math.max(0L, this.getStatsTaskAddCount().get() - this.getStatsTaskCount()));
            this.setStatsTaskCount(0L);
            this.setStatsTimeoutCount(0);
            this.setStatsLastResetMillis(Base.getSafeTimeMillis());
        }
    }

    public void runCanceled(PriorityTask task, boolean fAbandoned) {
        try {
            task.runCanceled(fAbandoned);
        }
        catch (RuntimeException runtimeException) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedule(Runnable task, long cMillis) {
        if (cMillis > 0L) {
            if (this.isStarted()) {
                Set setScheduled;
                DaemonPool$ScheduleTask taskSchedule = (DaemonPool$ScheduleTask)this._newChild("ScheduleTask");
                taskSchedule.setDelayMillis(cMillis);
                taskSchedule.setTask(task);
                Set set = setScheduled = this.getScheduledTasks();
                synchronized (set) {
                    if (this.isStarted()) {
                        Timers.scheduleNonBlockingTask(taskSchedule, cMillis, setScheduled);
                    }
                }
            }
        } else {
            this.add(task);
        }
    }

    protected void scheduleDaemonStart(int cStart) {
        Component._assert(cStart > 0);
        DaemonPool$StartTask taskStart = (DaemonPool$StartTask)this._newChild("StartTask");
        taskStart.setStartCount(cStart);
        this.add(taskStart, false);
    }

    protected void scheduleDaemonStop(int cStop) {
        Component._assert(cStop > 0);
        DaemonPool$StopTask taskStop = (DaemonPool$StopTask)this._newChild("StopTask");
        taskStop.setStopCount(cStop);
        this.add(taskStop, false);
    }

    public void setAbandonThreshold(int cThreads) {
        this.__m_AbandonThreshold = cThreads;
    }

    protected void setAutoStart(boolean fAutoStart) {
        Component._assert(this.is_Constructed() ^ true);
        this.__m_AutoStart = fAutoStart;
    }

    public void setContextClassLoader(ClassLoader loader) {
        throw new UnsupportedOperationException();
    }

    public synchronized void setDaemonCount(int cThreads) {
        int cOrig = this.getDaemonCount();
        if (cThreads != cOrig) {
            if (cThreads <= 0) {
                throw new IllegalArgumentException(new StringBuilder(String.valueOf("Requested number of threads (")).append(cThreads).append(") is invalid").toString());
            }
            if (this.isStarted()) {
                if (this.isInTransition()) {
                    Component._trace(new StringBuilder(String.valueOf("DaemonPool \"")).append(this.getName()).append("\" : ignoring a repetitive pool resize request; actual size=").append(cOrig).append(", target=").append(cThreads).toString(), 2);
                    return;
                }
                this.setInTransition(true);
                if (cThreads > cOrig) {
                    this.scheduleDaemonStart(cThreads - cOrig);
                } else {
                    this.scheduleDaemonStop(cOrig - cThreads);
                }
            }
            this.__m_DaemonCount = cThreads;
        }
    }

    public void setDaemonCountMax(int cThreads) {
        if (!this.is_Constructed() ? false : cThreads < 1) {
            throw new IllegalArgumentException("Maximum daemon count must be greater than 0");
        }
        this.__m_DaemonCountMax = cThreads;
    }

    public void setDaemonCountMin(int cThreads) {
        if (!this.is_Constructed() ? false : cThreads < 1) {
            throw new IllegalArgumentException("Minimum daemon count must be greater than 0");
        }
        this.__m_DaemonCountMin = cThreads;
    }

    private void setDaemonIndex(AtomicInteger atomic) {
        this.__m_DaemonIndex = atomic;
    }

    protected void setDaemons(DaemonPool$Daemon[] aDaemon) {
        this.__m_Daemons = aDaemon;
    }

    public void setDependencies(DaemonPoolDependencies deps) {
        if (this.getDependencies() != null) {
            throw new IllegalStateException("Dependencies already set");
        }
        if (this.isStarted()) {
            throw new IllegalStateException("DaemonPool has been started");
        }
        this.__m_Dependencies = this.cloneDependencies(deps).validate();
        this.onDependencies(this.getDependencies());
    }

    public void setHungThreshold(long cMillis) {
        this.__m_HungThreshold = cMillis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInTransition(boolean fTransition) {
        if (fTransition ^ true) {
            Object object = this.STATS_MONITOR;
            synchronized (object) {
                this.setStatsLastResizeMillis(Base.getSafeTimeMillis());
            }
        }
        this.__m_InTransition = fTransition;
    }

    protected synchronized void setInternalGuardian(Guardian guardian) {
        if (this.isStarted()) {
            throw new IllegalStateException("cannot modify the Guardian while the pool is running");
        }
        this.__m_InternalGuardian = guardian;
    }

    public synchronized void setName(String sName) {
        if (this.isStarted()) {
            throw new IllegalStateException("cannot modify the name while the pool is running");
        }
        this.__m_Name = sName;
    }

    protected void setQueues(AssociationPile[] aQueue) {
        this.__m_Queues = aQueue;
    }

    protected void setResizeTask(DaemonPool$ResizeTask task) {
        this.__m_ResizeTask = task;
    }

    protected void setScheduledTasks(Set setTasks) {
        this.__m_ScheduledTasks = setTasks;
    }

    protected void setStarted(boolean fStarted) {
        Component._assert(fStarted ^ true ? true : this.is_Constructed());
        this.__m_Started = fStarted;
    }

    public void setStatsAbandonedCount(int cThreads) {
        this.__m_StatsAbandonedCount = cThreads;
    }

    protected void setStatsActiveMillis(long cMillis) {
        this.__m_StatsActiveMillis = cMillis;
    }

    protected void setStatsHungCount(int cHung) {
        this.__m_StatsHungCount = cHung;
    }

    protected void setStatsHungDuration(long cDuration) {
        this.__m_StatsHungDuration = cDuration;
    }

    protected void setStatsHungTaskId(String sTaskId) {
        this.__m_StatsHungTaskId = sTaskId;
    }

    protected void setStatsLastBacklog(int cTasks) {
        this.__m_StatsLastBacklog = cTasks;
    }

    protected void setStatsLastResetMillis(long ldtReset) {
        this.__m_StatsLastResetMillis = ldtReset;
    }

    protected void setStatsLastResizeMillis(long ldtResize) {
        this.__m_StatsLastResizeMillis = ldtResize;
    }

    protected void setStatsLastTaskAddCount(long cTasks) {
        this.__m_StatsLastTaskAddCount = cTasks;
    }

    protected void setStatsLastTaskCount(long cTasks) {
        this.__m_StatsLastTaskCount = cTasks;
    }

    protected void setStatsMaxBacklog(int cTasks) {
        this.__m_StatsMaxBacklog = cTasks;
    }

    protected void setStatsTaskAddCount(AtomicLong cTasks) {
        this.__m_StatsTaskAddCount = cTasks;
    }

    protected void setStatsTaskCount(long cTasks) {
        this.__m_StatsTaskCount = cTasks;
    }

    public void setStatsTimeoutCount(int cTasks) {
        this.__m_StatsTimeoutCount = cTasks;
    }

    public void setTaskTimeout(long cMillis) {
        this.__m_TaskTimeout = cMillis;
    }

    public synchronized void setThreadGroup(ThreadGroup group) {
        if (this.isStarted()) {
            throw new IllegalStateException("cannot modify the ThreadGroup while the pool is running");
        }
        this.__m_ThreadGroup = group;
    }

    public synchronized void setThreadPriority(int nPriority) {
        if (nPriority < Thread.MIN_PRIORITY ? true : nPriority > Thread.MAX_PRIORITY) {
            throw new IllegalArgumentException(new StringBuilder(String.valueOf("invalid daemon thread priority: ")).append(nPriority).toString());
        }
        this.__m_ThreadPriority = nPriority;
        if (this.isStarted()) {
            DaemonPool$Daemon[] daemons = this.getDaemons();
            int i = 0;
            int c = daemons == null ? 0 : daemons.length;
            while (i < c) {
                daemons[i].getThread().setPriority(nPriority);
                ++i;
            }
        }
    }

    protected void setWorkSlot(int i, DaemonPool$WorkSlot slot) {
        Component._assert(!(slot != null) ? false : this.getWorkSlot(i) == null, "Must not change");
        this.__m_WorkSlot[i] = slot;
    }

    protected void setWorkSlot(DaemonPool$WorkSlot[] aSlot) {
        Component._assert(!(aSlot != null) ? false : this.getWorkSlot() == null, "Must not change");
        this.__m_WorkSlot = aSlot;
    }

    protected void setWorkSlotCount(int cSlots) {
        Component._assert(!(cSlots > 0) ? false : this.getWorkSlotCount() == 0, "Must not change");
        this.__m_WorkSlotCount = cSlots;
    }

    public void shutdown() {
        this.stop();
    }

    public synchronized void start() {
        Component._assert(this.is_Constructed());
        if (this.isStarted() ^ true) {
            int cSlots = Runtime.getRuntime().availableProcessors();
            try {
                String sSlots = Config.getProperty("coherence.daemonpool.slots");
                if (sSlots != null) {
                    cSlots = Math.abs(Integer.parseInt(sSlots));
                }
            }
            catch (RuntimeException e) {
                // empty catch block
            }
            this.setWorkSlot(new DaemonPool$WorkSlot[cSlots]);
            this.setWorkSlotCount(cSlots);
            int i = 0;
            while (i < cSlots) {
                DaemonPool$WorkSlot slot = (DaemonPool$WorkSlot)this._newChild("WorkSlot");
                slot.setIndex(i);
                this.setWorkSlot(i, slot);
                ++i;
            }
            int cDaemons = this.getDaemonCount();
            DaemonPool$Daemon[] aDaemon = new DaemonPool$Daemon[cDaemons];
            Component._assert(cDaemons > 0);
            int cQueues = Math.min(cDaemons, cSlots);
            AssociationPile[] aQueue = new AssociationPile[cQueues];
            int i2 = 0;
            while (i2 < cQueues) {
                AssociationPile queue = this.instantiateQueue();
                this.getWorkSlot(i2).setQueue(queue);
                aQueue[i2] = queue;
                aDaemon[i2] = this.instantiateDaemon(DAEMON_STANDARD, queue);
                ++i2;
            }
            if (cSlots >= cDaemons) {
                int iSlot = cDaemons;
                while (iSlot < cSlots) {
                    this.getWorkSlot(iSlot).setQueue(this.getWorkSlot(iSlot % cDaemons).getQueue());
                    ++iSlot;
                }
            } else {
                int iDaemon = cSlots;
                while (iDaemon < cDaemons) {
                    aDaemon[iDaemon] = this.instantiateDaemon(DAEMON_STANDARD, this.getWorkSlot(iDaemon % cSlots).getQueue());
                    ++iDaemon;
                }
            }
            this.setQueues(aQueue);
            this.setDaemons(aDaemon);
            i2 = 0;
            while (i2 < cSlots) {
                this.getWorkSlot(i2).setActive(true);
                ++i2;
            }
            i2 = 0;
            while (i2 < cDaemons) {
                aDaemon[i2].start();
                ++i2;
            }
            this.setStarted(true);
            if (this.isDynamic()) {
                DaemonPool$ResizeTask task = (DaemonPool$ResizeTask)this._newChild("ResizeTask");
                this.setResizeTask(task);
                this.schedule(task, task.getPeriodMillis());
            }
        }
    }

    public synchronized void startDaemon(DaemonPool$StartTask taskStart) {
        int cSlots = this.getWorkSlotCount();
        Object[] aDaemon = this.getDaemons();
        int cDaemons = aDaemon.length;
        if (cDaemons < cSlots) {
            DaemonPool$WorkSlot slotSplit = this.findMaxQueueSharingSlot();
            Component._assert(!(slotSplit != null) ? false : slotSplit.isActive());
            AssociationPile queueOld = slotSplit.getQueue();
            Gate gate = slotSplit.getGate();
            if (gate.close(1L) ^ true) {
                this.add(taskStart, false);
                return;
            }
            AssociationPile queue = this.instantiateQueue();
            DaemonPool$Daemon daemon = this.instantiateDaemon(DAEMON_STANDARD, queue);
            this.setQueues((AssociationPile[])DaemonPool.copyOnAdd(this.getQueues(), queue));
            this.setDaemons((DaemonPool$Daemon[])DaemonPool.copyOnAdd(aDaemon, daemon));
            try {
                slotSplit.setActive(false);
                slotSplit.setQueue(queue);
            }
            finally {
                Object var11_12 = null;
                gate.open();
            }
            int cStart = taskStart.getStartCount();
            taskStart = (DaemonPool$StartTask)this._newChild("StartTask");
            taskStart.setDaemon(daemon);
            taskStart.setWorkSlotActivate(slotSplit);
            taskStart.setStartCount(cStart);
            taskStart.setQueue(queueOld);
            queueOld.add(this.instantiateWrapperTask(taskStart, false));
        } else {
            AssociationPile queue = this.findMinDaemonSharingQueue();
            Component._assert(queue != null);
            DaemonPool$Daemon daemon = this.instantiateDaemon(DAEMON_STANDARD, queue);
            this.setDaemons((DaemonPool$Daemon[])DaemonPool.copyOnAdd(aDaemon, daemon));
            daemon.start();
            taskStart.scheduleNext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop() {
        if (this.isStarted()) {
            Set setScheduled;
            this.setStarted(false);
            DaemonPool$ResizeTask task = this.getResizeTask();
            if (task != null) {
                task.cancel();
            }
            DaemonPool$Daemon[] aDaemon = this.getDaemons();
            int i = 0;
            int c = aDaemon.length;
            while (i < c) {
                aDaemon[i].stop();
                ++i;
            }
            Set set = setScheduled = this.getScheduledTasks();
            synchronized (set) {
                Iterator iter = this.getScheduledTasks().iterator();
                while (iter.hasNext()) {
                    Disposable disposable = (Disposable)iter.next();
                    iter.remove();
                    disposable.dispose();
                }
            }
            this.setInTransition(false);
        }
    }

    public synchronized void stopDaemon(DaemonPool$StopTask taskStop) {
        DaemonPool$WorkSlot slot;
        int cSlots = this.getWorkSlotCount();
        DaemonPool$Daemon[] aDaemon = this.getDaemons();
        int cDaemons = aDaemon.length;
        if (cDaemons > cSlots) {
            slot = this.findMaxDaemonSharingSlot();
            Component._assert(slot != null);
            taskStop.setWorkSlot(slot);
        } else {
            AssociationPile queue = this.findMinSlotSharingQueue(null);
            slot = this.findSlot(queue);
            Component._assert(slot != null);
            taskStop.setQueue(queue);
        }
        slot.add(this.instantiateWrapperTask(taskStop, false));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.get_Name());
        sb.append("\nWorkSlots:");
        int i = 0;
        int c = this.getWorkSlotCount();
        while (i < c) {
            sb.append("\n  ").append(this.getWorkSlot(i));
            ++i;
        }
        DaemonPool$Daemon[] aDaemon = this.getDaemons();
        sb.append("\n Daemons:");
        int i2 = 0;
        int c2 = aDaemon == null ? 0 : aDaemon.length;
        while (i2 < c2) {
            sb.append("\n  ").append(aDaemon[i2]);
            ++i2;
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long updateStats(DaemonPool$Daemon daemon, int cTasks, long ldtStart) {
        long ldtNow = Base.getSafeTimeMillis();
        if (!(cTasks > 0) ? false : daemon.getDaemonType() == DAEMON_STANDARD) {
            Object object = this.STATS_MONITOR;
            synchronized (object) {
                this.setStatsTaskCount(this.getStatsTaskCount() + (long)cTasks);
                this.setStatsActiveMillis(this.getStatsActiveMillis() + ldtNow - ldtStart);
            }
        }
        daemon.setFlushStats(false);
        return ldtNow;
    }
}

