/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util;

import com.oracle.coherence.common.base.Disposable;
import com.oracle.coherence.common.base.Lockable;
import com.oracle.coherence.common.base.Timeout;
import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.Util;
import com.tangosol.coherence.component.application.console.Coherence;
import com.tangosol.coherence.component.net.Security;
import com.tangosol.coherence.component.net.extend.RemoteService;
import com.tangosol.coherence.component.net.extend.remoteService.RemoteCacheService;
import com.tangosol.coherence.component.net.extend.remoteService.RemoteInvocationService;
import com.tangosol.coherence.component.net.management.Gateway;
import com.tangosol.coherence.component.util.LocalCache;
import com.tangosol.coherence.component.util.SafeCluster$EnsureClusterAction;
import com.tangosol.coherence.component.util.SafeCluster$EnsureSafeServiceAction;
import com.tangosol.coherence.component.util.SafeCluster$ParseDependenciesAction;
import com.tangosol.coherence.component.util.SafeCluster$ShutdownHook;
import com.tangosol.coherence.component.util.SafeCluster$Unlockable;
import com.tangosol.coherence.component.util.SafeService;
import com.tangosol.coherence.component.util.safeService.SafeCacheService;
import com.tangosol.coherence.component.util.safeService.SafeInvocationService;
import com.tangosol.coherence.component.util.safeService.SafeProxyService;
import com.tangosol.coherence.component.util.safeService.safeCacheService.SafeDistributedCacheService;
import com.tangosol.coherence.config.Config;
import com.tangosol.coherence.config.builder.ParameterizedBuilderRegistry;
import com.tangosol.internal.net.cluster.DefaultClusterDependencies;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.CacheService;
import com.tangosol.net.Cluster;
import com.tangosol.net.ClusterDependencies;
import com.tangosol.net.DistributedCacheService;
import com.tangosol.net.InvocationService;
import com.tangosol.net.Member;
import com.tangosol.net.OperationalContext;
import com.tangosol.net.ProxyService;
import com.tangosol.net.RequestTimeoutException;
import com.tangosol.net.Service;
import com.tangosol.net.ServiceInfo;
import com.tangosol.net.SocketProviderFactory;
import com.tangosol.net.internal.ClusterJoinException;
import com.tangosol.net.internal.ScopedServiceReferenceStore;
import com.tangosol.net.management.Registry;
import com.tangosol.net.security.DoAsAction;
import com.tangosol.net.security.IdentityAsserter;
import com.tangosol.net.security.IdentityTransformer;
import com.tangosol.net.security.LocalPermission;
import com.tangosol.net.security.SecurityHelper;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.util.Base;
import com.tangosol.util.ListMap;
import com.tangosol.util.ResourceRegistry;
import com.tangosol.util.SafeHashMap;
import com.tangosol.util.SafeHashSet;
import com.tangosol.util.ServiceEvent;
import com.tangosol.util.ServiceListener;
import com.tangosol.util.SynchronousListener;
import com.tangosol.util.WrapperException;
import java.lang.ref.WeakReference;
import java.net.InetAddress;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;

public class SafeCluster
extends Util
implements Lockable,
Cluster,
OperationalContext,
ServiceListener,
SynchronousListener {
    private ClassLoader __m_ContextClassLoader;
    private volatile ClusterDependencies __m_Dependencies;
    private boolean __m_Disposed;
    private PrivilegedAction __m_EnsureClusterAction;
    private transient com.tangosol.coherence.component.net.Cluster __m_InternalCluster;
    private Set __m_LocalServices;
    private ReentrantLock __m_Lock;
    private transient Registry __m_Management;
    private boolean __m_Restart;
    private ScopedServiceReferenceStore __m_ScopedServiceStore;
    private transient Map __m_ServiceContext;
    private SafeCluster$ShutdownHook __m_ShutdownHook;
    private com.tangosol.coherence.component.net.Member __m_SurrogateMember;
    private SafeCluster$Unlockable __m_Unlockable;
    private static ListMap __mapChildren;

    static {
        SafeCluster.__initStatic();
    }

    public SafeCluster() {
        this(null, null, true);
    }

    public SafeCluster(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setLock(new ReentrantLock());
            this.setRestart(true);
            this.setScopedServiceStore(new ScopedServiceReferenceStore());
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
        try {
            this.__m_ServiceContext = new SafeHashMap();
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
    }

    private static void __initStatic() {
        __mapChildren = new ListMap();
        Class clazz = __mapChildren.put("EnsureClusterAction", SafeCluster$EnsureClusterAction.get_CLASS());
        Class clazz2 = __mapChildren.put("EnsureSafeServiceAction", SafeCluster$EnsureSafeServiceAction.get_CLASS());
        Class clazz3 = __mapChildren.put("ParseDependenciesAction", SafeCluster$ParseDependenciesAction.get_CLASS());
        Class clazz4 = __mapChildren.put("ShutdownHook", SafeCluster$ShutdownHook.get_CLASS());
        Class clazz5 = __mapChildren.put("Unlockable", SafeCluster$Unlockable.get_CLASS());
    }

    private void checkInternalAccess() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(LocalPermission.INTERNAL_SERVICE);
        }
    }

    protected void cleanup() {
        this.setInternalCluster(null);
        this.setSurrogateMember(null);
        this.getScopedServiceStore().clear();
        this.getLocalServices().clear();
    }

    public void configure(XmlElement xmlConfig) {
        SafeCluster$ParseDependenciesAction action = (SafeCluster$ParseDependenciesAction)this._newChild("ParseDependenciesAction");
        action.setXmlConfig(xmlConfig);
        this.setDependencies((ClusterDependencies)AccessController.doPrivileged(action));
    }

    public void dispose() {
        block2: {
            this.ensureLocked();
            try {
                if (!(this.isDisposed() ^ true)) break block2;
                this.setDisposed(true);
                this.shutdown();
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.unlock();
                throw throwable;
            }
        }
        Object var2_1 = null;
        this.unlock();
    }

    public ClusterDependencies ensureDependencies() {
        ClusterDependencies deps = this.getDependencies();
        if (deps == null) {
            this.configure(CacheFactory.getClusterConfig());
            deps = this.getDependencies();
        }
        return deps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Service ensureLocalService(String sName, String sType) {
        Component serviceLocal;
        Component service;
        if (sType.equals(CacheService.TYPE_LOCAL)) {
            service = new LocalCache();
            ((LocalCache)service).setServiceName(sName);
            ((LocalCache)service).setCluster(this);
            serviceLocal = service;
        } else if (sType.equals(CacheService.TYPE_REMOTE)) {
            service = new RemoteCacheService();
            ((RemoteService)service).setServiceName(sName);
            ((RemoteService)service).setCluster(this);
            serviceLocal = service;
        } else if (sType.equals(InvocationService.TYPE_REMOTE)) {
            service = new RemoteInvocationService();
            ((RemoteService)service).setServiceName(sName);
            ((RemoteService)service).setCluster(this);
            serviceLocal = service;
        } else {
            throw new IllegalArgumentException(new StringBuilder(String.valueOf("illegal local service type: ")).append(sType).toString());
        }
        serviceLocal.addServiceListener(this);
        String sHook = Config.getProperty("coherence.shutdownhook.local", "true");
        Set setLocal = this.getLocalServices();
        if (!(!setLocal.isEmpty() ? false : this.getShutdownHook() == null) ? false : "true".equals(sHook)) {
            Set set = setLocal;
            synchronized (set) {
                if (!setLocal.isEmpty() ? false : this.getShutdownHook() == null) {
                    try {
                        SafeCluster$ShutdownHook hook = new SafeCluster$ShutdownHook();
                        hook.set_Feed(new WeakReference<SafeCluster>(this));
                        this.setShutdownHook(hook);
                        hook.register();
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                }
            }
        }
        setLocal.add(serviceLocal);
        return serviceLocal;
    }

    public void ensureLocked() {
        long cTimeout = Timeout.remainingTimeoutMillis();
        ReentrantLock lock = this.getLock();
        try {
            if (lock.tryLock(cTimeout, TimeUnit.MILLISECONDS)) {
                return;
            }
            throw Base.ensureRuntimeException(new RequestTimeoutException(new StringBuilder(String.valueOf("Failed to acquire cluster lock in ")).append(cTimeout).append("ms").toString()));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw Base.ensureRuntimeException(e, "Interrupted while attempting to acquire cluster lock");
        }
    }

    public com.tangosol.coherence.component.net.Cluster ensureRunningCluster() {
        com.tangosol.coherence.component.net.Cluster cluster;
        block8: {
            Gateway registry;
            boolean fInit;
            block7: {
                this.checkInternalAccess();
                cluster = this.getInternalCluster();
                if (!(cluster == null ? true : cluster.isRunning() ^ true)) break block8;
                this.ensureLocked();
                fInit = true;
                try {
                    cluster = this.getInternalCluster();
                    if (cluster == null ? true : cluster.isRunning() ^ true) {
                        if (this.isRestart()) {
                            if (cluster != null) {
                                if (cluster.isHalted()) {
                                    throw new IllegalStateException("The cluster has been halted and is not restartable.");
                                }
                                cluster.ensureStopped();
                                cluster = null;
                                this.setInternalCluster(null);
                                Component._trace("Restarting cluster", 3);
                            }
                            cluster = this.restartCluster();
                            this.setInternalCluster(cluster);
                            break block7;
                        }
                        throw new IllegalStateException(this.isDisposed() ? "SafeCluster has been shutdown" : "SafeCluster has been explicitly stopped or has not been started");
                    }
                    fInit = false;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    this.unlock();
                    throw throwable;
                }
            }
            Object var4_3 = null;
            this.unlock();
            if (fInit && (registry = (Gateway)this.getManagement()) != null) {
                registry.reset();
                String sNodeName = registry.ensureGlobalName(Registry.NODE_TYPE);
                registry.register(sNodeName, this.getLocalMember());
                String sP2PName = registry.ensureGlobalName(Registry.POINT_TO_POINT_TYPE);
                registry.register(sP2PName, cluster.getClusterService().getClusterMemberSet());
                registry.registerReporter();
                registry.registerCustomBeans();
            }
        }
        return cluster;
    }

    public SafeService ensureSafeService(String sName, String sType) {
        ScopedServiceReferenceStore store = this.getScopedServiceStore();
        SafeService serviceSafe = (SafeService)store.getService(sName);
        if (serviceSafe == null) {
            block4: {
                this.ensureLocked();
                try {
                    serviceSafe = (SafeService)store.getService(sName);
                    if (!(serviceSafe == null)) break block4;
                    serviceSafe = this.instantiateSafeService(this.instantiateService(sName, sType));
                    serviceSafe.setContextClassLoader(this.getContextClassLoader());
                    serviceSafe.setSafeCluster(this);
                    serviceSafe.setServiceName(sName);
                    serviceSafe.setServiceType(sType);
                    serviceSafe.setSubject(SecurityHelper.getCurrentSubject());
                    store.putService(serviceSafe, sName, sType);
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    this.unlock();
                    throw throwable;
                }
            }
            Object var6_5 = null;
            this.unlock();
        }
        if (serviceSafe.getServiceType().equals(sType) ^ true) {
            throw new IllegalArgumentException(new StringBuilder(String.valueOf("Requested service type \"")).append(sType).append("\", but the existing service has type \"").append(serviceSafe.getServiceType()).append('\"').toString());
        }
        return serviceSafe;
    }

    public Service ensureService(String sName, String sType) {
        String sCacheName = (InvocationService.TYPE_DEFAULT.equals(sType) ? true : ProxyService.TYPE_DEFAULT.equals(sType)) ? null : "*";
        Security.checkPermission(this.getInternalCluster(), sName, sCacheName, "join");
        SafeCluster$EnsureSafeServiceAction action = (SafeCluster$EnsureSafeServiceAction)this._newChild("EnsureSafeServiceAction");
        action.setServiceName(sName);
        action.setServiceType(sType);
        return (Service)(System.getSecurityManager() == null ? action.run() : AccessController.doPrivileged(new DoAsAction(action)));
    }

    public Lockable.Unlockable exclusively() {
        this.ensureLocked();
        return this.getUnlockable();
    }

    public Map getAddressProviderMap() {
        return this.ensureDependencies().getAddressProviderMap();
    }

    public ParameterizedBuilderRegistry getBuilderRegistry() {
        return this.ensureDependencies().getBuilderRegistry();
    }

    public com.tangosol.coherence.component.net.Cluster getCluster() {
        this.checkInternalAccess();
        return this.getInternalCluster();
    }

    public String getClusterName() {
        return ((Cluster)this.getRunningCluster()).getClusterName();
    }

    public ClassLoader getContextClassLoader() {
        ClassLoader loader = this.__m_ContextClassLoader;
        if (loader == null) {
            loader = Base.getContextClassLoader(this);
        }
        return loader;
    }

    public ClusterDependencies getDependencies() {
        return this.__m_Dependencies;
    }

    public InetAddress getDiscoveryInterface() {
        return this.ensureDependencies().getGroupInterface();
    }

    public int getDiscoveryTimeToLive() {
        return this.ensureDependencies().getGroupTimeToLive();
    }

    public int getEdition() {
        return this.ensureDependencies().getEdition();
    }

    public String getEditionName() {
        return Coherence.EDITION_NAMES[this.ensureDependencies().getEdition()];
    }

    public PrivilegedAction getEnsureClusterAction() {
        return this.__m_EnsureClusterAction;
    }

    public Map getFilterMap() {
        return this.ensureDependencies().getFilterMap();
    }

    public IdentityAsserter getIdentityAsserter() {
        Security.getInstance();
        return Security.getIdentityAsserter();
    }

    public IdentityTransformer getIdentityTransformer() {
        Security.getInstance();
        return Security.getIdentityTransformer();
    }

    protected com.tangosol.coherence.component.net.Cluster getInternalCluster() {
        return this.__m_InternalCluster;
    }

    public Member getLocalMember() {
        com.tangosol.coherence.component.net.Cluster cluster = this.getInternalCluster();
        return cluster == null ? this.getSurrogateMember() : cluster.getLocalMember();
    }

    protected Set getLocalServices() {
        return this.__m_LocalServices;
    }

    public int getLocalTcpPort() {
        com.tangosol.coherence.component.net.Cluster cluster = this.getCluster();
        return cluster == null ? 0 : cluster.getSocketManager().getAcceptorChannel().getPort();
    }

    public ReentrantLock getLock() {
        return this.__m_Lock;
    }

    public Registry getManagement() {
        return this.__m_Management;
    }

    public Set getMemberSet() {
        return ((Cluster)this.getRunningCluster()).getMemberSet();
    }

    public Member getOldestMember() {
        return ((Cluster)this.getRunningCluster()).getOldestMember();
    }

    public Disposable getResource(String sName) {
        return ((Cluster)this.getRunningCluster()).getResource(sName);
    }

    public ResourceRegistry getResourceRegistry() {
        return ((Cluster)this.getRunningCluster()).getResourceRegistry();
    }

    public com.tangosol.coherence.component.net.Cluster getRunningCluster() {
        if (System.getSecurityManager() == null) {
            return this.ensureRunningCluster();
        }
        return (com.tangosol.coherence.component.net.Cluster)AccessController.doPrivileged(new DoAsAction(this.getEnsureClusterAction()));
    }

    public ScopedServiceReferenceStore getScopedServiceStore() {
        return this.__m_ScopedServiceStore;
    }

    public Map getSerializerMap() {
        return this.ensureDependencies().getSerializerMap();
    }

    public Service getService(String sName) {
        Security.checkPermission(this.getInternalCluster(), sName, null, "join");
        ScopedServiceReferenceStore store = this.getScopedServiceStore();
        SafeService serviceSafe = (SafeService)store.getService(sName);
        if (serviceSafe == null) {
            block3: {
                this.ensureLocked();
                try {
                    Service service;
                    serviceSafe = (SafeService)store.getService(sName);
                    if (!(serviceSafe == null) || !((service = this.getRunningCluster().getService(sName)) != null)) break block3;
                    serviceSafe = this.instantiateSafeService(service);
                    serviceSafe.setSafeCluster(this);
                    serviceSafe.setServiceName(sName);
                    String sServiceType = service.getInfo().getServiceType();
                    serviceSafe.setServiceType(sServiceType);
                    serviceSafe.setContextClassLoader(this.getContextClassLoader());
                    store.putService(serviceSafe, sName, sServiceType);
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    this.unlock();
                    throw throwable;
                }
            }
            Object var5_6 = null;
            this.unlock();
        }
        return serviceSafe;
    }

    protected Map getServiceContext() {
        return this.__m_ServiceContext;
    }

    public ServiceInfo getServiceInfo(String sName) {
        return ((Cluster)this.getRunningCluster()).getServiceInfo(sName);
    }

    public Enumeration getServiceNames() {
        return ((Cluster)this.getRunningCluster()).getServiceNames();
    }

    public SafeCluster$ShutdownHook getShutdownHook() {
        return this.__m_ShutdownHook;
    }

    public Map getSnapshotArchiverMap() {
        return this.ensureDependencies().getSnapshotArchiverMap();
    }

    public SocketProviderFactory getSocketProviderFactory() {
        return this.ensureDependencies().getSocketProviderFactory();
    }

    public long getStartupTimeout() {
        return 0L;
    }

    public com.tangosol.coherence.component.net.Member getSurrogateMember() {
        com.tangosol.coherence.component.net.Member member = this.__m_SurrogateMember;
        if (member == null) {
            ClusterDependencies deps = this.ensureDependencies();
            member = new com.tangosol.coherence.component.net.Member();
            member.configure(deps.getMemberIdentity(), deps.getLocalAddress());
            this.setSurrogateMember(member);
        }
        return member;
    }

    public long getTimeMillis() {
        try {
            return this.getInternalCluster().getTimeMillis();
        }
        catch (NullPointerException e) {
            return 0L;
        }
    }

    public SafeCluster$Unlockable getUnlockable() {
        return this.__m_Unlockable;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/SafeCluster".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    public static Component get_Instance() {
        return new SafeCluster();
    }

    private final Component get_Module() {
        return this;
    }

    protected SafeService instantiateSafeService(Service service) {
        SafeService serviceSafe = service instanceof CacheService ? (service instanceof DistributedCacheService ? new SafeDistributedCacheService() : new SafeCacheService()) : (service instanceof InvocationService ? new SafeInvocationService() : (service instanceof ProxyService ? new SafeProxyService() : new SafeService()));
        serviceSafe.setInternalService(service);
        return serviceSafe;
    }

    public Service instantiateService(String sName, String sType) {
        return SafeCluster.isLocalService(sType) ? this.ensureLocalService(sName, sType) : this.getRunningCluster().ensureService(sName, sType);
    }

    public boolean isDisposed() {
        return this.__m_Disposed;
    }

    public static boolean isLocalService(String sType) {
        return (sType.equals(CacheService.TYPE_LOCAL) ? true : sType.equals(CacheService.TYPE_REMOTE)) ? true : sType.equals(InvocationService.TYPE_REMOTE);
    }

    public boolean isRestart() {
        return this.__m_Restart;
    }

    public boolean isRunning() {
        com.tangosol.coherence.component.net.Cluster cluster = this.getInternalCluster();
        return !(!(cluster != null) ? false : this.isRestart()) ? false : cluster.isRunning();
    }

    public boolean isSubjectScopingEnabled() {
        Security.getInstance();
        return Security.isSubjectScoped();
    }

    public void onInit() {
        this.setLocalServices(new SafeHashSet(5, 1.0f, 1.0f));
        this.setEnsureClusterAction((SafeCluster$EnsureClusterAction)this._newChild("EnsureClusterAction"));
        this.setUnlockable((SafeCluster$Unlockable)this._newChild("Unlockable"));
        super.onInit();
    }

    public void registerResource(String sName, Disposable disposable) {
        ((Cluster)this.getRunningCluster()).registerResource(sName, disposable);
    }

    protected com.tangosol.coherence.component.net.Cluster restartCluster() {
        int cAttempts = 0;
        while (true) {
            com.tangosol.coherence.component.net.Cluster cluster = null;
            try {
                cluster = new com.tangosol.coherence.component.net.Cluster();
                this.startCluster(cluster);
                return cluster;
            }
            catch (Throwable e) {
                if (!(!(e instanceof ClusterJoinException ? true : e.getCause() instanceof ClusterJoinException) ? false : ++cAttempts < 5)) {
                    Component._trace(new StringBuilder(String.valueOf("Error while starting cluster: ")).append(Component.getStackTrace(e)).toString(), 1);
                    try {
                        if (this.isRunning()) {
                            cluster.stop();
                        }
                    }
                    catch (Throwable e2) {
                        Component._trace(new StringBuilder(String.valueOf("Failed to stop cluster: ")).append(Component.getStackTrace(e2)).toString(), 2);
                    }
                    if (e instanceof Error) {
                        throw (Error)e;
                    }
                    throw (RuntimeException)e;
                }
                Component._trace("Cluster seniority changed during join; rejoining the cluster", 3);
                ++cAttempts;
                continue;
            }
            break;
        }
    }

    public void resumeService(String sService) {
        com.tangosol.coherence.component.net.Cluster cluster = this.getRunningCluster();
        if (cluster != null) {
            Security.checkPermission(cluster, Base.equals(sService, "Cluster") ? "*" : sService, null, "create");
            cluster.resumeService(sService);
        }
    }

    public void serviceStarted(ServiceEvent evt) {
    }

    public void serviceStarting(ServiceEvent evt) {
    }

    public void serviceStopped(ServiceEvent evt) {
        Service service = (Service)evt.getService();
        if (SafeCluster.isLocalService(service.getInfo().getServiceType())) {
            this.getLocalServices().remove(service);
        }
    }

    public void serviceStopping(ServiceEvent evt) {
    }

    public void setContextClassLoader(ClassLoader loader) {
        this.__m_ContextClassLoader = loader;
    }

    public void setDependencies(ClusterDependencies deps) {
        if (this.isRunning()) {
            throw new IllegalStateException("Cannot configure running cluster");
        }
        this.__m_Dependencies = new DefaultClusterDependencies(deps).validate();
        this.setSurrogateMember(null);
    }

    protected void setDisposed(boolean fDispose) {
        this.__m_Disposed = fDispose;
    }

    protected void setEnsureClusterAction(PrivilegedAction action) {
        this.__m_EnsureClusterAction = action;
    }

    protected void setInternalCluster(com.tangosol.coherence.component.net.Cluster cluster) {
        this.__m_InternalCluster = cluster;
    }

    protected void setLocalServices(Set set) {
        this.__m_LocalServices = set;
    }

    public void setLock(ReentrantLock lock) {
        this.__m_Lock = lock;
    }

    public void setManagement(Registry registry) {
        this.__m_Management = registry;
    }

    protected void setRestart(boolean fRestart) {
        this.__m_Restart = fRestart;
    }

    protected void setScopedServiceStore(ScopedServiceReferenceStore store) {
        this.__m_ScopedServiceStore = store;
    }

    private void setServiceContext(Map mapContext) {
        this.__m_ServiceContext = mapContext;
    }

    protected void setShutdownHook(SafeCluster$ShutdownHook hook) {
        this.__m_ShutdownHook = hook;
    }

    protected void setSurrogateMember(com.tangosol.coherence.component.net.Member member) {
        this.__m_SurrogateMember = member;
    }

    public void setUnlockable(SafeCluster$Unlockable unlockable) {
        this.__m_Unlockable = unlockable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        com.tangosol.coherence.component.net.Cluster cluster;
        this.ensureLocked();
        try {
            this.setRestart(false);
            com.tangosol.coherence.component.net.Cluster cluster2 = this.getInternalCluster();
            if (cluster2 != null) {
                cluster = cluster2;
                synchronized (cluster) {
                    if (cluster2.isRunning()) {
                        cluster2.shutdown();
                    }
                }
            }
            this.shutdownLocalServices();
            this.cleanup();
        }
        finally {
            cluster = null;
            this.unlock();
        }
    }

    public void shutdownLocalServices() {
        SafeCluster$ShutdownHook hook = this.getShutdownHook();
        if (hook != null) {
            hook.unregister();
            this.setShutdownHook(null);
        }
        try {
            Iterator iter = this.getLocalServices().iterator();
            while (iter.hasNext()) {
                Service service = (Service)iter.next();
                iter.remove();
                service.removeServiceListener(this);
                service.shutdown();
            }
        }
        catch (Throwable throwable) {}
    }

    public void start() {
        if (this.isDisposed() ^ true) {
            this.ensureLocked();
            try {
                if (this.isDisposed() ^ true) {
                    this.setRestart(true);
                }
                this.getRunningCluster();
            }
            finally {
                Object var2_1 = null;
                this.unlock();
            }
        }
    }

    protected void startCluster(com.tangosol.coherence.component.net.Cluster cluster) {
        cluster.setDependencies(this.ensureDependencies());
        cluster.setOperationalContext(this);
        cluster.setManagement(this.getManagement());
        cluster.getClusterService().setServiceContext(this.getServiceContext());
        cluster.start();
        Component._trace(new StringBuilder(String.valueOf("Started cluster ")).append(cluster).toString(), 3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        com.tangosol.coherence.component.net.Cluster cluster;
        this.ensureLocked();
        try {
            this.setRestart(false);
            com.tangosol.coherence.component.net.Cluster cluster2 = this.getInternalCluster();
            if (cluster2 != null) {
                cluster = cluster2;
                synchronized (cluster) {
                    if (cluster2.isRunning()) {
                        cluster2.stop();
                    }
                }
            }
            this.shutdownLocalServices();
            this.cleanup();
        }
        finally {
            cluster = null;
            this.unlock();
        }
    }

    public void suspendService(String sService) {
        com.tangosol.coherence.component.net.Cluster cluster = this.getRunningCluster();
        if (cluster != null) {
            Security.checkPermission(cluster, Base.equals(sService, "Cluster") ? "*" : sService, null, "destroy");
            cluster.suspendService(sService);
        }
    }

    public String toString() {
        return new StringBuilder(String.valueOf(this.get_Name())).append(": ").append(this.getInternalCluster()).toString();
    }

    public void unlock() {
        this.getLock().unlock();
    }

    public Disposable unregisterResource(String sName) {
        return ((Cluster)this.getRunningCluster()).unregisterResource(sName);
    }
}

