/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util;

import com.oracle.coherence.common.base.Lockable;
import com.oracle.coherence.common.base.Timeout;
import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.Util;
import com.tangosol.coherence.component.net.Security;
import com.tangosol.coherence.component.net.extend.RemoteService;
import com.tangosol.coherence.component.util.SafeCluster;
import com.tangosol.coherence.component.util.SafeService$EnsureServiceAction;
import com.tangosol.coherence.component.util.SafeService$StartAction;
import com.tangosol.coherence.component.util.SafeService$Unlockable;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid;
import com.tangosol.io.Serializer;
import com.tangosol.net.Cluster;
import com.tangosol.net.InvocationService;
import com.tangosol.net.Member;
import com.tangosol.net.MemberEvent;
import com.tangosol.net.MemberListener;
import com.tangosol.net.ProxyService;
import com.tangosol.net.RequestTimeoutException;
import com.tangosol.net.ServiceDependencies;
import com.tangosol.net.ServiceInfo;
import com.tangosol.net.management.Registry;
import com.tangosol.net.security.DoAsAction;
import com.tangosol.net.security.LocalPermission;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.util.Base;
import com.tangosol.util.ListMap;
import com.tangosol.util.Listeners;
import com.tangosol.util.ResourceRegistry;
import com.tangosol.util.ServiceEvent;
import com.tangosol.util.ServiceListener;
import com.tangosol.util.SimpleResourceRegistry;
import com.tangosol.util.SynchronousListener;
import com.tangosol.util.WrapperException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import javax.security.auth.Subject;

public class SafeService
extends Util
implements Lockable,
MemberListener,
com.tangosol.net.Service,
ServiceListener {
    public static final int SERVICE_INITIAL = 0;
    public static final int SERVICE_STARTED = 1;
    public static final int SERVICE_STOPPED = 2;
    private transient XmlElement __m_Config;
    private ClassLoader __m_ContextClassLoader;
    private ServiceDependencies __m_Dependencies;
    private PrivilegedAction __m_EnsureServiceAction;
    private transient com.tangosol.net.Service __m_InternalService;
    private ReentrantLock __m_Lock;
    private Listeners __m_MemberListeners;
    private ResourceRegistry __m_ResourceRegistry;
    private transient boolean __m_Restarting;
    private transient SafeCluster __m_SafeCluster;
    private int __m_SafeServiceState;
    private Listeners __m_ServiceListeners;
    private String __m_ServiceName;
    private String __m_ServiceType;
    private Subject __m_Subject;
    private SafeService$Unlockable __m_Unlockable;
    private Object __m_UserContext;
    private static ListMap __mapChildren;

    static {
        SafeService.__initStatic();
    }

    public SafeService() {
        this(null, null, true);
    }

    public SafeService(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setLock(new ReentrantLock());
            this.setResourceRegistry(new SimpleResourceRegistry());
            this.setSafeServiceState(0);
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
        try {
            this.__m_MemberListeners = new Listeners();
            this.__m_ServiceListeners = new Listeners();
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
    }

    private static void __initStatic() {
        __mapChildren = new ListMap();
        Class clazz = __mapChildren.put("EnsureServiceAction", SafeService$EnsureServiceAction.get_CLASS());
        Class clazz2 = __mapChildren.put("StartAction", SafeService$StartAction.get_CLASS());
        Class clazz3 = __mapChildren.put("Unlockable", SafeService$Unlockable.get_CLASS());
    }

    public void addMemberListener(MemberListener l) {
        block4: {
            this.ensureLocked();
            try {
                com.tangosol.net.Service service = this.getInternalService();
                if (l instanceof SynchronousListener) {
                    if (!(service != null) ? false : service.isRunning()) {
                        service.addMemberListener(l);
                    }
                    break block4;
                }
                Listeners listeners = this.getMemberListeners();
                boolean fWasEmpty = listeners.isEmpty();
                listeners.add(l);
                if (!(!fWasEmpty ? false : listeners.isEmpty() ^ true) || !(!(service != null) ? false : service.isRunning())) break block4;
                service.addMemberListener(this);
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                this.unlock();
                throw throwable;
            }
        }
        Object var3_4 = null;
        this.unlock();
    }

    public void addServiceListener(ServiceListener l) {
        block4: {
            this.ensureLocked();
            try {
                com.tangosol.net.Service service = this.getInternalService();
                if (l instanceof SynchronousListener) {
                    if (!(service != null) ? false : service.isRunning()) {
                        service.addServiceListener(l);
                    }
                    break block4;
                }
                Listeners listeners = this.getServiceListeners();
                boolean fWasEmpty = listeners.isEmpty();
                listeners.add(l);
                if (!(!fWasEmpty ? false : listeners.isEmpty() ^ true) || !(!(service != null) ? false : service.isRunning())) break block4;
                service.addServiceListener(this);
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                this.unlock();
                throw throwable;
            }
        }
        Object var3_4 = null;
        this.unlock();
    }

    protected void checkClientThread(String sMethod) {
        if (this.isServiceThread()) {
            Component._trace(new StringBuilder(String.valueOf("Application code running on \"")).append(this.getServiceName()).append("\" service thread(s) should not call ").append(sMethod).append(" as this may result in deadlock. The most common case is").append(" a CacheFactory call from a custom CacheStore implementation.").toString(), 2);
            if (Component._isTraceEnabled(7)) {
                Component._trace(new StringBuilder(String.valueOf("Stack trace:\n")).append(Component.get_StackTrace()).toString(), 7);
            }
        }
    }

    private void checkInternalAccess() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(LocalPermission.INTERNAL_SERVICE);
        }
    }

    protected void cleanup() {
        this.setInternalService(null);
        this.setContextClassLoader(null);
        this.getMemberListeners().removeAll();
        this.getServiceListeners().removeAll();
        this.getResourceRegistry().dispose();
        this.setResourceRegistry(new SimpleResourceRegistry());
    }

    public void configure(XmlElement xmlConfig) {
        this.setConfig(xmlConfig);
    }

    public void ensureGlobalLock() {
        SafeCluster cluster = this.getSafeCluster();
        cluster.ensureLocked();
        try {
            this.ensureLocked();
        }
        catch (RuntimeException e) {
            cluster.unlock();
            throw e;
        }
    }

    public void ensureLocked() {
        ServiceDependencies deps = this.getDependencies();
        long cRequestTimeout = deps == null ? 0L : deps.getRequestTimeoutMillis();
        long cTimeout = Timeout.isSet() ? Timeout.remainingTimeoutMillis() : cRequestTimeout;
        ReentrantLock lock = this.getLock();
        try {
            if (lock.tryLock(cTimeout <= (long)0 ? Long.MAX_VALUE : cTimeout, TimeUnit.MILLISECONDS)) {
                return;
            }
            throw Base.ensureRuntimeException(new RequestTimeoutException(new StringBuilder(String.valueOf("Failed to acquire service lock in ")).append(cTimeout).append("ms").toString()));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw Base.ensureRuntimeException(e, "Interrupted while attempting to acquire service lock");
        }
    }

    /*
     * Unable to fully structure code
     */
    public com.tangosol.net.Service ensureRunningService() {
        this.checkInternalAccess();
        service = this.getInternalService();
        if (service == null != false ? true : service.isRunning() ^ true) {
            fRegister = true;
            cluster = this.getSafeCluster();
            this.ensureGlobalLock();
            try {
                sName = this.getServiceName();
                sType = this.getServiceType();
                sCacheName = (InvocationService.TYPE_DEFAULT.equals(sType) != false ? true : ProxyService.TYPE_DEFAULT.equals(sType)) != false ? null : "*";
                service = this.getInternalService();
                switch (this.getSafeServiceState()) {
                    case 0: {
                        Security.checkPermission(cluster, sName, sCacheName, "join");
                        if (service == null) {
                            service = this.restartService();
                            this.setInternalService(service);
                            ** break;
lbl19:
                            // 1 sources

                        } else {
                            this.startService(service);
                            ** break;
                        }
lbl22:
                        // 1 sources

                        break;
                    }
                    case 1: {
                        Security.checkPermission(cluster, sName, sCacheName, "join");
                        if (service == null != false ? true : service.isRunning() ^ true) {
                            service = null;
                            this.setInternalService(null);
                            Component._trace(new StringBuilder(String.valueOf("Restarting Service: ")).append(this.getServiceName()).toString(), 3);
                            service = this.restartService();
                            this.setInternalService(service);
                            ** break;
lbl32:
                            // 1 sources

                        } else {
                            fRegister = false;
                            ** break;
                        }
lbl35:
                        // 1 sources

                        break;
                    }
                    case 2: {
                        throw new IllegalStateException("SafeService was explicitly stopped");
                    }
                    ** default:
lbl39:
                    // 1 sources

                    break;
                }
            }
            finally {
                var5_6 = null;
                this.unlockGlobal();
            }
            if (fRegister) {
                this.register();
            }
        }
        return service;
    }

    public Lockable.Unlockable exclusively() {
        this.ensureLocked();
        return this.getUnlockable();
    }

    public Cluster getCluster() {
        return this.getSafeCluster();
    }

    public XmlElement getConfig() {
        return this.__m_Config;
    }

    public ClassLoader getContextClassLoader() {
        ClassLoader loader = this.__m_ContextClassLoader;
        if (loader == null) {
            loader = Base.getContextClassLoader(this);
        }
        return loader;
    }

    public ServiceDependencies getDependencies() {
        return this.__m_Dependencies;
    }

    public PrivilegedAction getEnsureServiceAction() {
        return this.__m_EnsureServiceAction;
    }

    public ServiceInfo getInfo() {
        return ((com.tangosol.net.Service)this.getRunningService()).getInfo();
    }

    protected com.tangosol.net.Service getInternalService() {
        return this.__m_InternalService;
    }

    public ReentrantLock getLock() {
        return this.__m_Lock;
    }

    protected Listeners getMemberListeners() {
        return this.__m_MemberListeners;
    }

    public ResourceRegistry getResourceRegistry() {
        return this.__m_ResourceRegistry;
    }

    public com.tangosol.util.Service getRunningService() {
        if (System.getSecurityManager() == null) {
            return this.ensureRunningService();
        }
        return (com.tangosol.net.Service)AccessController.doPrivileged(new DoAsAction(this.getEnsureServiceAction()));
    }

    public SafeCluster getSafeCluster() {
        return this.__m_SafeCluster;
    }

    public int getSafeServiceState() {
        return this.__m_SafeServiceState;
    }

    public Serializer getSerializer() {
        return ((com.tangosol.net.Service)this.getRunningService()).getSerializer();
    }

    public com.tangosol.net.Service getService() {
        this.checkInternalAccess();
        return this.getInternalService();
    }

    protected Listeners getServiceListeners() {
        return this.__m_ServiceListeners;
    }

    public String getServiceName() {
        return this.__m_ServiceName;
    }

    public String getServiceType() {
        return this.__m_ServiceType;
    }

    public Subject getSubject() {
        return this.__m_Subject;
    }

    public SafeService$Unlockable getUnlockable() {
        return this.__m_Unlockable;
    }

    public Object getUserContext() {
        return this.__m_UserContext;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/SafeService".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    public static Component get_Instance() {
        return new SafeService();
    }

    private final Component get_Module() {
        return this;
    }

    public boolean isLocalService() {
        this.getSafeCluster();
        return SafeCluster.isLocalService(this.getServiceType());
    }

    public boolean isRestarting() {
        return this.__m_Restarting;
    }

    public boolean isRunning() {
        com.tangosol.net.Service service = this.getInternalService();
        return !(!(service != null) ? false : service.isRunning()) ? false : (this.isLocalService() ? true : service.getCluster().isRunning());
    }

    public boolean isServiceThread() {
        com.tangosol.net.Service _service = this.getInternalService();
        if (_service instanceof Service) {
            return ((Service)((Object)_service)).isServiceThread(false);
        }
        if (_service instanceof RemoteService) {
            return ((RemoteService)_service).isServiceThread(false);
        }
        return false;
    }

    public void memberJoined(MemberEvent evt) {
        this.translateEvent(evt);
    }

    public void memberLeaving(MemberEvent evt) {
        this.translateEvent(evt);
    }

    public void memberLeft(MemberEvent evt) {
        this.translateEvent(evt);
    }

    public void onInit() {
        this.setEnsureServiceAction((SafeService$EnsureServiceAction)this._newChild("EnsureServiceAction"));
        this.setUnlockable((SafeService$Unlockable)this._newChild("Unlockable"));
        super.onInit();
    }

    protected void register() {
        Member member;
        Registry registry = this.getSafeCluster().getManagement();
        if ((!(!(registry != null) ? false : this.getServiceType().equals("Cluster") ^ true) ? false : this.getInternalService() instanceof RemoteService ^ true) && (member = this.getSafeCluster().getLocalMember()) != null) {
            String sName = new StringBuilder(String.valueOf(Registry.SERVICE_TYPE)).append(",name=").append(this.getServiceName()).toString();
            sName = registry.ensureGlobalName(sName);
            registry.register(sName, this);
        }
    }

    public void removeMemberListener(MemberListener l) {
        block4: {
            this.ensureLocked();
            try {
                com.tangosol.net.Service service = this.getInternalService();
                if (l instanceof SynchronousListener) {
                    if (!(service != null) ? false : service.isRunning()) {
                        service.removeMemberListener(l);
                    }
                    break block4;
                }
                Listeners listeners = this.getMemberListeners();
                if (!(listeners.isEmpty() ^ true)) break block4;
                listeners.remove(l);
                if (!listeners.isEmpty() || !(!(service != null) ? false : service.isRunning())) break block4;
                service.removeMemberListener(this);
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                this.unlock();
                throw throwable;
            }
        }
        Object var3_4 = null;
        this.unlock();
    }

    public void removeServiceListener(ServiceListener l) {
        block4: {
            this.ensureLocked();
            try {
                com.tangosol.net.Service service = this.getInternalService();
                if (l instanceof SynchronousListener) {
                    if (!(service != null) ? false : service.isRunning()) {
                        service.removeServiceListener(l);
                    }
                    break block4;
                }
                Listeners listeners = this.getServiceListeners();
                if (!(listeners.isEmpty() ^ true)) break block4;
                listeners.remove(l);
                if (!listeners.isEmpty() || !(!(service != null) ? false : service.isRunning())) break block4;
                service.removeServiceListener(this);
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                this.unlock();
                throw throwable;
            }
        }
        Object var3_4 = null;
        this.unlock();
    }

    protected com.tangosol.net.Service restartService() {
        this.setRestarting(true);
        try {
            com.tangosol.net.Service service = this.getSafeCluster().instantiateService(this.getServiceName(), this.getServiceType());
            this.startService(service);
            com.tangosol.net.Service service2 = service;
            Object var3_4 = null;
            this.setRestarting(false);
            return service2;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this.setRestarting(false);
            throw throwable;
        }
    }

    public void serviceStarted(ServiceEvent evt) {
        this.translateEvent(evt);
    }

    public void serviceStarting(ServiceEvent evt) {
        this.translateEvent(evt);
    }

    public void serviceStopped(ServiceEvent evt) {
        this.translateEvent(evt);
    }

    public void serviceStopping(ServiceEvent evt) {
        this.translateEvent(evt);
    }

    public void setConfig(XmlElement xmlConfig) {
        this.__m_Config = xmlConfig;
    }

    public void setContextClassLoader(ClassLoader loader) {
        SecurityManager security = System.getSecurityManager();
        if (!(security != null) ? false : loader != null) {
            security.checkPermission(new LocalPermission("BackingMapManagerContext.setClassLoader"));
        }
        this.__m_ContextClassLoader = loader;
        com.tangosol.net.Service service = this.getInternalService();
        if (service != null) {
            service.setContextClassLoader(loader);
        }
    }

    public void setDependencies(ServiceDependencies deps) {
        this.__m_Dependencies = deps;
    }

    protected void setEnsureServiceAction(PrivilegedAction action) {
        this.__m_EnsureServiceAction = action;
    }

    public void setInternalService(com.tangosol.net.Service service) {
        this.__m_InternalService = service;
    }

    public void setLock(ReentrantLock lock) {
        this.__m_Lock = lock;
    }

    private void setMemberListeners(Listeners listeners) {
        this.__m_MemberListeners = listeners;
    }

    protected void setResourceRegistry(ResourceRegistry registry) {
        this.__m_ResourceRegistry = registry;
    }

    protected void setRestarting(boolean fRestarting) {
        this.__m_Restarting = fRestarting;
    }

    public void setSafeCluster(SafeCluster cluster) {
        this.__m_SafeCluster = cluster;
    }

    protected void setSafeServiceState(int nState) {
        this.__m_SafeServiceState = nState;
    }

    private void setServiceListeners(Listeners listeners) {
        this.__m_ServiceListeners = listeners;
    }

    public void setServiceName(String sName) {
        this.__m_ServiceName = sName;
    }

    public void setServiceType(String sType) {
        this.__m_ServiceType = sType;
    }

    public void setSubject(Subject subject) {
        this.__m_Subject = subject;
    }

    public void setUnlockable(SafeService$Unlockable unlockable) {
        this.__m_Unlockable = unlockable;
    }

    public void setUserContext(Object oCtx) {
        this.__m_UserContext = oCtx;
        com.tangosol.net.Service service = this.getInternalService();
        if (service != null) {
            service.setUserContext(oCtx);
        }
    }

    public void shutdown() {
        block3: {
            this.ensureGlobalLock();
            try {
                if (!(this.getSafeServiceState() != SERVICE_STOPPED)) break block3;
                com.tangosol.net.Service service = this.getInternalService();
                if (service != null) {
                    service.shutdown();
                }
                this.unregister();
                this.cleanup();
                this.setSafeServiceState(SERVICE_STOPPED);
            }
            catch (Throwable throwable) {
                Object var2_4 = null;
                this.unlockGlobal();
                throw throwable;
            }
        }
        Object var2_3 = null;
        this.unlockGlobal();
    }

    public void start() {
        AccessController.doPrivileged(new DoAsAction((SafeService$StartAction)this._newChild("StartAction")));
    }

    public void startInternal() {
        this.ensureGlobalLock();
        try {
            if (this.getSafeServiceState() == SERVICE_STOPPED) {
                this.setSafeServiceState(SERVICE_INITIAL);
            }
            this.ensureRunningService();
        }
        finally {
            Object var2_1 = null;
            this.setSafeServiceState(SERVICE_STARTED);
            this.unlockGlobal();
        }
    }

    protected void startService(com.tangosol.net.Service service) {
        Listeners listenersService;
        if (service instanceof RemoteService) {
            ((RemoteService)service).setOperationalContext(this.getSafeCluster());
        } else if (service instanceof Service) {
            ((Service)((Object)service)).setOperationalContext(this.getSafeCluster());
        }
        if (service instanceof Grid) {
            ((Grid)service).setResourceRegistry(this.getResourceRegistry());
        }
        service.setContextClassLoader(this.getContextClassLoader());
        try {
            XmlElement xmlConfig = this.getConfig();
            if (xmlConfig == null) {
                service.setDependencies(this.getDependencies());
            } else {
                service.configure(xmlConfig);
            }
        }
        catch (Throwable e) {
            Component._trace(new StringBuilder(String.valueOf("Error while configuring service \"")).append(this.getServiceName()).append("\": ").append(Component.getStackTrace(e)).toString(), 1);
            if (e instanceof Error) {
                throw (Error)e;
            }
            throw (RuntimeException)e;
        }
        service.setUserContext(this.getUserContext());
        Listeners listenersMember = this.getMemberListeners();
        if (listenersMember.isEmpty() ^ true) {
            service.addMemberListener(this);
        }
        if ((listenersService = this.getServiceListeners()).isEmpty() ^ true) {
            service.addServiceListener(this);
        }
        try {
            service.start();
        }
        catch (Throwable e) {
            Component._trace(new StringBuilder(String.valueOf("Error while starting service \"")).append(this.getServiceName()).append("\": ").append(Component.getStackTrace(e)).toString(), 1);
            try {
                service.stop();
            }
            catch (Throwable e2) {
                Component._trace(new StringBuilder(String.valueOf("Failed to stop service \"")).append(this.getServiceName()).append("\": ").append(Component.getStackTrace(e2)).toString(), 2);
            }
            if (e instanceof Error) {
                throw (Error)e;
            }
            throw (RuntimeException)e;
        }
    }

    public void stop() {
        block3: {
            this.ensureGlobalLock();
            try {
                if (!(this.getSafeServiceState() != SERVICE_STOPPED)) break block3;
                com.tangosol.net.Service service = this.getInternalService();
                if (service != null) {
                    service.stop();
                }
                this.cleanup();
                this.setSafeServiceState(SERVICE_STOPPED);
            }
            catch (Throwable throwable) {
                Object var2_4 = null;
                this.unlockGlobal();
                throw throwable;
            }
        }
        Object var2_3 = null;
        this.unlockGlobal();
    }

    public String toString() {
        com.tangosol.net.Service service = this.getInternalService();
        return new StringBuilder(String.valueOf(this.get_Name())).append(": ").append(service == null ? "STOPPED" : service.toString()).toString();
    }

    protected void translateEvent(MemberEvent evtMember) {
        Listeners listeners;
        com.tangosol.net.Service service = this.getInternalService();
        if (service == null) {
            this.ensureLocked();
            service = this.getInternalService();
            this.unlock();
        }
        if ((listeners = this.getMemberListeners()).isEmpty() ^ true) {
            com.tangosol.net.Service serviceSource = evtMember.getService();
            MemberEvent evtSafe = new MemberEvent(service == serviceSource ? this : serviceSource, evtMember.getId(), evtMember.getMember());
            evtSafe.dispatch(listeners);
        }
    }

    protected void translateEvent(ServiceEvent evtService) {
        Listeners listeners;
        com.tangosol.net.Service service = this.getInternalService();
        if (service == null) {
            this.ensureLocked();
            service = this.getInternalService();
            this.unlock();
        }
        if ((listeners = this.getServiceListeners()).isEmpty() ^ true) {
            com.tangosol.net.Service serviceSource = (com.tangosol.net.Service)evtService.getService();
            ServiceEvent evtSafe = new ServiceEvent(service == serviceSource ? this : serviceSource, evtService.getId());
            evtSafe.dispatch(listeners);
        }
    }

    public void unlock() {
        this.getLock().unlock();
    }

    public void unlockGlobal() {
        this.getLock().unlock();
        this.getSafeCluster().getLock().unlock();
    }

    protected void unregister() {
        Member member;
        Registry registry = this.getSafeCluster().getManagement();
        if ((!(!(registry != null) ? false : this.getServiceType().equals("Cluster") ^ true) ? false : this.getInternalService() instanceof RemoteService ^ true) && (member = this.getSafeCluster().getLocalMember()) != null) {
            String sName = new StringBuilder(String.valueOf(Registry.SERVICE_TYPE)).append(",name=").append(this.getServiceName()).toString();
            sName = registry.ensureGlobalName(sName);
            registry.unregister(sName);
        }
    }
}

