/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor;

import com.oracle.coherence.common.base.Blocking;
import com.oracle.coherence.common.base.Continuation;
import com.oracle.coherence.common.base.SingleWaiterMultiNotifier;
import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.util.Queue;
import com.tangosol.coherence.component.util.daemon.QueueProcessor;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service$EventDispatcher$Guard;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service$EventDispatcher$Queue;
import com.tangosol.coherence.config.Config;
import com.tangosol.net.GuardSupport;
import com.tangosol.net.RequestTimeoutException;
import com.tangosol.util.Base;
import com.tangosol.util.ListMap;
import com.tangosol.util.SafeLinkedList;
import com.tangosol.util.WrapperException;
import java.util.Map;

public class Service$EventDispatcher
extends QueueProcessor {
    private volatile SafeLinkedList __m_BacklogContinuations;
    private int __m_CloggedCount;
    private int __m_CloggedDelay;
    private volatile boolean __m_Dispatching;
    private volatile long __m_EventCount;
    private transient long __m_LastLogTime;
    private static ListMap __mapChildren;

    static {
        Service$EventDispatcher.__initStatic();
    }

    public Service$EventDispatcher() {
        this(null, null, true);
    }

    public Service$EventDispatcher(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setCloggedCount(1024);
            this.setCloggedDelay(32);
            this.setDaemonState(0);
            this.setDefaultGuardRecovery(0.9f);
            this.setDefaultGuardTimeout(60000L);
            this.setNotifier(new SingleWaiterMultiNotifier());
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this._addChild(new Service$EventDispatcher$Guard("Guard", this, true), "Guard");
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    private static void __initStatic() {
        __mapChildren = new ListMap();
        Class clazz = __mapChildren.put("Queue", Service$EventDispatcher$Queue.get_CLASS());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkBacklog(Continuation continuation) {
        long cMaxEvents = this.getCloggedCount();
        if (!(cMaxEvents > (long)0) ? false : (long)this.getQueue().size() > cMaxEvents) {
            if (continuation != null) {
                SafeLinkedList list = this.getBacklogContinuations();
                if (list == null) {
                    Service$EventDispatcher service$EventDispatcher = this;
                    synchronized (service$EventDispatcher) {
                        list = this.getBacklogContinuations();
                        if (list == null) {
                            list = new SafeLinkedList();
                            this.setBacklogContinuations(list);
                        }
                    }
                }
                list.add(continuation);
                Service service = (Service)this.get_Module();
                if (service.getServiceState() == Service.SERVICE_STOPPED) {
                    return list.remove(continuation) ^ true;
                }
            }
            return true;
        }
        return false;
    }

    public long drainOverflow(long cMillisTimeout) throws InterruptedException {
        return this.drainOverflow(cMillisTimeout, this.getCloggedCount());
    }

    public long drainOverflow(long cMillisTimeout, int cMaxEvents) throws InterruptedException {
        return (cMaxEvents <= 0 ? true : this.getQueue().size() < cMaxEvents) ? cMillisTimeout : this.drainOverflowComplex(cMillisTimeout, cMaxEvents);
    }

    protected long drainOverflowComplex(long cMillisTimeout, int cMaxEvents) throws InterruptedException {
        if (Thread.currentThread() == this.getThread()) {
            return cMillisTimeout;
        }
        Queue queue = this.getQueue();
        Object oHead = null;
        int cEventsPrev = 0;
        int nIter = 0;
        long lGrowthInterval = 5000L;
        long ldtGrowthCheck = 0L;
        long ldtTimeout = 0L;
        long cMillisDelay = this.getCloggedDelay();
        while (this.isStarted()) {
            int cEvents = queue.size();
            if (cEvents < cMaxEvents) break;
            long ldtNow = Base.getSafeTimeMillis();
            if (nIter == 0) {
                oHead = queue.peekNoWait();
                ldtGrowthCheck = ldtNow + lGrowthInterval;
                cEventsPrev = cEvents;
                if (cMillisTimeout != 0L) {
                    ldtTimeout = ldtNow + cMillisTimeout;
                    cMillisDelay = Math.min(cMillisDelay, cMillisTimeout);
                }
            } else if (cMillisTimeout != 0L) {
                long cMillisLeft = ldtTimeout - ldtNow;
                if (cMillisLeft <= 0L) {
                    throw new RequestTimeoutException("Request timed out");
                }
                cMillisDelay = Math.min(cMillisDelay, cMillisLeft);
            }
            Blocking.sleep(cMillisDelay);
            if (!(++nIter % 10 == 0)) continue;
            Object oHeadCurrent = queue.peekNoWait();
            if (oHead == oHeadCurrent) {
                Service service = (Service)this.get_Module();
                if (!(!(service.isStopped() ^ true) ? false : ldtNow > this.getLastLogTime() + 60000L)) break;
                Component._trace("The event queue appears to be stuck.", 2);
                GuardSupport.logStackTraces();
                this.setLastLogTime(ldtNow);
                break;
            }
            if (ldtNow > ldtGrowthCheck) {
                if (cEvents >= cEventsPrev) {
                    Component._trace(new StringBuilder(String.valueOf("The events are processed at a slower rate than they arrive.")).append(" During the last ").append(lGrowthInterval).append("ms, the event ").append(" backlog went from ").append(cEventsPrev).append(" to ").append(cEvents).toString(), 2);
                }
                ldtGrowthCheck = ldtNow + lGrowthInterval;
                cEventsPrev = cEvents;
            }
            oHead = oHeadCurrent;
        }
        return cMillisTimeout == 0L ? 0L : Math.max(1L, ldtTimeout - Base.getSafeTimeMillis());
    }

    protected void evaluateBacklog() {
        SafeLinkedList list = this.getBacklogContinuations();
        if (!(list != null) ? false : list.isEmpty() ^ true) {
            long cNormal = (this.getCloggedCount() >> 2) * 3;
            if ((long)this.getQueue().size() < cNormal) {
                Service.notifyBacklogNormal(list);
            }
        }
    }

    public SafeLinkedList getBacklogContinuations() {
        return this.__m_BacklogContinuations;
    }

    public int getCloggedCount() {
        return this.__m_CloggedCount;
    }

    public int getCloggedDelay() {
        return this.__m_CloggedDelay;
    }

    public long getEventCount() {
        return this.__m_EventCount;
    }

    public long getLastLogTime() {
        return this.__m_LastLogTime;
    }

    public String getThreadName() {
        return new StringBuilder(String.valueOf(((Service)this.get_Module()).getThreadName())).append(':').append(super.getThreadName()).toString();
    }

    public long getWaitMillis() {
        long cWait = super.getWaitMillis();
        if (this.isGuarded() ? true : this.isGuardian()) {
            long cMaxWait = 1000L;
            cWait = cWait == (long)0 ? cMaxWait : Math.min(cWait, cMaxWait);
        }
        return cWait;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/daemon/queueProcessor/Service$EventDispatcher".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    public static Component get_Instance() {
        return new Service$EventDispatcher();
    }

    private final Component get_Module() {
        return this.get_Parent();
    }

    public boolean isDispatching() {
        return this.__m_Dispatching;
    }

    protected void onEnter() {
        super.onEnter();
        if (this.isGuarded()) {
            GuardSupport.setThreadContext(this.getGuardable().getContext());
        }
    }

    protected void onException(Throwable e) {
        if (this.isExiting() ^ true) {
            Component._trace("The following exception was caught by the event dispatcher:", 1);
            Component._trace(e);
            Component._trace("(The service event thread has logged the exception and is continuing.)", 1);
        }
    }

    protected void onExit() {
        this.onNotify();
        super.onExit();
    }

    public void onInit() {
        try {
            String sMaxEvents = Config.getProperty("coherence.events.limit");
            String sDelay = Config.getProperty("coherence.events.delay");
            if (sMaxEvents != null) {
                this.setCloggedCount(Integer.parseInt(sMaxEvents));
            }
            if (sDelay != null) {
                this.setCloggedDelay(Integer.parseInt(sDelay));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.onInit();
    }

    protected void onNotify() {
        super.onNotify();
        Queue queue = this.getQueue();
        Runnable task = null;
        this.setDispatching(true);
        try {
            block8: {
                try {
                    int cEvents = 0;
                    long cMax = 1L;
                    long cSoftTimeout = (long)((float)this.getDefaultGuardTimeout() * this.getDefaultGuardRecovery());
                    long ldtStartTime = Base.getSafeTimeMillis();
                    long ldtSoftTimeout = ldtStartTime + cSoftTimeout;
                    do {
                        if ((task = (Runnable)queue.removeNoWait()) == null) {
                            Service.notifyBacklogNormal(this.getBacklogContinuations());
                            break;
                        }
                        task.run();
                        long ldtNow = Base.getSafeTimeMillis();
                        cMax = Math.max(cMax, ldtNow - ldtStartTime);
                        if (ldtNow + (cMax << 2) > ldtSoftTimeout) {
                            this.heartbeat();
                            ldtSoftTimeout = ldtNow + cSoftTimeout;
                        }
                        ldtStartTime = ldtNow;
                    } while (++cEvents < 512);
                    if (cEvents > 0) {
                        this.setEventCount(this.getEventCount() + (long)cEvents);
                    }
                    this.evaluateBacklog();
                }
                catch (Throwable e) {
                    if (!((Service)this.get_Module()).isRunning()) break block8;
                    Component._trace(new StringBuilder(String.valueOf("An exception occurred while dispatching the following event:\n")).append(String.valueOf(task)).toString(), 1);
                    this.onException(e);
                }
            }
            Object var4_7 = null;
            this.setDispatching(false);
        }
        catch (Throwable throwable) {
            Object var4_8 = null;
            this.setDispatching(false);
            throw throwable;
        }
    }

    protected void onWait() throws InterruptedException {
        if (this.isGuarded()) {
            this.heartbeat();
        }
        super.onWait();
    }

    public void resetStats() {
        this.setEventCount(0L);
    }

    protected void setBacklogContinuations(SafeLinkedList listContinuations) {
        this.__m_BacklogContinuations = listContinuations;
    }

    public void setCloggedCount(int cMaxEvents) {
        this.__m_CloggedCount = cMaxEvents;
    }

    public void setCloggedDelay(int cMillis) {
        this.__m_CloggedDelay = Math.max(1, cMillis);
    }

    protected void setDispatching(boolean fDispatching) {
        this.__m_Dispatching = fDispatching;
    }

    protected void setEventCount(long cMillis) {
        this.__m_EventCount = cMillis;
    }

    protected void setLastLogTime(long ldtLog) {
        this.__m_LastLogTime = ldtLog;
    }
}

