/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor.packetProcessor;

import com.oracle.coherence.common.base.SingleWaiterMultiNotifier;
import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.PacketBundle;
import com.tangosol.coherence.component.net.Socket;
import com.tangosol.coherence.component.util.Daemon$Guard;
import com.tangosol.coherence.component.util.Queue;
import com.tangosol.coherence.component.util.daemon.queueProcessor.PacketProcessor;
import com.tangosol.coherence.component.util.daemon.queueProcessor.packetProcessor.PacketSpeaker$BundlingQueue;
import com.tangosol.coherence.component.util.daemon.queueProcessor.packetProcessor.PacketSpeaker$InQueue;
import com.tangosol.util.Base;
import com.tangosol.util.ListMap;
import com.tangosol.util.WrapperException;
import java.util.Map;

public class PacketSpeaker
extends PacketProcessor {
    private transient long __m_StatsCpu;
    private transient long __m_StatsReset;
    private transient long __m_StatsSent;
    private static ListMap __mapChildren;

    static {
        PacketSpeaker.__initStatic();
    }

    public PacketSpeaker() {
        this(null, null, true);
    }

    public PacketSpeaker(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setDaemonState(0);
            this.setDefaultGuardRecovery(0.9f);
            this.setDefaultGuardTimeout(60000L);
            this.setNotifier(new SingleWaiterMultiNotifier());
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this._addChild(new Daemon$Guard("Guard", this, true), "Guard");
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    private static void __initStatic() {
        __mapChildren = new ListMap();
        Class clazz = __mapChildren.put("BundlingQueue", PacketSpeaker$BundlingQueue.get_CLASS());
        Class clazz2 = __mapChildren.put("InQueue", PacketSpeaker$InQueue.get_CLASS());
    }

    public String formatStats() {
        long ldtNow = Base.getSafeTimeMillis();
        long cCpu = this.getStatsCpu();
        long cTotal = ldtNow - this.getStartTimestamp();
        long lSent = this.getStatsSent();
        double dCpu = cTotal == 0L ? 0.0 : (double)cCpu / (double)cTotal;
        double dThru = cCpu == 0L ? 0.0 : (double)lSent * (double)1000 / (double)cCpu;
        dCpu = (double)((int)(dCpu * (double)1000)) / 10.0;
        return new StringBuilder(String.valueOf("Cpu=")).append(cCpu).append("ms (").append(dCpu).append("%)").append(", PacketsSent=").append(lSent).append(", Throughput=").append((int)dThru).append("pkt/sec").append(", Queued=").append(this.getQueue().size()).toString();
    }

    public long getStatsCpu() {
        return this.__m_StatsCpu;
    }

    public long getStatsReset() {
        return this.__m_StatsReset;
    }

    public long getStatsSent() {
        return this.__m_StatsSent;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/daemon/queueProcessor/packetProcessor/PacketSpeaker".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    public static Component get_Instance() {
        return new PacketSpeaker();
    }

    private final Component get_Module() {
        return this;
    }

    protected Queue instantiateQueue() {
        return (Queue)this._newChild("BundlingQueue");
    }

    protected void onEnter() {
        super.onEnter();
        ((PacketSpeaker$BundlingQueue)this.getQueue()).setSpeakerEnabled(true);
    }

    protected void onExit() {
        ((PacketSpeaker$BundlingQueue)this.getQueue()).setSpeakerEnabled(false);
        super.onExit();
    }

    protected void onNotify() {
        Queue queue = this.getQueue();
        int cPackets = 0;
        long ldtStart = System.currentTimeMillis();
        while (this.isExiting() ^ true) {
            PacketBundle bundle = (PacketBundle)queue.removeNoWait();
            if (bundle == null) {
                this.updateStats(cPackets, ldtStart);
                bundle = (PacketBundle)queue.remove();
                cPackets = 0;
                ldtStart = System.currentTimeMillis();
            }
            if ((cPackets += bundle.getAddressCount()) > 30000) {
                this.updateStats(cPackets, ldtStart);
                cPackets = 0;
                ldtStart = System.currentTimeMillis();
            }
            try {
                bundle.send();
            }
            catch (RuntimeException e) {
                if (this.isExiting()) {
                    return;
                }
                if (!(bundle.getUdpSocket().getState() != Socket.STATE_CLOSED)) continue;
                throw e;
            }
        }
    }

    protected void onWait() throws InterruptedException {
    }

    public void resetStats() {
        this.setStatsSent(0L);
        this.setStatsCpu(0L);
        this.setStatsReset(Base.getSafeTimeMillis());
        ((PacketSpeaker$BundlingQueue)this.getQueue()).resetStats();
    }

    protected void setStatsCpu(long lMillis) {
        this.__m_StatsCpu = lMillis;
    }

    protected void setStatsReset(long lMillis) {
        this.__m_StatsReset = lMillis;
    }

    protected void setStatsSent(long cPackets) {
        this.__m_StatsSent = cPackets;
    }

    public String toString() {
        return new StringBuilder(String.valueOf(this.get_Name())).append(':').append(this.formatStats()).toString();
    }

    protected void updateStats(int cPackets, long ldtStart) {
        if (cPackets > 0) {
            long lDelta = System.currentTimeMillis() - ldtStart;
            if (lDelta > (long)0) {
                this.setStatsCpu(this.getStatsCpu() + lDelta);
            }
            this.setStatsSent(this.getStatsSent() + (long)cPackets);
        }
    }
}

