/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor.service;

import com.oracle.coherence.common.base.Blocking;
import com.oracle.coherence.common.base.Continuation;
import com.oracle.coherence.common.base.Disposable;
import com.oracle.coherence.common.base.MutableLong;
import com.oracle.coherence.common.base.SingleWaiterCooperativeNotifier;
import com.oracle.coherence.common.io.BufferManager;
import com.oracle.coherence.common.io.BufferManagers;
import com.oracle.coherence.common.io.BufferSequence;
import com.oracle.coherence.common.io.Buffers;
import com.oracle.coherence.common.net.exabus.EndPoint;
import com.oracle.coherence.common.net.exabus.MessageBus;
import com.tangosol.application.ContainerHelper;
import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Cluster;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.MemberSet;
import com.tangosol.coherence.component.net.Message;
import com.tangosol.coherence.component.net.MessageHandler;
import com.tangosol.coherence.component.net.Poll;
import com.tangosol.coherence.component.net.RequestContext;
import com.tangosol.coherence.component.net.memberSet.SingleMemberSet;
import com.tangosol.coherence.component.net.memberSet.actualMemberSet.ServiceMemberSet;
import com.tangosol.coherence.component.net.memberSet.actualMemberSet.serviceMemberSet.MasterMemberSet;
import com.tangosol.coherence.component.net.message.RequestMessage;
import com.tangosol.coherence.component.util.Queue;
import com.tangosol.coherence.component.util.ServiceConfig$Map;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$Acknowledgement;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$BusEventMessage;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$ConfigRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$ConfigResponse;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$ConfigSync;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$ConfigUpdate;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$DispatchEvent;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$DispatchNotification;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$EventDispatcher;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$Guard;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$MemberConfigListener;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$MemberConfigUpdate;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$MemberJoined;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$MemberWelcome;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$MemberWelcomeRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$MemberWelcomeRequestTask;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$NotifyConnectionClose;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$NotifyConnectionOpen;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$NotifyMemberJoined;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$NotifyMemberLeaving;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$NotifyMemberLeft;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$NotifyMessageReceipt;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$NotifyPollClosed;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$NotifyResponse;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$NotifyServiceAnnounced;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$NotifyServiceJoining;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$NotifyServiceLeaving;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$NotifyServiceLeft;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$NotifyServiceQuiescence;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$NotifyShutdown;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$NotifyStartup;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$PingRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$PollArray;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$ProtocolContext;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$ReceiveQueue;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$Response;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$ServiceConfig;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$ServiceConfig$Map;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$WrapperGuardable;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService;
import com.tangosol.coherence.config.Config;
import com.tangosol.coherence.config.ResolvableParameterList;
import com.tangosol.coherence.config.builder.ParameterizedBuilder;
import com.tangosol.coherence.config.builder.ServiceFailurePolicyBuilder;
import com.tangosol.config.expression.Parameter;
import com.tangosol.internal.net.service.DefaultServiceDependencies;
import com.tangosol.internal.net.service.grid.DefaultGridDependencies;
import com.tangosol.internal.net.service.grid.GridDependencies;
import com.tangosol.internal.net.service.grid.LegacyXmlGridHelper;
import com.tangosol.internal.tracing.Scope;
import com.tangosol.internal.tracing.Span;
import com.tangosol.internal.tracing.TracingHelper;
import com.tangosol.internal.util.GridComponent;
import com.tangosol.internal.util.MessagePublisher;
import com.tangosol.internal.util.NullMessagePublisher;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.SizeEstimatingBufferOutput;
import com.tangosol.io.WrapperBufferInput;
import com.tangosol.io.WrapperBufferOutput;
import com.tangosol.io.WrapperDataInputStream;
import com.tangosol.io.WrapperDataOutputStream;
import com.tangosol.io.WrapperStreamFactory;
import com.tangosol.io.WriteBuffer;
import com.tangosol.license.LicenseException;
import com.tangosol.net.ActionPolicy;
import com.tangosol.net.GuardSupport;
import com.tangosol.net.Guardable;
import com.tangosol.net.Guardian;
import com.tangosol.net.MemberEvent;
import com.tangosol.net.MemberListener;
import com.tangosol.net.PriorityTask;
import com.tangosol.net.RequestTimeoutException;
import com.tangosol.net.ServiceDependencies;
import com.tangosol.net.ServiceFailurePolicy;
import com.tangosol.net.ServiceInfo;
import com.tangosol.net.internal.ProtocolAwareStream;
import com.tangosol.net.management.Registry;
import com.tangosol.net.security.LocalPermission;
import com.tangosol.run.component.EventDeathException;
import com.tangosol.run.xml.SimpleElement;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.util.Base;
import com.tangosol.util.ListMap;
import com.tangosol.util.Listeners;
import com.tangosol.util.LongArray;
import com.tangosol.util.ObservableMap;
import com.tangosol.util.ResourceRegistry;
import com.tangosol.util.WrapperException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;

public abstract class Grid
extends Service
implements GridComponent,
com.tangosol.net.Service {
    public static final int CONFIG_MAP_SERVICE = 1;
    public static final int MESSAGE_OFFSET = 32;
    public static final int SUID_REQUEST = 0;
    public static final long TIME_CLUSTER = -3L;
    public static final long TIME_SAFE = -2L;
    public static final long TIME_SYSTEM = -1L;
    private boolean __m_AcceptingOthers;
    private ActionPolicy __m_ActionPolicy;
    private Long __m_BaseSUIDThisMember;
    private BufferManager __m_BufferManager;
    private transient com.tangosol.net.Cluster __m_Cluster;
    private MasterMemberSet __m_ClusterMemberSet;
    private transient ConcurrentMap __m_CompletedRequestSUIDs;
    private transient MemberSet __m_DepartingMembers;
    private volatile boolean __m_InWait;
    private Listeners __m_MemberListeners;
    private Class[] __m_MessageClass;
    private Map __m_MessageClassMap;
    private MessageHandler __m_MessageHandler;
    private volatile MessagePublisher __m_MessagePublisher;
    private transient AtomicLong __m_OldestPendingRequestSUIDCounter;
    private transient Collection __m_PendingQuiescenceResponses;
    private Grid$PollArray __m_PollArray;
    private Queue __m_QueueDeferred;
    private transient Queue __m_QueueDeferredWelcome;
    private long __m_RequestTimeout;
    private ResourceRegistry __m_ResourceRegistry;
    private transient AtomicLong[] __m_SUIDCounter;
    private Grid$ServiceConfig$Map __m_ServiceConfigMap;
    private ServiceFailurePolicy __m_ServiceFailurePolicy;
    private int __m_ServiceId;
    private Map __m_ServiceLeftActions;
    private ServiceMemberSet __m_ServiceMemberSet;
    private transient long __m_StatsPollCount;
    private transient long __m_StatsPollDuration;
    private transient long __m_StatsPollMaxDuration;
    private transient long __m_StatsSent;
    private transient long __m_StatsSentLocal;
    private volatile transient long __m_StatsTimeoutCount;
    private AtomicLong __m_SuspendPollLimit;
    private Object __m_UserContext;
    private List __m_WrapperStreamFactoryAllList;
    private List __m_WrapperStreamFactoryList;
    private static ListMap __mapChildren;

    static {
        Grid.__initStatic();
    }

    public Grid(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
    }

    protected void __initPrivate() {
        super.__initPrivate();
        try {
            this.__m_MemberListeners = new Listeners();
            this.__m_QueueDeferred = new Queue();
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
    }

    private static void __initStatic() {
        __mapChildren = new ListMap();
        Class clazz = __mapChildren.put("Acknowledgement", Grid$Acknowledgement.get_CLASS());
        Class clazz2 = __mapChildren.put("BusEventMessage", Grid$BusEventMessage.get_CLASS());
        Class clazz3 = __mapChildren.put("ConfigRequest", Grid$ConfigRequest.get_CLASS());
        Class clazz4 = __mapChildren.put("ConfigResponse", Grid$ConfigResponse.get_CLASS());
        Class clazz5 = __mapChildren.put("ConfigSync", Grid$ConfigSync.get_CLASS());
        Class clazz6 = __mapChildren.put("ConfigUpdate", Grid$ConfigUpdate.get_CLASS());
        Class clazz7 = __mapChildren.put("DispatchEvent", Grid$DispatchEvent.get_CLASS());
        Class clazz8 = __mapChildren.put("DispatchNotification", Grid$DispatchNotification.get_CLASS());
        Class clazz9 = __mapChildren.put("MemberConfigUpdate", Grid$MemberConfigUpdate.get_CLASS());
        Class clazz10 = __mapChildren.put("MemberJoined", Grid$MemberJoined.get_CLASS());
        Class clazz11 = __mapChildren.put("MemberWelcome", Grid$MemberWelcome.get_CLASS());
        Class clazz12 = __mapChildren.put("MemberWelcomeRequest", Grid$MemberWelcomeRequest.get_CLASS());
        Class clazz13 = __mapChildren.put("MemberWelcomeRequestTask", Grid$MemberWelcomeRequestTask.get_CLASS());
        Class clazz14 = __mapChildren.put("NotifyConnectionClose", Grid$NotifyConnectionClose.get_CLASS());
        Class clazz15 = __mapChildren.put("NotifyConnectionOpen", Grid$NotifyConnectionOpen.get_CLASS());
        Class clazz16 = __mapChildren.put("NotifyMemberJoined", Grid$NotifyMemberJoined.get_CLASS());
        Class clazz17 = __mapChildren.put("NotifyMemberLeaving", Grid$NotifyMemberLeaving.get_CLASS());
        Class clazz18 = __mapChildren.put("NotifyMemberLeft", Grid$NotifyMemberLeft.get_CLASS());
        Class clazz19 = __mapChildren.put("NotifyMessageReceipt", Grid$NotifyMessageReceipt.get_CLASS());
        Class clazz20 = __mapChildren.put("NotifyPollClosed", Grid$NotifyPollClosed.get_CLASS());
        Class clazz21 = __mapChildren.put("NotifyResponse", Grid$NotifyResponse.get_CLASS());
        Class clazz22 = __mapChildren.put("NotifyServiceAnnounced", Grid$NotifyServiceAnnounced.get_CLASS());
        Class clazz23 = __mapChildren.put("NotifyServiceJoining", Grid$NotifyServiceJoining.get_CLASS());
        Class clazz24 = __mapChildren.put("NotifyServiceLeaving", Grid$NotifyServiceLeaving.get_CLASS());
        Class clazz25 = __mapChildren.put("NotifyServiceLeft", Grid$NotifyServiceLeft.get_CLASS());
        Class clazz26 = __mapChildren.put("NotifyServiceQuiescence", Grid$NotifyServiceQuiescence.get_CLASS());
        Class clazz27 = __mapChildren.put("NotifyShutdown", Grid$NotifyShutdown.get_CLASS());
        Class clazz28 = __mapChildren.put("NotifyStartup", Grid$NotifyStartup.get_CLASS());
        Class clazz29 = __mapChildren.put("PingRequest", Grid$PingRequest.get_CLASS());
        Class clazz30 = __mapChildren.put("ProtocolContext", Grid$ProtocolContext.get_CLASS());
        Class clazz31 = __mapChildren.put("Response", Grid$Response.get_CLASS());
        Class clazz32 = __mapChildren.put("WrapperGuardable", Grid$WrapperGuardable.get_CLASS());
    }

    public void addMemberListener(MemberListener l) {
        this.ensureEventDispatcher();
        this.getMemberListeners().add(l);
    }

    public long adjustWaitTime(long cWaitMillis, long cAdjustMillis) {
        if (cWaitMillis < 0L) {
            return Long.MAX_VALUE;
        }
        if (cAdjustMillis < 0L) {
            if (cAdjustMillis == TIME_CLUSTER) {
                cAdjustMillis = this.getClusterTime();
            } else if (cAdjustMillis == TIME_SAFE) {
                cAdjustMillis = Base.getSafeTimeMillis();
            } else if (cAdjustMillis == TIME_SYSTEM) {
                cAdjustMillis = System.currentTimeMillis();
            } else {
                throw new IllegalArgumentException(new StringBuilder(String.valueOf("Invalid adjustment: ")).append(cAdjustMillis).toString());
            }
        }
        return (cWaitMillis += cAdjustMillis) < 0L ? Long.MAX_VALUE : cWaitMillis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long calculateOldestSUID(LongArray array, int nMember) {
        long lSUID;
        long lBase = Grid.getBaseSUID(nMember);
        LongArray longArray = array;
        synchronized (longArray) {
            lSUID = array.ceilingIndex(lBase);
        }
        return (lSUID == -1L ? true : Grid.getMemberId(lSUID) != nMember) ? -1L : lSUID;
    }

    public static long calculateOldestSUID(NavigableMap mapSUID, int nMember) {
        long lBaseMember = Grid.getBaseSUID(nMember);
        Long LSUID = mapSUID.ceilingKey(new Long(lBaseMember));
        return (LSUID == null ? true : Grid.getBaseSUID(LSUID) != lBaseMember) ? -1L : LSUID;
    }

    public long calculateRequestTimeout(RequestMessage msg) {
        long cTimeoutMillis = this.getRequestTimeout();
        if (msg instanceof PriorityTask) {
            cTimeoutMillis = Service.adjustTimeout(cTimeoutMillis, ((PriorityTask)((Object)msg)).getRequestTimeoutMillis());
        }
        return cTimeoutMillis;
    }

    protected void checkShutdownPermission() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(new LocalPermission("Cluster.shutdown"));
        }
    }

    protected DefaultServiceDependencies cloneDependencies(ServiceDependencies deps) {
        return new DefaultGridDependencies((GridDependencies)deps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closePolls() {
        long lLast;
        long lFirst;
        this.getServiceConfigMap().clearPendingPolls();
        Grid$PollArray waPoll = this.getPollArray();
        waPoll.checkPolls();
        Grid$PollArray grid$PollArray = waPoll;
        synchronized (grid$PollArray) {
            lFirst = waPoll.getFirstIndex();
            lLast = waPoll.getLastIndex();
        }
        long l = lFirst;
        while (l <= lLast) {
            Poll poll = (Poll)waPoll.get(l);
            if (poll != null) {
                poll.close();
            }
            ++l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closePolls(Member member) {
        long lLast;
        long lFirst;
        Grid$PollArray waPoll;
        Component._assert(Thread.currentThread() == this.getThread());
        Grid$PollArray grid$PollArray = waPoll = this.getPollArray();
        synchronized (grid$PollArray) {
            lFirst = waPoll.getFirstIndex();
            lLast = waPoll.getLastIndex();
        }
        long l = lFirst;
        while (l <= lLast) {
            Poll poll = (Poll)waPoll.get(l);
            if (poll != null) {
                poll.onLeft(member);
            }
            ++l;
        }
    }

    public String collectTransportStats(Member member) {
        EndPoint peer;
        MessageHandler handler = this.getMessageHandler();
        if (handler != null && (peer = this.getServiceMemberSet().getServiceEndPoint(member.getId())) != null) {
            return String.valueOf(handler.getConnectionMap().get(peer));
        }
        return member.toString(Member.SHOW_STATS);
    }

    public int compareImportance(Member memberThat) {
        return 0;
    }

    public synchronized void configure(XmlElement xml) {
        this.setDependencies(LegacyXmlGridHelper.fromXml(xml, new DefaultGridDependencies(), this.getOperationalContext(), this.getContextClassLoader()));
        this.setServiceConfig(xml);
    }

    protected ResolvableParameterList createResolver() {
        ResolvableParameterList resolver = new ResolvableParameterList();
        resolver.add(new Parameter("class-loader", this.getContextClassLoader()));
        resolver.add(new Parameter("service-name", this.getServiceName()));
        com.tangosol.net.Cluster cluster = this.getCluster();
        if (cluster != null) {
            resolver.add(new Parameter("cluster-name", cluster.getClusterName()));
        }
        return resolver;
    }

    public void deferUntilServiceLeft(Member member, Continuation continuation) {
        Map mapDeferred = this.getServiceLeftActions();
        LinkedList<Continuation> listActions = (LinkedList<Continuation>)mapDeferred.get(member);
        if (listActions == null) {
            listActions = new LinkedList<Continuation>();
            mapDeferred.put(member, listActions);
        }
        listActions.add(continuation);
    }

    public boolean deserializeMessage(Message msg) {
        if (this.validateMessage(msg) ^ true) {
            return false;
        }
        try {
            try {
                ReadBuffer.BufferInput input = msg.getReadBuffer().getBufferInput();
                input.readShort();
                input.readShort();
                boolean fWrapped = this.isProtocolFiltered();
                if (fWrapped) {
                    input = this.wrapStream(input, msg);
                }
                if (input instanceof WrapperBufferInput.VersionAwareBufferInput ^ true) {
                    input = new WrapperBufferInput.VersionAwareBufferInput(input, this.getContextClassLoader(), msg);
                }
                msg.readInternal(input);
                msg.read(input);
                if (fWrapped) {
                    input.close();
                }
                boolean bl = true;
                Object var5_8 = null;
                msg.setDeserializationRequired(false);
                msg.releaseIncoming();
                return bl;
            }
            catch (Throwable e) {
                boolean bl = this.onMessageReadException(e, msg);
                Object var5_9 = null;
                msg.setDeserializationRequired(false);
                msg.releaseIncoming();
                return bl;
            }
        }
        catch (Throwable throwable) {
            Object var5_10 = null;
            msg.setDeserializationRequired(false);
            msg.releaseIncoming();
            throw throwable;
        }
    }

    public void dispatchMemberEvent(Member member, int nEvent) {
        Listeners listeners = this.getMemberListeners();
        if (listeners.isEmpty() ^ true) {
            this.dispatchEvent(new MemberEvent(this, nEvent, member), listeners);
        }
    }

    public void dispatchNotification(String sMBeanName, String sType, String sMsg, Object oData) {
        Registry registry = this.getCluster().getManagement();
        if (registry != null) {
            Grid$DispatchNotification notify = (Grid$DispatchNotification)this._newChild("DispatchNotification");
            notify.setMBeanName(sMBeanName);
            notify.setSource(this.getThisMember().toString());
            notify.setType(sType);
            notify.setMessage(sMsg);
            notify.setUserData(oData);
            this.ensureEventDispatcher().getQueue().add(notify);
        }
    }

    public void doPollClose(Poll poll) {
        if (poll.isClosed() ^ true) {
            Grid$NotifyPollClosed msgNotify = (Grid$NotifyPollClosed)this.instantiateMessage("NotifyPollClosed");
            msgNotify.setNotifyPoll(poll);
            this.send(msgNotify);
        }
    }

    public void doPollClose(Poll poll, Throwable eReason) {
        if (poll.isClosed() ^ true) {
            Grid$NotifyPollClosed msgNotify = (Grid$NotifyPollClosed)this.instantiateMessage("NotifyPollClosed");
            msgNotify.setException(eReason);
            msgNotify.setNotifyPoll(poll);
            this.send(msgNotify);
        }
    }

    public void doPollMemberLeft(Poll poll, Member member) {
        Grid$NotifyPollClosed msgNotify = (Grid$NotifyPollClosed)this.instantiateMessage("NotifyPollClosed");
        msgNotify.setNotifyPoll(poll);
        msgNotify.setNotifyMember(member);
        this.send(msgNotify);
    }

    public long drainOverflow(MemberSet setMembers, long cMillis) throws InterruptedException {
        Grid$EventDispatcher dispatcher = (Grid$EventDispatcher)this.getEventDispatcher();
        if (dispatcher != null) {
            cMillis = dispatcher.drainOverflow(cMillis);
        }
        return this.getMessagePublisher().drainOverflow(setMembers, cMillis);
    }

    public int estimateMessageSize(Message msg) throws IOException {
        int cbMsg = msg.getEstimatedByteSize();
        return cbMsg < 0 ? this.serializeMessage(msg, new SizeEstimatingBufferOutput()) : cbMsg;
    }

    public void flush() {
        MessagePublisher publisher;
        if (this.getThread() != Thread.currentThread()) {
            this.getQueue().flush();
        }
        if ((publisher = this.getMessagePublisher()) != null) {
            publisher.flush();
        }
        SingleWaiterCooperativeNotifier.flush();
    }

    public String formatStats(boolean fVerbose) {
        String sStats = this.formatStats();
        if (fVerbose) {
            sStats = new StringBuilder(String.valueOf(sStats)).append(new StringBuilder(String.valueOf(" ")).append(this.getMessagePublisher()).toString()).toString();
        }
        return sStats;
    }

    public ActionPolicy getActionPolicy() {
        return this.__m_ActionPolicy;
    }

    public static long getBaseSUID(int nMember) {
        return (long)nMember << 48;
    }

    public static long getBaseSUID(long lSUID) {
        return lSUID & 0xFFFF000000000000L;
    }

    public Long getBaseSUIDThisMember() {
        return this.__m_BaseSUIDThisMember;
    }

    public BufferManager getBufferManager() {
        return this.__m_BufferManager;
    }

    public com.tangosol.net.Cluster getCluster() {
        return this.__m_Cluster;
    }

    public MasterMemberSet getClusterMemberSet() {
        return this.__m_ClusterMemberSet;
    }

    public Member getClusterOldestMember() {
        return this.getClusterMemberSet().getOldestMember();
    }

    public ClusterService getClusterService() {
        return ((Cluster)this.getCluster()).getClusterService();
    }

    public long getClusterTime() {
        return this.getCluster().getTimeMillis();
    }

    public int getClusterTimeVariance() {
        return this.getClusterService().getTimestampMaxVariance();
    }

    public ConcurrentMap getCompletedRequestSUIDs() {
        return this.__m_CompletedRequestSUIDs;
    }

    public ServiceConfig$Map getConfigMap(int nMapType) {
        if (nMapType == CONFIG_MAP_SERVICE) {
            return this.getServiceConfigMap();
        }
        throw new IllegalArgumentException();
    }

    public MemberSet getDepartingMembers() {
        return this.__m_DepartingMembers;
    }

    public String getDescription() {
        StringBuffer sb = new StringBuffer();
        sb.append("Id=").append(this.getServiceId());
        if (!this.isRunning() ? false : this.getServiceOldestMember() != null) {
            sb.append(", OldestMemberId=").append(this.getServiceOldestMember().getId());
        }
        return sb.toString();
    }

    public String getEndPointName() {
        MessageHandler handler = this.getMessageHandler();
        return handler == null ? "" : handler.getMessageBus().getLocalEndPoint().toString();
    }

    public ServiceInfo getInfo() {
        return this.getCluster().getServiceInfo(this.getServiceName());
    }

    public static int getMemberId(long lSUID) {
        return (int)(lSUID >>> 48);
    }

    public Listeners getMemberListeners() {
        return this.__m_MemberListeners;
    }

    private Class[] getMessageClass() {
        return this.__m_MessageClass;
    }

    public Class getMessageClass(int i) {
        Class[] aClass = this.getMessageClass();
        return (!(aClass != null) ? false : (i += MESSAGE_OFFSET) < aClass.length) ? aClass[i] : null;
    }

    public Class getMessageClass(String sMsgName) {
        return (Class)this.getMessageClassMap().get(sMsgName);
    }

    public Map getMessageClassMap() {
        return this.__m_MessageClassMap;
    }

    public MessageHandler getMessageHandler() {
        return this.__m_MessageHandler;
    }

    public MessagePublisher getMessagePublisher() {
        return this.__m_MessagePublisher;
    }

    public long getOldestPendingRequestSUID() {
        return this.getOldestPendingRequestSUIDCounter().get();
    }

    public AtomicLong getOldestPendingRequestSUIDCounter() {
        return this.__m_OldestPendingRequestSUIDCounter;
    }

    public MemberSet getOthersMemberSet() {
        return this.getOthersMemberSet(ServiceMemberSet.MEMBER_NEW);
    }

    public MemberSet getOthersMemberSet(int nState) {
        ServiceMemberSet setAll = this.getServiceMemberSet();
        MemberSet setOthers = new MemberSet();
        setOthers.addAll((Collection)setAll);
        setOthers.remove(this.getThisMember());
        if (nState > ServiceMemberSet.MEMBER_NEW) {
            Iterator iter = setAll.iterator();
            while (iter.hasNext()) {
                Member member = (Member)iter.next();
                if (!(setAll.getState(member.getId()) < nState)) continue;
                setOthers.remove(member);
            }
        }
        return setOthers;
    }

    public List getOutstandingPolls(long cAgeMillis) {
        long lLast;
        Grid$PollArray waPoll = this.getPollArray();
        long lFirst = waPoll.getFirstIndex();
        if (lFirst > (lLast = waPoll.getLastIndex())) {
            return Collections.emptyList();
        }
        if (cAgeMillis <= 0L) {
            cAgeMillis = Math.max(this.getDefaultGuardTimeout(), this.getStartupTimeout()) >>> 1;
        }
        LinkedList<Poll> listPolls = new LinkedList<Poll>();
        long ldtCutoff = Base.getSafeTimeMillis() - cAgeMillis;
        long l = lFirst;
        while (l <= lLast) {
            Poll poll = (Poll)waPoll.get(l);
            if (!(poll == null ? true : poll.isClosed())) {
                if (poll.getInitTimeMillis() >= ldtCutoff) {
                    return listPolls;
                }
                listPolls.add(poll);
            }
            ++l;
        }
        return listPolls;
    }

    public Collection getPendingQuiescenceResponses() {
        return this.__m_PendingQuiescenceResponses;
    }

    public Grid$PollArray getPollArray() {
        return this.__m_PollArray;
    }

    public ProtocolAwareStream.ProtocolContext getProtocolContext(Message msg) {
        Grid$ProtocolContext context = new Grid$ProtocolContext();
        context.setMessage(msg);
        return context;
    }

    private Queue getQueueDeferred() {
        return this.__m_QueueDeferred;
    }

    public Queue getQueueDeferredWelcome() {
        return this.__m_QueueDeferredWelcome;
    }

    public long getRequestTimeout() {
        return this.__m_RequestTimeout;
    }

    public ResourceRegistry getResourceRegistry() {
        return this.__m_ResourceRegistry;
    }

    public long getSUID(int nDomain) {
        return this.getSUIDCounter(nDomain).incrementAndGet();
    }

    protected AtomicLong[] getSUIDCounter() {
        return this.__m_SUIDCounter;
    }

    protected AtomicLong getSUIDCounter(int i) {
        return this.getSUIDCounter()[i];
    }

    public int getSUIDCounterLength() {
        return 1;
    }

    public long getSUIDRange(int nDomain, int nWidth) {
        Component._assert(nWidth > 0);
        return this.getSUIDCounter(nDomain).getAndAdd(nWidth) + 1L;
    }

    public Grid$ServiceConfig$Map getServiceConfigMap() {
        Grid$ServiceConfig$Map map = this.__m_ServiceConfigMap;
        if (map == null) {
            map = (Grid$ServiceConfig$Map)((Grid$ServiceConfig)this._findChild("ServiceConfig")).getMap();
            this.setServiceConfigMap(map);
        }
        return map;
    }

    public ServiceFailurePolicy getServiceFailurePolicy() {
        return this.__m_ServiceFailurePolicy;
    }

    public int getServiceId() {
        return this.__m_ServiceId;
    }

    public Map getServiceLeftActions() {
        return this.__m_ServiceLeftActions;
    }

    public ServiceMemberSet getServiceMemberSet() {
        return this.__m_ServiceMemberSet;
    }

    public Member getServiceOldestMember() {
        ServiceMemberSet setMember = this.getServiceMemberSet();
        return setMember == null ? null : setMember.getOldestMember();
    }

    public String getServiceType() {
        return null;
    }

    public String getServiceVersion() {
        return "";
    }

    public long getStartupTimeout() {
        long cMillis = super.getStartupTimeout();
        if (cMillis <= 0L) {
            cMillis = Long.parseLong(Config.getProperty("coherence.service.startuptimeout", "0"));
            if (cMillis <= 0L) {
                cMillis = this.getClusterService().getDeliveryTimeoutMillis();
            }
            this.setStartupTimeout(cMillis);
        }
        return cMillis;
    }

    public long getStatsPollCount() {
        return this.__m_StatsPollCount;
    }

    public long getStatsPollDuration() {
        return this.__m_StatsPollDuration;
    }

    public long getStatsPollMaxDuration() {
        return this.__m_StatsPollMaxDuration;
    }

    public long getStatsSent() {
        return this.__m_StatsSent;
    }

    public long getStatsSentLocal() {
        return this.__m_StatsSentLocal;
    }

    public long getStatsTimeoutCount() {
        return this.__m_StatsTimeoutCount;
    }

    public AtomicLong getSuspendPollLimit() {
        return this.__m_SuspendPollLimit;
    }

    public Member getThisMember() {
        MasterMemberSet setMembers = this.getClusterMemberSet();
        return setMembers == null ? null : setMembers.getThisMember();
    }

    public ObservableMap getThisMemberConfigMap() {
        Member memberThis = this.getThisMember();
        if (memberThis == null) {
            return null;
        }
        ServiceMemberSet setMemberService = this.getServiceMemberSet();
        return setMemberService == null ? this.getClusterService().getServiceInfo(this.getServiceId()).getMemberSet().ensureMemberConfigMap(memberThis.getId()) : setMemberService.ensureMemberConfigMap(memberThis.getId());
    }

    public String getThreadName() {
        String sServiceType = this.getServiceType();
        String sServiceName = this.getServiceName();
        return sServiceName.equals(sServiceType) ? sServiceName : new StringBuilder(String.valueOf(sServiceType)).append(':').append(sServiceName).toString();
    }

    public Object getUserContext() {
        return this.__m_UserContext;
    }

    public long getWaitMillis() {
        long cWait = super.getWaitMillis();
        if (this.isGuardian()) {
            long ldtNow = Base.getLastSafeTimeMillis();
            long cGuardMillis = Math.max(1L, this.getGuardSupport().getNextCheckTime() - ldtNow);
            cWait = cWait == (long)0 ? cGuardMillis : Math.min(cWait, cGuardMillis);
        } else if (this.isGuarded()) {
            cWait = cWait == (long)0 ? 1000L : Math.min(cWait, 1000L);
        }
        return cWait == 0L ? 1000L : cWait;
    }

    public List getWrapperStreamFactoryAllList() {
        return this.__m_WrapperStreamFactoryAllList;
    }

    public List getWrapperStreamFactoryList() {
        return this.__m_WrapperStreamFactoryList;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/daemon/queueProcessor/service/Grid".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    private final Component get_Module() {
        return this;
    }

    public Guardian.GuardContext guard(Guardable guardable, long cMillis, float flPctRecover) {
        if (guardable instanceof Grid$Guard) {
            Grid service = (Grid)((Grid$Guard)guardable).get_Parent();
            guardable = service.instantiateWrapperGuardable(guardable);
        } else {
            guardable = this.instantiateWrapperGuardable(guardable);
        }
        return super.guard(guardable, cMillis, flPctRecover);
    }

    protected XmlElement initServiceConfig() {
        return new SimpleElement("config");
    }

    protected void initializeSUID() {
        int nMember = this.getThisMember().getId();
        long lMillis = this.getClusterTime();
        long lFirst = (long)nMember << 48 | lMillis & 0xFFFFFFFFFFFFL;
        AtomicLong[] aCounter = new AtomicLong[this.getSUIDCounterLength()];
        int i = 0;
        int c = aCounter.length;
        while (i < c) {
            AtomicLong counter;
            aCounter[i] = counter = new AtomicLong(lFirst);
            ++i;
        }
        this.setSUIDCounter(aCounter);
        this.setBaseSUIDThisMember(new Long(lFirst));
        this.setOldestPendingRequestSUIDCounter(new AtomicLong(lFirst + 1L));
    }

    public void initializeTransport() {
        Cluster cluster = (Cluster)this.getCluster();
        String sTransport = ((GridDependencies)this.getDependencies()).getReliableTransport();
        if (Cluster.TRANSPORT_DATAGRAM.equals(sTransport)) {
            this.setMessagePublisher(cluster.getPublisher());
        } else {
            MessageHandler handler = this.getMessageHandler();
            MessageBus bus = cluster.createMessageBus(this.getServiceType(), sTransport);
            if (handler != null) {
                Component._trace(new StringBuilder(String.valueOf("Service ")).append(this.getServiceName()).append(" unbound from ").append(handler.getMessageBus().getLocalEndPoint()).toString(), 3);
                this.setMessageHandler(null);
                handler.close();
            }
            if (bus == null) {
                this.setMessagePublisher(cluster.getMessagePublisher());
            } else {
                handler = this.instantiateMessageHandler();
                handler.initialize(this, bus, cluster.getMessagePublisher());
                this.setMessagePublisher(handler);
                this.setMessageHandler(handler);
                this.setDepartingMembers(new MemberSet());
                Component._trace(new StringBuilder(String.valueOf("Service ")).append(this.getServiceName()).append(" is bound to ").append(bus.getLocalEndPoint()).toString(), 5);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public Message instantiateMessage(int nMsgType) {
        Class clz = this.getMessageClass(nMsgType);
        if (clz == null) {
            throw new RuntimeException(new StringBuilder(String.valueOf("Service ")).append(this.getServiceName()).append(" was unable to instantiate MessageType=").append(nMsgType).toString());
        }
        try {
            void e;
            Message msg = (Message)clz.newInstance();
            msg.setService(this);
            return e;
        }
        catch (Exception e) {
            throw Base.ensureRuntimeException(e);
        }
    }

    /*
     * WARNING - void declaration
     */
    public Message instantiateMessage(String sMsgName) {
        Class clz = this.getMessageClass(sMsgName);
        if (clz == null) {
            throw new IllegalArgumentException(new StringBuilder(String.valueOf("Unable to instantiate Message \"")).append(sMsgName).append('\"').toString());
        }
        try {
            void e;
            Message msg = (Message)clz.newInstance();
            msg.setService(this);
            return e;
        }
        catch (Exception e) {
            throw Base.ensureRuntimeException(e);
        }
    }

    protected MessageHandler instantiateMessageHandler() {
        return new MessageHandler();
    }

    protected Queue instantiateQueue() {
        return (Grid$ReceiveQueue)this._findChild("ReceiveQueue");
    }

    public RequestContext instantiateRequestContext() {
        return new RequestContext();
    }

    public Grid$WrapperGuardable instantiateWrapperGuardable(Guardable guardable) {
        Grid$WrapperGuardable wrapper = (Grid$WrapperGuardable)this._newChild("WrapperGuardable");
        wrapper.setGuardable(guardable);
        return wrapper;
    }

    public boolean isAcceptingOthers() {
        return this.__m_AcceptingOthers;
    }

    public boolean isClusterThread(boolean fStrict) {
        Thread threadService = this.getThread();
        if (threadService == null) {
            return false;
        }
        ThreadGroup groupCluster = threadService.getThreadGroup();
        ThreadGroup groupThis = Thread.currentThread().getThreadGroup();
        return fStrict ? groupCluster == groupThis : groupCluster.parentOf(groupThis);
    }

    public boolean isCoherenceThread() {
        return GuardSupport.getThreadContext() != null;
    }

    public boolean isInWait() {
        return this.__m_InWait;
    }

    public boolean isProtocolFiltered() {
        return this.getWrapperStreamFactoryAllList() != null ? true : this.getWrapperStreamFactoryList() != null;
    }

    public boolean isSuspended() {
        return this.getSuspendPollLimit().get() != Long.MAX_VALUE;
    }

    public boolean isSuspendedFully() {
        long lLast = this.getSuspendPollLimit().get();
        if (lLast < Long.MAX_VALUE) {
            Grid$PollArray aPoll = this.getPollArray();
            long lNext = aPoll.getFirstIndex();
            while (lNext <= lLast) {
                RequestMessage msg;
                Poll poll = (Poll)aPoll.get(lNext);
                if (poll != null && (!((msg = (RequestMessage)poll.get_Parent()) != null) ? false : msg.isSuspendable())) {
                    return false;
                }
                ++lNext;
            }
            return true;
        }
        return false;
    }

    public boolean isVersionCompatible(Member member, int nMajor, int nMinor, int nMicro, int nPatchSet, int nPatch) {
        int nVersion = ServiceMemberSet.encodeVersion(nMajor, nMinor, nMicro, nPatchSet, nPatch);
        return this.getClusterMemberSet().getServiceVersionInt(member.getId()) >= nVersion;
    }

    public boolean isVersionCompatible(MemberSet setMembers, int nMajor, int nMinor, int nMicro, int nPatchSet, int nPatch) {
        MasterMemberSet setMaster = this.getClusterMemberSet();
        int nVersion = ServiceMemberSet.encodeVersion(nMajor, nMinor, nMicro, nPatchSet, nPatch);
        switch (setMembers.size()) {
            case 0: {
                return true;
            }
            case 1: {
                return setMaster.getServiceVersionInt(setMembers.getFirstId()) >= nVersion;
            }
        }
        int[] anMember = setMembers.toIdArray();
        int i = 0;
        int c = anMember.length;
        while (i < c) {
            if (setMaster.getServiceVersionInt(anMember[i]) < nVersion) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isWelcomedBy(Member member) {
        return this.getServiceMemberSet().isMemberConfigured(member.getId());
    }

    protected void notifyServiceJoined() {
        ClusterService clusterService = this.getClusterService();
        if (clusterService != this) {
            int nIdThis = this.getThisMember().getId();
            this.getServiceMemberSet().setServiceJoined(nIdThis);
            Grid$MemberJoined msg = (Grid$MemberJoined)this.instantiateMessage("MemberJoined");
            msg.setMemberId(nIdThis);
            msg.setToMemberSet(this.getOthersMemberSet());
            this.send(msg);
            clusterService.doServiceJoined(this);
        }
    }

    public void onConfigIOException(IOException e, Member member) {
        StringBuffer sb = new StringBuffer();
        if (this.getServiceId() == 0) {
            sb.append("Failed to deserialize the config Message received from member ").append(member.getId()).append(". This member is configured with the following serializer: ").append(this.getSerializer()).append(", which may be incompatible with the serializer configured by the sender.");
        } else {
            sb.append(new StringBuilder(String.valueOf("The service \"")).append(this.getServiceName()).append('\"').toString());
            String sSerializerThat = (String)this.getServiceMemberSet().getMemberConfigMap(member.getId()).get("Serializer");
            sb.append(" is configured to use serializer ").append(this.getSerializer()).append(", which appears to be different from ").append(sSerializerThat == null ? "the serializer" : (sSerializerThat.length() == 0 ? "default serializer" : sSerializerThat)).append(" used by ").append(member).append('.');
        }
        if (member == this.getServiceOldestMember()) {
            sb.append('\n').append(Component.getStackTrace(e)).append("Stopping the ").append(this.getServiceName()).append(" service.");
            Component._trace(sb.toString(), 1);
            this.stop();
        } else {
            Component._trace(sb.toString(), 3);
        }
    }

    protected void onDependencies(ServiceDependencies deps) {
        List<ParameterizedBuilder<MemberListener>> listBuilder;
        ServiceFailurePolicyBuilder builder;
        super.onDependencies(deps);
        GridDependencies depsGrid = (GridDependencies)deps;
        ActionPolicy policyAction = (ActionPolicy)depsGrid.getActionPolicyBuilder().realize(this.createResolver(), this.getContextClassLoader(), null);
        this.setActionPolicy(policyAction);
        this.setRequestTimeout(depsGrid.getRequestTimeoutMillis());
        long cTimeoutMillis = depsGrid.getDefaultGuardTimeoutMillis();
        if (cTimeoutMillis > (long)0) {
            cTimeoutMillis = Math.max(cTimeoutMillis, GuardSupport.GUARDIAN_MAX_CHECK_INTERVAL);
            this.setDefaultGuardTimeout(cTimeoutMillis);
        }
        if ((builder = depsGrid.getServiceFailurePolicyBuilder()) != null) {
            this.setServiceFailurePolicy(builder.realize(this.createResolver(), this.getContextClassLoader(), null));
        }
        if ((listBuilder = depsGrid.getMemberListenerBuilders()) != null) {
            Iterator<ParameterizedBuilder<MemberListener>> iter = listBuilder.iterator();
            while (iter.hasNext()) {
                ParameterizedBuilder<MemberListener> bldr = iter.next();
                this.addMemberListener(bldr.realize(this.createResolver(), this.getContextClassLoader(), null));
            }
        }
    }

    protected void onEnter() {
        this.setStartTimestamp(Base.getSafeTimeMillis());
        this.resetStats();
        ContainerHelper.initializeThreadContext(this);
        this.initializeTransport();
        if (this.getServiceId() > 0) {
            this.initializeSUID();
            this.setQueueDeferredWelcome(new Queue());
            this.setServiceLeftActions(new HashMap());
            this.getThisMemberConfigMap().put("Serializer", this.ensureSerializer().getClass().getName());
        }
        this.getActionPolicy().init(this);
        this.setServiceState(Service.SERVICE_STARTING);
        this.post(this.instantiateMessage("NotifyStartup"));
    }

    public void onException(Throwable e) {
        TracingHelper.augmentSpanWithErrorDetails(TracingHelper.getActiveSpan(), true, e);
        super.onException(e);
    }

    protected void onExit() {
        Message msg;
        super.onExit();
        MessageHandler handler = this.getMessageHandler();
        if (handler != null) {
            handler.close();
        }
        Queue queue = this.getQueue();
        while (!((msg = (Message)queue.removeNoWait()) == null)) {
            if (!msg.isDeserializationRequired()) continue;
            msg.releaseIncoming();
        }
    }

    public void onInit() {
        super.onInit();
        this.setCompletedRequestSUIDs(new ConcurrentHashMap(16, 0.75f, Runtime.getRuntime().availableProcessors() * 3));
        Map map = ((Component)this).get_ChildClasses();
        Class clzMessage = Message.get_CLASS();
        Iterator iter = map.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String sMsgName = (String)entry.getKey();
            Class clz = (Class)entry.getValue();
            if (!clzMessage.isAssignableFrom(clz)) continue;
            this.registerMessageType(sMsgName, clz);
        }
        Grid$PollArray waPoll = (Grid$PollArray)this._findChild("PollArray");
        this.setPollArray(waPoll);
        waPoll.remove(waPoll.add(new Poll()));
        this.getSuspendPollLimit().set(Long.MAX_VALUE);
    }

    protected void onInterval() {
        MessageHandler handler;
        this.getPollArray().checkPolls();
        Collection colQuiescenceResp = this.getPendingQuiescenceResponses();
        if (!(colQuiescenceResp != null) ? false : this.isSuspendedFully()) {
            Iterator iter = colQuiescenceResp.iterator();
            while (iter.hasNext()) {
                Grid$NotifyResponse msgResp = (Grid$NotifyResponse)iter.next();
                this.post(msgResp);
            }
            this.setPendingQuiescenceResponses(null);
        }
        if ((handler = this.getMessageHandler()) != null) {
            handler.onInterval();
        }
        super.onInterval();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onMessage(Message msg) {
        if (!(msg != null)) return;
        try {
            Poll poll;
            boolean bl;
            if (this.validateMessage(msg) ^ true) {
                return;
            }
            Member memberFrom = msg.getFromMember();
            if (memberFrom != null) {
                MemberSet.readBarrier(memberFrom.getId());
            }
            this.setStatsReceived(this.getStatsReceived() + 1L);
            Span span = null;
            Scope scope = null;
            if (!(msg instanceof RequestMessage) ? false : TracingHelper.isEnabled()) {
                span = this.newTracingSpan(msg instanceof Runnable ? "dispatch" : "process", msg).setParent(((RequestMessage)msg).getTracingSpanContext()).withMetadata("member.source", memberFrom == null ? -1 : memberFrom.getId()).startSpan();
                scope = TracingHelper.getTracer().withSpan(span);
            }
            try {
                try {
                    msg.onReceived();
                }
                catch (EventDeathException e) {
                    if (msg instanceof RequestMessage) {
                        String sMsg = new StringBuilder(String.valueOf("Processing for RequestMessage has been interrupted:\n")).append(msg).toString();
                        span.log(sMsg);
                        Component._trace(sMsg, 2);
                        Component._trace(Component.getStackTrace(e), 4);
                    }
                }
                catch (Throwable t) {
                    TracingHelper.augmentSpanWithErrorDetails(span, true, t);
                    throw t;
                }
                Object var6_10 = null;
                bl = scope != null;
            }
            catch (Throwable t) {
                Object var6_11 = null;
                if (!(scope != null)) throw t;
                scope.close();
                span.end();
                throw t;
            }
            if (bl) {
                scope.close();
                span.end();
            }
            if (!((poll = msg.getPoll()) != null)) return;
            poll.onResponse(msg);
            return;
        }
        catch (Throwable e) {
            this.onException(e);
            return;
        }
    }

    protected boolean onMessageReadException(Throwable e, Message msg) {
        if (e instanceof SecurityException) {
            Component._trace(new StringBuilder(String.valueOf("SecurityException received while reading ")).append(msg).append("\n").append(Component.getStackTrace(e)).toString(), 1);
        } else {
            Component._trace(new StringBuilder(String.valueOf("An exception (")).append(e.getClass().getName()).append("): '").append(e.getMessage()).append("', occurred reading Message ").append(msg.get_Name()).append(" Type=").append(msg.getMessageType()).append(" for Service=").append(this).append(" from ").append(msg.getFromMember()).append(" with read buffer=").append(Buffers.toString(msg.getReadBuffer().toByteBuffer(), 1024 * 1024)).toString(), 1);
            this.onException(e);
        }
        return false;
    }

    public void onMessageReceipt(Message msg) {
        if (msg != null && !(!((Grid$ReceiveQueue)this.getQueue()).isPreprocessingEnabled() ? false : msg.preprocessSentNotification())) {
            Grid$NotifyMessageReceipt msgRecpt = (Grid$NotifyMessageReceipt)this.instantiateMessage("NotifyMessageReceipt");
            msgRecpt.setNotifyMessage(msg);
            this.post(msgRecpt);
        }
    }

    protected void onNotify() {
        long lStart = Base.getLastSafeTimeMillis();
        Queue queueDeferred = this.getQueueDeferred();
        Queue queueIn = this.getQueue();
        int i = 0;
        while (i < 512) {
            Message msg = queueDeferred == null ? (Message)queueIn.removeNoWait() : this.processDeferredQueue();
            if (msg == null) break;
            if (msg.isDeserializationRequired() ^ true ? true : this.deserializeMessage(msg)) {
                this.onMessage(msg);
            }
            ++i;
        }
        this.setStatsCpu(this.getStatsCpu() + (Base.getSafeTimeMillis() - lStart));
        super.onNotify();
    }

    public void onNotifyServiceJoined(Member member) {
        int nMember = member.getId();
        ServiceMemberSet setMember = this.getServiceMemberSet();
        Member memberOldest = setMember.getOldestMember();
        Component._trace(new StringBuilder(String.valueOf("Member ")).append(nMember).append(" joined Service ").append(this.getServiceName()).append(" with senior member ").append(memberOldest == null ? "n/a" : String.valueOf(memberOldest.getId())).toString(), 3);
        setMember.setServiceJoined(nMember);
        this.dispatchMemberEvent(member, MemberEvent.MEMBER_JOINED);
    }

    public void onNotifyServiceLeft(Member member) {
        int nMember = member.getId();
        ServiceMemberSet setMember = this.getServiceMemberSet();
        boolean fJoining = setMember.isServiceJoining(nMember);
        Member memberOldest = this.getServiceOldestMember();
        Component._trace(new StringBuilder(String.valueOf("Member ")).append(member.getId()).append(setMember.getState(nMember) == ServiceMemberSet.MEMBER_JOINING ? " aborted joining" : " left").append(" service ").append(this.getServiceName()).append(" with senior member ").append(memberOldest == null ? "n/a" : String.valueOf(memberOldest.getId())).toString(), 3);
        boolean fOldest = member == memberOldest;
        setMember.remove(member);
        this.closePolls(member);
        this.getServiceConfigMap().onServiceLeft(member, fOldest);
        MemberSet setDeparting = this.getDepartingMembers();
        if (!(setDeparting != null) ? false : setDeparting.remove(member)) {
            this.processDeferredWelcomes();
        }
        if (!fJoining) {
            this.dispatchMemberEvent(member, MemberEvent.MEMBER_LEFT);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onNotifyServiceQuiescence(boolean fResume, boolean fResumeOnFailover) {
        AtomicLong atlSuspend = this.getSuspendPollLimit();
        if (fResume ^ this.isSuspended()) {
            return;
        }
        if (fResume) {
            AtomicLong atomicLong = atlSuspend;
            synchronized (atomicLong) {
                atlSuspend.set(Long.MAX_VALUE);
                atlSuspend.notifyAll();
            }
        } else {
            atlSuspend.set(this.getPollArray().getLastIndex());
        }
        Component._trace(new StringBuilder(String.valueOf("Service ")).append(this.getServiceName()).append(" has been ").append(fResume ? "resumed" : "suspended").toString(), 5);
    }

    public void onPollClosed(Poll poll) {
        this.unregisterPoll(poll);
    }

    public void onServiceStarted() {
        if (this.validateServiceConfig()) {
            this.getServiceConfigMap().getConfig().attachConfigListener();
            this.notifyServiceJoined();
            this.setAcceptingOthers(true);
            this.setAcceptingClients(true);
        } else {
            this.post(this.instantiateMessage("NotifyShutdown"));
        }
    }

    protected void onServiceState(int nState) {
        ClusterService clusterservice = this.getClusterService();
        switch (nState) {
            case 1: {
                this.onServiceStarting();
                break;
            }
            case 2: {
                if (this == clusterservice) {
                    this.onServiceStarted();
                    break;
                }
                clusterservice.doServiceJoining(this);
                Member memberSenior = this.getServiceOldestMember();
                Component._trace(new StringBuilder(String.valueOf("Service ")).append(this.getServiceName()).append(" joined the cluster with ").append("senior service member ").append(memberSenior.getId()).toString(), 3);
                this.getThisMemberConfigMap().addMapListener((Grid$MemberConfigListener)this._findChild("MemberConfigListener"));
                MessageHandler handler = this.getMessageHandler();
                if (handler != null) {
                    handler.connectAll();
                }
                if (this.getThisMember() == memberSenior) {
                    this.onServiceStarted();
                    break;
                }
                Grid$MemberWelcomeRequest msg = (Grid$MemberWelcomeRequest)this.instantiateMessage("MemberWelcomeRequest");
                msg.setSenderMemberSet(this.getServiceMemberSet());
                msg.setToMemberSet(this.getOthersMemberSet());
                this.post(msg);
                break;
            }
            case 3: {
                this.getServiceMemberSet().setServiceLeaving(this.getThisMember().getId());
                this.onServiceStopping();
                clusterservice.doServiceLeaving(this);
                break;
            }
            case 4: {
                try {
                    this.onServiceStopped();
                    this.closePolls();
                    break;
                }
                finally {
                    Object var4_6 = null;
                    clusterservice.doServiceLeft(this);
                    Component._trace(new StringBuilder(String.valueOf("Service ")).append(this.getServiceName()).append(" left the cluster").toString(), 3);
                }
            }
        }
    }

    protected void onStartupTimeout() {
        throw new RequestTimeoutException(new StringBuilder(String.valueOf("Timeout during service start: ")).append(this.getInfo()).toString());
    }

    protected void onWait() throws InterruptedException {
        this.flush();
        this.setInWait(true);
        try {
            super.onWait();
            this.setInWait(false);
        }
        catch (InterruptedException e) {
            this.setInWait(false);
            throw e;
        }
    }

    public Object poll(RequestMessage msg) {
        return this.poll(msg, msg.checkTimeoutRemaining());
    }

    public Object poll(RequestMessage msg, long cMillisTimeout) {
        Component._assert(this.getThread() != Thread.currentThread(), "this is a blocking operation and cannot be called on the Service thread");
        this.waitAcceptingClients();
        long ldtStart = cMillisTimeout == 0L ? 0L : Base.getSafeTimeMillis();
        long cMillisWait = cMillisTimeout;
        Poll poll = msg.ensureRequestPoll();
        try {
            try {
                if (msg.isSuspendable() && poll.getPollId() > this.getSuspendPollLimit().get()) {
                    cMillisWait = poll.waitServiceResume(ldtStart, cMillisWait);
                }
                this.send(msg);
                this.drainOverflow(msg.getToMemberSet(), cMillisWait);
                Object object = poll.waitCompletion(ldtStart, cMillisTimeout);
                Object var10_9 = null;
                this.doPollClose(poll);
                return object;
            }
            catch (InterruptedException e) {
                if (this.isCoherenceThread()) {
                    this.heartbeat();
                    Thread.interrupted();
                } else {
                    Thread.currentThread().interrupt();
                }
                throw this.processPollInterrupt(new RequestMessage[]{msg}, e);
            }
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            this.doPollClose(poll);
            throw throwable;
        }
    }

    public void poll(Collection colMsgs, long cMillisTimeout) {
        if (!(colMsgs != null) ? false : colMsgs.isEmpty() ^ true) {
            RequestMessage[] aMsgs = new RequestMessage[colMsgs.size()];
            int i = 0;
            Iterator it = colMsgs.iterator();
            while (it.hasNext()) {
                aMsgs[i++] = (RequestMessage)it.next();
            }
            this.poll(aMsgs, cMillisTimeout);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void poll(RequestMessage[] aMsgs, long cMillisTimeout) {
        block17: {
            block18: {
                Component._assert(this.getThread() != Thread.currentThread(), "this is a blocking operation and cannot be called on the Service thread");
                this.waitAcceptingClients();
                ldtStart = cMillisTimeout == 0L != false ? 0L : Base.getSafeTimeMillis();
                cMillisWait = cMillisTimeout;
                cMsg = aMsgs.length;
                try {
                    try {
                        pollMax = null;
                        lPollIdMax = 0L;
                        i = 0;
                        while (i < cMsg) {
                            msg = aMsgs[i];
                            if (msg.isSuspendable() && (lPollId = (poll = msg.ensureRequestPoll()).getPollId()) > lPollIdMax) {
                                lPollIdMax = lPollId;
                                pollMax = poll;
                            }
                            ++i;
                        }
                        if (lPollIdMax != 0L == false ? false : lPollIdMax > this.getSuspendPollLimit().get()) {
                            cMillisWait = pollMax.waitServiceResume(ldtStart, cMillisWait);
                        }
                        cbPending = 0L;
                        nLast = -1;
                        i = 0;
                        while (i < cMsg) {
                            msg = aMsgs[i];
                            if ((cbPending = this.post(msg, cbPending)) == -1L) {
                                j = nLast + 1;
                                while (j <= i) {
                                    cMillisWait = this.drainOverflow(aMsgs[j].getToMemberSet(), cMillisWait);
                                    ++j;
                                }
                                cbPending = 0L;
                                nLast = i;
                            }
                            ++i;
                        }
                        this.flush();
                        i = nLast + 1;
                        while (i < cMsg) {
                            cMillisWait = this.drainOverflow(aMsgs[i].getToMemberSet(), cMillisWait);
                            ++i;
                        }
                        i = cMsg - 1;
                        while (i >= 0) {
                            aMsgs[i].getRequestPoll().waitCompletion(ldtStart, cMillisTimeout);
                            --i;
                        }
                        aMsgs = null;
                    }
                    catch (InterruptedException e) {
                        if (this.isCoherenceThread()) {
                            this.heartbeat();
                            Thread.interrupted();
                        } else {
                            Thread.currentThread().interrupt();
                        }
                        throw this.processPollInterrupt(aMsgs, e);
                    }
                    var10_10 = null;
                    ** if (!(aMsgs != null)) goto lbl-1000
                }
                catch (Throwable var9_8) {
                    var10_11 = null;
                    if (!(aMsgs != null)) break block18;
                    i = 0;
                    ** while (i < cMsg)
                }
lbl-1000:
                // 1 sources

                {
                    i = 0;
                    while (i < cMsg) {
                        this.doPollClose(aMsgs[i].ensureRequestPoll());
                        ++i;
                    }
                }
lbl-1000:
                // 2 sources

                {
                    break block17;
                }
lbl-1000:
                // 1 sources

                {
                    this.doPollClose(aMsgs[i].ensureRequestPoll());
                    ++i;
                    continue;
                }
            }
            throw var9_8;
        }
    }

    public void post(Message msg) {
        msg.setService(this);
        msg.post();
    }

    public long post(Message msg, long cbPending) {
        long cbMsg;
        this.post(msg);
        Disposable bufferController = msg.getBufferController();
        long l = cbMsg = bufferController instanceof BufferSequence ? ((BufferSequence)bufferController).getLength() : (long)(bufferController instanceof WriteBuffer ? ((WriteBuffer)((Object)bufferController)).length() : 0);
        if ((cbPending += cbMsg) > Math.max((long)(256 * 1024 * 1024), BufferManagers.getDirectManager().getCapacity() / (long)Runtime.getRuntime().availableProcessors())) {
            this.flush();
            cbPending = -1;
        }
        return cbPending;
    }

    protected Message processDeferredQueue() {
        Queue queueDeferred = this.getQueueDeferred();
        Message msg = null;
        if (this.isAcceptingOthers()) {
            if (queueDeferred != null && (msg = (Message)queueDeferred.removeNoWait()) == null) {
                this.setQueueDeferred(null);
            }
        } else {
            msg = (Message)this.getQueue().removeNoWait();
            if (!(msg != null) ? false : msg.isInternal() ^ true) {
                queueDeferred.add(msg);
                msg = null;
            }
        }
        return msg;
    }

    protected void processDeferredWelcomes() {
        MemberSet setDeparting = this.getDepartingMembers();
        if (setDeparting == null ? true : setDeparting.isEmpty()) {
            Object msg;
            Queue queue = this.getQueueDeferredWelcome();
            LinkedList<Object> listMsg = null;
            while (!((msg = queue.removeNoWait()) == null)) {
                if (listMsg == null) {
                    listMsg = new LinkedList<Object>();
                }
                listMsg.add(msg);
            }
            if (listMsg != null) {
                Iterator iter = listMsg.iterator();
                while (iter.hasNext()) {
                    ((Grid$MemberWelcomeRequest)iter.next()).onReceived();
                }
            }
        }
    }

    protected RuntimeException processPollInterrupt(RequestMessage[] aMsgs, InterruptedException e) {
        StringBuilder sbLog = new StringBuilder();
        TreeMap<Integer, String> mapMbrs = new TreeMap<Integer, String>();
        sbLog.append("This thread was interrupted while waiting for the results ").append("of a request:\n");
        int i = 0;
        int c = aMsgs.length;
        while (i < c) {
            Poll poll = aMsgs[i].ensureRequestPoll();
            if (poll.isClosed() ^ true) {
                sbLog.append(poll.toString());
                sbLog.append(',');
                int[] anMbr = poll.getRemainingMemberSet().toIdArray();
                int j = 0;
                while (j < anMbr.length) {
                    int nMemberId = anMbr[j];
                    Member member = this.getClusterMemberSet().getMember(nMemberId);
                    mapMbrs.put(new Integer(nMemberId), member == null ? String.valueOf(nMemberId) : member.toString());
                    ++j;
                }
            }
            ++i;
        }
        Component._trace(sbLog.toString(), 2);
        return new WrapperException(e, new StringBuilder(String.valueOf("Request interrupted while waiting for response from ")).append(mapMbrs.values()).toString());
    }

    public void processServiceLeftActions(Member member) {
        List listActions = (List)this.getServiceLeftActions().remove(member);
        if (!(listActions != null) ? false : listActions.isEmpty() ^ true) {
            Iterator iter = listActions.iterator();
            while (iter.hasNext()) {
                ((Continuation)iter.next()).proceed(null);
            }
        }
    }

    protected void register() {
        ClusterService clusterservice = this.getClusterService();
        int nId = clusterservice.ensureService(this.getServiceName(), this.getServiceType());
        Component._assert(nId > 0);
        this.setServiceId(nId);
        this.setClusterMemberSet(clusterservice.getClusterMemberSet());
    }

    public void registerMessageType(String sMsgName, Class clz) {
        try {
            Message msg = (Message)clz.newInstance();
            int nType = msg.getMessageType();
            if (this.getMessageClass(nType) != null) {
                throw new IllegalStateException(new StringBuilder(String.valueOf(clz)).append(" - duplicate MessageType: ").append(nType).append(" ").append(this.getMessageClass(nType)).toString());
            }
            this.setMessageClass(nType, clz);
            this.getMessageClassMap().put(sMsgName, clz);
        }
        catch (Exception e) {
            Component._trace(new StringBuilder(String.valueOf("Service.registerMessageType: Unable to instantiate ")).append(clz).toString(), 1);
            Component._trace(e);
        }
    }

    public RequestContext registerRequestContext(RequestContext ctx) {
        if (ctx == null) {
            ctx = this.instantiateRequestContext();
        }
        ctx.setRequestSUID(this.getSUID(SUID_REQUEST));
        ctx.setOldestPendingSUID(this.getOldestPendingRequestSUID());
        return ctx;
    }

    public void removeMemberListener(MemberListener l) {
        this.getMemberListeners().remove(l);
    }

    public static List removeSUIDRange(LongArray array, int nMember, boolean fValues) {
        return Grid.removeSUIDRange(array, Grid.getBaseSUID(nMember), Grid.getBaseSUID(nMember + 1), fValues);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List removeSUIDRange(LongArray array, long lFrom, long lTo, boolean fValues) {
        LongArray longArray = array;
        synchronized (longArray) {
            if (!fValues) {
                array.remove(lFrom, lTo);
                return null;
            }
            LinkedList listValues = new LinkedList();
            LongArray.Iterator iter = array.iterator(lFrom);
            while (iter.hasNext()) {
                Object oValue = iter.next();
                if (!(iter.getIndex() < lTo)) return listValues;
                iter.remove();
                listValues.add(oValue);
            }
            return listValues;
        }
    }

    public static void removeSUIDRange(SortedMap mapSUID, int nMember) {
        Grid.removeSUIDRange(mapSUID, Grid.getBaseSUID(nMember), Grid.getBaseSUID(nMember + 1));
    }

    public static void removeSUIDRange(SortedMap mapSUID, long lFrom, long lTo) {
        mapSUID.subMap(new Long(lFrom), new Long(lTo)).clear();
    }

    protected void reportTransportMismatch(Member member) {
        ServiceMemberSet setMember = this.getServiceMemberSet();
        Member memberThis = this.getThisMember();
        String sRoleThis = memberThis.getRoleName();
        String sRoleThat = member.getRoleName();
        Component._trace(new StringBuilder(String.valueOf(member)).append(" is joining the service using \"").append(ServiceMemberSet.formatEndPoint(setMember.getServiceEndPointName(member.getId()))).append("\" transport while this member is configured to use \"").append(ServiceMemberSet.formatEndPoint(setMember.getServiceEndPointName(memberThis.getId()))).append('\"').toString(), Base.equals(sRoleThis, sRoleThat) ? 2 : 3);
    }

    public void reportTransportStats() {
        ServiceMemberSet setMember = this.getServiceMemberSet();
        Iterator iter = setMember.iterator();
        while (iter.hasNext()) {
            Member member = (Member)iter.next();
            Component._trace(this.collectTransportStats(member));
        }
    }

    public void resetStats() {
        this.setStatsPollCount(0L);
        this.setStatsPollDuration(0L);
        this.setStatsPollMaxDuration(0L);
        this.setStatsTimeoutCount(0L);
        this.setStatsSent(0L);
        this.setStatsSentLocal(0L);
        MessageHandler handler = this.getMessageHandler();
        if (handler != null) {
            handler.resetStats();
        }
        super.resetStats();
    }

    public EndPoint resolveEndPoint(String sEndPoint, Member member, Map mapMemberConfig) {
        EndPoint peer = null;
        try {
            if (!(sEndPoint != null) ? false : sEndPoint.length() > 0) {
                peer = ((Cluster)this.getCluster()).getSocketManager().getDepot().resolveEndPoint(sEndPoint);
            }
        }
        catch (IllegalArgumentException e) {
            Component._trace(new StringBuilder(String.valueOf("Failed to resolve the EndPoint name \"")).append(sEndPoint).append("\" to communicate with service ").append(this.getServiceName()).append(" at ").append(member).append("; falling back on the datagram transport").toString(), 1);
            return null;
        }
        if (!(this.getMessageHandler() != null) ? false : peer == null) {
            this.reportTransportMismatch(member);
        }
        return peer;
    }

    public void send(Message msg) {
        this.post(msg);
        this.flush();
    }

    public void sendPingRequest(Member member, Continuation continuation) {
        Grid$PingRequest msgPing = (Grid$PingRequest)this.instantiateMessage("PingRequest");
        msgPing.setContinuation(continuation);
        msgPing.setToMemberSet(SingleMemberSet.instantiate(member));
        this.post(msgPing);
    }

    public int serializeMessage(Message msg, WriteBuffer.BufferOutput output) throws IOException {
        output.writeShort(this.getServiceId());
        output.writeShort(msg.getMessageType());
        boolean fFiltered = this.isProtocolFiltered();
        if (fFiltered) {
            output = this.wrapStream(output, msg);
        }
        if (output instanceof WrapperBufferOutput.VersionAwareBufferOutput ^ true) {
            output = new WrapperBufferOutput.VersionAwareBufferOutput(output, msg);
        }
        msg.writeInternal(output);
        msg.write(output);
        if (fFiltered) {
            output.close();
        }
        return output.getOffset();
    }

    public void setAcceptingClients(boolean fAccepting) {
        ClusterService clusterService;
        boolean fWasAccepting = this.isAcceptingClients();
        if (!(fWasAccepting ^ true) ? false : fAccepting) {
            this.dispatchMemberEvent(this.getThisMember(), MemberEvent.MEMBER_JOINED);
        }
        super.setAcceptingClients(fAccepting);
        if ((!(fWasAccepting ^ true) ? false : fAccepting) && (clusterService = this.getClusterService()) != this) {
            clusterService.guard(this.getGuardable(), this.getDefaultGuardTimeout(), this.getDefaultGuardRecovery());
            GuardSupport.setThreadContext(this.getGuardable().getContext());
            this.processDeferredWelcomes();
        }
    }

    protected void setAcceptingOthers(boolean fAccepting) {
        this.__m_AcceptingOthers = fAccepting;
    }

    protected void setActionPolicy(ActionPolicy policy) {
        this.__m_ActionPolicy = policy;
    }

    public void setBaseSUIDThisMember(Long longMember) {
        this.__m_BaseSUIDThisMember = longMember;
    }

    public void setBufferManager(BufferManager mgr) {
        this.__m_BufferManager = mgr;
    }

    public void setCluster(com.tangosol.net.Cluster cluster) {
        Component._assert(this.getCluster() == null);
        this.__m_Cluster = cluster;
    }

    public void setClusterMemberSet(MasterMemberSet setMember) {
        Component._assert(this.isStarted() ^ true);
        this.__m_ClusterMemberSet = setMember;
    }

    protected void setCompletedRequestSUIDs(ConcurrentMap map) {
        this.__m_CompletedRequestSUIDs = map;
    }

    protected void setDepartingMembers(MemberSet setMembers) {
        this.__m_DepartingMembers = setMembers;
    }

    protected void setInWait(boolean fWait) {
        this.__m_InWait = fWait;
    }

    private void setMemberListeners(Listeners listeners) {
        this.__m_MemberListeners = listeners;
    }

    protected void setMessageClass(int i, Class clz) {
        boolean fBeyondBounds;
        Class[] aClass = this.getMessageClass();
        boolean bl = aClass == null ? true : (fBeyondBounds = (i += MESSAGE_OFFSET) >= aClass.length);
        if (!fBeyondBounds ? false : clz != null) {
            int cNew = Math.max(i + (i >>> 1), i + 4);
            Class[] aClassNew = new Class[cNew];
            if (aClass != null) {
                System.arraycopy(aClass, 0, aClassNew, 0, aClass.length);
            }
            aClass = aClassNew;
            this.setMessageClass(aClassNew);
            fBeyondBounds = false;
        }
        if (fBeyondBounds ^ true) {
            aClass[i] = clz;
        }
    }

    private void setMessageClass(Class[] aclz) {
        this.__m_MessageClass = aclz;
    }

    protected void setMessageClassMap(Map map) {
        this.__m_MessageClassMap = map;
    }

    protected void setMessageHandler(MessageHandler handler) {
        this.__m_MessageHandler = handler;
    }

    public void setMessagePublisher(MessagePublisher queue) {
        this.__m_MessagePublisher = queue;
    }

    protected void setOldestPendingRequestSUIDCounter(AtomicLong map) {
        this.__m_OldestPendingRequestSUIDCounter = map;
    }

    public void setPendingQuiescenceResponses(Collection colResponses) {
        this.__m_PendingQuiescenceResponses = colResponses;
    }

    protected void setPollArray(Grid$PollArray waPoll) {
        this.__m_PollArray = waPoll;
    }

    private void setQueueDeferred(Queue queue) {
        this.__m_QueueDeferred = queue;
    }

    public void setQueueDeferredWelcome(Queue queue) {
        this.__m_QueueDeferredWelcome = queue;
    }

    public void setRequestTimeout(long cMillis) {
        this.__m_RequestTimeout = cMillis;
    }

    public void setResourceRegistry(ResourceRegistry registry) {
        this.__m_ResourceRegistry = registry;
    }

    protected void setSUIDCounter(int i, AtomicLong longCounter) {
        this.getSUIDCounter()[i] = longCounter;
    }

    protected void setSUIDCounter(AtomicLong[] alongCounter) {
        this.__m_SUIDCounter = alongCounter;
    }

    protected void setServiceConfigMap(Grid$ServiceConfig$Map map) {
        this.__m_ServiceConfigMap = map;
    }

    public void setServiceFailurePolicy(ServiceFailurePolicy policy) {
        this.__m_ServiceFailurePolicy = policy;
    }

    public void setServiceId(int nId) {
        Component._assert(this.isStarted() ^ true);
        this.__m_ServiceId = nId;
    }

    public void setServiceLeftActions(Map mapActions) {
        this.__m_ServiceLeftActions = mapActions;
    }

    public void setServiceMemberSet(ServiceMemberSet setMember) {
        Component._assert(this.getServiceMemberSet() == null ? true : setMember == null);
        this.__m_ServiceMemberSet = setMember;
    }

    public void setServiceState(int nState) {
        if (nState > this.getServiceState()) {
            switch (nState) {
                case 2: {
                    break;
                }
                case 3: {
                    this.dispatchMemberEvent(this.getThisMember(), MemberEvent.MEMBER_LEAVING);
                    break;
                }
                case 4: {
                    this.dispatchMemberEvent(this.getThisMember(), MemberEvent.MEMBER_LEFT);
                    break;
                }
            }
        }
        super.setServiceState(nState);
    }

    protected void setStatsPollCount(long cPolls) {
        this.__m_StatsPollCount = cPolls;
    }

    protected void setStatsPollDuration(long cMillis) {
        this.__m_StatsPollDuration = cMillis;
    }

    protected void setStatsPollMaxDuration(long cMillis) {
        this.__m_StatsPollMaxDuration = cMillis;
    }

    public void setStatsReceived(long cMsgs) {
        super.setStatsReceived(cMsgs);
    }

    public void setStatsSent(long cMsgs) {
        this.__m_StatsSent = cMsgs;
    }

    public void setStatsSentLocal(long cMsgs) {
        this.__m_StatsSentLocal = cMsgs;
    }

    public void setStatsTimeoutCount(long cRequests) {
        this.__m_StatsTimeoutCount = cRequests;
    }

    public void setSuspendPollLimit(AtomicLong atomicLimit) {
        this.__m_SuspendPollLimit = atomicLimit;
    }

    public void setUserContext(Object oCtx) {
        this.__m_UserContext = oCtx;
    }

    public void setWrapperStreamFactoryAllList(List listAll) {
        this.__m_WrapperStreamFactoryAllList = listAll;
    }

    public void setWrapperStreamFactoryList(List list) {
        Component._assert(this.isStarted() ^ true);
        this.__m_WrapperStreamFactoryList = list;
    }

    public synchronized void shutdown() {
        Thread thread;
        if (this.isStarted() && this.getServiceState() < Service.SERVICE_STOPPING) {
            this.checkShutdownPermission();
            this.send(this.instantiateMessage("NotifyShutdown"));
        }
        if ((thread = this.getThread()) != Thread.currentThread()) {
            while (!this.isStarted() ? false : this.getServiceState() < Service.SERVICE_STOPPED) {
                try {
                    Blocking.wait(this);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw Base.ensureRuntimeException(e);
                }
            }
            this.waitForEventDispatcher();
            if (this.getServiceState() != Service.SERVICE_STOPPED) {
                this.stop();
            }
        }
    }

    public synchronized void start() {
        if (this.getServiceState() == Service.SERVICE_INITIAL) {
            this.register();
        }
        super.start();
    }

    public void stop() {
        this.checkShutdownPermission();
        this.setMessagePublisher(NullMessagePublisher.INSTANCE);
        super.stop();
    }

    public RuntimeException tagException(Throwable e) {
        if (e instanceof LicenseException) {
            return (LicenseException)e;
        }
        String sMsg = null;
        try {
            StackTraceElement[] atrace;
            sMsg = new StringBuilder(String.valueOf("Failed request execution for ")).append(this.getServiceName()).append(" service on ").append(this.getThisMember()).toString();
            if (e instanceof WrapperException) {
                WrapperException we = (WrapperException)e;
                e = we.getOriginalException();
                sMsg = new StringBuilder(String.valueOf(sMsg)).append(new StringBuilder(String.valueOf(' ')).append(we.getMessage()).toString()).toString();
            }
            if (e instanceof OutOfMemoryError && ((atrace = e.getStackTrace()) == null ? true : atrace.length == 0)) {
                e = new OutOfMemoryError();
            }
        }
        catch (Throwable eIgnore) {
            // empty catch block
        }
        if (this.isExiting()) {
            Component._trace(new StringBuilder(String.valueOf(this.get_Name())).append(" encountered an exception (").append(e.getClass().getName()).append(": ").append(e.getMessage()).append(") while stopping.").toString(), 3);
            throw new EventDeathException(sMsg);
        }
        try {
            this.getSerializer().serialize(new SizeEstimatingBufferOutput(), e);
        }
        catch (Throwable ex) {
            e = new RuntimeException(new StringBuilder(String.valueOf(e.toString())).append(" (Note: The orignal exception is not serializable).").toString());
        }
        return Base.ensureRuntimeException(e, sMsg);
    }

    protected void unregisterPoll(Poll poll) {
        Component._assert(!(poll != null) ? false : poll.getService() == this);
        this.getPollArray().remove(poll.getPollId());
        long cMillis = Base.getSafeTimeMillis() - poll.getInitTimeMillis();
        this.setStatsPollCount(this.getStatsPollCount() + 1L);
        this.setStatsPollDuration(this.getStatsPollDuration() + cMillis);
        if (cMillis > this.getStatsPollMaxDuration()) {
            this.setStatsPollMaxDuration(cMillis);
        }
    }

    public void unregisterRequestContext(RequestContext ctx) {
        if (ctx == null) {
            return;
        }
        AtomicLong counterOldest = this.getOldestPendingRequestSUIDCounter();
        ConcurrentMap map = this.getCompletedRequestSUIDs();
        long lIdCtx = ctx.getRequestSUID();
        long lIdNext = lIdCtx + 1L;
        MutableLong LIdCtx = new MutableLong(lIdCtx);
        if (counterOldest.compareAndSet(lIdCtx, lIdNext) ^ true) {
            map.put(LIdCtx, Boolean.TRUE);
            if (counterOldest.compareAndSet(lIdCtx, lIdNext) ^ true) {
                return;
            }
            map.remove(LIdCtx);
        }
        while (!(!map.containsKey(LIdCtx.set(lIdNext)) ? false : map.remove(LIdCtx) != null) ? false : counterOldest.compareAndSet(lIdNext, lIdNext + 1L)) {
            ++lIdNext;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean validateMessage(Message msg) {
        Member memberFrom = msg.getFromMember();
        if (memberFrom != null) {
            int nMemberFrom = memberFrom.getId();
            ServiceMemberSet setMember = this.getServiceMemberSet();
            boolean fMember = false;
            if (setMember != null) {
                ServiceMemberSet serviceMemberSet = setMember;
                synchronized (serviceMemberSet) {
                    fMember = ((MemberSet)setMember).getMember(nMemberFrom) != null;
                }
            }
            if (!(!(fMember ^ true) ? false : msg.isInternal() ^ true) ? false : this.getServiceId() > 0) {
                Component._trace(new StringBuilder(String.valueOf("Discarding a ")).append(msg.get_Name()).append(" message from member ").append(nMemberFrom).append(" which does not belong to the service.").toString(), 3);
                return false;
            }
        }
        return true;
    }

    protected boolean validateServiceConfig() {
        boolean fSenior = this.getThisMember() == this.getServiceOldestMember();
        Character oConfigKey = new Character('$');
        Grid$ServiceConfig$Map mapConfig = this.getServiceConfigMap();
        XmlElement xmlConfig = fSenior ? null : (XmlElement)mapConfig.get(oConfigKey);
        if (xmlConfig == null) {
            Component._assert(fSenior, "The service configuration is missing.");
            xmlConfig = this.initServiceConfig();
            mapConfig.put(oConfigKey, xmlConfig);
            return true;
        }
        return this.validateServiceConfig(xmlConfig);
    }

    protected boolean validateServiceConfig(XmlElement xmlConfig) {
        return true;
    }

    protected boolean verifyFeature(String sFeature, Object oValue, Object oTest) {
        if (oValue.equals(oTest)) {
            return true;
        }
        Component._trace(new StringBuilder(String.valueOf("Incompatible ")).append(sFeature).append(" implementation: ").append("this node is configured to use ").append(oValue).append(", but the service senior is using ").append(oTest).append("; stopping the service.").toString(), 1);
        return false;
    }

    protected ReadBuffer.BufferInput wrapStream(ReadBuffer.BufferInput input, Message msg) {
        List listSvc;
        InputStream streamWrap = null;
        List listAll = this.getWrapperStreamFactoryAllList();
        if (listAll != null) {
            streamWrap = new WrapperDataInputStream(input);
            int i = 0;
            int c = listAll.size();
            while (i < c) {
                streamWrap = ((WrapperStreamFactory)listAll.get(i)).getInputStream(streamWrap);
                if (streamWrap instanceof ProtocolAwareStream) {
                    ((ProtocolAwareStream)((Object)streamWrap)).setProtocolContext(this.getProtocolContext(msg));
                }
                ++i;
            }
        }
        if ((listSvc = this.getWrapperStreamFactoryList()) != null) {
            if (streamWrap == null) {
                streamWrap = new WrapperDataInputStream(input);
            }
            int i = 0;
            int c = listSvc.size();
            while (i < c) {
                streamWrap = ((WrapperStreamFactory)listSvc.get(i)).getInputStream(streamWrap);
                if (streamWrap instanceof ProtocolAwareStream) {
                    ((ProtocolAwareStream)((Object)streamWrap)).setProtocolContext(this.getProtocolContext(msg));
                }
                ++i;
            }
        }
        return streamWrap == null ? input : (streamWrap instanceof ReadBuffer.BufferInput ? (ReadBuffer.BufferInput)((Object)streamWrap) : new WrapperBufferInput(new DataInputStream(streamWrap), this.getContextClassLoader()));
    }

    public WriteBuffer.BufferOutput wrapStream(WriteBuffer.BufferOutput output, Message msg) {
        List listAll;
        List listSvc = this.getWrapperStreamFactoryList();
        OutputStream streamWrap = null;
        if (listSvc != null) {
            streamWrap = new WrapperDataOutputStream(output);
            int i = 0;
            int c = listSvc.size();
            while (i < c) {
                streamWrap = ((WrapperStreamFactory)listSvc.get(i)).getOutputStream(streamWrap);
                if (streamWrap instanceof ProtocolAwareStream) {
                    ((ProtocolAwareStream)((Object)streamWrap)).setProtocolContext(this.getProtocolContext(msg));
                }
                ++i;
            }
        }
        if ((listAll = this.getWrapperStreamFactoryAllList()) != null) {
            if (streamWrap == null) {
                streamWrap = new WrapperDataOutputStream(output);
            }
            int i = 0;
            int c = listAll.size();
            while (i < c) {
                streamWrap = ((WrapperStreamFactory)listAll.get(i)).getOutputStream(streamWrap);
                if (streamWrap instanceof ProtocolAwareStream) {
                    ((ProtocolAwareStream)((Object)streamWrap)).setProtocolContext(this.getProtocolContext(msg));
                }
                ++i;
            }
        }
        return streamWrap == null ? output : (streamWrap instanceof WriteBuffer.BufferOutput ? (WriteBuffer.BufferOutput)((Object)streamWrap) : new WrapperBufferOutput(new DataOutputStream(streamWrap)));
    }
}

