/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.MemberSet;
import com.tangosol.coherence.component.net.Message;
import com.tangosol.coherence.component.net.memberSet.ActualMemberSet;
import com.tangosol.coherence.component.net.memberSet.actualMemberSet.serviceMemberSet.MasterMemberSet;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.WriteBuffer;
import com.tangosol.util.ImmutableArrayList;
import com.tangosol.util.UUID;
import com.tangosol.util.WrapperException;
import java.io.IOException;
import java.util.Arrays;

public class ClusterService$MemberLeft
extends Message {
    private transient int __m_MemberCount;
    private short[] __m_MemberIDs;
    private long[] __m_MemberTimestamps;
    private UUID[] __m_MemberUUIDs;
    private boolean __m_SynchronizationRequest;

    public ClusterService$MemberLeft() {
        this(null, null, true);
    }

    public ClusterService$MemberLeft(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setMessageType(36);
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    public int getMemberCount() {
        return this.__m_MemberCount;
    }

    public short[] getMemberIDs() {
        return this.__m_MemberIDs;
    }

    public short getMemberIDs(int i) {
        return this.getMemberIDs()[i];
    }

    public long[] getMemberTimestamps() {
        return this.__m_MemberTimestamps;
    }

    public long getMemberTimestamps(int i) {
        return this.getMemberTimestamps()[i];
    }

    public UUID[] getMemberUUIDs() {
        return this.__m_MemberUUIDs;
    }

    public UUID getMemberUUIDs(int i) {
        return this.getMemberUUIDs()[i];
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/daemon/queueProcessor/service/grid/ClusterService$MemberLeft".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public static Component get_Instance() {
        return new ClusterService$MemberLeft();
    }

    private final Component get_Module() {
        return ((Component)this).get_Parent();
    }

    public boolean isSynchronizationRequest() {
        return this.__m_SynchronizationRequest;
    }

    public void onReceived() {
        ClusterService service = (ClusterService)this.getService();
        Member memberFrom = this.getFromMember();
        Object[] auuid = this.getMemberUUIDs();
        short[] anid = this.getMemberIDs();
        long[] aldtDeath = this.getMemberTimestamps();
        MasterMemberSet setMembers = service.getClusterMemberSet();
        ActualMemberSet setDead = setMembers.getRecycleSet();
        int i = 0;
        int c = this.getMemberCount();
        while (i < c) {
            Member member = setMembers.getMember(auuid[i]);
            if (memberFrom == member) {
                service.removeMember(member);
                Component._trace(new StringBuilder(String.valueOf("MemberLeft announcement from ")).append(member).toString(), 3);
            } else if (member != null) {
                service.removeMember(member);
                Component._trace(new StringBuilder(String.valueOf("MemberLeft notification for ")).append(member).append(" received from ").append(memberFrom).toString(), 3);
            } else if (setMembers.contains(anid[i]) ^ true) {
                member = ((MemberSet)setDead).getMember(anid[i]);
                long ldtDeath = aldtDeath[i] - service.getTimestampAdjustment();
                if (member == null ? true : (!(member.getTimestamp() < ldtDeath) ? false : member.getUid32().equals(auuid[i]) ^ true)) {
                    member = new Member();
                    member.configureDead(anid[i], (UUID)auuid[i], ldtDeath);
                    member.setLeaving(true);
                    ((MemberSet)setDead).add(member);
                }
            }
            ++i;
        }
        if (this.isSynchronizationRequest()) {
            service.ensureMemberLeft(this.getFromMember(), new ImmutableArrayList(auuid).getSet(), false);
        }
    }

    public void read(ReadBuffer.BufferInput input) throws IOException {
        super.read(input);
        this.setSynchronizationRequest(input.readBoolean());
        int cDead = input.readInt();
        short[] anID = new short[cDead];
        long[] aldtDeath = new long[cDead];
        UUID[] aUUID = new UUID[cDead];
        int i = 0;
        while (i < cDead) {
            anID[i] = input.readShort();
            aldtDeath[i] = input.readLong();
            aUUID[i] = new UUID();
            aUUID[i].readExternal(input);
            ++i;
        }
        this.setMemberCount(cDead);
        this.setMemberIDs(anID);
        this.setMemberTimestamps(aldtDeath);
        this.setMemberUUIDs(aUUID);
    }

    public void setMemberCount(int nCount) {
        this.__m_MemberCount = nCount;
    }

    public void setMemberIDs(int i, short nID) {
        this.getMemberIDs()[i] = nID;
    }

    public void setMemberIDs(short[] anIDs) {
        this.__m_MemberIDs = anIDs;
    }

    public void setMemberTimestamps(int i, long ldt) {
        this.getMemberTimestamps()[i] = ldt;
    }

    public void setMemberTimestamps(long[] aldt) {
        this.__m_MemberTimestamps = aldt;
    }

    public void setMemberUUIDs(int i, UUID uuid) {
        this.getMemberUUIDs()[i] = uuid;
    }

    public void setMemberUUIDs(UUID[] auuid) {
        this.__m_MemberUUIDs = auuid;
    }

    public void setSynchronizationRequest(boolean fRequest) {
        this.__m_SynchronizationRequest = fRequest;
    }

    public String toString() {
        return new StringBuilder(String.valueOf("Request=")).append(this.isSynchronizationRequest()).append(", Members=").append(Arrays.toString(this.getMemberIDs())).toString();
    }

    public void write(WriteBuffer.BufferOutput output) throws IOException {
        super.write(output);
        output.writeBoolean(this.isSynchronizationRequest());
        int cDead = this.getMemberCount();
        short[] anID = this.getMemberIDs();
        long[] alDeath = this.getMemberTimestamps();
        UUID[] aUUID = this.getMemberUUIDs();
        output.writeInt(cDead);
        int i = 0;
        while (i < cDead) {
            output.writeShort(anID[i]);
            output.writeLong(alDeath[i]);
            aUUID[i].writeExternal(output);
            ++i;
        }
    }
}

