/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Cluster;
import com.tangosol.coherence.component.net.MemberSet;
import com.tangosol.coherence.component.net.memberSet.ActualMemberSet;
import com.tangosol.coherence.component.net.memberSet.actualMemberSet.serviceMemberSet.MasterMemberSet;
import com.tangosol.coherence.component.net.message.DiscoveryMessage;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService$MemberJoined;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService$NewMemberRequestIdReject;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService$NewMemberRequestIdReply;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService$NewMemberRequestIdWait;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.WriteBuffer;
import com.tangosol.net.Member;
import com.tangosol.net.Service;
import com.tangosol.run.component.EventDeathException;
import com.tangosol.util.Base;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.WrapperException;
import java.io.DataInput;
import java.io.IOException;
import java.util.Collection;

public class ClusterService$NewMemberRequestId
extends DiscoveryMessage
implements Service.MemberJoinAction {
    private int __m_AttemptCounter;
    private int __m_AttemptLimit;
    private transient int __m_Count;
    private int __m_MaxPacketSize;
    private String __m_ServiceVersion;
    private boolean __m_WkaEnabled;

    public ClusterService$NewMemberRequestId() {
        this(null, null, true);
    }

    public ClusterService$NewMemberRequestId(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setMessageType(10);
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    public void ensureEOS(DataInput stream) throws IOException {
        ((ClusterService)this.getService()).resetBroadcastCounter(stream, false);
        super.ensureEOS(stream);
    }

    public int getAttemptCounter() {
        return this.__m_AttemptCounter;
    }

    public int getAttemptLimit() {
        return this.__m_AttemptLimit;
    }

    public int getCount() {
        return this.__m_Count;
    }

    public String getDescription() {
        return new StringBuilder(String.valueOf("AttemptCounter=")).append(this.getAttemptCounter()).append("\nAttemptLimit=").append(this.getAttemptLimit()).append("\nServiceVersion=").append(this.getServiceVersion()).toString();
    }

    public Member getJoiningMember() {
        return this.getFromMember();
    }

    public int getMaxPacketSize() {
        return this.__m_MaxPacketSize;
    }

    public String getServiceVersion() {
        return this.__m_ServiceVersion;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/daemon/queueProcessor/service/grid/ClusterService$NewMemberRequestId".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public static Component get_Instance() {
        return new ClusterService$NewMemberRequestId();
    }

    private final Component get_Module() {
        return ((Component)this).get_Parent();
    }

    public boolean isWkaEnabled() {
        return this.__m_WkaEnabled;
    }

    public void onReceived() {
        super.onReceived();
        ClusterService service = (ClusterService)this.getService();
        com.tangosol.coherence.component.net.Member memberFrom = this.getFromMember();
        switch (service.getState()) {
            case 0: {
                if (this.isReadError()) {
                    service.onMemberRejected(ClusterService.REJECT_VERSION, null);
                    throw new EventDeathException("Version mismatch");
                }
                service.resetBroadcastCounter("the presence of an existing cluster", this);
                break;
            }
            case 1: {
                if (this.isReadError()) {
                    service.onMemberRejected(ClusterService.REJECT_VERSION, null);
                    throw new EventDeathException("Version mismatch");
                }
                com.tangosol.coherence.component.net.Member memberThis = service.getRequestMember();
                if (!(memberFrom.equals(memberThis) ^ true) || !(memberThis.compareTo(memberFrom) > 0)) break;
                service.resetBroadcastCounter("an older member joining", this);
                break;
            }
            case 2: {
                MasterMemberSet setMember = service.getClusterMemberSet();
                com.tangosol.coherence.component.net.Member memberSenior = setMember.getOldestMember();
                com.tangosol.coherence.component.net.Member memberThis = setMember.getThisMember();
                com.tangosol.coherence.component.net.Member memberNew = setMember.getMember(memberFrom.getUid32());
                if (!(!(!(memberThis == memberSenior) ? false : service.validateNewMember(memberFrom)) ? false : service.isMembershipSuspended() ^ true) ? false : (memberNew != null ? true : service.getPendingServiceJoining().isEmpty())) {
                    int cbPacketNew = this.getMaxPacketSize();
                    int cbPacketThis = service.getMaximumPacketLength();
                    String sVersionNew = this.getServiceVersion();
                    boolean fWkaEnabledNew = this.isWkaEnabled();
                    boolean fWkaEnabledThis = service.isWkaEnabled();
                    String sClusterNameNew = memberFrom.getClusterName();
                    String sClusterNameThis = service.getClusterName();
                    int nEditionNew = memberFrom.getEdition();
                    int nEditionThis = memberThis.getEdition();
                    int nModeNew = memberFrom.getMode();
                    int nModeThis = memberThis.getMode();
                    boolean fAllowRTCThis = nEditionThis == 5 ? true : nEditionThis == 3;
                    boolean fAllowRTCNew = nEditionNew == 5 ? true : nEditionNew == 3;
                    boolean fBrandNew = false;
                    if (memberNew == null) {
                        int nRejectReason;
                        if ((service.isVersionCompatible(sVersionNew) ^ true ? true : cbPacketNew == 0) ? true : this.isReadError()) {
                            nRejectReason = ClusterService.REJECT_VERSION;
                        } else if (Base.equals(sClusterNameNew, sClusterNameThis) ^ true) {
                            nRejectReason = ClusterService.REJECT_CLUSTER_NAME;
                        } else if (cbPacketNew != cbPacketThis) {
                            nRejectReason = ClusterService.REJECT_PACKET_MAX;
                        } else if (fWkaEnabledNew ^ fWkaEnabledThis) {
                            nRejectReason = ClusterService.REJECT_WKA;
                        } else if (nModeNew != nModeThis) {
                            nRejectReason = ClusterService.REJECT_LICENSE_TYPE;
                        } else if ((((!(nEditionNew >= 3) ? false : nEditionThis >= 3) ? true : (!(nEditionNew == 1) ? false : fAllowRTCThis)) ? true : (!fAllowRTCNew ? false : nEditionThis == 1)) ^ true) {
                            nRejectReason = ClusterService.REJECT_EDITION;
                        } else if (service.getActionPolicy().isAllowed(service, this) ^ true) {
                            nRejectReason = ClusterService.REJECT_QUORUM;
                        } else {
                            memberNew = service.instantiateMember();
                            memberNew.configure(memberFrom, 0L);
                            nRejectReason = setMember.induct(memberNew, service);
                        }
                        if (nRejectReason == ClusterService.REJECT_NONE) {
                            fBrandNew = true;
                            setMember.setServiceVersion(memberNew.getId(), sVersionNew);
                            setMember.setServiceJoinTime(memberNew.getId(), memberNew.getUid32().getTimestamp());
                        } else {
                            ClusterService$NewMemberRequestIdReject msg = (ClusterService$NewMemberRequestIdReject)service.instantiateMessage("NewMemberRequestIdReject");
                            msg.setToMember(memberFrom);
                            msg.setReason(nRejectReason);
                            service.send(msg);
                            break;
                        }
                    }
                    ClusterService$NewMemberRequestIdReply msg = (ClusterService$NewMemberRequestIdReply)service.instantiateMessage("NewMemberRequestIdReply");
                    msg.setToMember(memberNew);
                    msg.setServiceVersion(ClusterService.VERSION_BARRIER);
                    msg.setMulticastTimeToLive(service.getMulticastTimeToLive());
                    msg.setWkaHashCode(service.getWkaHashCode());
                    service.send(msg);
                    if (!fBrandNew) break;
                    service.ensureMemberLeft(memberNew, null, false);
                    service.doMemberInduct(memberNew);
                    service.onMemberJoined(memberNew);
                    ActualMemberSet setOthers = new ActualMemberSet();
                    ((MemberSet)setOthers).addAll((Collection)setMember);
                    setOthers.remove(memberThis);
                    setOthers.remove(memberNew);
                    if (!(((MemberSet)setOthers).isEmpty() ^ true)) break;
                    ClusterService$MemberJoined msg2 = (ClusterService$MemberJoined)service.instantiateMessage("MemberJoined");
                    msg2.setToMemberSet(setOthers);
                    msg2.setMember(memberNew);
                    msg2.setServiceVersion(sVersionNew);
                    service.send(msg2);
                    break;
                }
                if (!(this.getAttemptCounter() > this.getAttemptLimit() >>> 2)) break;
                int cMembers = setMember.size();
                if (!(((Cluster)service.getCluster()).getDependencies().getPublisherGroupThreshold() >= 100 ? true : (cMembers < 8 ? true : Base.getRandom().nextInt(cMembers) < (int)Math.log(cMembers) + 1))) break;
                ClusterService$NewMemberRequestIdWait msg = (ClusterService$NewMemberRequestIdWait)service.instantiateMessage("NewMemberRequestIdWait");
                msg.setToMember(memberFrom);
                msg.setSeniorMember(memberSenior);
                service.send(msg);
                break;
            }
        }
    }

    public void read(ReadBuffer.BufferInput input) throws IOException {
        super.read(input);
        this.setAttemptCounter(ExternalizableHelper.readInt(input));
        this.setAttemptLimit(ExternalizableHelper.readInt(input));
        this.setServiceVersion(ExternalizableHelper.readUTF(input));
        this.setMaxPacketSize(ExternalizableHelper.readInt(input));
        this.setWkaEnabled(input.readBoolean());
        this.getFromMember().setTcpRingPort(ExternalizableHelper.readInt(input));
        this.setCount(input.readInt());
        this.ensureEOS(input);
    }

    public void setAttemptCounter(int n) {
        this.__m_AttemptCounter = n;
    }

    public void setAttemptLimit(int c) {
        this.__m_AttemptLimit = c;
    }

    public void setCount(int pCount) {
        this.__m_Count = pCount;
    }

    public void setMaxPacketSize(int cb) {
        this.__m_MaxPacketSize = cb;
    }

    public void setServiceVersion(String sVersion) {
        this.__m_ServiceVersion = sVersion;
    }

    public void setWkaEnabled(boolean fEnabled) {
        this.__m_WkaEnabled = fEnabled;
    }

    public void write(WriteBuffer.BufferOutput output) throws IOException {
        super.write(output);
        ExternalizableHelper.writeInt(output, this.getAttemptCounter());
        ExternalizableHelper.writeInt(output, this.getAttemptLimit());
        ExternalizableHelper.writeUTF(output, this.getServiceVersion());
        ExternalizableHelper.writeInt(output, this.getMaxPacketSize());
        output.writeBoolean(this.isWkaEnabled());
        ExternalizableHelper.writeInt(output, this.getFromMember().getTcpRingPort());
        ((ClusterService)this.getService()).getBroadcastTimestamp().writeExternal(output);
    }
}

