/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.MemberSet;
import com.tangosol.coherence.component.net.memberSet.actualMemberSet.ServiceMemberSet;
import com.tangosol.coherence.component.net.message.RequestMessage;
import com.tangosol.coherence.component.util.DistributionStrategy;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$Response;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.PartitionedService;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.PartitionedService$CentralDistribution$DistributionManager;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.PartitionedService$DistributionPlanUpdate;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.PartitionedService$DistributionRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.PartitionedService$PartitionControl;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.PartitionedService$PartitionRecoverRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.PartitionedService$PartitionStatsUpdate;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.PartitionedService$PersistenceControl;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.PartitionedService$PersistenceControl$SnapshotController;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.PartitionedService$TransferControl;
import com.tangosol.coherence.config.Config;
import com.tangosol.net.partition.Ownership;
import com.tangosol.net.partition.PartitionAssignmentStrategy;
import com.tangosol.net.partition.PartitionSet;
import com.tangosol.net.partition.PartitionStatistics;
import com.tangosol.persistence.GUIDHelper;
import com.tangosol.util.Base;
import com.tangosol.util.WrapperException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class PartitionedService$CentralDistribution
extends DistributionStrategy {
    private volatile long __m_AnalysisNextMillis;
    private PartitionedService$CentralDistribution$DistributionManager __m_DistributionManager;
    private Member __m_LastCoordinator;
    private long __m_LastStorageSize;
    private transient PartitionAssignmentStrategy __m_PartitionAssignmentStrategy;
    private PartitionStatistics[] __m_PartitionStatistics;
    private Map[] __m_PendingChanges;
    private int __m_TargetStrength;

    public PartitionedService$CentralDistribution() {
        this(null, null, true);
    }

    public PartitionedService$CentralDistribution(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setDistributionsPendingStart(0L);
            this.setTargetStrength(-1);
            this.setWarningNextMillis(0L);
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this._addChild(new PartitionedService$CentralDistribution$DistributionManager("DistributionManager", this, true), "DistributionManager");
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    public void checkDistribution(MemberSet setOwners, Set setLeaving) {
        PartitionedService service = this.getService();
        long ldtNow = Base.getSafeTimeMillis();
        long ldtNextCheck = ldtNow + (long)service.getDistributionRepeatMillis();
        long ldtNextSample = this.getStatsSampleNextMillis();
        long ldtNextAnalysis = Long.MAX_VALUE;
        if (ldtNow > ldtNextSample) {
            PartitionedService$PartitionControl[] actrl = service.getPartitionControl();
            PartitionSet parts = service.collectOwnedPartitions(true);
            PartitionStatistics[] aStats = this.getPartitionStatistics();
            ArrayList<PartitionStatistics> listStats = new ArrayList<PartitionStatistics>(parts.cardinality());
            long cStorageSize = 0L;
            int nPartition = parts.next(0);
            while (nPartition >= 0) {
                PartitionStatistics statsCtrl = actrl[nPartition].updateDirectStorageSize();
                PartitionStatistics stats = aStats[nPartition];
                cStorageSize += statsCtrl.getStorageSize();
                if (this.isCoordinator()) {
                    if (stats == null) {
                        aStats[nPartition] = stats = new PartitionStatistics();
                    }
                    stats.copyFrom(statsCtrl);
                    statsCtrl.reset();
                } else {
                    listStats.add(statsCtrl);
                }
                nPartition = parts.next(nPartition + 1);
            }
            if (listStats.size() > 0 && (double)Math.abs(cStorageSize - this.getLastStorageSize()) > 0.1 * (double)cStorageSize) {
                PartitionedService$PartitionStatsUpdate msgUpdate = (PartitionedService$PartitionStatsUpdate)service.instantiateMessage("PartitionStatsUpdate");
                msgUpdate.setStatsList(listStats);
                msgUpdate.addToMember(service.getOwnershipSenior(false));
                service.post(msgUpdate);
                Iterator iter = listStats.iterator();
                while (iter.hasNext()) {
                    ((PartitionStatistics)iter.next()).reset();
                }
                this.setLastStorageSize(cStorageSize);
            }
            ldtNextSample = ldtNow + this.getStatsSamplingInterval();
            this.setStatsSampleNextMillis(ldtNextSample);
        }
        if (this.isCoordinator()) {
            Map mapUpdate;
            PartitionedService$CentralDistribution$DistributionManager manager = this.getDistributionManager();
            ldtNextAnalysis = this.getAnalysisNextMillis();
            if (ldtNow >= ldtNextAnalysis) {
                try {
                    manager.reset();
                    manager.setOwnershipMembers(setOwners);
                    manager.setOwnershipLeavingMembers(setLeaving);
                    long cAnalysisMillis = this.getPartitionAssignmentStrategy().analyzeDistribution();
                    if (setOwners.size() == 1) {
                        ldtNextAnalysis = ldtNextSample = Long.MAX_VALUE;
                        ldtNextCheck = ldtNextSample;
                    } else {
                        long cRepeatMillis = service.getDistributionRepeatMillis();
                        ldtNextAnalysis = ldtNow + (service.getServiceState() == Service.SERVICE_STOPPING ? cRepeatMillis / (long)service.getDistributionAggressiveness() : (cAnalysisMillis == -1L ? cRepeatMillis : cAnalysisMillis));
                    }
                    this.setAnalysisNextMillis(ldtNextAnalysis);
                }
                catch (Throwable t) {
                    Component._trace(new StringBuilder(String.valueOf("Unexpected exception occurred while calculating the ")).append("partition assignment: ").append(Base.printStackTrace(t)).toString(), 1);
                }
            }
            if (!((mapUpdate = manager.getSafeSuggestions()) != null) ? false : mapUpdate.isEmpty() ^ true) {
                PartitionedService$DistributionPlanUpdate msgUpdate = (PartitionedService$DistributionPlanUpdate)service.instantiateMessage("DistributionPlanUpdate");
                msgUpdate.setUpdateMap(mapUpdate);
                msgUpdate.setToMemberSet(service.getOwnershipOtherMemberSet(null));
                msgUpdate.setTargetStrength(this.getTargetStrength());
                service.post(msgUpdate);
                this.processUpdate(mapUpdate);
                Map mapDeferredSuggestions = manager.getSuggestionMap();
                if (!(mapDeferredSuggestions != null) ? false : mapDeferredSuggestions.isEmpty() ^ true) {
                    ldtNextCheck = ldtNow + (long)(service.getDistributionRepeatMillis() / service.getDistributionAggressiveness());
                }
            }
        }
        if ((!service.isDistributionAllowed() ? false : this.processPendingChanges() ^ true) ? true : service.isDistributionStable() ^ true) {
            ldtNextCheck = ldtNow + (long)(service.getDistributionRepeatMillis() / service.getDistributionAggressiveness());
        }
        service.setDistributionNextMillis(Math.min(Math.min(ldtNextCheck, ldtNextAnalysis), ldtNextSample));
    }

    public void clearAdvice(PartitionSet parts) {
        int iStore = 0;
        int cBackups = this.getBackupCount();
        while (iStore <= cBackups) {
            Map mapPending = this.getPendingChanges(iStore);
            Iterator iterPending = mapPending.values().iterator();
            while (iterPending.hasNext()) {
                PartitionSet partsPending = (PartitionSet)iterPending.next();
                partsPending.remove(parts);
            }
            ++iStore;
        }
    }

    protected void clearPendingChanges() {
        int iStore = 0;
        int cBackups = this.getBackupCount();
        while (iStore <= cBackups) {
            this.getPendingChanges(iStore).clear();
            ++iStore;
        }
    }

    protected boolean deferBackupTransfer(int iPart, int iStore) {
        int[] aiOwners = this.getPartitionAssignments()[iPart];
        int i = 1;
        int c = aiOwners.length;
        while (i < c) {
            if (aiOwners[i] == 0) {
                return i != iStore;
            }
            ++i;
        }
        return false;
    }

    protected void endangerPartitions(PartitionSet partsEndanger, int iStore) {
        int[][] aaiOwners = this.getPartitionAssignments();
        int nMemberThis = this.getThisMember().getId();
        PartitionedService service = this.getService();
        PartitionedService$TransferControl ctrlTransfer = service.getTransferControl();
        int iPart = partsEndanger.next(0);
        while (iPart >= 0) {
            if (aaiOwners[iPart][0] == nMemberThis) {
                int nBackupOwner = aaiOwners[iPart][iStore];
                Member memberBackup = service.getServiceMemberSet().getMember(nBackupOwner);
                if (memberBackup != null) {
                    aaiOwners[iPart][iStore] = 0;
                    service.getPartitionControl(iPart).preventTransfer();
                    ctrlTransfer.sendBackupRelease(iPart, iStore, nMemberThis, 0, memberBackup, null);
                }
            }
            iPart = partsEndanger.next(iPart + 1);
        }
    }

    public long getAnalysisNextMillis() {
        return this.__m_AnalysisNextMillis;
    }

    public PartitionedService$CentralDistribution$DistributionManager getDistributionManager() {
        PartitionedService$CentralDistribution$DistributionManager mgr = this.__m_DistributionManager;
        if (mgr == null) {
            Component._assert(this.isCoordinator());
            PartitionedService service = this.getService();
            Component._trace(new StringBuilder(String.valueOf("This member has become the distribution coordinator for ")).append(service.getOwnershipMemberSet()).toString(), 3);
            mgr = (PartitionedService$CentralDistribution$DistributionManager)this._findChild("DistributionManager");
            mgr.initialize(this.getPartitionAssignmentStrategy());
            this.setDistributionManager(mgr);
            this.scheduleImmediate();
        }
        return mgr;
    }

    protected Member getLastCoordinator() {
        return this.__m_LastCoordinator;
    }

    public long getLastStorageSize() {
        return this.__m_LastStorageSize;
    }

    public PartitionAssignmentStrategy getPartitionAssignmentStrategy() {
        return this.__m_PartitionAssignmentStrategy;
    }

    public PartitionStatistics[] getPartitionStatistics() {
        return this.__m_PartitionStatistics;
    }

    public PartitionStatistics getPartitionStatistics(int i) {
        return this.getPartitionStatistics()[i];
    }

    protected Map[] getPendingChanges() {
        return this.__m_PendingChanges;
    }

    public Map getPendingChanges(int iStore) {
        return this.getPendingChanges()[iStore];
    }

    public int getTargetStrength() {
        return this.__m_TargetStrength;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/daemon/queueProcessor/service/grid/PartitionedService$CentralDistribution".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public static Component get_Instance() {
        return new PartitionedService$CentralDistribution();
    }

    private final Component get_Module() {
        return this.get_Parent();
    }

    public void initialize() {
        super.initialize();
        PartitionedService service = (PartitionedService)this.get_Module();
        int cBackups = service.getBackupCount();
        Map[] aMapPending = new Map[cBackups + 1];
        int iStore = 0;
        while (iStore <= cBackups) {
            aMapPending[iStore] = new HashMap();
            ++iStore;
        }
        this.setPendingChanges(aMapPending);
        this.setPartitionStatistics(new PartitionStatistics[service.getPartitionCount()]);
        this.setStatsSamplingInterval(Config.getLong("coherence.distributed.sampling.interval", 5000));
    }

    public boolean isCoordinator() {
        PartitionedService service = this.getService();
        return service.getOwnershipSenior(false) == service.getThisMember();
    }

    public void onDistributionCompleted(Member member, boolean fSuccess) {
        this.setDistributionInProgress(false);
        PartitionedService service = this.getService();
        int nRetryMillis = service.getDistributionRepeatMillis() / service.getDistributionAggressiveness();
        if (fSuccess ^ true) {
            service.getTransferControl().onReceiveRollback(member);
        }
        Component._assert(service.isTransferInProgress() ^ true);
        service.setDistributionNextMillis(Base.getSafeTimeMillis() + (long)nRetryMillis);
        this.setStatsSampleNextMillis(Base.getSafeTimeMillis() + 1000L);
    }

    public void onDistributionPlanUpdate(PartitionedService$DistributionPlanUpdate msgUpdate) {
        PartitionedService service = this.getService();
        Member memberPrev = this.getLastCoordinator();
        Member memberCurr = msgUpdate.getFromMember();
        if (memberCurr != memberPrev) {
            if (memberPrev != null) {
                Component._trace(new StringBuilder(String.valueOf("Ignoring unprocessed distribution plan from ")).append(memberPrev.getId()).append(" due to advice from the new coordinator ").append(memberCurr.getId()).toString(), 6);
                this.clearPendingChanges();
            }
            this.setLastCoordinator(memberCurr);
        }
        this.setTargetStrength(msgUpdate.getTargetStrength());
        this.processUpdate(msgUpdate.getUpdateMap());
    }

    public void onDistributionRequest(RequestMessage msgRequest) {
        PartitionedService$DistributionRequest msg = (PartitionedService$DistributionRequest)msgRequest;
        PartitionedService service = this.getService();
        if (service.checkDeferredDistribution() ^ true) {
            PartitionSet parts = msg.getPartitions();
            int cRequest = msg.getPartitionCount();
            Member memberFrom = msg.getFromMember();
            parts.retain(service.collectOwnedPartitions(true));
            cRequest = Math.min(cRequest, parts.cardinality());
            if (cRequest > 0) {
                if (service.transferPrimary(memberFrom, msg, parts, cRequest)) {
                    return;
                }
                this.reportLateDistributions();
            }
        }
        Grid$Response msgResponse = (Grid$Response)service.instantiateMessage("Response");
        msgResponse.respondTo(msg);
        service.post(msgResponse);
    }

    public void onPartitionStatsUpdate(PartitionedService$PartitionStatsUpdate msgUpdate) {
        PartitionStatistics[] aStats = this.getPartitionStatistics();
        Iterator iter = msgUpdate.getStatsList().iterator();
        while (iter.hasNext()) {
            PartitionStatistics stats;
            aStats[stats.getPartition()] = stats = (PartitionStatistics)iter.next();
        }
        long ldtNext = Base.getSafeTimeMillis() + 1000L;
        this.getService().setDistributionNextMillis(ldtNext);
        this.setAnalysisNextMillis(ldtNext);
    }

    protected boolean processPendingChanges() {
        PartitionedService service = this.getService();
        int[][] aaiOwners = this.getPartitionAssignments();
        int nMemberThis = this.getThisMember().getId();
        ServiceMemberSet setMembers = service.getServiceMemberSet();
        int iStore = 0;
        int cBackups = this.getBackupCount();
        while (iStore <= cBackups) {
            block15: {
                int cPending;
                boolean fPrimary = iStore == 0;
                Map mapPending = this.getPendingChanges(iStore);
                PartitionSet partsEndanger = (PartitionSet)mapPending.remove(0);
                if (partsEndanger != null) {
                    Component._assert(iStore > 0);
                    this.endangerPartitions(partsEndanger, iStore);
                }
                if ((cPending = mapPending.size()) == 0) break block15;
                Object[] aNMember = mapPending.keySet().toArray(new Integer[cPending]);
                Base.randomize(aNMember);
                int i = 0;
                while (i < cPending) {
                    block17: {
                        block20: {
                            Member member;
                            PartitionSet partsPlan;
                            block21: {
                                PartitionSet partsDefer;
                                block19: {
                                    block18: {
                                        int nMember;
                                        Object NMember;
                                        block16: {
                                            NMember = aNMember[i];
                                            nMember = (Integer)NMember;
                                            partsPlan = (PartitionSet)mapPending.get(NMember);
                                            member = setMembers.getMember(nMember);
                                            if (!(member == null ? true : (!(fPrimary ^ true) ? false : setMembers.isServiceLeaving(nMember)))) break block16;
                                            mapPending.remove(NMember);
                                            Component._trace(new StringBuilder(String.valueOf("Ignoring obsolete distribution plan for ")).append(partsPlan).append("; member ").append(nMember).append(member == null ? " has left " : " is leaving ").append("the service").toString(), 6);
                                            break block17;
                                        }
                                        partsDefer = null;
                                        int iPart = partsPlan.next(0);
                                        while (iPart >= 0) {
                                            int[] aiOwners = aaiOwners[iPart];
                                            int nOwnerActual = aiOwners[0];
                                            if (fPrimary) {
                                                if (nOwnerActual != nMember) {
                                                    partsPlan.remove(iPart);
                                                }
                                            } else {
                                                int iStoreCur = service.getOwnedIndex(iPart, nMember);
                                                if ((nOwnerActual != nMemberThis ? true : iStore == iStoreCur) ? true : (!(iStoreCur != -1) ? false : service.swapBackupIndex(iPart, iStore, iStoreCur))) {
                                                    partsPlan.remove(iPart);
                                                } else if (!(cBackups > 1) ? false : this.deferBackupTransfer(iPart, iStore)) {
                                                    Component._trace(new StringBuilder(String.valueOf("Re-prioritizing transfer for backup[")).append(iStore).append("] of ").append(service.reportPartitionOwnership(iPart)).append(" to member ").append(nMember).toString(), 3);
                                                    if (partsDefer == null) {
                                                        partsDefer = new PartitionSet(partsPlan.getPartitionCount());
                                                    }
                                                    partsDefer.add(iPart);
                                                }
                                            }
                                            iPart = partsPlan.next(iPart + 1);
                                        }
                                        if (!partsPlan.isEmpty()) break block18;
                                        mapPending.remove(NMember);
                                        break block17;
                                    }
                                    if (!fPrimary) break block19;
                                    PartitionedService$DistributionRequest msg = (PartitionedService$DistributionRequest)service.instantiateMessage("DistributionRequest");
                                    msg.addToMember(member);
                                    msg.setSourceMember(member);
                                    msg.setPartitionCount(partsPlan.cardinality());
                                    msg.setPartitions(partsPlan);
                                    Component._trace(new StringBuilder(String.valueOf("Asking member ")).append(member.getId()).append(" for primary ownership of ").append(partsPlan).toString(), 3);
                                    this.setDistributionInProgress(true);
                                    service.post(msg);
                                    break block20;
                                }
                                partsPlan = new PartitionSet(partsPlan);
                                if (!(partsDefer != null)) break block21;
                                partsPlan.remove(partsDefer);
                                if (partsPlan.isEmpty()) break block17;
                            }
                            service.transferBackup(member, partsPlan, iStore, partsPlan.cardinality());
                        }
                        return false;
                    }
                    ++i;
                }
            }
            ++iStore;
        }
        return true;
    }

    protected void processUpdate(Map mapUpdate) {
        int nMemberThis = this.getThisMember().getId();
        int cPartitions = this.getPartitionCount();
        int cBackups = this.getBackupCount();
        int[][] aaiOwners = this.getPartitionAssignments();
        PartitionSet partsUpdated = new PartitionSet(cPartitions);
        Iterator<Object> iter = mapUpdate.values().iterator();
        while (iter.hasNext()) {
            PartitionSet parts = (PartitionSet)iter.next();
            partsUpdated.add(parts);
        }
        this.clearAdvice(partsUpdated);
        iter = mapUpdate.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            Ownership owners = (Ownership)entry.getKey();
            PartitionSet parts = (PartitionSet)entry.getValue();
            if (!(owners.getPrimaryOwner() == nMemberThis)) continue;
            PartitionSet partsIgnored = null;
            int iPart = parts.next(0);
            while (iPart >= 0) {
                int[] aiOwners = aaiOwners[iPart];
                boolean fPrimaryXfer = false;
                int iStore = 0;
                while (iStore <= cBackups) {
                    int nOwnerPlan = owners.getOwner(iStore);
                    int nOwnerActual = aiOwners[iStore];
                    if (!(iStore == 0) ? false : nOwnerActual == 0) {
                        if (partsIgnored == null) {
                            partsIgnored = new PartitionSet(cPartitions);
                        }
                        partsIgnored.add(iPart);
                        break;
                    }
                    if (nOwnerPlan != nOwnerActual ? true : fPrimaryXfer) {
                        int nMemberTarget = iStore == 0 ? nOwnerActual : nOwnerPlan;
                        Integer IMemberTarget = nMemberTarget;
                        Map mapPending = this.getPendingChanges(iStore);
                        PartitionSet partsPending = (PartitionSet)mapPending.get(IMemberTarget);
                        if (partsPending == null) {
                            partsPending = new PartitionSet(cPartitions);
                            mapPending.put(IMemberTarget, partsPending);
                        }
                        partsPending.add(iPart);
                        fPrimaryXfer = fPrimaryXfer ? true : iStore == 0;
                    }
                    ++iStore;
                }
                iPart = parts.next(iPart + 1);
            }
            if (!(partsIgnored != null)) continue;
            Component._trace(new StringBuilder(String.valueOf("Ignoring obsolete distribution plan update ")).append(owners).append(" for endangered ").append(partsIgnored).toString(), 6);
        }
        this.getService().setDistributionNextMillis(0L);
    }

    public void recoverOrphans(PartitionSet partsOrphan, MemberSet setOwners, Set setLeaving, GUIDHelper.GUIDResolver resolverGUID, String sSnapshot) {
        int cRequests;
        boolean fActivePersistence;
        PartitionedService$PartitionRecoverRequest msgRequest;
        Component._assert(this.isCoordinator());
        PartitionedService service = this.getService();
        Map mapSuggest = null;
        PartitionedService$CentralDistribution$DistributionManager manager = this.getDistributionManager();
        try {
            try {
                manager.reset();
                manager.setOwnershipMembers(setOwners);
                manager.setOwnershipLeavingMembers(setLeaving);
                this.getPartitionAssignmentStrategy().analyzeOrphans(resolverGUID.resolve());
                mapSuggest = manager.getSuggestionMap();
            }
            catch (Throwable t) {
                Component._trace(new StringBuilder(String.valueOf("Unexpected exception occurred while calculating the ")).append("partition assignment: ").append(Base.printStackTrace(t)).toString(), 1);
            }
            Object var10_12 = null;
            manager.reset();
        }
        catch (Throwable t) {
            Object var10_13 = null;
            manager.reset();
            throw t;
        }
        PartitionSet partsAssign = resolverGUID.getUnresolvedPartitions();
        partsAssign.retain(partsOrphan);
        PartitionSet partsRecover = service.instantiatePartitionSet(false);
        HashMap<Member, PartitionedService$PartitionRecoverRequest> mapMemberMsg = new HashMap<Member, PartitionedService$PartitionRecoverRequest>();
        if (!(mapSuggest != null) ? false : mapSuggest.isEmpty() ^ true) {
            Iterator iter = mapSuggest.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                int nOwner = ((Ownership)entry.getKey()).getPrimaryOwner();
                Member memberOwner = setOwners.getMember(nOwner);
                PartitionSet parts = (PartitionSet)entry.getValue();
                if (memberOwner == null) continue;
                parts.retain(partsOrphan);
                int iPart = parts.next(0);
                while (iPart >= 0) {
                    if (partsOrphan.contains(iPart)) {
                        msgRequest = (PartitionedService$PartitionRecoverRequest)mapMemberMsg.get(memberOwner);
                        if (msgRequest == null) {
                            msgRequest = (PartitionedService$PartitionRecoverRequest)service.instantiateMessage("PartitionRecoverRequest");
                            msgRequest.addToMember(memberOwner);
                            msgRequest.setPartsAssign(service.instantiatePartitionSet(false));
                            msgRequest.setPartsRecover(service.instantiatePartitionSet(false));
                            mapMemberMsg.put(memberOwner, msgRequest);
                        }
                        if (partsAssign.contains(iPart)) {
                            msgRequest.getPartsAssign().add(iPart);
                        } else {
                            msgRequest.getPartsRecover().add(iPart);
                            partsRecover.add(iPart);
                        }
                        partsOrphan.remove(iPart);
                    }
                    iPart = parts.next(iPart + 1);
                }
            }
        }
        if (!(fActivePersistence = service.isActivePersistence()) ? false : partsAssign.isEmpty() ^ true) {
            Component._trace(new StringBuilder(String.valueOf("Failed to find a partition assignment for orphaned ")).append(partsAssign).toString(), 2);
        }
        PartitionedService$PersistenceControl ctrlPersistence = service.getPersistenceControl();
        PartitionedService$PersistenceControl$SnapshotController ctrlSnapshot = (sSnapshot != null ? true : fActivePersistence) ? ctrlPersistence.getSnapshotController() : null;
        if (!(ctrlSnapshot != null) ? false : partsRecover.isEmpty() ^ true) {
            ctrlSnapshot.onRecoveryStarted(sSnapshot, partsRecover);
        }
        if (partsOrphan.isEmpty() ^ true) {
            Member memberThis = service.getThisMember();
            PartitionedService$PartitionRecoverRequest msgRequest2 = (PartitionedService$PartitionRecoverRequest)mapMemberMsg.get(memberThis);
            if (msgRequest2 == null) {
                msgRequest2 = (PartitionedService$PartitionRecoverRequest)service.instantiateMessage("PartitionRecoverRequest");
                msgRequest2.addToMember(memberThis);
                msgRequest2.setPartsAssign(service.instantiatePartitionSet(false));
                msgRequest2.setPartsRecover(service.instantiatePartitionSet(false));
                mapMemberMsg.put(memberThis, msgRequest2);
            }
            msgRequest2.getPartsAssign().add(partsOrphan);
        }
        if ((cRequests = mapMemberMsg.size()) == 0) {
            if (ctrlSnapshot != null) {
                ctrlSnapshot.onRecoveryCompleted(sSnapshot, partsOrphan);
            }
        } else {
            service.setDistributionNextMillis(Long.MAX_VALUE);
            ctrlPersistence.getActiveRecoveryRequests().set(cRequests);
            PartitionSet partsRecovered = service.instantiatePartitionSet(false);
            Iterator iter = mapMemberMsg.values().iterator();
            while (iter.hasNext()) {
                msgRequest = (PartitionedService$PartitionRecoverRequest)iter.next();
                msgRequest.setSnapshotToRecover(sSnapshot);
                msgRequest.setGUIDs(resolverGUID.getNewestGUIDs(msgRequest.getPartsRecover()));
                msgRequest.setPartsRecovered(partsRecovered);
                service.post(msgRequest);
            }
            service.setOwnershipInProgress(1);
        }
    }

    public String reportLocalDistributionState(boolean fVerbose) {
        StringBuilder sb = new StringBuilder();
        PartitionedService service = this.getService();
        ServiceMemberSet setMembers = service.getServiceMemberSet();
        int cBackups = this.getBackupCount();
        int cChanges = 0;
        int iStore = 0;
        while (iStore <= cBackups) {
            HashMap mapPending = this.getPendingChanges(iStore);
            if (!mapPending.isEmpty()) {
                while (true) {
                    try {
                        mapPending = new HashMap(mapPending);
                    }
                    catch (ConcurrentModificationException e) {
                        continue;
                    }
                    break;
                }
                int cPending = mapPending.size();
                Object[] aNMember = mapPending.keySet().toArray(new Integer[cPending]);
                Arrays.sort(aNMember);
                int i = 0;
                while (i < cPending) {
                    Object NMember = aNMember[i];
                    int nMember = (Integer)NMember;
                    PartitionSet parts = (PartitionSet)mapPending.get(NMember);
                    cChanges += parts.cardinality();
                    if (fVerbose) {
                        Member member = ((MemberSet)setMembers).getMember(nMember);
                        sb.append("  Transfer of ").append(iStore == 0 ? "Primary " : "Backup ").append(parts).append(iStore == 0 ? " from" : " to").append(" Member ").append(nMember).append('\n');
                    }
                    ++i;
                }
            }
            ++iStore;
        }
        String sPending = this.displayPendingState(fVerbose);
        if (cChanges == 0) {
            return sPending.isEmpty() ? "There are currently no pending or scheduled distributions for this service." : new StringBuilder(String.valueOf(sPending)).append("\nThere are no additional scheduled distributions for this service.").toString();
        }
        return new StringBuilder(String.valueOf(sPending.isEmpty() ? sPending : new StringBuilder(String.valueOf(sPending)).append("\n").toString())).append(cChanges).append(" scheduled distributions remain to be processed").append(fVerbose ? new StringBuilder(String.valueOf(":\n")).append(sb.toString()).toString() : ".").toString();
    }

    public void scheduleImmediate() {
        PartitionedService service = this.getService();
        this.setAnalysisNextMillis(0L);
        super.scheduleImmediate();
    }

    public void setAnalysisNextMillis(long ldtNext) {
        this.__m_AnalysisNextMillis = ldtNext;
    }

    protected void setDistributionManager(PartitionedService$CentralDistribution$DistributionManager manager) {
        this.__m_DistributionManager = manager;
    }

    protected void setLastCoordinator(Member member) {
        this.__m_LastCoordinator = member;
    }

    public void setLastStorageSize(long lSize) {
        this.__m_LastStorageSize = lSize;
    }

    public void setPartitionAssignmentStrategy(PartitionAssignmentStrategy strategy) {
        if (this.getService().isAcceptingClients()) {
            throw new IllegalStateException("Service is already running");
        }
        this.__m_PartitionAssignmentStrategy = strategy;
    }

    public void setPartitionStatistics(int i, PartitionStatistics stats) {
        this.getPartitionStatistics()[i] = stats;
    }

    public void setPartitionStatistics(PartitionStatistics[] aStats) {
        this.__m_PartitionStatistics = aStats;
    }

    protected void setPendingChanges(int iStore, Map mapPending) {
        this.getPendingChanges()[iStore] = mapPending;
    }

    protected void setPendingChanges(Map[] aMapPending) {
        this.__m_PendingChanges = aMapPending;
    }

    public void setTargetStrength(int nStrength) {
        this.__m_TargetStrength = nStrength;
    }
}

