/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid;

import com.oracle.coherence.common.base.SingleWaiterMultiNotifier;
import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Lease;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.util.Collections;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$Acknowledgement;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$BusEventMessage;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$ConfigRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$ConfigResponse;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$ConfigSync;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$ConfigUpdate;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$DaemonPool;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$DispatchEvent;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$DispatchNotification;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$EventDispatcher;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$Guard;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$MemberConfigListener;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$MemberConfigUpdate;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$MemberJoined;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$MemberWelcome;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$MemberWelcomeRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$MemberWelcomeRequestTask;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$NotifyConnectionClose;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$NotifyConnectionOpen;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$NotifyMemberJoined;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$NotifyMemberLeaving;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$NotifyMemberLeft;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$NotifyMessageReceipt;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$NotifyPollClosed;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$NotifyResponse;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$NotifyServiceAnnounced;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$NotifyServiceLeaving;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$NotifyServiceLeft;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$NotifyServiceQuiescence;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$NotifyShutdown;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$NotifyStartup;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$PingRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$PollArray;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$ProtocolContext;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$ReceiveQueue;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$Response;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$ServiceConfig;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$WrapperGuardable;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.SimpleCache$BackingMapManagerContext;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.SimpleCache$ConverterFromInternal;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.SimpleCache$ConverterToInternal;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.SimpleCache$NotifyServiceJoining;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.SimpleCache$ResourceRemove;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.SimpleCache$ResourceRemoveAll;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.SimpleCache$ResourceUpdate;
import com.tangosol.net.BackingMapManager;
import com.tangosol.net.CacheService;
import com.tangosol.net.NamedCache;
import com.tangosol.net.cache.CacheMap;
import com.tangosol.util.Binary;
import com.tangosol.util.Converter;
import com.tangosol.util.Filter;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.InvocableMapHelper;
import com.tangosol.util.ListMap;
import com.tangosol.util.MapEvent;
import com.tangosol.util.MapListener;
import com.tangosol.util.MapListenerSupport;
import com.tangosol.util.SafeHashMap;
import com.tangosol.util.SimpleEnumerator;
import com.tangosol.util.SimpleResourceRegistry;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.WrapperException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicLong;

public final class SimpleCache
extends Grid
implements CacheService,
NamedCache {
    private transient BackingMapManager __m_BackingMapManager;
    private transient Converter __m_ConverterFromInternal;
    private transient Converter __m_ConverterToInternal;
    private transient MapListenerSupport __m_ListenerSupport;
    private transient Map __m_ResourceMap;
    private static ListMap __mapChildren;

    static {
        SimpleCache.__initStatic();
    }

    public SimpleCache() {
        this(null, null, true);
    }

    public SimpleCache(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setDaemonState(0);
            this.setDefaultGuardRecovery(0.9f);
            this.setDefaultGuardTimeout(60000L);
            this.setMessageClassMap(new HashMap());
            this.setNotifier(new SingleWaiterMultiNotifier());
            this.setOldestPendingRequestSUIDCounter(new AtomicLong());
            this.setResourceMap(new SafeHashMap());
            this.setResourceRegistry(new SimpleResourceRegistry());
            this.setSerializerMap(new WeakHashMap());
            this.setSuspendPollLimit(new AtomicLong());
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this._addChild(new Grid$DaemonPool("DaemonPool", this, true), "DaemonPool");
        this._addChild(new Grid$EventDispatcher("EventDispatcher", this, true), "EventDispatcher");
        this._addChild(new Grid$Guard("Guard", this, true), "Guard");
        this._addChild(new Grid$MemberConfigListener("MemberConfigListener", this, true), "MemberConfigListener");
        this._addChild(new Grid$PollArray("PollArray", this, true), "PollArray");
        this._addChild(new Grid$ReceiveQueue("ReceiveQueue", this, true), "ReceiveQueue");
        this._addChild(new Grid$ServiceConfig("ServiceConfig", this, true), "ServiceConfig");
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    private static void __initStatic() {
        __mapChildren = new ListMap();
        Class clazz = __mapChildren.put("Acknowledgement", Grid$Acknowledgement.get_CLASS());
        Class clazz2 = __mapChildren.put("BackingMapManagerContext", SimpleCache$BackingMapManagerContext.get_CLASS());
        Class clazz3 = __mapChildren.put("BusEventMessage", Grid$BusEventMessage.get_CLASS());
        Class clazz4 = __mapChildren.put("ConfigRequest", Grid$ConfigRequest.get_CLASS());
        Class clazz5 = __mapChildren.put("ConfigResponse", Grid$ConfigResponse.get_CLASS());
        Class clazz6 = __mapChildren.put("ConfigSync", Grid$ConfigSync.get_CLASS());
        Class clazz7 = __mapChildren.put("ConfigUpdate", Grid$ConfigUpdate.get_CLASS());
        Class clazz8 = __mapChildren.put("ConverterFromInternal", SimpleCache$ConverterFromInternal.get_CLASS());
        Class clazz9 = __mapChildren.put("ConverterToInternal", SimpleCache$ConverterToInternal.get_CLASS());
        Class clazz10 = __mapChildren.put("DispatchEvent", Grid$DispatchEvent.get_CLASS());
        Class clazz11 = __mapChildren.put("DispatchNotification", Grid$DispatchNotification.get_CLASS());
        Class clazz12 = __mapChildren.put("MemberConfigUpdate", Grid$MemberConfigUpdate.get_CLASS());
        Class clazz13 = __mapChildren.put("MemberJoined", Grid$MemberJoined.get_CLASS());
        Class clazz14 = __mapChildren.put("MemberWelcome", Grid$MemberWelcome.get_CLASS());
        Class clazz15 = __mapChildren.put("MemberWelcomeRequest", Grid$MemberWelcomeRequest.get_CLASS());
        Class clazz16 = __mapChildren.put("MemberWelcomeRequestTask", Grid$MemberWelcomeRequestTask.get_CLASS());
        Class clazz17 = __mapChildren.put("NotifyConnectionClose", Grid$NotifyConnectionClose.get_CLASS());
        Class clazz18 = __mapChildren.put("NotifyConnectionOpen", Grid$NotifyConnectionOpen.get_CLASS());
        Class clazz19 = __mapChildren.put("NotifyMemberJoined", Grid$NotifyMemberJoined.get_CLASS());
        Class clazz20 = __mapChildren.put("NotifyMemberLeaving", Grid$NotifyMemberLeaving.get_CLASS());
        Class clazz21 = __mapChildren.put("NotifyMemberLeft", Grid$NotifyMemberLeft.get_CLASS());
        Class clazz22 = __mapChildren.put("NotifyMessageReceipt", Grid$NotifyMessageReceipt.get_CLASS());
        Class clazz23 = __mapChildren.put("NotifyPollClosed", Grid$NotifyPollClosed.get_CLASS());
        Class clazz24 = __mapChildren.put("NotifyResponse", Grid$NotifyResponse.get_CLASS());
        Class clazz25 = __mapChildren.put("NotifyServiceAnnounced", Grid$NotifyServiceAnnounced.get_CLASS());
        Class clazz26 = __mapChildren.put("NotifyServiceJoining", SimpleCache$NotifyServiceJoining.get_CLASS());
        Class clazz27 = __mapChildren.put("NotifyServiceLeaving", Grid$NotifyServiceLeaving.get_CLASS());
        Class clazz28 = __mapChildren.put("NotifyServiceLeft", Grid$NotifyServiceLeft.get_CLASS());
        Class clazz29 = __mapChildren.put("NotifyServiceQuiescence", Grid$NotifyServiceQuiescence.get_CLASS());
        Class clazz30 = __mapChildren.put("NotifyShutdown", Grid$NotifyShutdown.get_CLASS());
        Class clazz31 = __mapChildren.put("NotifyStartup", Grid$NotifyStartup.get_CLASS());
        Class clazz32 = __mapChildren.put("PingRequest", Grid$PingRequest.get_CLASS());
        Class clazz33 = __mapChildren.put("ProtocolContext", Grid$ProtocolContext.get_CLASS());
        Class clazz34 = __mapChildren.put("ResourceRemove", SimpleCache$ResourceRemove.get_CLASS());
        Class clazz35 = __mapChildren.put("ResourceRemoveAll", SimpleCache$ResourceRemoveAll.get_CLASS());
        Class clazz36 = __mapChildren.put("ResourceUpdate", SimpleCache$ResourceUpdate.get_CLASS());
        Class clazz37 = __mapChildren.put("Response", Grid$Response.get_CLASS());
        Class clazz38 = __mapChildren.put("WrapperGuardable", Grid$WrapperGuardable.get_CLASS());
    }

    public void addIndex(ValueExtractor extractor, boolean fOrdered, Comparator comparator) {
        throw new UnsupportedOperationException();
    }

    public void addMapListener(MapListener listener) {
        this.addMapListener(listener, (Filter)null, false);
    }

    public synchronized void addMapListener(MapListener listener, Filter filter, boolean fLite) {
        Component._assert(listener != null);
        MapListenerSupport support = this.getListenerSupport();
        if (support == null) {
            support = new MapListenerSupport();
            this.setListenerSupport(support);
        }
        support.addListener(listener, filter, fLite);
    }

    public synchronized void addMapListener(MapListener listener, Object oKey, boolean fLite) {
        Component._assert(listener != null);
        MapListenerSupport support = this.getListenerSupport();
        if (support == null) {
            support = new MapListenerSupport();
            this.setListenerSupport(support);
        }
        support.addListener(listener, oKey, fLite);
    }

    public Object aggregate(Filter filter, InvocableMap.EntryAggregator agent) {
        return this.aggregate((Collection)this.keySet(filter), agent);
    }

    public Object aggregate(Collection collKeys, InvocableMap.EntryAggregator agent) {
        return agent.aggregate(InvocableMapHelper.makeEntrySet(this, collKeys, true));
    }

    protected void checkStatus() {
        if (this.getServiceState() != Service.SERVICE_STARTED) {
            throw new IllegalStateException(new StringBuilder(String.valueOf("Service is not running: ")).append(this).toString());
        }
        if (this.isActive() ^ true) {
            throw new IllegalStateException(new StringBuilder(String.valueOf("Map has been invalidated:\n")).append(this).toString());
        }
    }

    public void clear() {
        this.checkStatus();
        this.getResourceMap().clear();
        SimpleCache$ResourceRemoveAll msg = (SimpleCache$ResourceRemoveAll)this.instantiateMessage("ResourceRemoveAll");
        msg.setToMemberSet(this.getOthersMemberSet());
        this.send(msg);
    }

    public boolean containsKey(Object oKey) {
        this.checkStatus();
        return this.getResourceMap().containsKey(oKey);
    }

    public boolean containsValue(Object oValue) {
        this.checkStatus();
        return this.getResourceMap().containsValue(oValue);
    }

    public void destroy() {
        this.clear();
        try {
            Thread.sleep(500);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        this.shutdown();
    }

    public void destroyCache(NamedCache map) {
        Component._assert(map == this);
        this.destroy();
    }

    public void doResourceRemove(Object oKey) {
        Map map = this.getResourceMap();
        if (map.containsKey(oKey)) {
            MapListenerSupport support;
            Object oValueOld = map.remove(oKey);
            if (this.isActive() && (support = this.getListenerSupport()) != null) {
                MapEvent event = new MapEvent(this, MapEvent.ENTRY_DELETED, oKey, oValueOld, null);
                event = MapListenerSupport.convertEvent(event, this, null, this.getConverterFromInternal());
                support.fireEvent(event, true);
            }
        }
    }

    public void doResourceRemoveAll() {
        this.getResourceMap().clear();
    }

    public void doResourceUpdate(Object oKey, Object oValue) {
        MapListenerSupport support;
        Map map = this.getResourceMap();
        boolean fUpdate = map.containsKey(oKey);
        Object oValueOld = map.put(oKey, oValue);
        if (this.isActive() && (support = this.getListenerSupport()) != null) {
            MapEvent event = new MapEvent(this, fUpdate ? MapEvent.ENTRY_UPDATED : MapEvent.ENTRY_INSERTED, oKey, oValueOld, oValue);
            event = MapListenerSupport.convertEvent(event, this, null, this.getConverterFromInternal());
            support.fireEvent(event, true);
        }
    }

    public void doWelcome(Member member) {
        if (this.getThisMember() == this.getServiceOldestMember()) {
            Enumeration enumeration = this.getResourceKeys();
            while (enumeration.hasMoreElements()) {
                Object oKey = enumeration.nextElement();
                SimpleCache$ResourceUpdate msg = (SimpleCache$ResourceUpdate)this.instantiateMessage("ResourceUpdate");
                msg.addToMember(member);
                msg.setLease(Lease.instantiate(-1, oKey, this));
                msg.setResource(this.getResourceMap().get(oKey));
                this.send(msg);
            }
        }
    }

    public synchronized NamedCache ensureCache(String sName, ClassLoader loader) {
        if (sName.equals(this.getServiceName())) {
            BackingMapManager manager = this.getBackingMapManager();
            if (manager != null) {
                Map map = manager.instantiateBackingMap(sName);
                if (map == null) {
                    throw new RuntimeException(new StringBuilder(String.valueOf("BackingMapManager returned \"null\" for map ")).append(sName).toString());
                }
                map.putAll(this.getResourceMap());
                this.setResourceMap(map);
            }
            if (loader == null && (loader = this.getContextClassLoader()) == null) {
                loader = this.getClass().getClassLoader();
                Component._assert(loader != null, "ClassLoader must be specified");
            }
            if (loader != this.getContextClassLoader()) {
                this.releaseClassLoader();
                this.setContextClassLoader(loader);
            }
            return this;
        }
        throw new UnsupportedOperationException("Only one cache per service is allowed");
    }

    public Set entrySet() {
        this.checkStatus();
        return java.util.Collections.unmodifiableSet(this.getResourceMap().entrySet());
    }

    public Set entrySet(Filter filter) {
        return InvocableMapHelper.query(this, filter, true, false, null);
    }

    public Set entrySet(Filter filter, Comparator comparator) {
        return InvocableMapHelper.query(this, filter, true, true, comparator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(Object oKey) {
        this.checkStatus();
        Map mapResource = this.getResourceMap();
        Object oResource = mapResource.get(oKey);
        if (oResource instanceof Binary) {
            Binary binValue = (Binary)oResource;
            try {
                oResource = this.getConverterFromInternal().convert(binValue);
            }
            catch (WrapperException e) {
                throw new WrapperException(e.getOriginalException(), new StringBuilder(String.valueOf("CacheName=")).append(this.getCacheName()).append(", Key=").append(oKey).toString());
            }
            Map map = mapResource;
            synchronized (map) {
                if (binValue == mapResource.get(oKey)) {
                    mapResource.put(oKey, oResource);
                }
            }
        }
        return oResource;
    }

    public Map getAll(Collection colKeys) {
        HashMap mapResult = new HashMap(colKeys.size());
        Iterator iter = colKeys.iterator();
        while (iter.hasNext()) {
            Object oKey = iter.next();
            Object oVal = this.get(oKey);
            if (!(oVal != null ? true : this.containsKey(oKey))) continue;
            mapResult.put(oKey, oVal);
        }
        return mapResult;
    }

    public BackingMapManager getBackingMapManager() {
        return this.__m_BackingMapManager;
    }

    public String getCacheName() {
        return this.getServiceName();
    }

    public Enumeration getCacheNames() {
        return new SimpleEnumerator<String>(new String[]{this.getServiceName()});
    }

    public CacheService getCacheService() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Converter getConverterFromInternal() {
        Converter conv = this.__m_ConverterFromInternal;
        if (conv == null) {
            SimpleCache simpleCache = this;
            synchronized (simpleCache) {
                conv = this.__m_ConverterFromInternal;
                if (conv == null) {
                    conv = this.instantiateConverterFromInternal(this.getContextClassLoader());
                    this.setConverterFromInternal(conv);
                }
            }
        }
        return conv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Converter getConverterToInternal() {
        Converter conv = this.__m_ConverterToInternal;
        if (conv == null) {
            SimpleCache simpleCache = this;
            synchronized (simpleCache) {
                conv = this.__m_ConverterToInternal;
                if (conv == null) {
                    conv = this.instantiateConverterToInternal(this.getContextClassLoader());
                    this.setConverterToInternal(conv);
                }
            }
        }
        return conv;
    }

    public MapListenerSupport getListenerSupport() {
        return this.__m_ListenerSupport;
    }

    public Enumeration getResourceKeys() {
        return new SimpleEnumerator<Object>(this.getResourceMap().keySet().toArray());
    }

    public Map getResourceMap() {
        return this.__m_ResourceMap;
    }

    public String getServiceType() {
        return "SimpleCache";
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/daemon/queueProcessor/service/grid/SimpleCache".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    public static Component get_Instance() {
        return new SimpleCache();
    }

    private final Component get_Module() {
        return this;
    }

    protected Converter instantiateConverterFromInternal(ClassLoader loader) {
        SimpleCache$ConverterFromInternal conv = (SimpleCache$ConverterFromInternal)this._newChild("ConverterFromInternal");
        conv.setSerializer(this.ensureSerializer(loader));
        return conv;
    }

    protected Converter instantiateConverterToInternal(ClassLoader loader) {
        SimpleCache$ConverterToInternal conv = (SimpleCache$ConverterToInternal)this._newChild("ConverterToInternal");
        conv.setSerializer(this.ensureSerializer(loader));
        return conv;
    }

    public Object invoke(Object oKey, InvocableMap.EntryProcessor agent) {
        return InvocableMapHelper.invokeLocked(this, InvocableMapHelper.makeEntry(this, oKey), agent);
    }

    public Map invokeAll(Filter filter, InvocableMap.EntryProcessor agent) {
        return this.invokeAll((Collection)this.keySet(filter), agent);
    }

    public Map invokeAll(Collection collKeys, InvocableMap.EntryProcessor agent) {
        return InvocableMapHelper.invokeAllLocked(this, InvocableMapHelper.makeEntrySet(this, collKeys, false), agent);
    }

    public boolean isActive() {
        return this.getContextClassLoader() != null;
    }

    public boolean isEmpty() {
        this.checkStatus();
        return this.getResourceMap().isEmpty();
    }

    public Set keySet() {
        this.checkStatus();
        return java.util.Collections.unmodifiableSet(this.getResourceMap().keySet());
    }

    public Set keySet(Filter filter) {
        return InvocableMapHelper.query(this, filter, false, false, null);
    }

    public boolean lock(Object oKey) {
        return this.lock(oKey, 0);
    }

    public boolean lock(Object oKey, long cWait) {
        throw new UnsupportedOperationException();
    }

    public void onServiceStarted() {
        BackingMapManager manager = this.getBackingMapManager();
        if (manager != null) {
            SimpleCache$BackingMapManagerContext ctx = (SimpleCache$BackingMapManagerContext)this._newChild("BackingMapManagerContext");
            ctx.setManager(manager);
            manager.init(ctx);
        }
        super.onServiceStarted();
    }

    public Object put(Object oKey, Object oValue) {
        return this.put(oKey, oValue, 0L);
    }

    public Object put(Object oKey, Object oValue, long cMillis) {
        this.checkStatus();
        if (!(oValue != null) ? false : oValue instanceof Serializable ^ true) {
            throw new IllegalArgumentException(new StringBuilder(String.valueOf("Resource is not serializable: ")).append("Key=").append(oKey).append(", Value=").append(oValue).toString());
        }
        Object oValueOld = this.get(oKey);
        Map map = this.getResourceMap();
        if (map instanceof CacheMap) {
            ((CacheMap)map).put(oKey, oValue, cMillis);
        } else if (cMillis <= (long)0) {
            map.put(oKey, oValue);
        } else {
            throw new UnsupportedOperationException(new StringBuilder(String.valueOf("Class \"")).append(map.getClass().getName()).append("\" does not implement CacheMap interface").toString());
        }
        SimpleCache$ResourceUpdate msg = (SimpleCache$ResourceUpdate)this.instantiateMessage("ResourceUpdate");
        msg.setToMemberSet(this.getOthersMemberSet());
        msg.setLease(Lease.instantiate(-1, oKey, this));
        msg.setResource(oValue);
        this.send(msg);
        return oValueOld;
    }

    public void putAll(Map map) {
        Collections.putAll(this, map);
    }

    public void release() {
        this.shutdown();
    }

    public void releaseCache(NamedCache map) {
        Component._assert(map == this);
        this.release();
    }

    protected void releaseClassLoader() {
        ClassLoader loader = this.getContextClassLoader();
        if (loader != null) {
            this.setContextClassLoader(null);
            Map map = this.getResourceMap();
            Iterator iter = this.keySet().iterator();
            while (iter.hasNext()) {
                Object oKey = iter.next();
                Object oValue = map.get(oKey);
                try {
                    Object oInternal = this.getConverterToInternal().convert(oValue);
                    if (!(oInternal != oValue)) continue;
                    oValue = oInternal;
                    map.put(oKey, oValue);
                }
                catch (WrapperException e) {
                    throw new WrapperException(e.getOriginalException(), new StringBuilder(String.valueOf("CacheName=")).append(this.getCacheName()).append(", Key=").append(oKey).toString());
                }
            }
        }
    }

    public Object remove(Object oKey) {
        this.checkStatus();
        Object oValue = this.get(oKey);
        this.getResourceMap().remove(oKey);
        SimpleCache$ResourceRemove msg = (SimpleCache$ResourceRemove)this.instantiateMessage("ResourceRemove");
        msg.setToMemberSet(this.getOthersMemberSet());
        msg.setLease(Lease.instantiate(-1, oKey, this));
        this.send(msg);
        return oValue;
    }

    public void removeIndex(ValueExtractor extractor) {
        throw new UnsupportedOperationException();
    }

    public void removeMapListener(MapListener listener) {
        this.removeMapListener(listener, (Filter)null);
    }

    public synchronized void removeMapListener(MapListener listener, Filter filter) {
        Component._assert(listener != null);
        MapListenerSupport support = this.getListenerSupport();
        if (support != null) {
            support.removeListener(listener, filter);
            if (support.isEmpty()) {
                this.setListenerSupport(null);
            }
        }
    }

    public synchronized void removeMapListener(MapListener listener, Object oKey) {
        Component._assert(listener != null);
        MapListenerSupport support = this.getListenerSupport();
        if (support != null) {
            support.removeListener(listener, oKey);
            if (support.isEmpty()) {
                this.setListenerSupport(null);
            }
        }
    }

    public void setBackingMapManager(BackingMapManager manager) {
        this.__m_BackingMapManager = manager;
    }

    protected void setConverterFromInternal(Converter conv) {
        this.__m_ConverterFromInternal = conv;
    }

    protected void setConverterToInternal(Converter pConverterToInternal) {
        this.__m_ConverterToInternal = pConverterToInternal;
    }

    protected void setListenerSupport(MapListenerSupport support) {
        this.__m_ListenerSupport = support;
    }

    protected void setResourceMap(Map map) {
        this.__m_ResourceMap = map;
    }

    public int size() {
        this.checkStatus();
        return this.getResourceMap().size();
    }

    public void stop() {
        super.stop();
        this.setContextClassLoader(null);
        this.setResourceMap(java.util.Collections.EMPTY_MAP);
    }

    public boolean unlock(Object oKey) {
        throw new UnsupportedOperationException();
    }

    public Collection values() {
        this.checkStatus();
        return java.util.Collections.unmodifiableCollection(this.getResourceMap().values());
    }
}

