/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.partitionedService;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.Util;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.partitionedService.PartitionedCache;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.partitionedService.PartitionedCache$InvocationContext;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.partitionedService.PartitionedCache$Storage;
import com.tangosol.internal.util.SimpleBinaryEntry;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.SerializationSupport;
import com.tangosol.io.Serializer;
import com.tangosol.net.BackingMapContext;
import com.tangosol.net.BackingMapManagerContext;
import com.tangosol.net.cache.CacheMap;
import com.tangosol.net.cache.ConfigurableCacheMap;
import com.tangosol.net.internal.StorageVersion;
import com.tangosol.net.internal.Trint;
import com.tangosol.net.security.StorageAccessAuthorizer;
import com.tangosol.util.Base;
import com.tangosol.util.Binary;
import com.tangosol.util.BinaryEntry;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.InvocableMapHelper;
import com.tangosol.util.MapIndex;
import com.tangosol.util.MapTrigger;
import com.tangosol.util.ObservableMap;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.ValueUpdater;
import com.tangosol.util.WrapperException;
import com.tangosol.util.comparator.SafeComparator;
import java.io.ObjectStreamException;
import java.security.AccessController;

public class PartitionedCache$Storage$BinaryEntry
extends Util
implements SerializationSupport,
BinaryEntry,
MapTrigger.Entry {
    public static final int ACCESS_MASK = 57344;
    public static final int ACCESS_READ = 8192;
    public static final int ACCESS_READ_ANY = 40960;
    public static final int ACCESS_WRITE = 16384;
    public static final int ACCESS_WRITE_ANY = 49152;
    protected static final int EXPIRE_UPDATED = 4;
    protected static final int KEY_CONVERTED = 2;
    protected static final int ORIG_MASK = 6144;
    protected static final int ORIG_NONE = 2048;
    protected static final int ORIG_PRESENT = 4096;
    public static final int STATE_MASK = 65535;
    protected static final int VALUE_CONVERTED = 8;
    protected static final int VALUE_FORCE_EXTRACT = 1024;
    protected static final int VALUE_LOADED = 16;
    protected static final int VALUE_NONE = 32;
    protected static final int VALUE_READONLY = 64;
    protected static final int VALUE_REMOVED = 128;
    protected static final int VALUE_STALE = 1;
    protected static final int VALUE_SYNTHETIC = 256;
    protected static final int VALUE_UPDATED = 512;
    public static final int VERSION_MASK = 0x3FFF0000;
    public static final int VERSION_OFFSET = 16;
    private Binary __m_BinaryKey;
    private Binary __m_BinaryValue;
    private transient Object __m_ConvertedKey;
    private transient Object __m_ConvertedValue;
    private long __m_ExpiryValue;

    public PartitionedCache$Storage$BinaryEntry() {
        this(null, null, true);
    }

    public PartitionedCache$Storage$BinaryEntry(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.set_Order(-2.0f);
            this.setExpiryValue(-2L);
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    protected void checkAccess(int nAccess) {
        PartitionedCache$Storage storage = this.getStorage();
        if (storage == null) {
            return;
        }
        StorageAccessAuthorizer authorizer = storage.getAccessAuthorizer();
        if (authorizer != null) {
            int nState = this.getState();
            if ((nState & nAccess) == nAccess) {
                return;
            }
            PartitionedCache$InvocationContext ctxInvoke = this.getService().getInvocationContext();
            if (ctxInvoke == null ? true : ctxInvoke.getAccessReason() == 0) {
                return;
            }
            if (!((ctxInvoke.getAccessGranted() & nAccess) == nAccess) ? false : ctxInvoke.getAccessStorage() == storage) {
                return;
            }
            this.setState(nState | nAccess);
            switch (nAccess) {
                case 8192: {
                    authorizer.checkRead(this, ctxInvoke.getAccessSubject(), ctxInvoke.getAccessReason());
                    break;
                }
                case 16384: {
                    authorizer.checkWrite(this, ctxInvoke.getAccessSubject(), ctxInvoke.getAccessReason());
                    break;
                }
                default: {
                    throw new IllegalArgumentException(new StringBuilder(String.valueOf("Invalid entry access: ")).append(nAccess).toString());
                }
            }
        }
    }

    protected void checkMutable() {
        if (this.isReadOnly()) {
            throw new UnsupportedOperationException("Read-only entry does not allow Map modifications");
        }
    }

    protected boolean checkVersion() {
        int nTrint = this.getVersionTrint();
        if (nTrint == 0) {
            return true;
        }
        PartitionedCache$Storage storage = this.getStorage();
        StorageVersion version = storage.getVersion();
        long lCurrent = version.getSubmittedVersion();
        long lVersion = Trint.translateTrint14(nTrint, lCurrent);
        return lVersion == lCurrent ? true : version.isPartitionModified(lVersion, storage.getService().getKeyPartition(this.getBinaryKey())) ^ true;
    }

    public int compareTo(Object o) {
        return SafeComparator.compareSafe(null, this.getBinaryKey(), ((PartitionedCache$Storage$BinaryEntry)o).getBinaryKey());
    }

    public void disableConversion() {
    }

    public void ensureReadOnly() {
        this.setState(this.getState() | VALUE_READONLY);
    }

    public void ensureWriteable() {
        this.setState(this.getState() & ~VALUE_READONLY);
    }

    public boolean equals(Object obj) {
        return !(!(obj instanceof PartitionedCache$Storage$BinaryEntry) ? false : Base.equals(this.getBinaryKey(), ((PartitionedCache$Storage$BinaryEntry)obj).getBinaryKey())) ? false : Base.equals(this.getStorage(), ((PartitionedCache$Storage$BinaryEntry)obj).getStorage());
    }

    public void expire(long cMillis) {
        this.checkMutable();
        this.setExpiryValue(cMillis >= (long)0 ? cMillis : CacheMap.EXPIRY_NEVER);
        this.setState(this.getState() | EXPIRE_UPDATED);
    }

    public Object extract(ValueExtractor extractor) {
        Object oValue;
        MapIndex index;
        int nState = this.getState();
        if ((nState & (VALUE_UPDATED | VALUE_REMOVED | VALUE_LOADED | VALUE_FORCE_EXTRACT)) == 0 && (index = (MapIndex)this.getStorage().getIndexMap().get(extractor)) != null && (oValue = index.get(this.getBinaryKey())) != MapIndex.NO_VALUE) {
            if (this.checkVersion()) {
                this.checkAccess(ACCESS_READ);
                return oValue;
            }
            this.setForceExtract(true);
        }
        return InvocableMapHelper.extractFromEntry(extractor, this);
    }

    public static String formatState(int nState) {
        StringBuffer sb = new StringBuffer();
        if ((nState & KEY_CONVERTED) != 0) {
            sb.append(" | KEY_CONVERTED");
        }
        if ((nState & VALUE_CONVERTED) != 0) {
            sb.append(" | VALUE_CONVERTED");
        }
        if ((nState & VALUE_FORCE_EXTRACT) != 0) {
            sb.append(" | VALUE_FORCE_EXTRACT");
        }
        if ((nState & VALUE_NONE) != 0) {
            sb.append(" | VALUE_NONE");
        }
        if ((nState & VALUE_READONLY) != 0) {
            sb.append(" | VALUE_READONLY");
        }
        if ((nState & VALUE_REMOVED) != 0) {
            sb.append(" | VALUE_REMOVED");
        }
        if ((nState & VALUE_SYNTHETIC) != 0) {
            sb.append(" | VALUE_SYNTHETIC");
        }
        if ((nState & EXPIRE_UPDATED) != 0) {
            sb.append(" | EXPIRE_UPDATED");
        }
        if ((nState & VALUE_UPDATED) != 0) {
            sb.append(" | VALUE_UPDATED");
        }
        if ((nState & VALUE_LOADED) != 0) {
            sb.append(" | VALUE_LOADED");
        }
        if ((nState & ORIG_PRESENT) != 0) {
            sb.append(" | ORIG_PRESENT");
        }
        if ((nState & ORIG_NONE) != 0) {
            sb.append(" | ORIG_NONE");
        }
        return sb.length() > 0 ? sb.substring(3) : "";
    }

    public ObservableMap getBackingMap() {
        return this.getStorage().getBackingMap();
    }

    public BackingMapContext getBackingMapContext() {
        PartitionedCache$InvocationContext ctx = this.getInvocationContext();
        PartitionedCache$Storage storage = this.getStorage();
        return ctx == null ? storage : ctx.ensureBackingMapContext(storage);
    }

    protected ObservableMap getBackingMapInternal() {
        if (System.getSecurityManager() == null) {
            return this.getStorage().getBackingMap();
        }
        return (ObservableMap)AccessController.doPrivileged(this.getStorage().getBackingMapAction());
    }

    public Binary getBinaryKey() {
        return this.__m_BinaryKey;
    }

    public Binary getBinaryValue() {
        int nState;
        Binary binValue = this.__m_BinaryValue;
        if (binValue == null && ((nState = this.getState()) & VALUE_NONE) == 0) {
            if ((nState & VALUE_CONVERTED) != 0) {
                binValue = (Binary)this.getStorage().getConverterValueDown().convert(this.getConvertedValue());
            } else if (this.isOriginalPresent()) {
                binValue = this.getOriginalBinaryValue();
            } else {
                binValue = (Binary)this.getBackingMapInternal().get(this.getBinaryKey());
                if (binValue != null) {
                    this.setState(this.getState() | VALUE_LOADED);
                }
            }
            if (binValue == null) {
                this.setState(this.getState() | VALUE_NONE);
            } else {
                this.setBinaryValue(binValue);
            }
        }
        this.checkAccess(ACCESS_READ);
        return binValue;
    }

    public BackingMapManagerContext getContext() {
        PartitionedCache$InvocationContext ctx = this.getInvocationContext();
        if (ctx == null) {
            return this.getService().getBackingMapContext();
        }
        ctx.ensureBackingMapContext(this.getStorage());
        return ctx;
    }

    protected Object getConvertedKey() {
        return this.__m_ConvertedKey;
    }

    protected Object getConvertedValue() {
        return this.__m_ConvertedValue;
    }

    public long getExpiry() {
        long cExpiry;
        if (this.isExpiryInitialized()) {
            cExpiry = this.getExpiryValue();
        } else if ((this.isValueChanged() ? true : this.isValueRemoved()) ? true : this.isOriginalPresent() ^ true) {
            cExpiry = CacheMap.EXPIRY_DEFAULT;
            this.setExpiryValue(cExpiry);
        } else {
            this.getOriginalBinaryValue();
            cExpiry = this.getExpiryValue();
        }
        if (cExpiry == CacheMap.EXPIRY_DEFAULT) {
            ConfigurableCacheMap mapCCM = this.getStorage().getBackingConfigurableCache();
            if (mapCCM != null) {
                cExpiry = mapCCM.getExpiryDelay();
            }
        } else if (!(cExpiry != CacheMap.EXPIRY_NEVER) ? false : this.isExpireChanged() ^ true) {
            long ldtNow = this.getService().getClusterTime();
            cExpiry = Math.max(1L, cExpiry - ldtNow);
        }
        return cExpiry;
    }

    private long getExpiryValue() {
        return this.__m_ExpiryValue;
    }

    protected PartitionedCache$InvocationContext getInvocationContext() {
        PartitionedCache$InvocationContext ctx = this.getService().getInvocationContext();
        return (!(ctx != null) ? false : ((ctx.isReadOnly() ? true : this.isReadOnly() ^ true) ? true : this.isValueLoaded())) ? ctx : null;
    }

    public Object getKey() {
        int nState = this.getState();
        if ((nState & KEY_CONVERTED) != 0) {
            return this.getConvertedKey();
        }
        Object oKey = this.getStorage().getConverterUp().convert(this.getBinaryKey());
        this.setConvertedKey(oKey);
        this.setState(nState | KEY_CONVERTED);
        return oKey;
    }

    public Binary getOriginalBinaryValue() {
        Object binValue = this.get_Sink();
        boolean fExpirySet = this.isExpiryInitialized();
        long ldtExpiry = fExpirySet ? this.getExpiryValue() : CacheMap.EXPIRY_DEFAULT;
        if (!(binValue != null) ? false : fExpirySet) {
            return (Binary)binValue;
        }
        if (this.isOriginalPresent()) {
            Binary binKey = this.getBinaryKey();
            PartitionedCache$Storage storage = this.getStorage();
            ConfigurableCacheMap ccm = storage.getBackingConfigurableCache();
            if (ccm == null) {
                if (binValue == null) {
                    binValue = this.getBackingMapInternal().get(binKey);
                }
                if (!(binValue != null) ? false : fExpirySet ^ true) {
                    ldtExpiry = ExternalizableHelper.decodeExpiry((Binary)binValue);
                }
            } else {
                ConfigurableCacheMap.Entry entry = ccm.getCacheEntry(binKey);
                if (entry != null) {
                    if (binValue == null) {
                        Object oValue = entry.getValue();
                        Object object = binValue = oValue instanceof ReadBuffer ? oValue : ccm.get(binKey);
                    }
                    if (fExpirySet ^ true) {
                        ldtExpiry = entry.getExpiryMillis();
                        ldtExpiry = ldtExpiry == 0L ? CacheMap.EXPIRY_NEVER : this.getService().getClusterService().calcTimestamp(ldtExpiry);
                    }
                }
            }
            this.set_Sink(binValue);
            this.setExpiryValue(ldtExpiry);
        }
        return (Binary)binValue;
    }

    public Object getOriginalValue() {
        Object oValue = this.get_Feed();
        if (oValue == null) {
            oValue = this.getStorage().getConverterUp().convert(this.getOriginalBinaryValue());
            this.set_Feed(oValue);
        }
        return oValue;
    }

    public Serializer getSerializer() {
        return this.getService().getSerializer();
    }

    public PartitionedCache getService() {
        return (PartitionedCache)this.get_Module();
    }

    protected int getState() {
        return this.get_StateAux() & STATE_MASK;
    }

    public PartitionedCache$Storage getStorage() {
        return (PartitionedCache$Storage)this.get_Parent();
    }

    public Object getValue() {
        int nState = this.getState();
        if ((nState & VALUE_CONVERTED) != 0) {
            return this.getConvertedValue();
        }
        PartitionedCache$Storage storage = this.getStorage();
        MapIndex indexFwd = storage.getDeserializationAccelerator();
        Object oValue = (indexFwd == null ? true : (nState & (VALUE_FORCE_EXTRACT | VALUE_UPDATED | VALUE_REMOVED)) != 0) ? MapIndex.NO_VALUE : indexFwd.get(this.getBinaryKey());
        if (oValue == MapIndex.NO_VALUE) {
            oValue = storage.getConverterUp().convert(this.getBinaryValue());
        } else {
            this.checkAccess(ACCESS_READ);
        }
        this.setConvertedValue(oValue);
        this.setState(this.getState() | VALUE_CONVERTED);
        return oValue;
    }

    public int getVersionTrint() {
        return (this.get_StateAux() & VERSION_MASK) >>> VERSION_OFFSET;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/PartitionedCache$Storage$BinaryEntry".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public static Component get_Instance() {
        return new PartitionedCache$Storage$BinaryEntry();
    }

    private final Component get_Module() {
        return this.get_Parent().get_Parent();
    }

    public int hashCode() {
        Binary binKey = this.getBinaryKey();
        return binKey == null ? 0 : binKey.hashCode();
    }

    public boolean isExpireChanged() {
        return (this.getState() & EXPIRE_UPDATED) != 0;
    }

    public boolean isExpiryInitialized() {
        return this.getExpiryValue() != -2L;
    }

    public boolean isKeyConverted() {
        return (this.getState() & KEY_CONVERTED) != 0;
    }

    public boolean isOriginalPresent() {
        int nState = this.getState();
        if ((nState & ORIG_MASK) != 0) {
            return (nState & ORIG_PRESENT) != 0;
        }
        if (this.getBackingMapInternal().containsKey(this.getBinaryKey())) {
            this.setState(nState | ORIG_PRESENT);
            return true;
        }
        this.setState(nState | ORIG_NONE);
        return false;
    }

    public boolean isPresent() {
        int nState = this.getState();
        if ((nState & (VALUE_REMOVED | VALUE_NONE)) != 0) {
            return false;
        }
        return (nState & (VALUE_UPDATED | VALUE_LOADED)) != 0 ? true : this.isOriginalPresent();
    }

    public boolean isReadOnly() {
        return (this.getState() & VALUE_READONLY) != 0;
    }

    public boolean isSynthetic() {
        return (this.getState() & VALUE_SYNTHETIC) != 0;
    }

    public boolean isValueChanged() {
        return (this.getState() & (VALUE_UPDATED | EXPIRE_UPDATED | VALUE_REMOVED)) != 0;
    }

    public boolean isValueConverted() {
        return (this.getState() & VALUE_CONVERTED) != 0;
    }

    public boolean isValueLoaded() {
        return (this.getState() & VALUE_LOADED) != 0;
    }

    public boolean isValueRemoved() {
        return (this.getState() & VALUE_REMOVED) != 0;
    }

    public boolean isValueStale() {
        return (this.getState() & VALUE_STALE) != 0;
    }

    public boolean isValueUpdated() {
        return (this.getState() & VALUE_UPDATED) != 0;
    }

    public void markStale() {
        this.setState(this.getState() | VALUE_STALE);
    }

    public void remove(boolean fSynthetic) {
        this.checkMutable();
        this.setConvertedValue(null);
        this.setBinaryValue(null);
        int nState = this.getState() & ~(VALUE_UPDATED | VALUE_SYNTHETIC);
        this.setState(nState | VALUE_CONVERTED | VALUE_REMOVED | VALUE_NONE | (fSynthetic ? VALUE_SYNTHETIC : 0));
    }

    public void reset(Binary binKey) {
        this.reset(binKey, null);
    }

    public void reset(Binary binKey, Binary binValue) {
        Component._assert(binKey != null);
        this.setState(this.getState() & VALUE_READONLY);
        this.setBinaryKey(binKey);
        this.setBinaryValue(binValue);
        this.set_Feed(null);
        this.set_Sink(null);
        this.setExpiryValue(-2L);
    }

    public void setBinaryKey(Binary binKey) {
        this.__m_BinaryKey = binKey;
    }

    public void setBinaryValue(Binary binValue) {
        this.__m_BinaryValue = binValue;
        this.checkAccess(ACCESS_WRITE);
    }

    protected void setConvertedKey(Object oKey) {
        this.__m_ConvertedKey = oKey;
    }

    protected void setConvertedValue(Object oValue) {
        this.__m_ConvertedValue = oValue;
    }

    public void setExpiryValue(long lValue) {
        this.__m_ExpiryValue = lValue;
    }

    public void setForceExtract(boolean fForce) {
        if (fForce) {
            this.setState(this.getState() | VALUE_FORCE_EXTRACT);
        } else {
            this.setState(this.getState() & ~VALUE_FORCE_EXTRACT);
        }
    }

    protected void setState(int nState) {
        this.set_StateAux(this.get_StateAux() & ~STATE_MASK | nState & STATE_MASK);
    }

    public void setSynthetic(boolean fSynthetic) {
        if (fSynthetic) {
            this.setState(this.getState() | VALUE_SYNTHETIC);
        } else {
            this.setState(this.getState() & ~VALUE_SYNTHETIC);
        }
    }

    public Object setValue(Object oValue) {
        this.checkMutable();
        Object oValueOld = this.getValue();
        this.setValue(oValue, false);
        return oValueOld;
    }

    public void setValue(Object oValue, boolean fSynthetic) {
        this.checkMutable();
        this.setConvertedValue(oValue);
        this.setBinaryValue(null);
        if (this.isExpireChanged() ^ true) {
            this.setExpiryValue(CacheMap.EXPIRY_DEFAULT);
        }
        int nState = (this.getState() | VALUE_CONVERTED | VALUE_UPDATED) & ~(VALUE_REMOVED | VALUE_NONE);
        nState = fSynthetic ? (nState |= VALUE_SYNTHETIC) : (nState &= ~VALUE_SYNTHETIC);
        this.setState(nState);
    }

    public void setVersionTrint(int nTrint) {
        this.set_StateAux(this.get_StateAux() & ~VERSION_MASK | nTrint << VERSION_OFFSET);
    }

    public String toString() {
        int nState = this.getState();
        return new StringBuilder(String.valueOf(this.get_Name())).append("{Key=").append((nState & KEY_CONVERTED) != 0 ? String.valueOf(this.getKey()) : this.toString(this.getBinaryKey())).append(", Value=").append((nState & VALUE_CONVERTED) != 0 ? String.valueOf(this.getValue()) : this.toString(this.getBinaryValue())).append(", State=").append(PartitionedCache$Storage$BinaryEntry.formatState(nState)).append('}').toString();
    }

    protected String toString(Binary binValue) {
        int MAX_BYTES = 512;
        int cb = binValue == null ? 0 : binValue.length();
        return cb <= MAX_BYTES ? String.valueOf(binValue) : new StringBuilder(String.valueOf("Binary(length=")).append(binValue.length()).append(", value=").append(Base.toHexEscape(binValue.toByteArray(0, MAX_BYTES))).append("...)").toString();
    }

    public void update(ValueUpdater updater, Object oValue) {
        InvocableMapHelper.updateEntry(updater, this, oValue);
    }

    public void updateBinaryValue(Binary binValue) {
        this.updateBinaryValue(binValue, false);
    }

    public void updateBinaryValue(Binary binValue, boolean fSynthetic) {
        this.checkMutable();
        if (binValue == null) {
            this.remove(fSynthetic);
        } else {
            int nState = this.getState() & ~(VALUE_SYNTHETIC | VALUE_REMOVED | VALUE_CONVERTED | VALUE_NONE);
            this.setState(nState | VALUE_UPDATED | (fSynthetic ? VALUE_SYNTHETIC : 0));
            this.setBinaryValue(binValue);
            this.setConvertedValue(null);
            if (this.isExpireChanged() ^ true) {
                this.setExpiryValue(CacheMap.EXPIRY_DEFAULT);
            }
        }
    }

    public void updateLoadedValue(Binary binValue) {
        this.checkMutable();
        if (binValue == null) {
            throw new IllegalArgumentException();
        }
        this.setState(this.getState() | (VALUE_LOADED | ORIG_PRESENT));
        this.setBinaryValue(binValue);
    }

    public void updateOriginalBinaryValue(Binary binValue) {
        this.set_Sink(binValue);
        if (binValue == null) {
            this.setState(this.getState() & ~ORIG_MASK | ORIG_NONE);
        } else {
            this.setState(this.getState() & ~ORIG_MASK | ORIG_PRESENT);
        }
    }

    public Object writeReplace() throws ObjectStreamException {
        return new SimpleBinaryEntry(this.getBinaryKey(), this.getBinaryValue());
    }
}

