/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor.service.peer;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.extend.Connection;
import com.tangosol.coherence.component.util.DaemonPool;
import com.tangosol.coherence.component.util.daemon.QueueProcessor$Queue;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Peer;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Peer$DispatchEvent;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.peer.Acceptor$MessageFactory;
import com.tangosol.internal.net.service.peer.acceptor.AcceptorDependencies;
import com.tangosol.internal.net.service.peer.acceptor.HttpAcceptorDependencies;
import com.tangosol.internal.net.service.peer.acceptor.JmsAcceptorDependencies;
import com.tangosol.internal.net.service.peer.acceptor.MemcachedAcceptorDependencies;
import com.tangosol.internal.net.service.peer.acceptor.TcpAcceptorDependencies;
import com.tangosol.license.CoherenceCachingEdition;
import com.tangosol.net.OperationalContext;
import com.tangosol.net.ServiceDependencies;
import com.tangosol.net.messaging.ConnectionAcceptor;
import com.tangosol.net.messaging.ConnectionFilter;
import com.tangosol.net.messaging.Protocol;
import com.tangosol.util.ListMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class Acceptor
extends Peer
implements ConnectionAcceptor {
    private volatile boolean __m_AcceptingConnections;
    private ConnectionFilter __m_ConnectionFilter;
    private int __m_ConnectionLimit;
    private Set __m_ConnectionPendingSet;
    private Set __m_ConnectionSet;
    private static ListMap __mapChildren;

    static {
        Acceptor._initStatic();
    }

    public Acceptor(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    private static void __initStatic() {
        __mapChildren = new ListMap();
        Class clazz = __mapChildren.put("DispatchEvent", Peer$DispatchEvent.get_CLASS());
        Class clazz2 = __mapChildren.put("MessageFactory", Acceptor$MessageFactory.get_CLASS());
        Class clazz3 = __mapChildren.put("Queue", QueueProcessor$Queue.get_CLASS());
    }

    private static void _initStatic$Default() {
        Acceptor.__initStatic();
    }

    protected static void _initStatic() {
        Acceptor._initStatic$Default();
        try {
            new CoherenceCachingEdition();
        }
        catch (RuntimeException e) {
            Peer.setLicenseError(e.getMessage());
        }
    }

    protected void checkPingTimeouts() {
        Iterator iter = this.getConnectionSet().iterator();
        while (iter.hasNext()) {
            Connection connection = (Connection)iter.next();
            this.checkPingTimeout(connection);
        }
    }

    public static ConnectionAcceptor createAcceptor(AcceptorDependencies deps, OperationalContext ctx) {
        Acceptor acceptor;
        if (deps instanceof HttpAcceptorDependencies) {
            acceptor = (Acceptor)Component._newInstance("Component.Util.Daemon.QueueProcessor.Service.Peer.Acceptor.HttpAcceptor");
        } else if (deps instanceof JmsAcceptorDependencies) {
            acceptor = (Acceptor)Component._newInstance("Component.Util.Daemon.QueueProcessor.Service.Peer.Acceptor.JmsAcceptor");
        } else if (deps instanceof TcpAcceptorDependencies) {
            acceptor = (Acceptor)Component._newInstance("Component.Util.Daemon.QueueProcessor.Service.Peer.Acceptor.TcpAcceptor");
        } else if (deps instanceof MemcachedAcceptorDependencies) {
            acceptor = (Acceptor)Component._newInstance("Component.Util.Daemon.QueueProcessor.Service.Peer.Acceptor.MemcachedAcceptor");
        } else {
            throw new IllegalArgumentException(new StringBuilder(String.valueOf("unsupported acceptor dependencies :\n")).append(deps).toString());
        }
        acceptor.setOperationalContext(ctx);
        acceptor.setDependencies(deps);
        return acceptor;
    }

    public String formatStats() {
        return new StringBuilder(String.valueOf("Connections=")).append(this.getConnectionSet().size()).append(", ").append(super.formatStats()).toString();
    }

    public ConnectionFilter getConnectionFilter() {
        return this.__m_ConnectionFilter;
    }

    public int getConnectionLimit() {
        return this.__m_ConnectionLimit;
    }

    public Set getConnectionPendingSet() {
        return this.__m_ConnectionPendingSet;
    }

    public Set getConnectionSet() {
        return this.__m_ConnectionSet;
    }

    public Collection getConnections() {
        return Collections.unmodifiableSet(this.getConnectionSet());
    }

    public DaemonPool getDaemonPool() {
        return (DaemonPool)this._findChild("DaemonPool");
    }

    public String getDescription() {
        int cLimit = this.getConnectionLimit();
        if (cLimit > 0) {
            return new StringBuilder(String.valueOf(super.getDescription())).append(", ConnectionLimit=").append(cLimit).toString();
        }
        return super.getDescription();
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/daemon/queueProcessor/service/peer/Acceptor".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    private final Component get_Module() {
        return this;
    }

    public boolean isAcceptingConnections() {
        int cLimit = this.getConnectionLimit();
        if (!(cLimit > 0) ? false : this.getConnectionSet().size() >= cLimit) {
            return false;
        }
        return this.__m_AcceptingConnections;
    }

    public Map negotiateProtocols(Connection connection, Map mapRequired) {
        Component._assert(connection != null);
        Component._assert(mapRequired != null);
        Map mapProtcol = this.getProtocolMap();
        HashMap<String, Integer> mapReturn = new HashMap<String, Integer>();
        HashMap<String, Protocol.MessageFactory> mapFactory = new HashMap<String, Protocol.MessageFactory>(mapRequired);
        Iterator iter = mapRequired.entrySet().iterator();
        while (iter.hasNext()) {
            int nVersion;
            Map.Entry entry = iter.next();
            String sName = (String)entry.getKey();
            Object oVersion = entry.getValue();
            Protocol protocol = this.getProtocol(sName);
            if (protocol == null) {
                throw new RuntimeException(new StringBuilder(String.valueOf("unsupported protocol: ")).append(sName).toString());
            }
            if (oVersion instanceof Integer) {
                nVersion = (Integer)oVersion;
            } else {
                int nRequestSupport;
                int nRequestCurrent;
                Object[] aVersions;
                if (oVersion instanceof int[]) {
                    aVersions = (int[])oVersion;
                    nRequestCurrent = aVersions[0];
                    nRequestSupport = aVersions[1];
                } else {
                    aVersions = (Object[])oVersion;
                    nRequestCurrent = aVersions[0];
                    nRequestSupport = aVersions[1];
                }
                int nVersionCurrent = protocol.getCurrentVersion();
                int nVersionSupport = protocol.getSupportedVersion();
                nVersion = Math.min(nRequestCurrent, nVersionCurrent);
                if (nVersion < nRequestSupport ? true : nVersion < nVersionSupport) {
                    throw new RuntimeException(new StringBuilder(String.valueOf("could not negotiate protocol: ")).append(sName).toString());
                }
                if (nVersion != nRequestCurrent) {
                    mapReturn.put(sName, nVersion);
                }
            }
            mapFactory.put(sName, protocol.getMessageFactory(nVersion));
        }
        connection.setMessageFactoryMap(Collections.unmodifiableMap(mapFactory));
        return mapReturn.isEmpty() ? null : mapReturn;
    }

    public void onConnectionClosed(Connection connection) {
        if (this.get_Connection() == connection) {
            return;
        }
        if (!(this.getConnectionPendingSet().remove(connection) ^ true) ? false : this.getConnectionSet().remove(connection)) {
            super.onConnectionClosed(connection);
        }
    }

    public void onConnectionError(Connection connection, Throwable e) {
        if (this.get_Connection() == connection) {
            return;
        }
        if (!(this.getConnectionPendingSet().remove(connection) ^ true) ? false : this.getConnectionSet().remove(connection)) {
            super.onConnectionError(connection, e);
        }
    }

    public void onConnectionOpened(Connection connection) {
        if (this.get_Connection() == connection) {
            return;
        }
        if (!this.getConnectionPendingSet().remove(connection) ? false : this.getConnectionSet().add(connection)) {
            super.onConnectionOpened(connection);
        }
    }

    protected void onDependencies(ServiceDependencies deps) {
        super.onDependencies(deps);
        AcceptorDependencies acceptorDeps = (AcceptorDependencies)deps;
        this.setConnectionLimit(acceptorDeps.getConnectionLimit());
    }

    public void onServiceStarted() {
        this.setAcceptingConnections(true);
        super.onServiceStarted();
    }

    protected void onServiceStopped() {
        Connection connection;
        this.setAcceptingConnections(false);
        Iterator iter = this.getConnectionPendingSet().iterator();
        while (iter.hasNext()) {
            connection = (Connection)iter.next();
            iter.remove();
            connection.closeInternal(true, null, 0L);
        }
        iter = new HashSet(this.getConnectionSet()).iterator();
        while (iter.hasNext()) {
            connection = (Connection)iter.next();
            connection.closeInternal(true, null, 0L);
        }
        iter = this.getConnectionSet().iterator();
        while (iter.hasNext()) {
            connection = (Connection)iter.next();
            iter.remove();
            connection.closeInternal(true, null, 100L);
            if (!connection.isOpen()) continue;
            this.getDaemonPool().stop();
            connection.closeInternal(true, null, 1000L);
            if (!connection.isOpen()) continue;
            Component._trace(new StringBuilder(String.valueOf("Unable to close \"")).append(connection).append("\"; this Connection will be abandoned").toString(), 1);
        }
        super.onServiceStopped();
    }

    protected void onServiceStopping() {
        Connection connection;
        this.setAcceptingConnections(false);
        Iterator iter = this.getConnectionPendingSet().iterator();
        while (iter.hasNext()) {
            connection = (Connection)iter.next();
            iter.remove();
            connection.closeInternal(true, null, 0L);
        }
        iter = this.getConnectionSet().iterator();
        while (iter.hasNext()) {
            connection = (Connection)iter.next();
            iter.remove();
            connection.closeInternal(true, null, 0L);
        }
        super.onServiceStopping();
    }

    protected void ping() {
        Iterator iter = this.getConnectionSet().iterator();
        while (iter.hasNext()) {
            Connection connection = (Connection)iter.next();
            connection.ping();
        }
    }

    protected void setAcceptingConnections(boolean fAccepting) {
        this.__m_AcceptingConnections = fAccepting;
    }

    public void setConnectionFilter(ConnectionFilter filter) {
        this.__m_ConnectionFilter = filter;
    }

    protected void setConnectionLimit(int cLimit) {
        this.__m_ConnectionLimit = cLimit;
    }

    protected void setConnectionPendingSet(Set set) {
        this.__m_ConnectionPendingSet = set;
    }

    protected void setConnectionSet(Set set) {
        this.__m_ConnectionSet = set;
    }
}

