/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor.service.peer;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.extend.Channel;
import com.tangosol.coherence.component.net.extend.Connection;
import com.tangosol.coherence.component.util.daemon.QueueProcessor$Queue;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Peer;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Peer$DispatchEvent;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Peer$MessageFactory$OpenConnection;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.peer.Initiator$MessageFactory;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.peer.Initiator$MessageFactory$OpenConnection;
import com.tangosol.internal.net.service.peer.initiator.InitiatorDependencies;
import com.tangosol.internal.net.service.peer.initiator.JmsInitiatorDependencies;
import com.tangosol.internal.net.service.peer.initiator.TcpInitiatorDependencies;
import com.tangosol.net.OperationalContext;
import com.tangosol.net.RequestTimeoutException;
import com.tangosol.net.ServiceDependencies;
import com.tangosol.net.messaging.ConnectionInitiator;
import com.tangosol.net.messaging.Protocol;
import com.tangosol.net.messaging.Request;
import com.tangosol.net.security.SecurityHelper;
import com.tangosol.util.ListMap;
import com.tangosol.util.SafeHashSet;
import java.util.Iterator;
import java.util.Map;
import javax.security.auth.Subject;

public abstract class Initiator
extends Peer
implements ConnectionInitiator {
    private SafeHashSet __m_CloseOnExit;
    private long __m_ConnectTimeout;
    private Connection __m_Connection;
    private long __m_RequestSendTimeout;
    private static ListMap __mapChildren;

    static {
        Initiator.__initStatic();
    }

    public Initiator(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    private static void __initStatic() {
        __mapChildren = new ListMap();
        Class clazz = __mapChildren.put("DispatchEvent", Peer$DispatchEvent.get_CLASS());
        Class clazz2 = __mapChildren.put("MessageFactory", Initiator$MessageFactory.get_CLASS());
        Class clazz3 = __mapChildren.put("Queue", QueueProcessor$Queue.get_CLASS());
    }

    protected void checkPingTimeouts() {
        Connection connection = this.getConnection();
        if (connection != null) {
            this.checkPingTimeout(connection);
        }
    }

    public static ConnectionInitiator createInitiator(InitiatorDependencies deps, OperationalContext ctx) {
        Initiator initiator;
        if (deps instanceof JmsInitiatorDependencies) {
            initiator = (Initiator)Component._newInstance("Component.Util.Daemon.QueueProcessor.Service.Peer.Initiator.JmsInitiator");
        } else if (deps instanceof TcpInitiatorDependencies) {
            initiator = (Initiator)Component._newInstance("Component.Util.Daemon.QueueProcessor.Service.Peer.Initiator.TcpInitiator");
        } else {
            throw new IllegalArgumentException(new StringBuilder(String.valueOf("unsupported initiator dependencies :\n")).append(deps).toString());
        }
        initiator.setOperationalContext(ctx);
        initiator.setDependencies(deps);
        return initiator;
    }

    public synchronized com.tangosol.net.messaging.Connection ensureConnection() {
        if (this.isRunning() ^ true) {
            throw new IllegalStateException(new StringBuilder(String.valueOf(this.getServiceName())).append(" is not running").toString());
        }
        Connection connection = this.getConnection();
        if (connection == null ? true : connection.isOpen() ^ true) {
            connection = this.openConnection();
        }
        return connection;
    }

    public SafeHashSet getCloseOnExit() {
        return this.__m_CloseOnExit;
    }

    public long getConnectTimeout() {
        return this.__m_ConnectTimeout;
    }

    public Connection getConnection() {
        return this.__m_Connection;
    }

    public String getDescription() {
        return new StringBuilder(String.valueOf(super.getDescription())).append(", ConnectTimeout=").append(this.getConnectTimeout()).toString();
    }

    public long getRequestSendTimeout() {
        return this.__m_RequestSendTimeout;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/daemon/queueProcessor/service/peer/Initiator".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    private final Component get_Module() {
        return this;
    }

    public void onConnectionClosed(Connection connection) {
        if (this.getConnection() == connection) {
            this.setConnection(null);
            super.onConnectionClosed(connection);
        }
    }

    public void onConnectionError(Connection connection, Throwable e) {
        if (this.getConnection() == connection) {
            this.setConnection(null);
            super.onConnectionError(connection, e);
        }
    }

    public void onConnectionOpened(Connection connection) {
        if (this.get_Connection() == connection) {
            return;
        }
        if (this.getConnection() == null) {
            this.setConnection(connection);
            super.onConnectionOpened(connection);
        }
    }

    protected void onDependencies(ServiceDependencies deps) {
        super.onDependencies(deps);
        InitiatorDependencies initiatorDeps = (InitiatorDependencies)deps;
        this.setConnectTimeout(initiatorDeps.getConnectTimeoutMillis());
        this.setRequestSendTimeout(initiatorDeps.getRequestSendTimeoutMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onExit() {
        SafeHashSet setClose;
        SafeHashSet safeHashSet = setClose = this.getCloseOnExit();
        synchronized (safeHashSet) {
            Iterator iter = setClose.iterator();
            while (iter.hasNext()) {
                try {
                    ((AutoCloseable)iter.next()).close();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        super.onExit();
    }

    protected void onServiceStopped() {
        Connection connection = this.getConnection();
        if (connection != null) {
            connection.closeInternal(true, null, 100L);
            if (connection.isOpen()) {
                this.getDaemonPool().stop();
                connection.closeInternal(true, null, 1000L);
                if (connection.isOpen()) {
                    Component._trace(new StringBuilder(String.valueOf("Unable to close \"")).append(connection).append("\"; this Connection will be abandoned").toString(), 1);
                }
            }
        }
        super.onServiceStopped();
    }

    protected void onServiceStopping() {
        Connection connection = this.getConnection();
        if (connection != null) {
            connection.closeInternal(true, null, 0L);
        }
        super.onServiceStopping();
    }

    protected Connection openConnection() {
        Connection connection = this.instantiateConnection();
        connection.open();
        return connection;
    }

    public void openConnection(Connection connection) {
        Component._assert(connection != null);
        Channel channel0 = this.get_Channel();
        Protocol.MessageFactory factory0 = channel0.getMessageFactory();
        Initiator$MessageFactory$OpenConnection request = (Initiator$MessageFactory$OpenConnection)factory0.createMessage(Peer$MessageFactory$OpenConnection.TYPE_ID);
        Subject subject = SecurityHelper.getCurrentSubject();
        request.setConnectionOpen(connection);
        request.setIdentityToken(this.serializeIdentityToken(this.generateIdentityToken(subject)));
        request.setSubject(subject);
        Request.Status status = (Request.Status)channel0.request(request);
        if (status != null) {
            try {
                status.waitForResponse(this.getConnectTimeout());
            }
            catch (RequestTimeoutException e) {
                connection.close(false, e);
                throw e;
            }
        }
    }

    protected void ping() {
        Connection connection = this.getConnection();
        if (connection != null) {
            connection.ping();
        }
    }

    public void setCloseOnExit(SafeHashSet setExit) {
        this.__m_CloseOnExit = setExit;
    }

    protected void setConnectTimeout(long cMillis) {
        this.__m_ConnectTimeout = cMillis;
    }

    public void setConnection(Connection connection) {
        this.__m_Connection = connection;
    }

    protected void setRequestSendTimeout(long cMillis) {
        this.__m_RequestSendTimeout = cMillis;
    }
}

