/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor.service.peer.acceptor;

import com.oracle.coherence.common.base.SingleWaiterMultiNotifier;
import com.oracle.coherence.common.net.InetAddresses;
import com.oracle.coherence.common.net.SocketProvider;
import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.extend.Connection;
import com.tangosol.coherence.component.util.Daemon$Guard;
import com.tangosol.coherence.component.util.daemon.QueueProcessor$Queue;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service$EventDispatcher;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Peer$DispatchEvent;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Peer$Protocol;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.peer.Acceptor;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.peer.Acceptor$DaemonPool;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.peer.Acceptor$MessageFactory;
import com.tangosol.internal.net.service.DefaultServiceDependencies;
import com.tangosol.internal.net.service.peer.acceptor.DefaultHttpAcceptorDependencies;
import com.tangosol.internal.net.service.peer.acceptor.HttpAcceptorDependencies;
import com.tangosol.internal.net.service.peer.acceptor.LegacyXmlHttpAcceptorHelper;
import com.tangosol.net.ServiceDependencies;
import com.tangosol.net.Session;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.util.Base;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.ListMap;
import com.tangosol.util.SafeHashSet;
import com.tangosol.util.WrapperException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;

public class HttpAcceptor
extends Acceptor {
    private String __m_AuthMethod;
    private Object __m_HttpServer;
    private String __m_ListenAddress;
    private int __m_ListenPort;
    private String __m_LocalAddress;
    private int __m_LocalPort;
    private Map __m_ResourceConfig;
    private Session __m_Session;
    private SocketProvider __m_SocketProvider;
    private static ListMap __mapChildren;

    static {
        HttpAcceptor.__initStatic();
    }

    public HttpAcceptor() {
        this(null, null, true);
    }

    public HttpAcceptor(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setAuthMethod("\"none\"");
            this.setConnectionPendingSet(new SafeHashSet());
            this.setConnectionSet(new SafeHashSet());
            this.setDaemonState(0);
            this.setDefaultGuardRecovery(0.9f);
            this.setDefaultGuardTimeout(60000L);
            this.setLocalAddress("localhost");
            this.setLocalPort(0);
            this.setNotifier(new SingleWaiterMultiNotifier());
            this.setProtocolMap(new HashMap());
            this.setReceiverMap(new HashMap());
            this.setRequestTimeout(30000L);
            this.setSerializerMap(new WeakHashMap());
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this._addChild(new Acceptor$DaemonPool("DaemonPool", this, true), "DaemonPool");
        this._addChild(new Service$EventDispatcher("EventDispatcher", this, true), "EventDispatcher");
        this._addChild(new Daemon$Guard("Guard", this, true), "Guard");
        this._addChild(new Peer$Protocol("Protocol", this, true), "Protocol");
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    private static void __initStatic() {
        __mapChildren = new ListMap();
        Class clazz = __mapChildren.put("DispatchEvent", Peer$DispatchEvent.get_CLASS());
        Class clazz2 = __mapChildren.put("MessageFactory", Acceptor$MessageFactory.get_CLASS());
        Class clazz3 = __mapChildren.put("Queue", QueueProcessor$Queue.get_CLASS());
    }

    protected DefaultServiceDependencies cloneDependencies(ServiceDependencies deps) {
        return new DefaultHttpAcceptorDependencies((HttpAcceptorDependencies)deps);
    }

    public synchronized void configure(XmlElement xml) {
        this.setDependencies(LegacyXmlHttpAcceptorHelper.fromXml(xml, new DefaultHttpAcceptorDependencies(), this.getOperationalContext(), this.getContextClassLoader()));
        this.setServiceConfig(xml);
    }

    public String getAuthMethod() {
        return this.__m_AuthMethod;
    }

    public String getDescription() {
        return new StringBuilder(String.valueOf("HttpServer=")).append(this.getHttpServer()).append(", LocalAddress=").append(this.getLocalAddress()).append(", LocalPort=").append(this.getLocalPort()).append(", ResourceConfig=").append(String.valueOf(this.getResourceConfig())).toString();
    }

    public Object getHttpServer() {
        return this.__m_HttpServer;
    }

    public String getListenAddress() {
        return this.__m_ListenAddress;
    }

    public int getListenPort() {
        return this.__m_ListenPort;
    }

    public String getLocalAddress() {
        return this.__m_LocalAddress;
    }

    public int getLocalPort() {
        return this.__m_LocalPort;
    }

    public Map getResourceConfig() {
        return this.__m_ResourceConfig;
    }

    public Session getSession() {
        return this.__m_Session;
    }

    public SocketProvider getSocketProvider() {
        return this.__m_SocketProvider;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/daemon/queueProcessor/service/peer/acceptor/HttpAcceptor".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    public static Component get_Instance() {
        return new HttpAcceptor();
    }

    private final Component get_Module() {
        return this;
    }

    protected Connection instantiateConnection() {
        throw new UnsupportedOperationException();
    }

    protected void onDependencies(ServiceDependencies deps) {
        super.onDependencies(deps);
        HttpAcceptorDependencies httpDeps = (HttpAcceptorDependencies)deps;
        this.setHttpServer(httpDeps.getHttpServer());
        this.setSocketProvider(httpDeps.getSocketProviderBuilder().realize(null, null, null));
        this.setLocalAddress(httpDeps.getLocalAddress());
        this.setLocalPort(httpDeps.getLocalPort());
        this.setResourceConfig(httpDeps.getResourceConfig());
        this.setAuthMethod(httpDeps.getAuthMethod());
    }

    protected void onServiceStarting() {
        super.onServiceStarting();
        Object oServer = this.getHttpServer();
        Component._assert(oServer != null);
        Map mapConfig = this.getResourceConfig();
        Component._assert(mapConfig != null);
        try {
            ClassHelper.invoke(oServer, "setAuthMethod", new Object[]{this.getAuthMethod()});
            ClassHelper.invoke(oServer, "setSession", new Object[]{this.getSession()});
            ClassHelper.invoke(oServer, "setLocalAddress", new Object[]{this.getLocalAddress()});
            ClassHelper.invoke(oServer, "setLocalPort", new Object[]{this.getLocalPort()});
            ClassHelper.invoke(oServer, "setResourceConfig", new Object[]{mapConfig});
            ClassHelper.invoke(oServer, "setParentService", new Object[]{this.getParentService()});
            ClassHelper.invoke(oServer, "setSocketProvider", new Object[]{this.getSocketProvider()});
            ClassHelper.invoke(oServer, "start", ClassHelper.VOID);
        }
        catch (Exception e) {
            throw Base.ensureRuntimeException(e);
        }
        String sAddr = this.getLocalAddress();
        int nPort = this.getLocalPort();
        try {
            sAddr = (String)ClassHelper.invoke(oServer, "getListenAddress", null);
            nPort = (Integer)ClassHelper.invoke(oServer, "getListenPort", null);
        }
        catch (Exception e) {
            Component._trace(new StringBuilder(String.valueOf("Unable to obtain the HttpServer's listen address and port:\n")).append(Base.printStackTrace(e)).toString(), 2);
        }
        this.setListenAddress(sAddr);
        this.setListenPort(nPort);
        if (InetAddresses.isAnyLocalAddress(sAddr)) {
            try {
                sAddr = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                // empty catch block
            }
        }
        Component._trace(new StringBuilder(String.valueOf("HttpAcceptor now listening for connections on ")).append(sAddr).append(':').append(nPort).toString(), 3);
    }

    protected void onServiceStopped() {
        super.onServiceStopped();
        try {
            Object oServer = this.getHttpServer();
            if (oServer != null) {
                ClassHelper.invoke(oServer, "stop", ClassHelper.VOID);
            }
        }
        catch (Exception e) {
            throw Base.ensureRuntimeException(e);
        }
    }

    protected void onServiceStopping() {
        super.onServiceStopping();
        try {
            Object oServer = this.getHttpServer();
            if (oServer != null) {
                ClassHelper.invoke(oServer, "stop", ClassHelper.VOID);
            }
        }
        catch (Exception e) {
            throw Base.ensureRuntimeException(e);
        }
    }

    public void resetStats() {
        super.resetStats();
        Object oServer = this.getHttpServer();
        Component._assert(oServer != null);
        try {
            ClassHelper.invoke(oServer, "resetStats", ClassHelper.VOID);
        }
        catch (Exception e) {
            throw Base.ensureRuntimeException(e);
        }
    }

    protected void setAuthMethod(String sMethod) {
        this.__m_AuthMethod = sMethod;
    }

    public void setHttpServer(Object pHttpServer) {
        this.__m_HttpServer = pHttpServer;
    }

    protected void setListenAddress(String sAddress) {
        this.__m_ListenAddress = sAddress;
    }

    protected void setListenPort(int nPort) {
        this.__m_ListenPort = nPort;
    }

    protected void setLocalAddress(String sAddress) {
        this.__m_LocalAddress = sAddress;
    }

    protected void setLocalPort(int nPort) {
        this.__m_LocalPort = nPort;
    }

    protected void setResourceConfig(Map map) {
        this.__m_ResourceConfig = map;
    }

    public void setSession(Session session) {
        this.__m_Session = session;
    }

    protected void setSocketProvider(SocketProvider provider) {
        this.__m_SocketProvider = provider;
    }
}

