/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor.service.peer.acceptor;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.util.Queue;
import com.tangosol.coherence.component.util.pool.simplePool.GrowablePool;
import com.tangosol.coherence.component.util.queue.concurrentQueue.DualQueue;
import com.tangosol.io.MultiBufferWriteBuffer;
import com.tangosol.io.WriteBuffer;
import com.tangosol.io.nio.ByteBufferWriteBuffer;
import com.tangosol.util.Base;
import com.tangosol.util.WrapperException;
import java.nio.Buffer;
import java.nio.ByteBuffer;

public class TcpAcceptor$BufferPool
extends GrowablePool
implements MultiBufferWriteBuffer.WriteBufferPool {
    public static final int TYPE_DIRECT = 0;
    public static final int TYPE_HEAP = 1;
    private int __m_BufferSize;
    private int __m_BufferType;
    private String __m_Name;
    private int __m_Overflow;

    public TcpAcceptor$BufferPool() {
        this(null, null, true);
    }

    public TcpAcceptor$BufferPool(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setBufferSize(2048);
            this.setBufferType(0);
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object acquire() {
        ByteBufferWriteBuffer wb = (ByteBufferWriteBuffer)this.getStorage().removeNoWait();
        if (wb == null) {
            boolean fGrow;
            TcpAcceptor$BufferPool tcpAcceptor$BufferPool = this;
            synchronized (tcpAcceptor$BufferPool) {
                int cSize = this.getSize();
                int cCapacity = this.getCapacity();
                if (cSize < cCapacity ? true : cCapacity <= 0) {
                    this.setSize(cSize + 1);
                    fGrow = true;
                } else {
                    this.setOverflow(this.getOverflow() + 1);
                    fGrow = false;
                }
            }
            wb = (ByteBufferWriteBuffer)this.instantiateResource();
            if (Component._isTraceEnabled(9)) {
                if (fGrow) {
                    Component._trace(new StringBuilder(String.valueOf(this.getName())).append("BufferPool increased to ").append(this.getSize() * this.getBufferSize()).append(" bytes total").toString(), 9);
                } else {
                    Component._trace(new StringBuilder(String.valueOf(this.getName())).append("BufferPool allocated ").append(this.getBufferSize()).append(" bytes").toString(), 9);
                }
            }
        } else {
            ((Buffer)wb.getByteBuffer()).clear();
        }
        return wb;
    }

    public WriteBuffer allocate(int cbPreviousTotal) {
        return (ByteBufferWriteBuffer)this.acquire();
    }

    public int getBufferSize() {
        return this.__m_BufferSize;
    }

    public int getBufferType() {
        return this.__m_BufferType;
    }

    public int getMaximumCapacity() {
        return this.getBufferSize() * this.getCapacity();
    }

    public String getName() {
        String sName = this.__m_Name;
        return sName == null ? "" : sName;
    }

    public int getOverflow() {
        return this.__m_Overflow;
    }

    public static int getType(String sType) {
        if (sType.equalsIgnoreCase("HEAP")) {
            return TYPE_HEAP;
        }
        return TYPE_DIRECT;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/daemon/queueProcessor/service/peer/acceptor/TcpAcceptor$BufferPool".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public static Component get_Instance() {
        return new TcpAcceptor$BufferPool();
    }

    private final Component get_Module() {
        return this.get_Parent();
    }

    protected Object instantiateResource() {
        ByteBuffer buf;
        switch (this.getBufferType()) {
            case 0: {
                buf = ByteBuffer.allocateDirect(this.getBufferSize());
                break;
            }
            default: {
                buf = ByteBuffer.allocate(this.getBufferSize());
            }
        }
        return new ByteBufferWriteBuffer(buf);
    }

    protected Queue instantiateStorage() {
        return new DualQueue();
    }

    public boolean isCapacityLimited() {
        return this.getCapacity() > 0;
    }

    public synchronized void release() {
        Queue queue = this.getStorage();
        while (queue.isEmpty() ^ true) {
            queue.removeNoWait();
        }
        this.setOverflow(0);
        this.setSize(0);
    }

    public void release(WriteBuffer wb) {
        this.release((Object)wb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(Object oElement) {
        boolean fRelease;
        int cOverflow;
        Component._assert(oElement instanceof ByteBufferWriteBuffer);
        TcpAcceptor$BufferPool tcpAcceptor$BufferPool = this;
        synchronized (tcpAcceptor$BufferPool) {
            cOverflow = this.getOverflow();
            if (cOverflow == 0) {
                fRelease = true;
            } else {
                this.setOverflow(--cOverflow);
                fRelease = false;
            }
        }
        if (fRelease) {
            super.release(oElement);
        } else {
            if (!(this.getBufferType() == TYPE_DIRECT) ? false : cOverflow == 0) {
                System.gc();
            }
            if (Component._isTraceEnabled(9)) {
                Component._trace(new StringBuilder(String.valueOf(this.getName())).append("BufferPool released ").append(((ByteBufferWriteBuffer)oElement).getCapacity()).append(" bytes").toString(), 9);
            }
        }
    }

    public void setBufferSize(int cb) {
        Component._assert(cb > 0);
        this.__m_BufferSize = cb;
    }

    public void setBufferType(int nType) {
        Component._assert(nType == TYPE_DIRECT ? true : nType == TYPE_HEAP);
        this.__m_BufferType = nType;
    }

    public void setName(String sName) {
        if (!(!(sName != null) ? false : sName.length() > 0) ? false : sName.endsWith(" ") ^ true) {
            sName = new StringBuilder(String.valueOf(sName)).append(' ').toString();
        }
        this.__m_Name = sName;
    }

    public void setOverflow(int cElements) {
        this.__m_Overflow = cElements;
    }

    public String toString() {
        String sCapacity = this.getMaximumCapacity() == 0 ? "Unlimited" : Base.toMemorySizeString(this.getMaximumCapacity());
        return new StringBuilder(String.valueOf(this.get_Name())).append('(').append("BufferSize=").append(Base.toMemorySizeString(this.getBufferSize())).append(", BufferType=").append(this.getBufferType() == TYPE_DIRECT ? "DIRECT" : "HEAP").append(", Capacity=").append(sCapacity).append(')').toString();
    }
}

