/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.queue;

import com.oracle.coherence.common.base.Notifier;
import com.oracle.coherence.common.base.SingleWaiterMultiNotifier;
import com.oracle.coherence.common.collections.ConcurrentLinkedQueue;
import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.util.Queue;
import com.tangosol.util.WrapperException;
import java.util.Iterator;

public class SingleConsumerQueue
extends Queue {
    private transient int __m_AddCount;
    private transient int __m_BatchSize;
    private ConcurrentLinkedQueue __m_Delegate;
    private transient Notifier __m_Notifier;

    public SingleConsumerQueue() {
        this(null, null, true);
    }

    public SingleConsumerQueue(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setBatchSize(1);
            this.setDelegate(new ConcurrentLinkedQueue());
            this.setNotifier(new SingleWaiterMultiNotifier());
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    public boolean add(Object oElement) {
        if (this.getDelegate().add(oElement)) {
            int nBatchSize = this.getBatchSize();
            int cAdds = this.getAddCount() + 1;
            this.setAddCount(cAdds);
            if (nBatchSize <= 1 ? true : cAdds % nBatchSize == 0) {
                this.signal();
            }
            return true;
        }
        return false;
    }

    public boolean addHead(Object oElement) {
        throw new UnsupportedOperationException();
    }

    public void await(long cMillis) throws InterruptedException {
        this.getNotifier().await(cMillis);
    }

    public void flush() {
        if (!(this.getBatchSize() > 1) ? false : this.isEmpty() ^ true) {
            this.signal();
        }
    }

    public int getAddCount() {
        return this.__m_AddCount;
    }

    public int getBatchSize() {
        return this.__m_BatchSize;
    }

    protected ConcurrentLinkedQueue getDelegate() {
        return this.__m_Delegate;
    }

    public Notifier getNotifier() {
        return this.__m_Notifier;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/queue/SingleConsumerQueue".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public static Component get_Instance() {
        return new SingleConsumerQueue();
    }

    private final Component get_Module() {
        return this;
    }

    public boolean isEmpty() {
        return this.getDelegate().isEmpty();
    }

    public Iterator iterator() {
        return this.getDelegate().iterator();
    }

    public Object peekNoWait() {
        return this.getDelegate().peek();
    }

    public Object removeNoWait() {
        return this.getDelegate().poll();
    }

    public void setAddCount(int nCount) {
        this.__m_AddCount = nCount;
    }

    public void setBatchSize(int nInterval) {
        this.__m_BatchSize = nInterval;
    }

    protected void setDelegate(ConcurrentLinkedQueue queueDelegate) {
        this.__m_Delegate = queueDelegate;
    }

    public void setNotifier(Notifier notifier) {
        this.__m_Notifier = notifier;
    }

    public void signal() {
        this.getNotifier().signal();
    }

    public int size() {
        return this.getDelegate().size();
    }
}

