/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.config;

import com.tangosol.coherence.config.CacheMapping;
import com.tangosol.coherence.config.CacheMappingRegistry;
import com.tangosol.coherence.config.ResourceMapping;
import com.tangosol.coherence.config.ResourceMappingRegistry;
import com.tangosol.coherence.config.SchemeMappingRegistry;
import com.tangosol.coherence.config.ServiceSchemeRegistry;
import com.tangosol.coherence.config.TopicMapping;
import com.tangosol.coherence.config.builder.NamedEventInterceptorBuilder;
import com.tangosol.coherence.config.scheme.CachingScheme;
import com.tangosol.coherence.config.scheme.NamedTopicScheme;
import com.tangosol.coherence.config.scheme.ServiceScheme;
import com.tangosol.config.ConfigurationException;
import com.tangosol.config.annotation.Injectable;
import com.tangosol.config.expression.ParameterResolver;
import com.tangosol.util.Base;
import com.tangosol.util.ResourceRegistry;
import java.util.LinkedList;
import java.util.List;

public class CacheConfig {
    public static final String TOP_LEVEL_ELEMENT_NAME = "cache-config";
    private String m_sScopeName = "";
    private SchemeMappingRegistry m_registrySchemeMapping;
    private ServiceSchemeRegistry m_registrySchemeRegistry = new ServiceSchemeRegistry();
    private ParameterResolver m_parameterResolver;
    private List<NamedEventInterceptorBuilder> m_listEventInterceptorBuilders = new LinkedList<NamedEventInterceptorBuilder>();

    public CacheConfig(ParameterResolver defaultParameterResolver) {
        this.m_parameterResolver = defaultParameterResolver;
    }

    public String getScopeName() {
        return this.m_sScopeName;
    }

    @Injectable(value="scope-name")
    @Deprecated
    public void setScopeName(String sScopeName) {
        this.m_sScopeName = sScopeName.trim();
    }

    public List<NamedEventInterceptorBuilder> getEventInterceptorBuilders() {
        return this.m_listEventInterceptorBuilders;
    }

    @Injectable(value="interceptors")
    public void setEventInterceptorBuilders(List<NamedEventInterceptorBuilder> listBuilders) {
        this.m_listEventInterceptorBuilders = listBuilders;
    }

    public ResourceMappingRegistry getMappingRegistry() {
        return this.m_registrySchemeMapping;
    }

    public CacheMappingRegistry getCacheMappingRegistry() {
        return new CacheMappingRegistry(this.getMappingRegistry());
    }

    public void setCacheMappingRegistry(CacheMappingRegistry registry) {
        if (registry == null) {
            return;
        }
        SchemeMappingRegistry schemeMappingRegistry = this.m_registrySchemeMapping;
        if (schemeMappingRegistry == null) {
            this.m_registrySchemeMapping = new SchemeMappingRegistry();
        }
        for (CacheMapping mapping : registry) {
            if (schemeMappingRegistry.findMapping(mapping.getNamePattern(), mapping.getClass()) != null) continue;
            schemeMappingRegistry.register(mapping);
        }
    }

    @Injectable(value="caching-scheme-mapping")
    public void addCacheMappingRegistry(SchemeMappingRegistry registry) {
        this.addRegistrySchemeMapping(registry);
    }

    @Injectable(value="topic-scheme-mapping")
    public void addRegistrySchemeMapping(SchemeMappingRegistry registry) {
        if (registry == null) {
            return;
        }
        SchemeMappingRegistry schemeMappingRegistry = this.m_registrySchemeMapping;
        if (schemeMappingRegistry == null) {
            this.m_registrySchemeMapping = registry;
        } else {
            for (ResourceMapping mapping : registry) {
                if (schemeMappingRegistry.findMapping(mapping.getNamePattern(), mapping.getClass()) != null) continue;
                schemeMappingRegistry.register(mapping);
            }
        }
    }

    public ServiceSchemeRegistry getServiceSchemeRegistry() {
        return this.m_registrySchemeRegistry;
    }

    @Injectable(value="caching-schemes")
    public void setServiceSchemeRegistry(ServiceSchemeRegistry registry) {
        this.m_registrySchemeRegistry = registry;
    }

    public CachingScheme findSchemeByCacheName(String sCacheName) {
        ResourceMappingRegistry registry = this.getMappingRegistry();
        CacheMapping mapping = registry.findMapping(sCacheName, CacheMapping.class);
        if (mapping == null) {
            return null;
        }
        String sSchemeName = mapping.getSchemeName();
        ServiceScheme serviceScheme = this.findSchemeBySchemeName(sSchemeName);
        return serviceScheme instanceof CachingScheme ? (CachingScheme)serviceScheme : null;
    }

    public NamedTopicScheme findSchemeByTopicName(String sTopicName) {
        ResourceMappingRegistry registry = this.getMappingRegistry();
        TopicMapping mapping = registry.findMapping(sTopicName, TopicMapping.class);
        if (mapping == null) {
            return null;
        }
        String sSchemeName = mapping.getSchemeName();
        ServiceScheme serviceScheme = this.findSchemeBySchemeName(sSchemeName);
        return serviceScheme instanceof NamedTopicScheme ? (NamedTopicScheme)serviceScheme : null;
    }

    public ServiceScheme findSchemeByServiceName(String sServiceName) {
        return this.getServiceSchemeRegistry().findSchemeByServiceName(sServiceName);
    }

    public ServiceScheme findSchemeBySchemeName(String sSchemeName) {
        return this.getServiceSchemeRegistry().findSchemeBySchemeName(sSchemeName);
    }

    public ParameterResolver getDefaultParameterResolver() {
        return this.m_parameterResolver;
    }

    public CacheConfig validate(ResourceRegistry registry) {
        ResourceMappingRegistry regMapping = this.getMappingRegistry();
        ServiceSchemeRegistry regSchemes = this.getServiceSchemeRegistry();
        Base.checkNotNull(regMapping, "ResourceMappingRegistry");
        Base.checkNotNull(regSchemes, "ServiceSchemeRegistry");
        for (ResourceMapping mapping : regMapping) {
            String sSchemeName = mapping.getSchemeName();
            ServiceScheme scheme = regSchemes.findSchemeBySchemeName(sSchemeName);
            if (scheme == null) {
                throw new ConfigurationException("Scheme definition missing for scheme " + sSchemeName, "Provide the scheme definition.");
            }
            mapping.validateScheme(scheme);
        }
        return this;
    }
}

