/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.config.builder;

import com.tangosol.coherence.config.ParameterList;
import com.tangosol.coherence.config.builder.ParameterizedBuilder;
import com.tangosol.config.ConfigurationException;
import com.tangosol.config.expression.ParameterResolver;
import com.tangosol.net.ActionPolicy;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.util.NullImplementation;

public abstract class ActionPolicyBuilder
implements ParameterizedBuilder<ActionPolicy> {

    public static class QuorumRule {
        protected XmlElement m_xmlElement;
        protected String m_sRuleElementName;
        protected int m_nRuleMask;
        protected int m_nThreshold;

        public QuorumRule(String sRuleElementName, int nRuleMask, int nThreshold, XmlElement xmlElement) {
            this.m_sRuleElementName = sRuleElementName;
            this.m_nRuleMask = nRuleMask;
            this.m_nThreshold = nThreshold;
            this.m_xmlElement = xmlElement;
        }

        public void validate() throws ConfigurationException {
            if (this.m_nThreshold < 0) {
                throw new ConfigurationException("Invalid value [" + this.m_nThreshold + "] for <" + this.m_sRuleElementName + "> in [" + this.m_xmlElement + "]", "The <" + this.m_sRuleElementName + "> must be non-negative");
            }
        }
    }

    public static class NullImplementationBuilder
    extends ActionPolicyBuilder {
        @Override
        public ActionPolicy realize(ParameterResolver resolver, ClassLoader loader, ParameterList listParameters) throws ConfigurationException {
            return NullImplementation.getActionPolicy();
        }
    }

    public static class ActionPolicyParameterizedBuilder
    extends ActionPolicyBuilder {
        private ParameterizedBuilder<ActionPolicy> m_builder;

        public ActionPolicyParameterizedBuilder(ParameterizedBuilder<ActionPolicy> bldr) {
            this.m_builder = bldr;
        }

        @Override
        public ActionPolicy realize(ParameterResolver resolver, ClassLoader loader, ParameterList listParameters) throws ConfigurationException {
            return this.m_builder.realize(resolver, loader, listParameters);
        }
    }
}

