/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.config.builder;

import com.tangosol.coherence.config.ParameterList;
import com.tangosol.coherence.config.builder.DefaultBuilderCustomization;
import com.tangosol.coherence.config.builder.ParameterizedBuilder;
import com.tangosol.config.annotation.Injectable;
import com.tangosol.config.expression.Expression;
import com.tangosol.config.expression.LiteralExpression;
import com.tangosol.config.expression.ParameterResolver;
import com.tangosol.net.cache.ConfigurableCacheMap;
import com.tangosol.net.cache.LocalCache;

public class EvictionPolicyBuilder
extends DefaultBuilderCustomization<ConfigurableCacheMap.EvictionPolicy>
implements ParameterizedBuilder<ConfigurableCacheMap.EvictionPolicy>,
ParameterizedBuilder.ReflectionSupport {
    private Expression<String> m_exprPolicy = new LiteralExpression<String>("HYBRID");

    public String getEvictionType(ParameterResolver resolver) {
        return this.m_exprPolicy.evaluate(resolver);
    }

    @Injectable
    public void setEvictionType(Expression<String> expr) {
        this.m_exprPolicy = expr;
    }

    @Override
    public boolean realizes(Class<?> clzClass, ParameterResolver resolver, ClassLoader loader) {
        return this.getClass().isAssignableFrom(clzClass);
    }

    @Override
    public ConfigurableCacheMap.EvictionPolicy realize(ParameterResolver resolver, ClassLoader loader, ParameterList listParameters) {
        ConfigurableCacheMap.EvictionPolicy policy;
        ParameterizedBuilder bldr = this.getCustomBuilder();
        if (bldr == null) {
            String sType;
            switch (sType = this.getEvictionType(resolver).toUpperCase()) {
                case "HYBRID": {
                    policy = LocalCache.INSTANCE_HYBRID;
                    break;
                }
                case "LRU": {
                    policy = LocalCache.INSTANCE_LRU;
                    break;
                }
                case "LFU": {
                    policy = LocalCache.INSTANCE_LFU;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Error: the <eviction-policy> value " + sType + "is invalid");
                }
            }
        } else {
            policy = (ConfigurableCacheMap.EvictionPolicy)bldr.realize(resolver, loader, listParameters);
        }
        return policy;
    }
}

