/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.config.builder.storemanager;

import com.tangosol.coherence.config.ResolvableParameterList;
import com.tangosol.coherence.config.builder.ParameterizedBuilder;
import com.tangosol.coherence.config.builder.storemanager.AbstractStoreManagerBuilder;
import com.tangosol.config.annotation.Injectable;
import com.tangosol.config.expression.Expression;
import com.tangosol.config.expression.LiteralExpression;
import com.tangosol.config.expression.Parameter;
import com.tangosol.config.expression.ParameterResolver;
import com.tangosol.io.bdb.BerkeleyDBBinaryStoreManager;
import com.tangosol.run.xml.SimpleElement;
import com.tangosol.util.Base;
import java.io.File;

public class BdbStoreManagerBuilder
extends AbstractStoreManagerBuilder<BerkeleyDBBinaryStoreManager> {
    private Expression<String> m_exprDirectory = new LiteralExpression<String>(String.valueOf(""));
    private Expression<String> m_exprStoreName = new LiteralExpression<String>(String.valueOf(""));
    private Expression<String> m_exprXmlInitParams = new LiteralExpression<String>(String.valueOf(""));
    private ResolvableParameterList m_listResolvableInitParameters;

    @Override
    public BerkeleyDBBinaryStoreManager realize(ParameterResolver resolver, ClassLoader loader, boolean fPaged) {
        this.validate(resolver);
        String sStoreName = this.getStoreName(resolver);
        String sPath = this.getDirectory(resolver);
        File fileDir = sPath.length() == 0 ? null : new File(sPath);
        try {
            ParameterizedBuilder bldrCustom = this.getCustomBuilder();
            if (bldrCustom == null) {
                BerkeleyDBBinaryStoreManager bdbMgr = new BerkeleyDBBinaryStoreManager(fileDir, sStoreName);
                ResolvableParameterList listParams = this.getInitParams();
                if (listParams != null && !listParams.isEmpty()) {
                    SimpleElement xmlInit = new SimpleElement("config");
                    for (Parameter param : listParams) {
                        xmlInit.ensureElement(param.getName()).setString(param.evaluate(resolver).as(String.class));
                    }
                    bdbMgr.setConfig(xmlInit);
                }
                return bdbMgr;
            }
            ResolvableParameterList listArgs = new ResolvableParameterList();
            listArgs.add(new Parameter("fileDir", fileDir));
            listArgs.add(new Parameter("storeName", sStoreName));
            return (BerkeleyDBBinaryStoreManager)bldrCustom.realize(resolver, loader, listArgs);
        }
        catch (NoClassDefFoundError e) {
            String sMsg = "Berkeley DB JE libraries are required to utilize a 'bdb-store-manager', visit www.sleepycat.com for additional information.";
            throw Base.ensureRuntimeException(e, sMsg);
        }
    }

    public String getDirectory(ParameterResolver resolver) {
        return this.m_exprDirectory.evaluate(resolver);
    }

    @Injectable
    public void setDirectory(Expression<String> expr) {
        this.m_exprDirectory = expr;
    }

    public String getStoreName(ParameterResolver resolver) {
        return this.m_exprStoreName.evaluate(resolver);
    }

    @Injectable
    public void setStoreName(Expression<String> expr) {
        this.m_exprStoreName = expr;
    }

    public String getXmlInitParams(ParameterResolver resolver) {
        return this.m_exprXmlInitParams.evaluate(resolver);
    }

    @Injectable
    public void setXmlInitParams(Expression<String> expr) {
        this.m_exprXmlInitParams = expr;
    }

    public ResolvableParameterList getInitParams() {
        return this.m_listResolvableInitParameters;
    }

    @Injectable(value="init-params")
    public void setInitParams(ResolvableParameterList listInitParams) {
        this.m_listResolvableInitParameters = listInitParams;
    }
}

