/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.config.xml.processor;

import com.tangosol.config.ConfigurationException;
import com.tangosol.config.xml.ConditionalElementProcessor;
import com.tangosol.config.xml.ProcessingContext;
import com.tangosol.run.xml.XmlElement;

public abstract class AbstractEmptyElementProcessor<T>
implements ConditionalElementProcessor<T> {
    private EmptyElementBehavior m_behavior;
    private T m_oDefaultValue;

    public AbstractEmptyElementProcessor() {
        this.m_behavior = EmptyElementBehavior.PROCESS;
        this.m_oDefaultValue = null;
    }

    public AbstractEmptyElementProcessor(EmptyElementBehavior behavior) {
        this.m_behavior = behavior;
        this.m_oDefaultValue = null;
    }

    public AbstractEmptyElementProcessor(T oDefaultValue) {
        this.m_behavior = EmptyElementBehavior.USE_DEFAULT_VALUE;
        this.m_oDefaultValue = oDefaultValue;
    }

    protected abstract T onProcess(ProcessingContext var1, XmlElement var2) throws ConfigurationException;

    protected boolean isEmptyElement(ProcessingContext context, XmlElement xmlElement) {
        return xmlElement.isEmpty() && xmlElement.getElementList().size() == 0;
    }

    @Override
    public boolean accepts(ProcessingContext context, XmlElement xmlElement) throws ConfigurationException {
        return this.m_behavior == EmptyElementBehavior.IGNORE && !this.isEmptyElement(context, xmlElement) || this.m_behavior != EmptyElementBehavior.IGNORE;
    }

    @Override
    public final T process(ProcessingContext context, XmlElement xmlElement) throws ConfigurationException {
        boolean fIsEmpty = this.isEmptyElement(context, xmlElement);
        if (fIsEmpty) {
            switch (this.m_behavior) {
                case USE_DEFAULT_VALUE: {
                    return this.m_oDefaultValue;
                }
                case PROCESS: {
                    return this.onProcess(context, xmlElement);
                }
                case THROW_EXCEPTION: {
                    throw new ConfigurationException("Invalid <" + xmlElement.getName() + "> declaration.  The specified element is empty in [" + xmlElement.getParent() + "]", "Please specify a valid <" + xmlElement.getName() + ">");
                }
            }
            throw new IllegalStateException("Impossible state reached");
        }
        return this.onProcess(context, xmlElement);
    }

    public static enum EmptyElementBehavior {
        IGNORE,
        THROW_EXCEPTION,
        USE_DEFAULT_VALUE,
        PROCESS;

    }
}

