/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.config.xml.processor;

import com.tangosol.coherence.config.scheme.AbstractCompositeScheme;
import com.tangosol.coherence.config.scheme.CachingScheme;
import com.tangosol.coherence.config.xml.processor.CustomizableBuilderProcessor;
import com.tangosol.config.ConfigurationException;
import com.tangosol.config.xml.ProcessingContext;
import com.tangosol.run.xml.XmlElement;

public class CompositeSchemeProcessor<T extends AbstractCompositeScheme>
extends CustomizableBuilderProcessor<T> {
    public CompositeSchemeProcessor(Class<T> clzToRealize) {
        super(clzToRealize);
    }

    @Override
    public T process(ProcessingContext context, XmlElement element) throws ConfigurationException {
        XmlElement xmlBack;
        AbstractCompositeScheme scheme = (AbstractCompositeScheme)super.process(context, element);
        XmlElement xmlFront = element.findElement("front-scheme");
        if (xmlFront != null) {
            Object oFront = context.processOnlyElementOf(xmlFront);
            if (oFront instanceof CachingScheme) {
                scheme.setFrontScheme((CachingScheme)oFront);
            } else {
                throw new ConfigurationException(String.format("<front-scheme> of %s is not a CachingScheme.", element), "Please ensure the <front-scheme> is of the appropriate type");
            }
        }
        if ((xmlBack = element.findElement("back-scheme")) != null) {
            Object oBack = context.processOnlyElementOf(xmlBack);
            if (oBack instanceof CachingScheme) {
                scheme.setBackScheme((CachingScheme)oBack);
            } else {
                throw new ConfigurationException(String.format("<back-scheme> of %s is not a CachingScheme.", element), "Please ensure the <back-scheme> is of the appropriate type");
            }
        }
        return (T)scheme;
    }
}

