/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.config.xml.processor;

import com.tangosol.coherence.config.scheme.BackingMapScheme;
import com.tangosol.coherence.config.scheme.CachingScheme;
import com.tangosol.coherence.config.scheme.PagedTopicScheme;
import com.tangosol.coherence.config.scheme.PagedTopicStorageScheme;
import com.tangosol.coherence.config.xml.processor.ServiceBuilderProcessor;
import com.tangosol.config.ConfigurationException;
import com.tangosol.config.xml.ProcessingContext;
import com.tangosol.config.xml.XmlSimpleName;
import com.tangosol.internal.net.service.DefaultServiceDependencies;
import com.tangosol.internal.net.service.grid.DefaultPartitionedCacheDependencies;
import com.tangosol.internal.net.service.grid.PartitionedCacheDependencies;
import com.tangosol.io.Serializer;
import com.tangosol.io.SerializerFactory;
import com.tangosol.io.pof.PofContext;
import com.tangosol.io.pof.SafeConfigurablePofContext;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.util.ExternalizableHelper;

@XmlSimpleName(value="paged-topic-scheme")
public class PagedTopicSchemeProcessor
extends ServiceBuilderProcessor<PagedTopicScheme> {
    public PagedTopicSchemeProcessor() {
        super(PagedTopicScheme.class);
    }

    @Override
    public PagedTopicScheme process(ProcessingContext context, XmlElement element) throws ConfigurationException {
        PagedTopicScheme scheme = (PagedTopicScheme)super.process(context, element);
        DefaultPartitionedCacheDependencies deps = new DefaultPartitionedCacheDependencies((PartitionedCacheDependencies)scheme.getServiceDependencies());
        final SerializerFactory factory = deps.getSerializerFactory();
        SerializerFactory factoryPof = new SerializerFactory(){

            @Override
            public Serializer createSerializer(ClassLoader loader) {
                Serializer serializer = factory == null ? ExternalizableHelper.ensureSerializer(loader) : factory.createSerializer(loader);
                return serializer instanceof PofContext ? serializer : new SafeConfigurablePofContext(serializer, loader);
            }
        };
        ((DefaultServiceDependencies)deps).setSerializerFactory(factoryPof);
        scheme.setServiceDependencies(deps);
        CachingScheme schemeStorage = scheme.getStorageScheme(context.getDefaultParameterResolver());
        BackingMapScheme backingMapScheme = new BackingMapScheme();
        backingMapScheme.setStorageAccessAuthorizer(scheme.getStorageAccessAuthorizer());
        backingMapScheme.setTransient(scheme.getTransientExpression());
        backingMapScheme.setInnerScheme(new PagedTopicStorageScheme(schemeStorage, scheme));
        scheme.setBackingMapScheme(backingMapScheme);
        return scheme;
    }
}

