/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.dslquery.internal;

import com.oracle.coherence.common.base.Blocking;
import com.oracle.coherence.persistence.PersistenceException;
import com.tangosol.coherence.dslquery.CohQLException;
import com.tangosol.coherence.dslquery.ExecutionContext;
import com.tangosol.coherence.dsltools.precedence.OPScanner;
import com.tangosol.coherence.dsltools.termtrees.AtomicTerm;
import com.tangosol.coherence.dsltools.termtrees.Term;
import com.tangosol.coherence.dsltools.termtrees.Terms;
import com.tangosol.io.FileHelper;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.Cluster;
import com.tangosol.net.ConfigurableCacheFactory;
import com.tangosol.net.ExtensibleConfigurableCacheFactory;
import com.tangosol.net.Member;
import com.tangosol.net.management.MBeanServerProxy;
import com.tangosol.net.management.Registry;
import com.tangosol.persistence.CachePersistenceHelper;
import com.tangosol.persistence.PersistenceEnvironmentInfo;
import com.tangosol.util.Base;
import com.tangosol.util.Filters;
import com.tangosol.util.WrapperException;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.management.MBeanException;

public class PersistenceToolsHelper {
    private static final String COHERENCE = "Coherence:";
    public static final String CREATE_SNAPSHOT = "createSnapshot";
    public static final String RECOVER_SNAPSHOT = "recoverSnapshot";
    public static final String REMOVE_SNAPSHOT = "removeSnapshot";
    public static final String ARCHIVE_SNAPSHOT = "archiveSnapshot";
    public static final String RETRIEVE_ARCHIVED_SNAPSHOT = "retrieveArchivedSnapshot";
    public static final String REMOVE_ARCHIVED_SNAPSHOT = "removeArchivedSnapshot";
    public static final String SUSPEND_SERVICE = "suspendService";
    public static final String RESUME_SERVICE = "resumeService";
    public static final String FORCE_RECOVERY = "forceRecovery";
    private static final String STATUS_IDLE = "Idle";
    private static final long SLEEP_TIME = 500L;
    private static final String HELPER = "persistence_tools_helper";
    private static final String[] NO_SNAPSHOTS = new String[0];
    private PrintWriter m_out = null;
    private MBeanServerProxy m_mbsProxy;
    private Registry m_registry;

    public PersistenceToolsHelper() {
        this(null);
    }

    public PersistenceToolsHelper(PrintWriter out) {
        Cluster cluster = CacheFactory.ensureCluster();
        this.m_registry = cluster.getManagement();
        this.m_out = out;
        if (this.m_registry == null) {
            throw new CohQLException("Unable to retrieve Registry from cluster");
        }
        this.m_mbsProxy = this.m_registry.getMBeanServerProxy();
        this.ensureMBeanRegistration("type=Cluster");
    }

    public static PersistenceToolsHelper ensurePersistenceToolsHelper(ExecutionContext ctx) throws CohQLException {
        PersistenceToolsHelper helper = ctx.getResourceRegistry().getResource(PersistenceToolsHelper.class, HELPER);
        try {
            if (helper == null) {
                helper = new PersistenceToolsHelper(ctx.isTraceEnabled() ? ctx.getWriter() : null);
                ctx.getResourceRegistry().registerResource(PersistenceToolsHelper.class, HELPER, helper);
            }
        }
        catch (Exception e) {
            throw PersistenceToolsHelper.ensureCohQLException(e, "Unable to instantiate PersistenceToolsHelper");
        }
        return helper;
    }

    public void invokeOperationWithWait(String sOperation, String sSnapshot, String sServiceName) throws MBeanException {
        try {
            this.invokeOperation(sOperation, sServiceName, new String[]{sSnapshot}, new String[]{"java.lang.String"});
            String sBeanName = this.getPersistenceMBean(sServiceName);
            Blocking.sleep(500L);
            while (true) {
                Blocking.sleep(500L);
                boolean fisIdle = (Boolean)this.getAttribute(sBeanName, STATUS_IDLE);
                this.traceMessage("Idle = " + fisIdle);
                if (fisIdle) {
                    return;
                }
                this.traceMessage("Operation " + sOperation + " not yet complete, waiting " + 500L + "ms");
            }
        }
        catch (Exception e) {
            throw Base.ensureRuntimeException(e, "Unable to complete operation " + sOperation + " for service " + sServiceName);
        }
    }

    public void invokeOperation(String sOperation, String sServiceName, Object[] aoParams, String[] asParamTypes) throws MBeanException {
        String sBeanName = this.getPersistenceMBean(sServiceName);
        this.traceMessage("Invoking " + sOperation + " on " + sBeanName + " using params = " + Arrays.toString(aoParams));
        this.m_mbsProxy.invoke(sBeanName, sOperation, aoParams, asParamTypes);
    }

    public boolean serviceExists(String sServiceName) {
        try {
            Map<String, String[]> mapServices = this.listServices();
            return mapServices != null && mapServices.containsKey(sServiceName);
        }
        catch (Exception e) {
            throw Base.ensureRuntimeException(e, "Error validating service");
        }
    }

    public boolean snapshotExists(String sServiceName, String sSnapshotName) {
        try {
            String[] asSnapshots = this.listSnapshots(sServiceName);
            return asSnapshots != null && Arrays.asList(asSnapshots).contains(sSnapshotName);
        }
        catch (Exception e) {
            throw Base.ensureRuntimeException(e, "Error validating snapshot");
        }
    }

    public boolean archivedSnapshotExists(String sServiceName, String sSnapshotName) {
        try {
            String[] asSnapshots = this.listArchivedSnapshots(sServiceName);
            return asSnapshots != null && Arrays.asList(asSnapshots).contains(sSnapshotName);
        }
        catch (Exception e) {
            throw Base.ensureRuntimeException(e, "Error validating archived snapshots");
        }
    }

    public void validateSnapshotExistsForAllServices(String sSnapshotName) {
        StringBuilder sb = new StringBuilder();
        try {
            for (Map.Entry<String, String[]> entry : this.listSnapshots().entrySet()) {
                String[] asSnapshots = entry.getValue();
                if (Arrays.asList(asSnapshots).contains(sSnapshotName)) continue;
                sb.append("The snapshot ").append(sSnapshotName).append(" does not exist on service ").append(entry.getKey()).append('\n');
            }
        }
        catch (Exception e) {
            throw Base.ensureRuntimeException(e, "Error validating snapshot");
        }
        if (sb.length() > 0) {
            throw new CohQLException(sb.toString());
        }
    }

    public void validateArchivedSnapshotExistsForAllServices(String sSnapshotName) {
        StringBuilder sb = new StringBuilder();
        try {
            for (Map.Entry<String, String[]> entry : this.listServices().entrySet()) {
                String sServiceName = entry.getKey();
                String[] asArchivedSnapshots = this.listArchivedSnapshots(sServiceName);
                if (Arrays.asList(asArchivedSnapshots).contains(sSnapshotName)) continue;
                sb.append("The archived snapshot ").append(sSnapshotName).append(" does not exist on service ").append(sServiceName).append('\n');
            }
        }
        catch (Exception e) {
            throw Base.ensureRuntimeException(e, "Error validating snapshot");
        }
        if (sb.length() > 0) {
            throw new CohQLException(sb.toString());
        }
    }

    public Map<String, String[]> listServices() {
        HashMap<String, String[]> mapResults = new HashMap<String, String[]>();
        for (Map.Entry<String, String> entry : this.getPersistenceServices().entrySet()) {
            String sServiceName = entry.getKey();
            String sPersistenceMode = entry.getValue();
            String[] asResults = this.getServiceInfo(sServiceName);
            mapResults.put(sServiceName, new String[]{sPersistenceMode, asResults[0], asResults[1]});
        }
        return mapResults;
    }

    public List<String> listServicesEnvironment() {
        ArrayList<String> listInfo = new ArrayList<String>();
        for (String sServiceName : this.getPersistenceServices().keySet()) {
            String sMBean = this.getStorageEnabledMember(sServiceName);
            if (sMBean == null) {
                throw new RuntimeException("Unable to find storage-enabled members for service " + sServiceName);
            }
            String sEnvironment = (String)this.getAttribute(sMBean, "PersistenceEnvironment");
            listInfo.add(sServiceName + " - " + sEnvironment);
        }
        return listInfo;
    }

    public String[] listSnapshots(String sServiceName) {
        try {
            String[] asSnapshots = (String[])this.getAttribute(this.getPersistenceMBean(sServiceName), "Snapshots");
            return asSnapshots == null ? NO_SNAPSHOTS : asSnapshots;
        }
        catch (Exception e) {
            throw Base.ensureRuntimeException(e);
        }
    }

    public Map<String, String[]> listSnapshots() {
        HashMap<String, String[]> mapResults = new HashMap<String, String[]>();
        for (Map.Entry<String, String> entry : this.getPersistenceServices().entrySet()) {
            String sServiceName = entry.getKey();
            mapResults.put(sServiceName, this.listSnapshots(sServiceName));
        }
        return mapResults;
    }

    public String[] listArchivedSnapshots(String sServiceName) {
        try {
            return (String[])this.m_mbsProxy.invoke(this.getPersistenceMBean(sServiceName), "listArchivedSnapshots", new String[0], new String[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to execute listArchivedSnapshots for service " + sServiceName + ": " + e.getMessage());
        }
    }

    public Map<String, String[]> listArchivedSnapshots() {
        HashMap<String, String[]> mapResults = new HashMap<String, String[]>();
        for (String sServiceName : this.getPersistenceServices().keySet()) {
            try {
                mapResults.put(sServiceName, this.listArchivedSnapshots(sServiceName));
            }
            catch (Exception e) {
                if (e instanceof RuntimeException && e.getMessage().contains("MBeanException")) continue;
                throw PersistenceToolsHelper.ensureCohQLException(e, "Unable to list archived snapshots");
            }
        }
        return mapResults;
    }

    public String getArchiver(String sServiceName) {
        String sMBean = this.getStorageEnabledMember(sServiceName);
        if (sMBean == null) {
            throw new RuntimeException("Unable to find storage-enabled members for service " + sServiceName);
        }
        return (String)this.getAttribute(sMBean, "PersistenceSnapshotArchiver");
    }

    public void resumeService(String sServiceName) {
        try {
            this.m_mbsProxy.invoke("type=Cluster", RESUME_SERVICE, new String[]{sServiceName}, new String[]{"java.lang.String"});
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to resume service " + e.getMessage());
        }
    }

    public void suspendService(String sServiceName) {
        try {
            this.m_mbsProxy.invoke("type=Cluster", SUSPEND_SERVICE, new String[]{sServiceName}, new String[]{"java.lang.String"});
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to resume service " + e.getMessage());
        }
    }

    public void ensureReady(boolean fWait, String sServiceToCheck) {
        try {
            String sStatus;
            while (!STATUS_IDLE.equals(sStatus = this.getOperationStatus(sServiceToCheck))) {
                if (fWait) {
                    Blocking.sleep(500L);
                    continue;
                }
                throw new CohQLException("The service " + sServiceToCheck + " currently has an operation in progress: \n" + sStatus + "\nPlease use LIST SERVICES to determine when service is ready.");
            }
        }
        catch (Exception e) {
            throw PersistenceToolsHelper.ensureCohQLException(e, "Error during ensureReady");
        }
    }

    public void ensureReady(ExecutionContext ctx, String sService) {
        this.ensureReady(ctx.isSilent(), sService);
    }

    public static CohQLException ensureCohQLException(Throwable eCause, String sMsg) {
        StringBuilder sb = new StringBuilder(sMsg);
        Throwable cause = eCause;
        if (eCause instanceof WrapperException && eCause.getCause() instanceof RuntimeException || eCause instanceof PersistenceException) {
            Throwable t = eCause.getCause();
            sb.append(" - ").append(eCause.getMessage());
            if (t != null) {
                sb.append('\n').append(t.getMessage());
                cause = t.getCause();
                if (cause != null) {
                    sb.append('\n').append(cause.getMessage());
                    sb.append('\n').append(cause.getCause());
                }
            }
        }
        return eCause instanceof CohQLException ? (CohQLException)eCause : new CohQLException(sb.toString(), cause);
    }

    private void traceMessage(String sMessage) {
        if (this.isTraceEnabled()) {
            this.m_out.println(new Date(Base.getSafeTimeMillis()) + " : " + sMessage);
            this.m_out.flush();
        }
    }

    public String getOperationStatus(String sServiceName) {
        return (String)this.getAttribute(this.getPersistenceMBean(sServiceName), "OperationStatus");
    }

    private void validateNoSnapshotExistsForAllServices(String sSnapshotName) {
        StringBuilder sb = new StringBuilder();
        try {
            for (Map.Entry<String, String[]> entry : this.listSnapshots().entrySet()) {
                String[] asSnapshots = entry.getValue();
                if (!Arrays.asList(asSnapshots).contains(sSnapshotName)) continue;
                sb.append("The snapshot ").append(sSnapshotName).append(" already exists on service ").append(entry.getKey()).append('\n');
            }
        }
        catch (Exception e) {
            throw Base.ensureRuntimeException(e, "Error validating snapshot");
        }
        if (sb.length() > 0) {
            throw new CohQLException(sb.toString());
        }
    }

    private Map<String, String> getPersistenceServices() {
        HashMap<String, String> mapServices = new HashMap<String, String>();
        String sQuery = "Coherence:type=PartitionAssignment,responsibility=DistributionCoordinator,*";
        Set<String> setServiceNames = this.m_mbsProxy.queryNames(sQuery, null).stream().map(s -> s.replaceAll("^.*type=PartitionAssignment", "").replaceAll(",responsibility=DistributionCoordinator", "").replaceAll("domainPartition=.*,", "").replaceAll(",service=", "")).collect(Collectors.toSet());
        setServiceNames.forEach(s -> {
            Optional serviceMBean = this.m_mbsProxy.queryNames("Coherence:type=Service,name=" + s + ",*", null).stream().findAny();
            if (serviceMBean.isPresent()) {
                String sServiceMbean = (String)serviceMBean.get();
                Map<String, Object> mapServiceAttr = this.m_mbsProxy.getAttributes(sServiceMbean, Filters.always());
                mapServices.put((String)s, (String)mapServiceAttr.get("PersistenceMode"));
            }
        });
        return mapServices;
    }

    private String getStorageEnabledMember(String sServiceName) {
        Set<String> setServices = this.m_mbsProxy.queryNames("Coherence:type=Service,name=" + sServiceName + ",*", null);
        for (String sMbean : setServices) {
            if ((Integer)this.getAttribute(sMbean, "OwnedPartitionsPrimary") <= 0) continue;
            return sMbean;
        }
        return null;
    }

    private void ensureMBeanRegistration(String sObjectName) {
        boolean fLogged = false;
        int nCounter = 3000;
        while (!this.m_mbsProxy.isMBeanRegistered(sObjectName)) {
            if (this.isTraceEnabled() && !fLogged) {
                this.traceMessage("Waiting for " + sObjectName + " to be registered");
                fLogged = true;
            }
            try {
                Blocking.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (--nCounter > 0) continue;
            throw new RuntimeException("MBean " + sObjectName + " was not registered after 30 seconds. You must be running an MBean Server within the cluster to use 'Persistence' commands.");
        }
        if (this.isTraceEnabled() && fLogged) {
            this.traceMessage(sObjectName + " is now registered");
        }
    }

    private String[] getServiceInfo(String sServiceName) {
        String sMBean = this.getStorageEnabledMember(sServiceName);
        if (sMBean == null) {
            throw new RuntimeException("Unable to find storage-enabled members for service " + sServiceName);
        }
        String sQuorumStatus = (String)this.getAttribute(sMBean, "QuorumStatus");
        String sMBeanName = CachePersistenceHelper.getMBeanName(sServiceName);
        if (sMBean.contains("domainPartition")) {
            String sDomainPartition = sMBean.replaceAll("^.*,domainPartition=", "domainPartition=").replaceAll(",.*$", "");
            sMBeanName = CachePersistenceHelper.getMBeanName(sServiceName) + "," + sDomainPartition;
        }
        String sOperationStatus = (String)this.getAttribute(sMBeanName, "OperationStatus");
        return new String[]{sQuorumStatus, sOperationStatus};
    }

    public String getPersistenceMBean(String sServiceName) {
        return this.ensureGlobalName(CachePersistenceHelper.getMBeanName(sServiceName));
    }

    public String getServiceMBean(String sServiceName, Member member) {
        return this.m_registry.ensureGlobalName("type=Service,name=" + sServiceName, member);
    }

    private static boolean isValidServiceType(String sType) {
        return "DistributedCache".equals(sType) || "FederatedCache".equals(sType);
    }

    private String ensureGlobalName(String sName) {
        return this.m_registry.ensureGlobalName(sName);
    }

    private Object getAttribute(String sObjectName, String sAttribute) {
        return this.m_mbsProxy.getAttribute(sObjectName, sAttribute);
    }

    public static Term getNextTerm(OPScanner s, String sName, String sDescription, String sCommand) {
        if (s.isEndOfStatement()) {
            throw new CohQLException(sDescription + " required for " + sCommand);
        }
        return Terms.newTerm(sName, AtomicTerm.createString(s.getCurrentAsStringWithAdvance()));
    }

    public static File getSnapshotDirectory(ConfigurableCacheFactory ccf, String sSnapshot, String sServiceName) {
        if (ccf instanceof ExtensibleConfigurableCacheFactory) {
            PersistenceEnvironmentInfo info = CachePersistenceHelper.getEnvironmentInfo((ExtensibleConfigurableCacheFactory)ccf, sServiceName);
            if (info == null) {
                throw new CohQLException("Unable to get persistence environment info for service " + sServiceName + " and snapshot " + sSnapshot);
            }
            return new File(info.getPersistenceSnapshotDirectory(), FileHelper.toFilename(sSnapshot));
        }
        throw new UnsupportedOperationException("ConfigurableCacheFactory is not an instance of ExtensibleConfigurableCacheFactory");
    }

    public void setPrintWriter(PrintWriter out) {
        this.m_out = out;
    }

    public boolean isTraceEnabled() {
        return this.m_out != null;
    }
}

